<?php

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}


add_action( 'vc_load_default_templates_action','nectar_custom_studio_templates_for_vc' );


/**
 * Salient Studio templates.
 *
 * @since 1.0
 */
if( !function_exists('nectar_custom_studio_templates_for_vc') ) {

function nectar_custom_studio_templates_for_vc() {


	$hide_studio_button = get_option('salient_custom_branding_hide_studio', false);
	if ( $hide_studio_button === 'on' ) {
		return '';
	}

	$cat_display_names = array(
		'about' => esc_html__('About', 'salient-core'),
		'blog' => esc_html__('Blog', 'salient-core'),
		'cta' => esc_html__('Call To Action', 'salient-core'),
		'counters' => esc_html__('Counters', 'salient-core'),
		'general' => esc_html__('General', 'salient-core'),
		'icons' => esc_html__('Icons', 'salient-core'),
		'hero_section' => esc_html__('Hero Section', 'salient-core'),
		'google_map' => esc_html__('Map', 'salient-core'),
		'lottie' => esc_html__('Lottie', 'salient-core'),
		'portfolio' => esc_html__('Project', 'salient-core'),
		'pricing' => esc_html__('Pricing', 'salient-core'),
		'services' => esc_html__('Services', 'salient-core'),
		'team' => esc_html__('Team', 'salient-core'),
		'testimonials' => esc_html__('Testimonials', 'salient-core'),
		'shop' => esc_html__('Shop', 'salient-core'),
		'new' => esc_html__('New', 'salient-core')
	);





$data = array();
$data['name'] = esc_html__( 'Harbor Hero', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['hero_section'];
$data['custom_class'] = 'hero_section date-10-Oct-2025';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/harbor-hero.webp' );
$data['content'] = <<<CONTENT
[vc_section type="full_width_background" flex_justify_content_tablet="flex-end" flex_gap_desktop="" text_color="dark" background_image="https://themenectar.com/img/demo-media/unsplash/mountains-harbor.webp" background_image_phone="https://themenectar.com/img/demo-media/unsplash/mountains-harbor-phone.webp" background_image_type="default" background_image_position="center bottom" background_image_loading="default" advanced_gradient="linear-gradient(0deg, rgba(0,0,0,0) 33%, rgba(0,0,0,0) 33%)" advanced_gradient_opacity="0" advanced_gradient_opacity_hover="0" row_border_radius="none" row_border_radius_applies="bg" parallax_bg="true" parallax_bg_scroll_effect="parallax_fade" parallax_bg_speed="medium" min_height_desktop="100svh" content_layout="flexbox" flex_layout_desktop="column" flex_justify_content_desktop="flex-end" flex_align_items_desktop="flex-start" flex_align_items_phone="" flex_wrap_desktop="nowrap" flex_reverse_desktop="false" advanced_gradient_display_type="linear"][vc_row type="full_width_content" full_screen_row_position="middle" column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" text_color="light" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column bottom_padding_desktop="10px" left_padding_desktop="40px" constrain_group_101="yes" right_padding_desktop="40px" left_padding_tablet="20px" constrain_group_103="yes" right_padding_tablet="20px" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="advanced" border_bottom_desktop="1" column_border_color="#FFFFFF36" column_border_style="solid" column_padding_type="advanced" gradient_type="default" content_layout="default"][split_line_heading line_reveal_by_space_text_effect="letter-reveal-blur-top" font_style="h2" stagger_animation="true" fit_text_to_container="true" mobile_disable_animation="true" content_alignment="default" mobile_content_alignment="inherit" animation_type="line-reveal-by-space" link_target="_self" text_content="Vision in Focus" text_direction="default"][/split_line_heading][/vc_column][/vc_row][vc_row type="full_width_content" full_screen_row_position="middle" column_margin="none" column_direction="default" column_direction_tablet="column_reverse" column_direction_phone="default" scene_position="center" text_color="light" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column top_padding_desktop="40px" constrain_group_100="yes" bottom_padding_desktop="40px" left_padding_desktop="40px" constrain_group_101="yes" right_padding_desktop="40px" top_padding_tablet="20px" constrain_group_102="yes" bottom_padding_tablet="20px" left_padding_tablet="20px" constrain_group_103="yes" right_padding_tablet="20px" flex_gap_desktop="40px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" gradient_type="default" content_layout="flexbox" flex_layout_desktop="row" flex_justify_content_desktop="space-between" flex_align_items_desktop="flex-start" flex_align_items_phone="" flex_wrap_desktop="nowrap" flex_reverse_desktop="false"][vc_row_inner equal_height="yes" column_margin="20px" column_direction="default" column_direction_tablet="default" column_direction_phone="default" backdrop_filter="blur" backdrop_filter_blur="16" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" max_width_desktop="64%" max_width_tablet="50%" max_width_phone="100%" overflow="visible" pointer_events="all" css=".vc_custom_1762873971144{padding-top: 15px !important;padding-right: 15px !important;padding-bottom: 15px !important;padding-left: 15px !important;background-color: #0000006E !important;border-radius: 15px !important;}"][vc_column_inner column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="small_desktop" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_color="#FFFFFF5E" column_border_style="solid" column_padding_type="advanced" content_layout="default" gradient_type="default" offset="vc_col-xs-4"][image_with_animation image_url="https://themenectar.com/img/demo-media/unsplash/shaurya-kauhsish-w9Ae-0Gap9I-unsplash-2-800x800.jpg" image_size="medium_featured" max_width="100%" max_width_mobile="default" animation_type="entrance" animation="None" animation_movement_type="transform_y" hover_animation="none" alignment="" border_radius="15px" box_shadow="none" image_loading="skip-lazy-load" fit_to_container="1" image_object_position="center center"][/vc_column_inner][vc_column_inner flex_gap_desktop="20px" flex_gap_phone="15px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="2/3" tablet_width_inherit="small_desktop" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" content_layout="flexbox" gradient_type="default" flex_layout_desktop="column" flex_justify_content_desktop="space-between" flex_align_items_desktop="flex-start" flex_align_items_phone="" flex_wrap_desktop="nowrap" flex_reverse_desktop="false" offset="vc_col-xs-8"][nectar_responsive_text inherited_font_style="h5" text_direction="default"]Expert financial consulting in Manhattan, New York.[/nectar_responsive_text][nectar_cta btn_style="arrow-circle-animation" heading_tag="span" border_radius="100" link_type="regular" button_color="white" text_color="#000000" button_border_thickness="0px" alignment="left" alignment_tablet="default" alignment_phone="default" icon_gap="30" backdrop_filter="blur" backdrop_filter_blur="13" display="inline" display_tablet="inherit" display_phone="inherit" link_text="Book a Call" padding_top="4px" padding_bottom="4px" padding_left="20px" padding_right="4px" url="https://themenectar.com/salient/harbor/contact/"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" device_visibility_phone="hidden" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" flex_gap_desktop="10px" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][nectar_responsive_text inherited_font_style="default" text_direction="default"](NYC Experts)[/nectar_responsive_text][/vc_column_inner][/vc_row_inner][/vc_column][vc_column top_padding_desktop="40" constrain_group_100="yes" bottom_padding_desktop="40" left_padding_desktop="40" constrain_group_101="yes" right_padding_desktop="40" top_padding_tablet="20px" bottom_padding_tablet="0" left_padding_tablet="20px" constrain_group_103="yes" right_padding_tablet="20px" flex_align_items_tablet="flex-start" flex_gap_desktop="40%" flex_gap_phone="25%" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="advanced" border_left_desktop="1" border_left_tablet="0" column_border_color="#FFFFFF36" column_border_style="solid" column_padding_type="advanced" content_layout="flexbox" gradient_type="default" flex_layout_desktop="row" flex_justify_content_desktop="space-between" flex_align_items_desktop="flex-start" flex_align_items_phone="" flex_wrap_desktop="nowrap" flex_reverse_desktop="false" offset="vc_hidden-sm vc_hidden-xs"][nectar_responsive_text inherited_font_style="h5" text_direction="default"]We give vision, structure, and the confidence you need to build momentum.[/nectar_responsive_text][nectar_cta btn_style="next-section" btn_type="minimal-arrow-alt" next_section_icon_size="0.7" next_section_down_arrow_alt_animation="hover-only" next_section_color="#FFFFFF" alignment="left" alignment_tablet="default" alignment_phone="default" display_tablet="inherit" display_phone="inherit"][/vc_column][/vc_row][/vc_section]
CONTENT;

vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Harbor Intro', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-09-Oct-2025';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/harbor-about.webp' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="10%" bottom_padding="5%" left_padding_desktop="40px" constrain_group_2="yes" right_padding_desktop="40px" top_padding_tablet="15%" left_padding_tablet="20px" constrain_group_4="yes" right_padding_tablet="20px" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" id="about" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" flex_gap_desktop="60px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" content_layout="flexbox" flex_layout_desktop="column" flex_justify_content_desktop="flex-start" flex_align_items_desktop="stretch" flex_align_items_phone="" flex_wrap_desktop="nowrap" flex_reverse_desktop="false" gradient_type="default"][split_line_heading line_reveal_by_space_text_effect="default" font_style="h2" stagger_animation="true" content_alignment="default" mobile_content_alignment="inherit" animation_type="line-reveal-by-space" link_target="_self" text_content="All text and visuals shown here are merely illustrations of potential. You can easily replace every section with details that reflect your business, services, and unique brand voice." text_direction="default" font_text_indent="25vw"][/split_line_heading][vc_row_inner equal_height="yes" column_margin="30px" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="slight-fade-in-from-bottom" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" content_layout="default" gradient_type="default"][split_line_heading line_reveal_by_space_text_effect="none" font_style="p" stagger_animation="true" content_alignment="left" mobile_content_alignment="inherit" animation_type="line-reveal-by-space" link_target="_self" text_content="(About Us)" text_direction="default"][/split_line_heading][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/6" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" content_layout="default" gradient_type="default" offset="vc_hidden-sm vc_hidden-xs"][/vc_column_inner][vc_column_inner right_padding_desktop="15%" right_padding_phone="0" column_element_direction_desktop="default" column_element_spacing="30px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="slight-fade-in-from-bottom" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" content_layout="default" gradient_type="default"][nectar_responsive_text inherited_font_style="default" text_direction="default"]We provide leaders with the strategies they need to make confident decisions. Our approach combines actionable insights with personalized guidance.[/nectar_responsive_text][nectar_responsive_text inherited_font_style="default" text_direction="default"]Whether you’re just starting out or scaling to the next level, we’re here to support your growth every step of the way.[/nectar_responsive_text][nectar_cta btn_style="underline" heading_tag="span" link_type="regular" button_color="default" button_border_thickness="0px" alignment="left" alignment_tablet="default" alignment_phone="default" display="block" display_tablet="inherit" display_phone="inherit" icon_family="none" link_text="View Services" url="#services"][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/6" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="slight-fade-in-from-bottom" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" content_layout="default" gradient_type="default"][image_with_animation image_url="https://themenectar.com/img/demo-media/tn/ceo.jpg" image_size="medium_large" max_width="100%" max_width_mobile="default" animation_type="entrance" animation="None" animation_movement_type="transform_y" hover_animation="none" alignment="" border_radius="15px" box_shadow="none" image_loading="lazy-load" fit_to_container="1" image_object_position="center center"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Horizontal Services', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'] . ' ' . $cat_display_names['services'];
$data['custom_class'] = 'general services date-08-Oct-2025';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/harbor-sticky-content-sections.webp' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="10%" bottom_padding="5px" left_padding_desktop="5px" constrain_group_2="yes" right_padding_desktop="5px" top_padding_tablet="15%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" flex_gap_desktop="10px" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding="40px" left_padding_desktop="40px" constrain_group_2="yes" right_padding_desktop="40px" bottom_padding_tablet="20px" left_padding_tablet="20px" constrain_group_4="yes" right_padding_tablet="20px" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" flex_gap_desktop="10px" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][nectar_responsive_text inherited_font_style="default" text_direction="default"]
<h2>How we can help you</h2>
[/nectar_responsive_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="5px" bottom_padding="5px" left_padding_desktop="5px" constrain_group_2="yes" right_padding_desktop="5px" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" id="services" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" flex_gap_desktop="10px" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][nectar_sticky_media_sections type="horizontal-scrolling" horizontal_effect="default" horizontal_section_width="85" section_height="100vh" horizontal_section_gap_desktop="5px" content_alignment="stretch" border_radius="15px"][nectar_sticky_media_section section_type="color" section_color_source="palette" link_target="_self" section_color_palette="extra-color-1"][vc_row_inner equal_height="yes" column_margin="custom" column_margin_custom="10vw" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding="56px" constrain_group_1="yes" bottom_padding="56px" left_padding_desktop="56px" constrain_group_2="yes" right_padding_desktop="56px" top_padding_tablet="30px" constrain_group_3="yes" bottom_padding_tablet="30px" left_padding_tablet="30px" constrain_group_4="yes" right_padding_tablet="30px" top_padding_phone="20px" constrain_group_5="yes" bottom_padding_phone="20px" left_padding_phone="20px" constrain_group_6="yes" right_padding_phone="20px" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" flex_gap_desktop="15px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="small_desktop" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" content_layout="flexbox" flex_layout_desktop="column" flex_justify_content_desktop="space-between" flex_align_items_desktop="flex-start" flex_align_items_phone="" flex_wrap_desktop="nowrap" flex_reverse_desktop="false" gradient_type="default" offset="vc_col-lg-6 vc_col-md-6"][nectar_responsive_text inherited_font_style="default" font_size_desktop="20vw" font_line_height="1" text_direction="default"]
<h2>01</h2>
[/nectar_responsive_text][nectar_responsive_text inherited_font_style="default" text_direction="default" max_width="75%"]
<h2>Tailored Strategic Planning Sessions</h2>
[/nectar_responsive_text][nectar_responsive_text inherited_font_style="default" text_direction="default"]Build a clear roadmap with tailored strategy sessions that align your financial goals with practical, actionable steps. Uncovers opportunities and challenges, giving you the clarity to move forward.[/nectar_responsive_text][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://themenectar.com/img/demo-media/unsplash/planning-sessions.jpg" background_image_position="center center" background_image_stacking="default" enable_bg_scale="true" background_image_loading="default" column_backdrop_filter="none" column_shadow="none" column_border_radius="15px" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="small_desktop" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" content_layout="default" gradient_type="default" offset="vc_col-lg-6 vc_col-md-6"][divider line_type="No Line" custom_height="400px"][/vc_column_inner][/vc_row_inner][/nectar_sticky_media_section][nectar_sticky_media_section section_type="color" section_color_source="palette" link_target="_self" section_color_palette="extra-color-2"][vc_row_inner equal_height="yes" column_margin="custom" column_margin_custom="10vw" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding="56px" constrain_group_1="yes" bottom_padding="56px" left_padding_desktop="56px" constrain_group_2="yes" right_padding_desktop="56px" top_padding_tablet="30px" constrain_group_3="yes" bottom_padding_tablet="30px" left_padding_tablet="30px" constrain_group_4="yes" right_padding_tablet="30px" top_padding_phone="20px" constrain_group_5="yes" bottom_padding_phone="20px" left_padding_phone="20px" constrain_group_6="yes" right_padding_phone="20px" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" flex_gap_desktop="15px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="small_desktop" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" content_layout="flexbox" flex_layout_desktop="column" flex_justify_content_desktop="space-between" flex_align_items_desktop="flex-start" flex_align_items_phone="" flex_wrap_desktop="nowrap" flex_reverse_desktop="false" gradient_type="default" offset="vc_col-lg-6 vc_col-md-6"][nectar_responsive_text inherited_font_style="default" font_size_desktop="20vw" font_line_height="1" text_direction="default"]
<h2>02</h2>
[/nectar_responsive_text][nectar_responsive_text inherited_font_style="default" text_direction="default" max_width="75%"]
<h2>1:1 Consulting &amp; Advisory</h2>
[/nectar_responsive_text][nectar_responsive_text inherited_font_style="default" text_direction="default"]Get personalized guidance through one-on-one consulting that tackles your most pressing financial and operational challenges. We provide fresh insights and practical solutions to keep your business moving.[/nectar_responsive_text][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://themenectar.com/img/demo-media/tn/advisory.jpg" background_image_position="center center" background_image_stacking="default" enable_bg_scale="true" background_image_loading="default" column_backdrop_filter="none" column_shadow="none" column_border_radius="15px" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="small_desktop" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" content_layout="default" gradient_type="default" offset="vc_col-lg-6 vc_col-md-6"][divider line_type="No Line" custom_height="400px"][/vc_column_inner][/vc_row_inner][/nectar_sticky_media_section][nectar_sticky_media_section section_type="color" section_color_source="palette" link_target="_self" section_color_palette="extra-color-3"][vc_row_inner equal_height="yes" column_margin="custom" column_margin_custom="10vw" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding="56px" constrain_group_1="yes" bottom_padding="56px" left_padding_desktop="56px" constrain_group_2="yes" right_padding_desktop="56px" top_padding_tablet="30px" constrain_group_3="yes" bottom_padding_tablet="30px" left_padding_tablet="30px" constrain_group_4="yes" right_padding_tablet="30px" top_padding_phone="20px" constrain_group_5="yes" bottom_padding_phone="20px" left_padding_phone="20px" constrain_group_6="yes" right_padding_phone="20px" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" flex_gap_desktop="15px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="small_desktop" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" content_layout="flexbox" flex_layout_desktop="column" flex_justify_content_desktop="space-between" flex_align_items_desktop="flex-start" flex_align_items_phone="" flex_wrap_desktop="nowrap" flex_reverse_desktop="false" gradient_type="default" offset="vc_col-lg-6 vc_col-md-6"][nectar_responsive_text inherited_font_style="default" font_size_desktop="20vw" font_line_height="1" text_direction="default"]
<h2>03</h2>
[/nectar_responsive_text][nectar_responsive_text inherited_font_style="default" text_direction="default" max_width="85%"]
<h2>Comprehensive Tools &amp; Data Analytics</h2>
[/nectar_responsive_text][nectar_responsive_text inherited_font_style="default" text_direction="default"]Exclusive templates, tools, and priority support designed to help you make smarter decisions. With a curated resource library and direct communication channels, you’ll always have expert guidance.[/nectar_responsive_text][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://themenectar.com/img/demo-media/unsplash/working.jpg" background_image_position="center center" background_image_stacking="default" enable_bg_scale="true" background_image_loading="default" column_backdrop_filter="none" column_shadow="none" column_border_radius="15px" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="small_desktop" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" content_layout="default" gradient_type="default" offset="vc_col-lg-6 vc_col-md-6"][divider line_type="No Line" custom_height="400px"][/vc_column_inner][/vc_row_inner][/nectar_sticky_media_section][/nectar_sticky_media_sections][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Team Section', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['team'];
$data['custom_class'] = 'team date-07-Oct-2025';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/harbor-team.webp' );
$data['content'] = <<<CONTENT
[vc_section type="full_width_background" text_color="dark" top_padding="10%" bottom_padding_tablet="10%" row_border_radius="none" row_border_radius_applies="bg" content_layout="default" advanced_gradient_display_type="linear"][vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" left_padding_desktop="40px" constrain_group_2="yes" right_padding_desktop="40px" left_padding_tablet="20px" constrain_group_4="yes" right_padding_tablet="20px" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" row_position_desktop="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" flex_gap_desktop="10px" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][split_line_heading line_reveal_by_space_text_effect="default" font_style="h2" stagger_animation="true" content_alignment="default" mobile_content_alignment="inherit" animation_type="line-reveal-by-space" link_target="_self" text_content="We believe financial clarity comes from turning complex numbers into practical strategies. Our approach helps you move quickly, stay aligned, and uncover opportunities before they arise." text_direction="default" font_text_indent="25vw"]The layouts, service descriptions, and visuals displayed here are provided as illustrative examples. Adapt and customize them to match your industry, audience, and goals[/split_line_heading][/vc_column][/vc_row][vc_row type="full_width_content" full_screen_row_position="middle" column_margin="10px" equal_height="yes" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="5%" constrain_group_1="yes" bottom_padding="5%" left_padding_desktop="30px" constrain_group_2="yes" right_padding_desktop="30px" bottom_padding_tablet="0" left_padding_tablet="20px" constrain_group_4="yes" right_padding_tablet="20px" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" row_position_desktop="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" flex_gap_desktop="10px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="slight-fade-in-from-bottom" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" content_layout="flexbox" gradient_type="default" flex_layout_desktop="row" flex_justify_content_desktop="flex-start" flex_align_items_desktop="flex-end" flex_align_items_phone="" flex_wrap_desktop="nowrap" flex_reverse_desktop="false" offset="vc_col-xs-6"][image_with_animation image_url="https://themenectar.com/img/demo-media/tn/team-photo.jpg" image_size="full" max_width="100%" max_width_mobile="default" animation_type="entrance" animation="None" animation_movement_type="transform_y" hover_animation="none" alignment="" border_radius="15px" box_shadow="none" image_loading="default" fit_to_container="1" image_object_position="center center"][/vc_column][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" flex_gap_desktop="10px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="slight-fade-in-from-bottom" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" content_layout="flexbox" flex_layout_desktop="column" flex_justify_content_desktop="flex-end" flex_align_items_desktop="flex-start" flex_align_items_phone="" flex_wrap_desktop="nowrap" flex_reverse_desktop="false" gradient_type="default" offset="vc_col-xs-6"][image_with_animation image_url="https://themenectar.com/img/demo-media/unsplash/office-minimal.jpg" image_size="full" max_width="50%" max_width_mobile="100%" animation_type="entrance" animation="None" animation_movement_type="transform_y" hover_animation="none" alignment="" border_radius="15px" box_shadow="none" image_loading="default"][/vc_column][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" top_margin_tablet="30px" flex_gap_desktop="40px" flex_gap_tablet="20px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="slight-fade-in-from-bottom" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" content_layout="flexbox" flex_layout_desktop="column" flex_justify_content_desktop="flex-end" flex_align_items_desktop="flex-start" flex_align_items_phone="" flex_wrap_desktop="nowrap" flex_reverse_desktop="false" gradient_type="default" offset="vc_col-xs-12"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" flex_gap_desktop="10px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" content_layout="flexbox" flex_layout_desktop="column" flex_justify_content_desktop="flex-start" flex_align_items_desktop="flex-start" flex_align_items_phone="" flex_wrap_desktop="nowrap" flex_reverse_desktop="false" gradient_type="default"][nectar_responsive_text inherited_font_style="default" text_direction="default"]
<h4>Smarter Decisions, Faster</h4>
[/nectar_responsive_text][nectar_responsive_text inherited_font_style="default" text_direction="default"]Turn complex numbers into clear strategies. Access actionable insights that help you make confident business moves without hesitation.[/nectar_responsive_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" flex_gap_desktop="10px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" content_layout="flexbox" gradient_type="default" flex_layout_desktop="column" flex_justify_content_desktop="flex-start" flex_align_items_desktop="flex-start" flex_align_items_phone="" flex_wrap_desktop="nowrap" flex_reverse_desktop="false"][nectar_responsive_text inherited_font_style="default" text_direction="default"]
<h4>Growth That Stays on Course</h4>
[/nectar_responsive_text][nectar_responsive_text inherited_font_style="default" text_direction="default"]Track performance against your goals in real time. Keep every department aligned and ensure your company grows with purpose.[/nectar_responsive_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" flex_gap_desktop="10px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" content_layout="flexbox" gradient_type="default" flex_layout_desktop="column" flex_justify_content_desktop="flex-start" flex_align_items_desktop="flex-start" flex_align_items_phone="" flex_wrap_desktop="nowrap" flex_reverse_desktop="false"][nectar_responsive_text inherited_font_style="default" text_direction="default"]
<h4>Opportunities Before They Surface</h4>
[/nectar_responsive_text][nectar_responsive_text inherited_font_style="default" text_direction="default"]Uncover market shifts and financial signals early. Stay ahead of risks and seize advantages before your competitors even notice.[/nectar_responsive_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][/vc_section]
CONTENT;

vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Harbor Difference', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['counters'];
$data['custom_class'] = 'counters date-06-Oct-2025';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/harbor-difference.webp' );
$data['content'] = <<<CONTENT
[vc_section type="full_width_background" text_color="light" top_padding="5%" top_padding_tablet="10%" background_color="#000000" background_image="https://themenectar.com/img/demo-media/unsplash/sky.webp" background_image_type="default" background_image_position="center center" background_image_loading="default" advanced_gradient="linear-gradient(0deg, rgb(0,0,0) 45%, rgb(0,0,0) 45%)" advanced_gradient_opacity="0.2" advanced_gradient_opacity_hover="0.2" row_border_radius="none" row_border_radius_applies="bg" parallax_bg="true" parallax_bg_scroll_effect="parallax" parallax_bg_speed="fast" content_layout="default" advanced_gradient_display_type="linear"][vc_row type="full_width_content" full_screen_row_position="middle" column_margin="custom" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" mouse_sensitivity="19" left_padding_desktop="40px" constrain_group_2="yes" right_padding_desktop="40px" left_padding_tablet="20px" constrain_group_4="yes" right_padding_tablet="20px" text_color="light" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" sticky_content="true" sticky_content_functionality="css" sticky_content_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="advanced" border_bottom_desktop="1px" column_border_color="#FFFFFF36" column_border_style="solid" column_padding_type="default" content_layout="default" gradient_type="default"][split_line_heading line_reveal_by_space_text_effect="scroll-opacity-reveal" font_style="h2" stagger_animation="true" font_size_min="32px" content_alignment="default" mobile_content_alignment="inherit" animation_type="line-reveal-by-space" link_target="_self" text_content="Layouts, service descriptions, and visuals here are sample examples. Customize them to fit your industry, audience, and goals." font_size="5vw" text_direction="default"][/split_line_heading][divider line_type="No Line" custom_height="30vh" custom_height_phone="15vh" custom_height_tablet="20vh"][/vc_column][/vc_row][vc_row type="full_width_content" full_screen_row_position="middle" column_margin="custom" column_margin_custom="7%" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="40px" bottom_padding="40px" left_padding_desktop="40px" constrain_group_2="yes" right_padding_desktop="40px" left_padding_tablet="20px" constrain_group_4="yes" right_padding_tablet="20px" text_color="light" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="hidden" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column right_padding_phone="0" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="small_desktop" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" content_layout="default" gradient_type="default" offset="vc_col-md-4 vc_col-xs-6"][nectar_badge display_tag="body" badge_style="default" bg_color_type="custom" bg_color_custom="#FFFFFF1F" text_color="#FFFFFF" backdrop_filter="blur" backdrop_filter_blur="12" padding="small" border_radius="20px" display="block" text="Value created"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" flex_layout_tablet="column" flex_gap_desktop="25px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" content_layout="flexbox" flex_layout_desktop="row" flex_justify_content_desktop="flex-start" flex_align_items_desktop="flex-start" flex_align_items_phone="" flex_wrap_desktop="nowrap" flex_reverse_desktop="false" gradient_type="default" flex_layout_phone="column"][nectar_responsive_text inherited_font_style="h2" font_size_min="40px" text_direction="default" font_size_desktop="3vw"]$175M[/nectar_responsive_text][nectar_responsive_text inherited_font_style="default" font_size_min="16px" font_size_max="22px" text_direction="default" max_width="280px" font_size_desktop="1.1vw" font_line_height="1.4"]
<p data-start="399" data-end="491">Empowering growth through strategic solutions.</p>

[/nectar_responsive_text][/vc_column_inner][/vc_row_inner][/vc_column][vc_column left_padding_phone="0" constrain_group_105="yes" right_padding_phone="0" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="small_desktop" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" content_layout="default" gradient_type="default" offset="vc_col-md-4 vc_col-xs-6"][nectar_badge display_tag="body" badge_style="default" bg_color_type="custom" bg_color_custom="#FFFFFF1F" text_color="#FFFFFF" backdrop_filter="blur" backdrop_filter_blur="12" padding="small" border_radius="20px" display="block" text="Return client rate"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" flex_layout_tablet="column" flex_gap_desktop="25px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" content_layout="flexbox" flex_layout_desktop="row" flex_justify_content_desktop="flex-start" flex_align_items_desktop="flex-start" flex_align_items_phone="" flex_wrap_desktop="nowrap" flex_reverse_desktop="false" gradient_type="default" flex_layout_phone="column"][nectar_responsive_text inherited_font_style="h2" font_size_min="40px" font_size_desktop="3vw" text_direction="default"]92%[/nectar_responsive_text][nectar_responsive_text inherited_font_style="default" font_size_min="16px" font_size_max="22px" text_direction="default" max_width="280px" font_size_desktop="1.1vw" font_line_height="1.4"]
<p data-start="399" data-end="491">Building lasting partnerships built on trust.</p>

[/nectar_responsive_text][/vc_column_inner][/vc_row_inner][/vc_column][vc_column left_padding_phone="0" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="small_desktop" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" content_layout="default" gradient_type="default" offset="vc_col-md-4 vc_col-xs-12 vc_hidden-xs"][nectar_badge display_tag="body" badge_style="default" bg_color_type="custom" bg_color_custom="#FFFFFF1F" text_color="#FFFFFF" backdrop_filter="blur" backdrop_filter_blur="12" padding="small" border_radius="20px" display="block" text="Projects delivered"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" flex_layout_tablet="column" flex_gap_desktop="25px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" content_layout="flexbox" flex_layout_desktop="row" flex_justify_content_desktop="flex-start" flex_align_items_desktop="flex-start" flex_align_items_phone="" flex_wrap_desktop="nowrap" flex_reverse_desktop="false" gradient_type="default" flex_layout_phone="column"][nectar_responsive_text inherited_font_style="h2" font_size_min="40px" font_size_desktop="3vw" text_direction="default"]320+[/nectar_responsive_text][nectar_responsive_text inherited_font_style="default" font_size_min="16px" font_size_max="22px" text_direction="default" max_width="280px" font_size_desktop="1.1vw" font_line_height="1.4"]
<p data-start="399" data-end="491">Driving successful outcomes across industries.</p>

[/nectar_responsive_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][/vc_section]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Harbor Testimonials', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['testimonials'];
$data['custom_class'] = 'testimonials date-05-Oct-2025';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/harbor-testimonials.webp' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" id="testimonials" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" flex_gap_desktop="10px" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][nectar_sticky_media_sections type="layered-card-reveal" layered_card_reveal_aspect_ratio="4-5" content_alignment="stretch" border_radius="15px" layered_card_reveal_width="31" layered_card_reveal_effect="stack" layered_card_reveal_width_desktop="400px" layered_card_reveal_width_phone="85vw"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding_phone="20%" translate_y="-50%" translate_y_phone="0" text_align="left" row_position="absolute" row_position_tablet="inherit" row_position_phone="relative" top_position_desktop="50%" left_position_desktop="30px" top_position_phone="0" left_position_phone="0" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="center" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" content_layout="default" gradient_type="default"][nectar_responsive_text inherited_font_style="h5" text_direction="default"]Testimonials[/nectar_responsive_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" translate_y="-50%" translate_y_phone="0" text_align="left" row_position="absolute" row_position_tablet="inherit" row_position_phone="relative" top_position_desktop="50%" right_position_desktop="30px" top_position_phone="0" right_position_phone="0" overflow="visible" device_visibility_phone="hidden" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="center" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" content_layout="default" gradient_type="default"][nectar_responsive_text inherited_font_style="h5" text_direction="default"]They love us[/nectar_responsive_text][/vc_column_inner][/vc_row_inner][nectar_sticky_media_section section_type="color" section_color_source="palette" link_target="_self" section_color_palette="extra-color-3"][vc_row_inner equal_height="yes" column_margin="custom" column_margin_custom="150px" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding="7%" constrain_group_1="yes" bottom_padding="7%" left_padding_desktop="7%" constrain_group_2="yes" right_padding_desktop="7%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="20px" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="small_desktop" animation_type="default" bg_image_animation="none" parallax_bg="true" parallax_bg_speed="fast" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" content_layout="default" gradient_type="default" offset="vc_col-xs-6"][nectar_responsive_text inherited_font_style="h2" font_size_desktop="80px" text_direction="default" font_line_height="1"]S[/nectar_responsive_text][/vc_column_inner][vc_column_inner left_padding_phone="25px" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="small_desktop" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" content_layout="default" gradient_type="default" offset="vc_col-xs-6"][image_with_animation image_url="https://themenectar.com/img/demo-media/unsplash/harbor-testimonial-man.jpg" image_size="large" max_width="100%" max_width_mobile="default" animation_type="entrance" animation="None" animation_movement_type="transform_y" hover_animation="none" alignment="" border_radius="15px" box_shadow="none" image_loading="default"][/vc_column_inner][/vc_row_inner][divider line_type="No Line" custom_height="100%"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding="7%" left_padding_desktop="7%" right_padding_desktop="7%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="5px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" content_layout="default" gradient_type="default"][nectar_responsive_text inherited_font_style="default" text_direction="default" font_size_desktop="22px" font_line_height="1.3" font_size_phone="19px"]"Straightforward and supportive. Working together turned numbers into an actionable plan I could trust."[/nectar_responsive_text][divider line_type="No Line" custom_height="30px"][nectar_responsive_text inherited_font_style="default" text_direction="default" font_line_height="1.1"]<strong>Samuel Mitchell</strong>[/nectar_responsive_text][nectar_responsive_text inherited_font_style="default" text_direction="default" font_line_height="1.1"]Restaurant Owner[/nectar_responsive_text][/vc_column_inner][/vc_row_inner][/nectar_sticky_media_section][nectar_sticky_media_section section_type="color" section_color_source="palette" link_target="_self" section_color_palette="extra-color-1"][vc_row_inner equal_height="yes" column_margin="custom" column_margin_custom="150px" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding="7%" constrain_group_1="yes" bottom_padding="7%" left_padding_desktop="7%" constrain_group_2="yes" right_padding_desktop="7%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="20px" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="small_desktop" animation_type="default" bg_image_animation="none" parallax_bg="true" parallax_bg_speed="fast" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" content_layout="default" gradient_type="default" offset="vc_col-xs-6"][nectar_responsive_text inherited_font_style="h2" font_size_desktop="80px" text_direction="default" font_line_height="1"]M[/nectar_responsive_text][/vc_column_inner][vc_column_inner left_padding_phone="25px" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="small_desktop" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" content_layout="default" gradient_type="default" offset="vc_col-xs-6"][image_with_animation image_url="https://themenectar.com/img/demo-media/unsplash/harbor-testimonial-woman.jpg" image_size="large" max_width="100%" max_width_mobile="default" animation_type="entrance" animation="None" animation_movement_type="transform_y" hover_animation="none" alignment="" border_radius="15px" box_shadow="none" image_loading="default"][/vc_column_inner][/vc_row_inner][divider line_type="No Line" custom_height="100%"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding="7%" left_padding_desktop="7%" right_padding_desktop="7%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="5px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" content_layout="default" gradient_type="default"][nectar_responsive_text inherited_font_style="default" text_direction="default" font_size_desktop="22px" font_line_height="1.3" font_size_phone="19px"]"Clear, practical advice that actually made sense. Exactly the guidance I received helped me move forward with confidence."[/nectar_responsive_text][divider line_type="No Line" custom_height="30px"][nectar_responsive_text inherited_font_style="default" text_direction="default" font_line_height="1.1"]<strong>Marissa Lawson</strong>[/nectar_responsive_text][nectar_responsive_text inherited_font_style="default" text_direction="default" font_line_height="1.1"]CCO, Nectar Media[/nectar_responsive_text][/vc_column_inner][/vc_row_inner][/nectar_sticky_media_section][nectar_sticky_media_section section_type="color" section_color_source="palette" link_target="_self" section_color_palette="extra-color-2"][vc_row_inner equal_height="yes" column_margin="custom" column_margin_custom="150px" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding="7%" constrain_group_1="yes" bottom_padding="7%" left_padding_desktop="7%" constrain_group_2="yes" right_padding_desktop="7%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="20px" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="small_desktop" animation_type="default" bg_image_animation="none" parallax_bg="true" parallax_bg_speed="fast" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" content_layout="default" gradient_type="default" offset="vc_col-xs-6"][nectar_responsive_text inherited_font_style="h2" font_size_desktop="80px" text_direction="default" font_line_height="1"]G[/nectar_responsive_text][/vc_column_inner][vc_column_inner left_padding_phone="25px" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="small_desktop" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" content_layout="default" gradient_type="default" offset="vc_col-xs-6"][image_with_animation image_url="https://themenectar.com/img/demo-media/unsplash/harbor-testimonial-man-2.jpg" image_size="large" max_width="100%" max_width_mobile="default" animation_type="entrance" animation="None" animation_movement_type="transform_y" hover_animation="none" alignment="" border_radius="15px" box_shadow="none" image_loading="default"][/vc_column_inner][/vc_row_inner][divider line_type="No Line" custom_height="100%"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding="7%" left_padding_desktop="7%" right_padding_desktop="7%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="5px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" content_layout="default" gradient_type="default"][nectar_responsive_text inherited_font_style="default" text_direction="default" font_size_desktop="22px" font_line_height="1.3" font_size_phone="19px"]"Professional, reliable, and easy to understand — Jonathan gave me the clarity I needed to plan my finances."[/nectar_responsive_text][divider line_type="No Line" custom_height="30px"][nectar_responsive_text inherited_font_style="default" text_direction="default" font_line_height="1.1"]<strong>Gabriel Roberts</strong>[/nectar_responsive_text][nectar_responsive_text inherited_font_style="default" text_direction="default" font_line_height="1.1"]Marketing Director[/nectar_responsive_text][/vc_column_inner][/vc_row_inner][/nectar_sticky_media_section][/nectar_sticky_media_sections][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Harbor Pricing', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['pricing'];
$data['custom_class'] = 'pricing date-04-Oct-2025';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/harbor-pricing.webp' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="5%" bottom_padding="5%" left_padding_desktop="15%" constrain_group_2="yes" right_padding_desktop="15%" bottom_padding_tablet="10%" left_padding_phone="20px" constrain_group_6="yes" right_padding_phone="20px" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" zindex="2" row_position_desktop="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" id="pricing" shape_divider_position="bottom" bg_image_animation="none" gradient_type="advanced" shape_type="" advanced_gradient_display_type="linear"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="30px" desktop_text_alignment="center" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="static" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="default" content_layout="default"][split_line_heading line_reveal_by_space_text_effect="fade-bottom" font_style="p" content_alignment="default" mobile_content_alignment="inherit" animation_type="line-reveal-by-space" link_target="_self" text_content="(Pricing)" text_direction="default"][/split_line_heading][split_line_heading line_reveal_by_space_text_effect="default" font_style="h2" stagger_animation="true" content_alignment="default" mobile_content_alignment="inherit" animation_type="line-reveal-by-space" link_target="_self" text_content="The strategic insight and guidance that leaders use to make confident financial decisions." text_direction="default"][/split_line_heading][/vc_column][/vc_row][vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" bottom_padding="50px" left_padding_desktop="40px" constrain_group_2="yes" right_padding_desktop="40px" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" zindex="2" row_position_desktop="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="hidden" shape_divider_position="bottom" bg_image_animation="none" gradient_type="advanced" shape_type="" advanced_gradient_display_type="linear"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="50px" desktop_text_alignment="center" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="static" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="default" content_layout="default"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" left_padding_tablet="20%" constrain_group_4="yes" right_padding_tablet="20%" left_padding_phone="0" constrain_group_6="yes" right_padding_phone="0" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" flex_gap_desktop="10px" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][vc_gallery css="" type="flickity_static_height_style" flickity_spacing="40px" flickity_controls="none" flickity_overflow="visible" flickity_wrap_around="wrap" flickity_autoplay="true" flickity_autorotate_type="ticker" flickity_ticker_speed="slow" flickity_mask_edges="yes" flickity_box_shadow="none" image_loading="default" onclick="link_no" flickity_img_height="4vw" flickity_img_small_desktop_height="30px" flickity_img_tablet_height="30px" flickity_img_mobile_height="20px"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row type="full_width_content" full_screen_row_position="middle" column_margin="none" equal_height="yes" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" left_padding_desktop="40px" constrain_group_2="yes" right_padding_desktop="40px" left_padding_tablet="20px" constrain_group_4="yes" right_padding_tablet="20px" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" row_position_desktop="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column top_padding_desktop="40px" constrain_group_100="yes" bottom_padding_desktop="40px" left_padding_desktop="40px" constrain_group_101="yes" right_padding_desktop="40px" top_padding_phone="20px" constrain_group_104="yes" bottom_padding_phone="20px" left_padding_phone="20px" constrain_group_105="yes" right_padding_phone="20px" column_element_direction_desktop="default" column_element_spacing="20px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="advanced" border_left_desktop="1px" border_top_desktop="1px" border_bottom_desktop="1px" border_left_tablet="1px" border_top_tablet="1px" border_right_tablet="1px" border_bottom_tablet="0px" column_border_color="#00000033" column_border_style="solid" column_padding_type="advanced" content_layout="default" gradient_type="default"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner flex_gap_desktop="25px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" content_layout="flexbox" gradient_type="default" flex_layout_desktop="column" flex_justify_content_desktop="flex-start" flex_align_items_desktop="flex-start" flex_align_items_phone="" flex_wrap_desktop="nowrap" flex_reverse_desktop="false"][nectar_responsive_text inherited_font_style="default" font_size_min="28px" font_size_desktop="2vw" text_direction="default" font_line_height="1"]
<h3>Starter</h3>
[/nectar_responsive_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" content_layout="default" gradient_type="default" min_height_desktop="150"][nectar_responsive_text inherited_font_style="default" text_color="#0000007A" text_direction="default"]Perfect for individuals or small teams beginning their financial journey. A simple plan to help you get started with clarity.[/nectar_responsive_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner flex_gap_desktop="0" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" content_layout="flexbox" flex_layout_desktop="row" flex_justify_content_desktop="flex-start" flex_align_items_desktop="flex-end" flex_align_items_phone="" flex_wrap_desktop="nowrap" flex_reverse_desktop="false" gradient_type="default"][nectar_responsive_text inherited_font_style="default" font_size_min="40px" font_size_desktop="3vw" text_direction="default" font_line_height="1"]
<h3>$99</h3>
[/nectar_responsive_text][nectar_responsive_text inherited_font_style="default" text_direction="default" font_line_height="1.3"]/month[/nectar_responsive_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner bottom_padding_desktop="20px" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" content_layout="default" gradient_type="default"][nectar_cta btn_style="arrow-circle-animation" heading_tag="span" border_radius="100" link_type="regular" button_color="custom" button_color_custom="#000000" text_color="#FFFFFF" button_border_thickness="0px" alignment="stretch" alignment_tablet="default" alignment_phone="default" icon_gap="40" backdrop_filter="blur" backdrop_filter_blur="13" display="inline" display_tablet="inherit" display_phone="inherit" link_text="Learn More" padding_top="4px" padding_bottom="4px" padding_left="20px" padding_right="4px" margin_right="10" margin_top="20px"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner top_padding_desktop="40px" flex_gap_desktop="10px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="advanced" border_top_desktop="1" column_border_color="#00000033" column_border_style="solid" column_padding_type="advanced" content_layout="flexbox" gradient_type="default" height_desktop="100%" flex_layout_desktop="column" flex_justify_content_desktop="space-between" flex_align_items_desktop="stretch" flex_align_items_phone="" flex_wrap_desktop="nowrap" flex_reverse_desktop="false"][vc_column_text css="" text_direction="default"]Plan Includes:[/vc_column_text][fancy-ul icon_type="standard_dot" alignment="left" spacing="default" link_style="default"]
<ul>
 	<li>1 Kick-off strategy call</li>
 	<li>2 Follow-up sessions</li>
 	<li>Access to digital templates</li>
</ul>
[/fancy-ul][/vc_column_inner][/vc_row_inner][/vc_column][vc_column top_padding_desktop="40px" constrain_group_100="yes" bottom_padding_desktop="40px" left_padding_desktop="40px" constrain_group_101="yes" right_padding_desktop="40px" top_padding_phone="20px" constrain_group_104="yes" bottom_padding_phone="20px" left_padding_phone="20px" constrain_group_105="yes" right_padding_phone="20px" column_element_direction_desktop="default" column_element_spacing="20px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="advanced" border_left_desktop="1px" border_top_desktop="1px" border_bottom_desktop="1px" border_left_tablet="1px" border_top_tablet="1px" border_right_tablet="1px" border_bottom_tablet="0px" column_border_color="#00000033" column_border_style="solid" column_padding_type="advanced" content_layout="default" gradient_type="default"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner flex_gap_desktop="25px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" content_layout="flexbox" gradient_type="default" flex_layout_desktop="row" flex_justify_content_desktop="space-between" flex_align_items_desktop="center" flex_align_items_phone="" flex_wrap_desktop="nowrap" flex_reverse_desktop="false"][nectar_responsive_text inherited_font_style="default" font_size_min="28px" font_size_desktop="2vw" text_direction="default" font_line_height="1"]
<h3>Professional</h3>
[/nectar_responsive_text][nectar_badge display_tag="body" badge_style="default" bg_color_type="global" color="extra-color-1" text_color="#000000" padding="small" border_radius="50px" display="inline" text="Reccomended"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" content_layout="default" gradient_type="default" min_height_desktop="150"][nectar_responsive_text inherited_font_style="default" text_color="#0000007A" text_direction="default"]Designed for growing businesses that need deeper insights and tailored strategies. Gain the guidance and tools to scale.[/nectar_responsive_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner flex_gap_desktop="0" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" content_layout="flexbox" flex_layout_desktop="row" flex_justify_content_desktop="flex-start" flex_align_items_desktop="flex-end" flex_align_items_phone="" flex_wrap_desktop="nowrap" flex_reverse_desktop="false" gradient_type="default"][nectar_responsive_text inherited_font_style="default" font_size_min="40px" font_size_desktop="3vw" text_direction="default" font_line_height="1"]
<h3>$399</h3>
[/nectar_responsive_text][nectar_responsive_text inherited_font_style="default" text_direction="default" font_line_height="1.3"]/month[/nectar_responsive_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner bottom_padding_desktop="20px" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" content_layout="default" gradient_type="default"][nectar_cta btn_style="arrow-circle-animation" heading_tag="span" border_radius="100" link_type="regular" button_color="custom" button_color_custom="#000000" text_color="#FFFFFF" button_border_thickness="0px" alignment="stretch" alignment_tablet="default" alignment_phone="default" icon_gap="40" backdrop_filter="blur" backdrop_filter_blur="13" display="inline" display_tablet="inherit" display_phone="inherit" link_text="Learn More" padding_top="4px" padding_bottom="4px" padding_left="20px" padding_right="4px" margin_right="10" margin_top="20px"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner top_padding_desktop="40px" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="advanced" border_top_desktop="1" column_border_color="#00000033" column_border_style="solid" column_padding_type="advanced" content_layout="default" gradient_type="default"][vc_column_text css="" text_direction="default"]Plan Includes:[/vc_column_text][fancy-ul icon_type="standard_dot" alignment="left" spacing="default" link_style="default"]
<ul>
 	<li>Monthly strategic planning session</li>
 	<li>Unlimited 1:1 consulting sessions</li>
 	<li>Resource library access</li>
 	<li>Email + text support</li>
</ul>
[/fancy-ul][/vc_column_inner][/vc_row_inner][/vc_column][vc_column top_padding_desktop="40px" constrain_group_100="yes" bottom_padding_desktop="40px" left_padding_desktop="40px" constrain_group_101="yes" right_padding_desktop="40px" top_padding_phone="20px" constrain_group_104="yes" bottom_padding_phone="20px" left_padding_phone="20px" constrain_group_105="yes" right_padding_phone="20px" column_element_direction_desktop="default" column_element_spacing="20px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="advanced" border_left_desktop="1px" border_top_desktop="1px" border_right_desktop="1px" border_bottom_desktop="1px" border_left_tablet="1px" border_top_tablet="1px" border_right_tablet="1px" border_bottom_tablet="1px" column_border_color="#00000033" column_border_style="solid" column_padding_type="advanced" content_layout="default" gradient_type="default"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner flex_gap_desktop="25px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" content_layout="flexbox" gradient_type="default" flex_layout_desktop="column" flex_justify_content_desktop="flex-start" flex_align_items_desktop="flex-start" flex_align_items_phone="" flex_wrap_desktop="nowrap" flex_reverse_desktop="false"][nectar_responsive_text inherited_font_style="default" font_size_min="28px" font_size_desktop="2vw" text_direction="default" font_line_height="1"]
<h3>Executive</h3>
[/nectar_responsive_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" content_layout="default" gradient_type="default" min_height_desktop="150"][nectar_responsive_text inherited_font_style="default" text_color="#0000007A" text_direction="default"]Built for leaders and organizations managing complex challenges. Unlock premium support, advanced strategies, and priority access.[/nectar_responsive_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner flex_gap_desktop="0" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" content_layout="flexbox" flex_layout_desktop="row" flex_justify_content_desktop="flex-start" flex_align_items_desktop="flex-end" flex_align_items_phone="" flex_wrap_desktop="nowrap" flex_reverse_desktop="false" gradient_type="default"][nectar_responsive_text inherited_font_style="default" font_size_min="40px" font_size_desktop="3vw" text_direction="default" font_line_height="1"]
<h3>$599</h3>
[/nectar_responsive_text][nectar_responsive_text inherited_font_style="default" text_direction="default" font_line_height="1.3"]/month[/nectar_responsive_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner bottom_padding_desktop="20px" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" content_layout="default" gradient_type="default"][nectar_cta btn_style="arrow-circle-animation" heading_tag="span" border_radius="100" link_type="regular" button_color="custom" button_color_custom="#000000" text_color="#FFFFFF" button_border_thickness="0px" alignment="stretch" alignment_tablet="default" alignment_phone="default" icon_gap="40" backdrop_filter="blur" backdrop_filter_blur="13" display="inline" display_tablet="inherit" display_phone="inherit" link_text="Learn More" padding_top="4px" padding_bottom="4px" padding_left="20px" padding_right="4px" margin_right="10" margin_top="20px"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner top_padding_desktop="40px" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="advanced" border_top_desktop="1" column_border_color="#00000033" column_border_style="solid" column_padding_type="advanced" content_layout="default" gradient_type="default"][vc_column_text css="" text_direction="default"]Plan Includes:[/vc_column_text][fancy-ul icon_type="standard_dot" alignment="left" spacing="default" link_style="default"]
<ul>
 	<li>Monthly executive review session</li>
 	<li>6 Custom consulting sessions per month</li>
 	<li>VIP resource library access</li>
 	<li>Priority phone + email support</li>
</ul>
[/fancy-ul][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Harbor CTA', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['cta'];
$data['custom_class'] = 'cta date-02-Oct-2025';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/harbor-cta.webp' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#FFFFFF" scene_position="center" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" row_position_desktop="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column flex_gap_desktop="10px" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="static" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" flexbox_justify_content_tablet="" flexbox_align_items_tablet="" flexbox_direction_tablet="" column_padding_type="advanced" gradient_type="default"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" left_padding_tablet="20%" constrain_group_4="yes" right_padding_tablet="20%" left_padding_phone="10%" constrain_group_6="yes" right_padding_phone="10%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner top_padding_desktop="15%" constrain_group_100="yes" bottom_padding_desktop="15%" top_padding_phone="30%" column_element_direction_desktop="default" column_element_spacing="20px" centered_text="true" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" gradient_type="default" content_layout="default" column_link="#"][split_line_heading line_reveal_by_space_text_effect="blur-bottom" font_style="h2" stagger_animation="true" content_alignment="default" mobile_content_alignment="inherit" animation_type="line-reveal-by-space" link_target="_self" text_direction="default" text_content="Want to get started? Click here to book a meeting."][/split_line_heading][/vc_column_inner][/vc_row_inner][nectar_content_trail animation_in="scale" animation_out="scale" border_radius="23" frequency="85" duration="1.2" lerp="0" randomize="true" randomize_rotation="true" position_desktop="absolute" top_position_desktop="0" bottom_position_desktop="10%" left_position_desktop="0" right_position_desktop="0" height_desktop="100%" overflow="visible" animation="scale" zindex="10" type="text" text_array="%5B%7B%22text_value%22%3A%22Say%20hello%22%7D%2C%7B%22text_value%22%3A%22Let's%20talk%22%7D%2C%7B%22text_value%22%3A%22Start%20today%22%7D%2C%7B%22text_value%22%3A%22Call%20us%22%7D%5D" text_color_array="%5B%7B%22color_value%22%3A%22%23ff4a4b%22%7D%2C%7B%22color_value%22%3A%22%23ffa628%22%7D%2C%7B%22color_value%22%3A%22%238ccbff%22%7D%5D"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Harbor Footer', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-01-Oct-2025';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/harbor-footer.webp' );
$data['content'] = <<<CONTENT
[vc_section type="full_width_background" text_color="dark" row_border_radius="none" row_border_radius_applies="bg" content_layout="default" advanced_gradient_display_type="linear"][vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="column_reverse" scene_position="center" top_padding="40px" bottom_padding="40px" left_padding_desktop="40px" constrain_group_2="yes" right_padding_desktop="40px" bottom_padding_phone="20px" left_padding_phone="20px" constrain_group_6="yes" right_padding_phone="20px" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" flex_gap_desktop="10px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/4" tablet_width_inherit="small_desktop" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" content_layout="flexbox" flex_layout_desktop="column" flex_justify_content_desktop="flex-end" flex_align_items_desktop="flex-start" flex_align_items_phone="flex-end" flex_wrap_desktop="nowrap" flex_reverse_desktop="false" gradient_type="default" flex_layout_phone="row" flex_justify_content_phone="space-between"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" flex_gap_desktop="25px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" content_layout="flexbox" flex_layout_desktop="row" flex_justify_content_desktop="flex-start" flex_align_items_desktop="flex-start" flex_align_items_phone="" flex_wrap_desktop="nowrap" flex_reverse_desktop="false" gradient_type="default"][nectar_icon icon_family="nectarbrands" icon_style="default" icon_color_type="color_scheme" icon_color="Accent-Color" open_new_tab="true" icon_padding="0px" pointer_events="all" icon_nectarbrands="nectar-brands-x-twitter" icon_size="16" url="https://twitter.com"][nectar_icon icon_family="nectarbrands" icon_style="default" icon_color_type="color_scheme" icon_color="Accent-Color" open_new_tab="true" icon_padding="0px" pointer_events="all" icon_size="16" icon_nectarbrands="nectar-brands-instagram" url="https://instagram.com"][nectar_icon icon_family="fontawesome" icon_style="default" icon_color_type="color_scheme" icon_color="Accent-Color" open_new_tab="true" icon_padding="0px" pointer_events="all" icon_size="16" icon_fontawesome="fa fa-linkedin" url="https://linkedin.com"][/vc_column_inner][/vc_row_inner][nectar_responsive_text inherited_font_style="default" font_size_min="16px" text_direction="default"]© ThemeNectar. [nectar_current_year].[/nectar_responsive_text][/vc_column][vc_column top_padding_phone="20px" constrain_group_104="yes" bottom_padding_phone="20px" flex_gap_desktop="20px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="small_desktop" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" content_layout="flexbox" flex_layout_desktop="row" flex_justify_content_desktop="center" flex_align_items_desktop="flex-end" flex_align_items_phone="" flex_wrap_desktop="nowrap" flex_reverse_desktop="false" gradient_type="default" flex_justify_content_phone="flex-start"][nectar_cta btn_style="text-reveal" heading_tag="span" link_type="regular" button_color="default" button_border_thickness="0px" alignment="left" alignment_tablet="default" alignment_phone="default" display="block" display_tablet="inherit" display_phone="inherit" icon_family="none" link_text="About" url="#about"][nectar_cta btn_style="text-reveal" heading_tag="span" link_type="regular" button_color="default" button_border_thickness="0px" alignment="left" alignment_tablet="default" alignment_phone="default" display="block" display_tablet="inherit" display_phone="inherit" icon_family="none" link_text="Services" url="#services"][nectar_cta btn_style="text-reveal" heading_tag="span" link_type="regular" button_color="default" button_border_thickness="0px" alignment="left" alignment_tablet="default" alignment_phone="default" display="block" display_tablet="inherit" display_phone="inherit" icon_family="none" link_text="Pricing" url="#pricing"][/vc_column][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" flex_gap_desktop="10px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/4" tablet_width_inherit="small_desktop" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" content_layout="flexbox" gradient_type="default" flex_layout_desktop="column" flex_justify_content_desktop="flex-end" flex_align_items_desktop="flex-end" flex_align_items_phone="center" flex_wrap_desktop="nowrap" flex_reverse_desktop="false" offset="vc_hidden-xs"][nectar_responsive_text inherited_font_style="default" font_size_min="16px" text_direction="default"]All Rights Reserved.[/nectar_responsive_text][/vc_column][/vc_row][vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" flex_gap_desktop="10px" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][divider line_type="Full Width Line" line_thickness="1" divider_color="default" custom_height="1"][/vc_column][/vc_row][vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" animated_gradient_bg="true" animated_gradient_bg_color_1="#FF4A4B" animated_gradient_bg_speed="850" animated_gradient_bg_blending_mode="linear" scene_position="center" left_padding_desktop="20px" right_padding_desktop="40px" left_padding_tablet="10px" right_padding_tablet="20px" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="hidden" advanced_gradient="linear-gradient(0deg, rgba(255,255,255,0) 10%, rgb(255,255,255) 91%)" shape_divider_position="bottom" bg_image_animation="none" gradient_type="advanced" shape_type="" advanced_gradient_display_type="linear"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" bottom_margin="-7%" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" content_layout="default" gradient_type="default"][split_line_heading line_reveal_by_space_text_effect="none" font_style="h1" fit_text_to_container="true" content_alignment="default" mobile_content_alignment="inherit" animation_type="line-reveal-by-space" link_target="_self" text_content="Harbor" text_direction="default" font_line_height="0.8"][/split_line_heading][/vc_column][/vc_row][/vc_section]
CONTENT;

vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Typography Heavy Gradient', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['hero_section'];
$data['custom_class'] = 'hero_section date-29-Sep-2025';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/typography-gradient.webp' );
$data['content'] = <<<CONTENT
[vc_section type="full_width_content" flex_gap_desktop="0" text_color="light" advanced_gradient="linear-gradient(0deg, rgb(255,255,0) 2%, rgb(165,198,239) 27%, rgb(88,133,253) 62%, rgb(40,83,197) 96%)" row_border_radius="none" row_border_radius_applies="bg" content_layout="flexbox" flex_layout_desktop="column" flex_justify_content_desktop="center" flex_align_items_desktop="stretch" flex_align_items_phone="" flex_wrap_desktop="nowrap" flex_reverse_desktop="false" advanced_gradient_display_type="linear" min_height_desktop="100svh"][vc_row type="in_container" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" left_padding_desktop="20%" constrain_group_2="yes" right_padding_desktop="20%" left_padding_tablet="15%" constrain_group_4="yes" right_padding_tablet="15%" left_padding_phone="0" constrain_group_6="yes" right_padding_phone="0" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" row_position_desktop="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" row_position="default" gradient_type="default" shape_type=""][vc_column flex_gap_desktop="10px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" content_layout="flexbox" flex_layout_desktop="row" flex_justify_content_desktop="center" flex_align_items_desktop="flex-start" flex_align_items_phone="" flex_wrap_desktop="nowrap" flex_reverse_desktop="false" gradient_type="default"][split_line_heading line_reveal_by_space_text_effect="default" font_style="h1" font_size_max="112px" content_alignment="default" mobile_content_alignment="inherit" animation_type="line-reveal-by-space" link_target="_self" text_content="CURIOUS MINDS" font_size="7vw" font_line_height="0.9" text_direction="default" font_size_tablet="6vw" font_size_phone="2.3rem"][/split_line_heading][/vc_column][/vc_row][vc_row type="in_container" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" left_padding_desktop="20%" constrain_group_2="yes" right_padding_desktop="20%" left_padding_tablet="15%" constrain_group_4="yes" right_padding_tablet="15%" left_padding_phone="0" constrain_group_6="yes" right_padding_phone="0" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" row_position_desktop="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" row_position="default" gradient_type="default" shape_type=""][vc_column flex_gap_desktop="3%" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" content_layout="flexbox" flex_layout_desktop="row" flex_justify_content_desktop="flex-start" flex_align_items_desktop="center" flex_align_items_phone="" flex_wrap_desktop="nowrap" flex_reverse_desktop="false" gradient_type="default"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" flex_sizing="true" overflow="visible" device_visibility_phone="hidden" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" flex_gap_desktop="0" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="slight-fade-in-from-bottom" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" content_layout="flexbox" flex_layout_desktop="row" flex_justify_content_desktop="space-between" flex_align_items_desktop="center" flex_align_items_phone="" flex_wrap_desktop="nowrap" flex_reverse_desktop="false" gradient_type="default" delay="200"][nectar_responsive_text inherited_font_style="h6" font_size_max="13px" text_direction="default" font_size_desktop="0.8vw" font_size_tablet="1.2vw"]Impactful design from Philadelphia[/nectar_responsive_text][/vc_column_inner][/vc_row_inner][split_line_heading line_reveal_by_space_text_effect="default" font_style="h1" font_size_max="112px" content_alignment="default" mobile_content_alignment="inherit" animation_type="line-reveal-by-space" link_target="_self" text_content="MAKE CHANGE" font_size="7vw" font_line_height="0.9" text_direction="default" animation_delay="100" font_size_tablet="6vw" font_size_phone="2.3rem"][/split_line_heading][/vc_column][/vc_row][vc_row type="in_container" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" left_padding_desktop="20%" constrain_group_2="yes" right_padding_desktop="20%" left_padding_tablet="15%" constrain_group_4="yes" right_padding_tablet="15%" left_padding_phone="0" constrain_group_6="yes" right_padding_phone="0" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" row_position_desktop="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" row_position="default" gradient_type="default" shape_type=""][vc_column flex_gap_desktop="7%" flex_gap_tablet="12%" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" content_layout="flexbox" flex_layout_desktop="row" flex_justify_content_desktop="flex-start" flex_align_items_desktop="center" flex_align_items_phone="" flex_wrap_desktop="nowrap" flex_reverse_desktop="false" gradient_type="default" flex_justify_content_phone="flex-end"][split_line_heading line_reveal_by_space_text_effect="default" font_style="h1" font_size_max="112px" content_alignment="default" mobile_content_alignment="inherit" animation_type="line-reveal-by-space" link_target="_self" text_content="FROM IDEAS" font_size="7vw" font_line_height="0.9" text_direction="default" animation_delay="200" font_size_tablet="6vw" font_size_phone="2.3rem"][/split_line_heading][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" flex_sizing="true" overflow="visible" device_visibility_phone="hidden" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" flex_gap_desktop="10px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="slight-fade-in-from-bottom" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" content_layout="flexbox" flex_layout_desktop="row" flex_justify_content_desktop="space-between" flex_align_items_desktop="center" flex_align_items_phone="" flex_wrap_desktop="nowrap" flex_reverse_desktop="false" gradient_type="default" delay="300"][nectar_badge display_tag="h6" font_size_max="13px" badge_style="default" bg_color_type="custom" padding="small" border="true" border_radius="100px" display="block" text="`{`nectar_current_year`}` PORTFOLIO" font_size_desktop="0.8vw" font_size_tablet="1.2vw"][nectar_cta btn_style="next-section" btn_type="minimal-arrow-alt" next_section_icon_size="0.8" next_section_down_arrow_alt_animation="default" alignment="left" alignment_tablet="default" alignment_phone="default" display_tablet="inherit" display_phone="inherit"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][/vc_section]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Signal Hero', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['hero_section'];
$data['custom_class'] = 'hero_section date-22-Sep-2025';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/signal-hero.webp' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#FFFFFF" scene_position="center" left_padding_desktop="60px" constrain_group_2="yes" right_padding_desktop="60px" left_padding_tablet="25px" constrain_group_4="yes" right_padding_tablet="25px" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" row_position_desktop="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column flex_gap_desktop="10px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="static" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" flexbox_justify_content_tablet="" flexbox_align_items_tablet="" flexbox_direction_tablet="" column_padding_type="advanced" gradient_type="default" content_layout="flexbox" flex_layout_desktop="column" flex_justify_content_desktop="space-between" flex_align_items_desktop="stretch" flex_align_items_phone="" flex_wrap_desktop="nowrap" flex_reverse_desktop="false" min_height_desktop="100svh"][divider line_type="No Line" custom_height="100%"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" constrain_group_2="yes" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner flex_gap_desktop="5px" flex_gap_tablet="10px" desktop_text_alignment="center" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" gradient_type="default" content_layout="flexbox" flex_layout_desktop="column" flex_justify_content_desktop="center" flex_align_items_desktop="center" flex_align_items_phone="" flex_wrap_desktop="nowrap" flex_reverse_desktop="false"][split_line_heading line_reveal_by_space_text_effect="letter-reveal-bottom" font_style="h1" stagger_animation="true" font_size_max="250px" content_alignment="default" mobile_content_alignment="inherit" animation_type="line-reveal-by-space" link_target="_self" text_direction="default" font_size="14vw" font_line_height="0.85" text_content="WE CREATE"][/split_line_heading][split_line_heading line_reveal_by_space_text_effect="letter-reveal-bottom" font_style="h1" stagger_animation="true" font_size_max="250px" content_alignment="default" mobile_content_alignment="inherit" animation_type="line-reveal-by-space" link_target="_self" text_direction="default" font_size="14vw" font_line_height="0.85" text_content="THE HYPE"][/split_line_heading][/vc_column_inner][/vc_row_inner][divider line_type="No Line" custom_height="100%"][vc_row_inner column_margin="10px" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding="30px" bottom_padding_phone="20px" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" flex_gap_desktop="10px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="small_desktop" animation_type="default" enable_animation="true" animation="slight-fade-in-from-bottom" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" content_layout="flexbox" flex_layout_desktop="row" flex_justify_content_desktop="flex-start" flex_align_items_desktop="flex-end" flex_align_items_phone="" flex_wrap_desktop="nowrap" flex_reverse_desktop="false" gradient_type="default" delay="300" offset="vc_hidden-xs"][nectar_responsive_text inherited_font_style="h6" text_direction="default" font_size_tablet="12px"]Based in New York[/nectar_responsive_text][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="small_desktop" animation_type="default" enable_animation="true" animation="slight-fade-in-from-bottom" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" content_layout="default" gradient_type="default" delay="350"][nectar_responsive_text inherited_font_style="default" text_direction="default" font_size_tablet="14px" font_size_phone="16px"]
<p style="text-align: center;">A boutique marketing + creative agency</p>
[/nectar_responsive_text][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" flex_gap_desktop="10px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="small_desktop" animation_type="default" enable_animation="true" animation="slight-fade-in-from-bottom" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" content_layout="flexbox" flex_layout_desktop="row" flex_justify_content_desktop="flex-end" flex_align_items_desktop="flex-end" flex_align_items_phone="" flex_wrap_desktop="nowrap" flex_reverse_desktop="false" gradient_type="default" delay="400" offset="vc_hidden-xs"][nectar_responsive_text inherited_font_style="h6" text_direction="default" font_size_tablet="12px"]Established 2013[/nectar_responsive_text][/vc_column_inner][/vc_row_inner][nectar_content_trail image_size="large" image_width_phone="100px" animation_in="scale" animation_out="scale" aspect_ratio="3-2" border_radius="10" frequency="110" duration="0.9" lerp="0" randomize_rotation="true" position_desktop="absolute" top_position_desktop="0" bottom_position_desktop="10%" left_position_desktop="0" right_position_desktop="0" height_desktop="100%" overflow="visible" animation="scale" zindex="10" type="images"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Services Carousel', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['services'];
$data['custom_class'] = 'services date-23-Sep-2025';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/signal-carousel.webp' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="12%" bottom_padding="6%" top_padding_tablet="24%" bottom_padding_tablet="15%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" row_position_desktop="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="hidden" id="services" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="top" shape_divider_height="50%" bg_image_animation="none" shape_type="straight_section" gradient_type="default"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" flex_gap_desktop="10px" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" flexbox_justify_content_tablet="" flexbox_align_items_tablet="" flexbox_direction_tablet=""][vc_row_inner equal_height="yes" content_placement="bottom" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding="3%" left_padding_desktop="60px" constrain_group_2="yes" right_padding_desktop="60px" bottom_padding_tablet="6%" left_padding_tablet="25px" right_padding_tablet="40%" left_padding_phone="25px" constrain_group_6="yes" right_padding_phone="25px" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner right_padding_desktop="8%" right_padding_phone="0" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="advanced" content_layout="default"][nectar_responsive_text inherited_font_style="default" text_direction="default"]
<h2>From strategy to spotlight, we make brands shine</h2>
[/nectar_responsive_text][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" flex_gap_desktop="10px" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][nectar_cta btn_style="underline" heading_tag="p" link_type="regular" button_color="default" button_border_thickness="0px" alignment="right" alignment_tablet="default" alignment_phone="left" display="block" display_tablet="inherit" display_phone="inherit" icon_family="none" link_text="Start a Project" url="#contact"][/vc_column_inner][/vc_row_inner][carousel script="flickity" flickity_formatting="default" desktop_cols_flickity="4" desktop_small_cols_flickity="3" tablet_cols_flickity="2" phone_cols_flickity="1" flickity_subtract_from_column_width="80px" flickity_controls="none" color="default" flickity_overflow="visible" flickity_wrap_around="wrap" flickity_spacing="10px" flickity_centered_cells="true" flickity_column_vertical_alignment="default" column_padding="20px" flickity_element_spacing="0" border_radius="10px" autorotate="true" autorotate_type="ticker" ticker_speed="slow" ticker_direction="default" flickity_autorotate_pause_on_hover="true"][item simple_slider_bg_image_position="default" simple_slider_overlay_strength="0.3" simple_slider_bg_image_loading="default" flickity_bg_image_url="https://themenectar.com/img/demo-media/tn/content_creation.jpg" flickity_bg_image_loading="lazy-load" flickity_background_image_gradient_blur="true" flex_gap_desktop="10px" flickity_item_link_type="regular" color_layer_gradient_direction="left_to_right" id="1763427101439-7" title="Item" content_layout="flexbox" advanced_gradient_display_type="linear" flex_layout_desktop="column" flex_justify_content_desktop="space-between" flex_align_items_desktop="flex-start" flex_align_items_phone="" flex_wrap_desktop="nowrap" flex_reverse_desktop="false" tab_id="1763427101439-4"][nectar_responsive_text inherited_font_style="default" text_color="#ffffff" text_direction="default"]
<h3>Content Creation</h3>
[/nectar_responsive_text][divider line_type="No Line" custom_height="350px" custom_height_phone="250px"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" flex_gap_desktop="8px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" content_layout="flexbox" flex_layout_desktop="row" flex_justify_content_desktop="flex-start" flex_align_items_desktop="flex-start" flex_align_items_phone="" flex_wrap_desktop="wrap" flex_reverse_desktop="false" gradient_type="default"][nectar_badge display_tag="body" font_size_min="10px" font_size_max="20px" badge_style="default" bg_color_type="custom" bg_color_custom="rgba(0,0,0,0.09)" padding="small" border_radius="20px" display="block" font_size_desktop="0.8vw" font_line_height="1" blur_background="true" text="Copywriting"][nectar_badge display_tag="body" font_size_min="10px" font_size_max="20px" badge_style="default" bg_color_type="custom" bg_color_custom="rgba(0,0,0,0.09)" padding="small" border_radius="20px" display="block" font_size_desktop="0.8vw" font_line_height="1" blur_background="true" text="Design"][nectar_badge display_tag="body" font_size_min="10px" font_size_max="20px" badge_style="default" bg_color_type="custom" bg_color_custom="rgba(0,0,0,0.09)" padding="small" border_radius="20px" display="block" font_size_desktop="0.8vw" font_line_height="1" blur_background="true" text="Production"][nectar_badge display_tag="body" font_size_min="10px" font_size_max="20px" badge_style="default" bg_color_type="custom" bg_color_custom="rgba(0,0,0,0.09)" padding="small" border_radius="20px" display="block" font_size_desktop="0.8vw" font_line_height="1" blur_background="true" text="Blogs &amp; Articles"][nectar_badge display_tag="body" font_size_min="10px" font_size_max="20px" badge_style="default" bg_color_type="custom" bg_color_custom="rgba(0,0,0,0.09)" padding="small" border_radius="20px" display="block" font_size_desktop="0.8vw" font_line_height="1" blur_background="true" text="Creative Assets"][/vc_column_inner][/vc_row_inner][/item][item simple_slider_bg_image_position="default" simple_slider_overlay_strength="0.3" simple_slider_bg_image_loading="default" flickity_bg_image_url="https://themenectar.com/img/demo-media/tn/ipad-mockup-studio.jpg" flickity_bg_image_loading="lazy-load" flickity_background_image_gradient_blur="true" flex_gap_desktop="10px" flickity_item_link_type="regular" advanced_gradient="linear-gradient(0deg, rgb(0,0,0) 0%, rgba(0,0,0,0) 36%)" advanced_gradient_opacity="0.2" advanced_gradient_opacity_hover="0.2" color_layer_opacity="" color_layer_opacity_hover="" color_layer="linear-gradient(274deg, rgb(255, 96, 96) 10%, #f3f3f3 90%)" color_layer_gradient_angle="274" color_layer_gradient_radial_position="top right" color_layer_gradient_direction="left_b_to_right_t" id="1763427101503-7" title="Item" color_layer_gradient_type="radial" advanced_gradient_display_type="linear" content_layout="flexbox" flex_layout_desktop="column" flex_justify_content_desktop="space-between" flex_align_items_desktop="flex-start" flex_align_items_phone="" flex_wrap_desktop="nowrap" flex_reverse_desktop="false" tab_id="1763427101504-10"][nectar_responsive_text inherited_font_style="default" text_color="#ffffff" text_direction="default"]
<h3>Web Design</h3>
[/nectar_responsive_text][divider line_type="No Line" custom_height="350px" custom_height_phone="250px"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" flex_gap_desktop="8px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" content_layout="flexbox" flex_layout_desktop="row" flex_justify_content_desktop="flex-start" flex_align_items_desktop="flex-start" flex_align_items_phone="" flex_wrap_desktop="wrap" flex_reverse_desktop="false" gradient_type="default"][nectar_badge display_tag="body" font_size_min="10px" font_size_max="20px" badge_style="default" bg_color_type="custom" bg_color_custom="#00000017" padding="small" border_radius="20px" display="block" blur_background="true" text="WordPress" font_size_desktop="0.8vw" font_line_height="1"][nectar_badge display_tag="body" font_size_min="10px" font_size_max="20px" badge_style="default" bg_color_type="custom" bg_color_custom="rgba(0,0,0,0.09)" padding="small" border_radius="20px" display="block" blur_background="true" text="Responsive Design" font_size_desktop="0.8vw" font_line_height="1"][nectar_badge display_tag="body" font_size_min="10px" font_size_max="20px" badge_style="default" bg_color_type="custom" bg_color_custom="rgba(0,0,0,0.09)" padding="small" border_radius="20px" display="block" blur_background="true" text="Prototyping" font_size_desktop="0.8vw" font_line_height="1"][nectar_badge display_tag="body" font_size_min="10px" font_size_max="20px" badge_style="default" bg_color_type="custom" bg_color_custom="rgba(0,0,0,0.09)" padding="small" border_radius="20px" display="block" blur_background="true" text="CMS" font_size_desktop="0.8vw" font_line_height="1"][nectar_badge display_tag="body" font_size_min="10px" font_size_max="20px" badge_style="default" bg_color_type="custom" bg_color_custom="rgba(0,0,0,0.09)" padding="small" border_radius="20px" display="block" blur_background="true" text="Lighthouse" font_size_desktop="0.8vw" font_line_height="1"][/vc_column_inner][/vc_row_inner][/item][item simple_slider_bg_image_position="default" simple_slider_overlay_strength="0.3" simple_slider_bg_image_loading="default" flickity_bg_image_url="https://themenectar.com/img/demo-media/unsplash/abstract-o.jpg" flickity_bg_image_loading="lazy-load" flickity_background_image_gradient_blur="true" flex_gap_desktop="10px" flickity_item_link_type="regular" advanced_gradient="linear-gradient(0deg, rgb(0,0,0) 0%, rgba(0,0,0,0) 37%)" advanced_gradient_opacity="0.2" advanced_gradient_opacity_hover="0.2" color_layer_gradient_direction="left_to_right" id="1763427101580-2" title="Item" content_layout="flexbox" advanced_gradient_display_type="linear" flex_layout_desktop="column" flex_justify_content_desktop="space-between" flex_align_items_desktop="flex-start" flex_align_items_phone="" flex_wrap_desktop="nowrap" flex_reverse_desktop="false" tab_id="1763427101580-8"][nectar_responsive_text inherited_font_style="default" text_color="#ffffff" text_direction="default"]
<h3>Branding</h3>
[/nectar_responsive_text][divider line_type="No Line" custom_height="350px" custom_height_phone="250px"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" flex_gap_desktop="8px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" content_layout="flexbox" flex_layout_desktop="row" flex_justify_content_desktop="flex-start" flex_align_items_desktop="flex-start" flex_align_items_phone="" flex_wrap_desktop="wrap" flex_reverse_desktop="false" gradient_type="default"][nectar_badge display_tag="body" font_size_min="10px" font_size_max="20px" badge_style="default" bg_color_type="custom" bg_color_custom="rgba(0,0,0,0.09)" padding="small" border_radius="20px" display="block" font_size_desktop="0.8vw" font_line_height="1" blur_background="true" text="Logo Design"][nectar_badge display_tag="body" font_size_min="10px" font_size_max="20px" badge_style="default" bg_color_type="custom" bg_color_custom="rgba(0,0,0,0.09)" padding="small" border_radius="20px" display="block" font_size_desktop="0.8vw" font_line_height="1" blur_background="true" text="Strategy"][nectar_badge display_tag="body" font_size_min="10px" font_size_max="20px" badge_style="default" bg_color_type="custom" bg_color_custom="rgba(0,0,0,0.09)" padding="small" border_radius="20px" display="block" font_size_desktop="0.8vw" font_line_height="1" blur_background="true" text="Print"][nectar_badge display_tag="body" font_size_min="10px" font_size_max="20px" badge_style="default" bg_color_type="custom" bg_color_custom="rgba(0,0,0,0.09)" padding="small" border_radius="20px" display="block" font_size_desktop="0.8vw" font_line_height="1" blur_background="true" text="Style Guides"][nectar_badge display_tag="body" font_size_min="10px" font_size_max="20px" badge_style="default" bg_color_type="custom" bg_color_custom="rgba(0,0,0,0.09)" padding="small" border_radius="20px" display="block" font_size_desktop="0.8vw" font_line_height="1" blur_background="true" text="Visual Identity"][/vc_column_inner][/vc_row_inner][/item][item simple_slider_bg_image_position="default" simple_slider_overlay_strength="0.3" simple_slider_bg_image_loading="default" flickity_bg_image_url="https://themenectar.com/img/demo-media/unsplash/laptop-top.jpg" flickity_bg_image_loading="lazy-load" flickity_background_image_gradient_blur="true" flex_gap_desktop="10px" flickity_item_link_type="regular" advanced_gradient="linear-gradient(0deg, rgb(0,0,0) 0%, rgba(0,0,0,0) 36%)" advanced_gradient_opacity="0.2" advanced_gradient_opacity_hover="0.2" color_layer_opacity="" color_layer_opacity_hover="" color_layer="linear-gradient(274deg, rgb(255, 96, 96) 10%, #f3f3f3 90%)" color_layer_gradient_angle="274" color_layer_gradient_radial_position="top right" color_layer_gradient_direction="left_b_to_right_t" id="1763427101669-2" title="Item" color_layer_gradient_type="radial" advanced_gradient_display_type="linear" content_layout="flexbox" flex_layout_desktop="column" flex_justify_content_desktop="space-between" flex_align_items_desktop="flex-start" flex_align_items_phone="" flex_wrap_desktop="nowrap" flex_reverse_desktop="false" tab_id="1763427101669-9"][nectar_responsive_text inherited_font_style="default" text_color="#ffffff" text_direction="default"]
<h3>Videos</h3>
[/nectar_responsive_text][divider line_type="No Line" custom_height="350px" custom_height_phone="250px"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" flex_gap_desktop="8px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" content_layout="flexbox" flex_layout_desktop="row" flex_justify_content_desktop="flex-start" flex_align_items_desktop="flex-start" flex_align_items_phone="" flex_wrap_desktop="wrap" flex_reverse_desktop="false" gradient_type="default"][nectar_badge display_tag="body" font_size_min="10px" font_size_max="20px" badge_style="default" bg_color_type="custom" bg_color_custom="#00000017" padding="small" border_radius="20px" display="block" blur_background="true" text="Storyboarding" font_size_desktop="0.8vw" font_line_height="1"][nectar_badge display_tag="body" font_size_min="10px" font_size_max="20px" badge_style="default" bg_color_type="custom" bg_color_custom="#00000017" padding="small" border_radius="20px" display="block" blur_background="true" text="Reels &amp; Shorts" font_size_desktop="0.8vw" font_line_height="1"][nectar_badge display_tag="body" font_size_min="10px" font_size_max="20px" badge_style="default" bg_color_type="custom" bg_color_custom="rgba(0,0,0,0.09)" padding="small" border_radius="20px" display="block" blur_background="true" text="Filming" font_size_desktop="0.8vw" font_line_height="1"][nectar_badge display_tag="body" font_size_min="10px" font_size_max="20px" badge_style="default" bg_color_type="custom" bg_color_custom="rgba(0,0,0,0.09)" padding="small" border_radius="20px" display="block" blur_background="true" text="Editing" font_size_desktop="0.8vw" font_line_height="1"][nectar_badge display_tag="body" font_size_min="10px" font_size_max="20px" badge_style="default" bg_color_type="custom" bg_color_custom="rgba(0,0,0,0.09)" padding="small" border_radius="20px" display="block" blur_background="true" text="Motion Graphics" font_size_desktop="0.8vw" font_line_height="1"][/vc_column_inner][/vc_row_inner][/item][item simple_slider_bg_image_position="default" simple_slider_overlay_strength="0.3" simple_slider_bg_image_loading="default" flickity_bg_image_url="https://themenectar.com/img/demo-media/unsplash/flower-field.jpg" flickity_bg_image_loading="lazy-load" flickity_background_image_gradient_blur="true" flex_gap_desktop="10px" flickity_item_link_type="regular" color_layer_gradient_direction="left_to_right" id="1763427101778-6" title="Item" content_layout="flexbox" advanced_gradient_display_type="linear" flex_layout_desktop="column" flex_justify_content_desktop="space-between" flex_align_items_desktop="flex-start" flex_align_items_phone="" flex_wrap_desktop="nowrap" flex_reverse_desktop="false" tab_id="1763427101779-0"][nectar_responsive_text inherited_font_style="default" text_color="#ffffff" text_direction="default"]
<h3>Social Media</h3>
[/nectar_responsive_text][divider line_type="No Line" custom_height="350px" custom_height_phone="250px"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" flex_gap_desktop="8px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" content_layout="flexbox" flex_layout_desktop="row" flex_justify_content_desktop="flex-start" flex_align_items_desktop="flex-start" flex_align_items_phone="" flex_wrap_desktop="wrap" flex_reverse_desktop="false" gradient_type="default"][nectar_badge display_tag="body" font_size_min="10px" font_size_max="20px" badge_style="default" bg_color_type="custom" bg_color_custom="rgba(0,0,0,0.09)" padding="small" border_radius="20px" display="block" font_size_desktop="0.8vw" font_line_height="1" blur_background="true" text="Strategy"][nectar_badge display_tag="body" font_size_min="10px" font_size_max="20px" badge_style="default" bg_color_type="custom" bg_color_custom="rgba(0,0,0,0.09)" padding="small" border_radius="20px" display="block" font_size_desktop="0.8vw" font_line_height="1" blur_background="true" text="Paid Ads"][nectar_badge display_tag="body" font_size_min="10px" font_size_max="20px" badge_style="default" bg_color_type="custom" bg_color_custom="rgba(0,0,0,0.09)" padding="small" border_radius="20px" display="block" font_size_desktop="0.8vw" font_line_height="1" blur_background="true" text="Analytics"][nectar_badge display_tag="body" font_size_min="10px" font_size_max="20px" badge_style="default" bg_color_type="custom" bg_color_custom="rgba(0,0,0,0.09)" padding="small" border_radius="20px" display="block" font_size_desktop="0.8vw" font_line_height="1" blur_background="true" text="Content Scheduling"][nectar_badge display_tag="body" font_size_min="10px" font_size_max="20px" badge_style="default" bg_color_type="custom" bg_color_custom="rgba(0,0,0,0.09)" padding="small" border_radius="20px" display="block" font_size_desktop="0.8vw" font_line_height="1" blur_background="true" text="Management"][/vc_column_inner][/vc_row_inner][/item][item simple_slider_bg_image_position="default" simple_slider_overlay_strength="0.3" simple_slider_bg_image_loading="default" flickity_bg_image_url="https://themenectar.com/img/demo-media/unsplash/lamp.jpg" flickity_bg_image_loading="lazy-load" flickity_background_image_gradient_blur="true" flex_gap_desktop="10px" flickity_item_link_type="regular" color_layer_gradient_direction="left_to_right" id="1763427101903-3" title="Item" content_layout="flexbox" advanced_gradient_display_type="linear" flex_layout_desktop="column" flex_justify_content_desktop="space-between" flex_align_items_desktop="flex-start" flex_align_items_phone="" flex_wrap_desktop="nowrap" flex_reverse_desktop="false" tab_id="1763427101903-10"][nectar_responsive_text inherited_font_style="default" text_color="#ffffff" text_direction="default"]
<h3>Marketing</h3>
[/nectar_responsive_text][divider line_type="No Line" custom_height="350px" custom_height_phone="250px"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" flex_gap_desktop="8px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" content_layout="flexbox" flex_layout_desktop="row" flex_justify_content_desktop="flex-start" flex_align_items_desktop="flex-start" flex_align_items_phone="" flex_wrap_desktop="wrap" flex_reverse_desktop="false" gradient_type="default"][nectar_badge display_tag="body" font_size_min="10px" font_size_max="20px" badge_style="default" bg_color_type="custom" bg_color_custom="rgba(0,0,0,0.09)" padding="small" border_radius="20px" display="block" font_size_desktop="0.8vw" font_line_height="1" blur_background="true" text="SEO"][nectar_badge display_tag="body" font_size_min="10px" font_size_max="20px" badge_style="default" bg_color_type="custom" bg_color_custom="rgba(0,0,0,0.09)" padding="small" border_radius="20px" display="block" font_size_desktop="0.8vw" font_line_height="1" blur_background="true" text="PPC"][nectar_badge display_tag="body" font_size_min="10px" font_size_max="20px" badge_style="default" bg_color_type="custom" bg_color_custom="rgba(0,0,0,0.09)" padding="small" border_radius="20px" display="block" font_size_desktop="0.8vw" font_line_height="1" blur_background="true" text="Conversion Optimization"][nectar_badge display_tag="body" font_size_min="10px" font_size_max="20px" badge_style="default" bg_color_type="custom" bg_color_custom="rgba(0,0,0,0.09)" padding="small" border_radius="20px" display="block" font_size_desktop="0.8vw" font_line_height="1" blur_background="true" text="A/B Testing"][nectar_badge display_tag="body" font_size_min="10px" font_size_max="20px" badge_style="default" bg_color_type="custom" bg_color_custom="rgba(0,0,0,0.09)" padding="small" border_radius="20px" display="block" font_size_desktop="0.8vw" font_line_height="1" blur_background="true" text="Analytics &amp; Reporting"][/vc_column_inner][/vc_row_inner][/item][/carousel][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );





$data = array();
$data['name'] = esc_html__( 'Portfolio List', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['portfolio'];
$data['custom_class'] = 'portfolio date-22-Sep-2025';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/signal-portfolio-1.webp' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="6%" bottom_padding="5%" left_padding_desktop="60px" constrain_group_2="yes" right_padding_desktop="60px" top_padding_tablet="15%" left_padding_tablet="25px" constrain_group_4="yes" right_padding_tablet="25px" constrain_group_9="yes" constrain_group_10="yes" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type="" gradient_type="default"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="20px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" flexbox_justify_content_tablet="" flexbox_align_items_tablet="" flexbox_direction_tablet="" gradient_type="default" column_padding_type="default" content_layout="default"][nectar_responsive_text inherited_font_style="h6" text_direction="default"]Featured Work[/nectar_responsive_text][nectar_post_grid post_type="portfolio" portfolio_category="all" portfolio_starting_category="all" order="DESC" orderby="date" pagination="none" ignore_sticky_posts="yes" grid_item_spacing="15px" image_size="portfolio-thumb_large" image_loading="default" animation="fade-in-from-bottom" animation_stagger="150" animation_easing="default" heading_tag="h2" heading_tag_render="default" category_position="default" additional_meta_size="default" custom_fields_location="before_post_meta" grid_style="vertical_list" vertical_list_hover_effect="featured_image_follow" vertical_list_bg_color_hover="#121213" vertical_list_text_color_hover="#F0EAE6" vertical_list_border_color="#000000" vertical_list_read_more="yes" vertical_list_read_more_style="arrow" text_color="dark" border_radius="10px" posts_per_page="6" display_type="grid"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );





$data = array();
$data['name'] = esc_html__( 'Signal Testimonials', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['testimonials'];
$data['custom_class'] = 'testimonials date-21-Sep-2025';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/signal-testimonials.webp' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="7%" bottom_padding="10%" left_padding_desktop="60px" constrain_group_2="yes" right_padding_desktop="60px" left_padding_tablet="25px" constrain_group_4="yes" right_padding_tablet="25px" top_padding_phone="5rem" constrain_group_5="yes" bottom_padding_phone="5rem" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" id="testimonials" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" centered_text="true" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" flexbox_justify_content_tablet="" flexbox_align_items_tablet="" flexbox_direction_tablet="" column_padding_type="default" content_layout="default" gradient_type="default"][testimonial_slider style="minimal" star_rating_color="accent-color" disable_height_animation="true" font_size_desktop="2vw" font_line_height="1.4"][testimonial image="https://themenectar.com/img/demo-media/unsplash/signal-testimonial-2-1.jpg" star_rating="none" title="Testimonial" id="1763422583102-7" name="Zak Reid" subtitle="Founder" quote="The strategy sessions felt like creative therapy — and the final campaign? It stopped people in their tracks. Our audience finally sees us the way we always hoped they would." tab_id="1763422583102-4"][testimonial image="https://themenectar.com/img/demo-media/unsplash/signal-testimonial-2-2.jpg" star_rating="none" title="Testimonial" id="1763422583113-0" name="Eve Crawford" subtitle="Product Designer" quote="It’s rare to find a partner that’s equally strategic and artistic. They understood our goals, challenged our assumptions, and turned big ideas into visuals that demand attention." tab_id="1763422583113-0"][testimonial image="https://themenectar.com/img/demo-media/unsplash/signal-testimonial-2-3.jpg" star_rating="none" title="Testimonial" id="1763422583119-6" name="Aura Brooks" subtitle="Graphic Designer" quote="Working with this team was a turning point for our brand. They didn’t just deliver a new identity — they uncovered what made us different and gave it a voice." tab_id="1763422583119-8"][/testimonial_slider][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );





$data = array();
$data['name'] = esc_html__( 'Manifesto', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-20-Sep-2025';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/signal-manifesto.webp' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="10%" constrain_group_1="yes" bottom_padding="10%" left_padding_desktop="15%" constrain_group_2="yes" right_padding_desktop="15%" left_padding_phone="25px" constrain_group_6="yes" right_padding_phone="25px" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" row_position_desktop="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" flex_gap_desktop="10px" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="center" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" flexbox_justify_content_tablet="" flexbox_align_items_tablet="" flexbox_direction_tablet="" column_padding_type="default" gradient_type="default"][nectar_text_inline_images media_type="images" image_size="large__h_rect" image_effect="scroll_fade" media_roundness="10px" inherit_typography_from="h1" image_loading="default" text_direction="default" font_size_desktop="6.5vw" font_line_height="1.1" font_size_phone="10vw"]
<h2 style="text-align: center;">IN A * WORLD FULL OF NOISE, WE HELP BRANDS * STAND OUT WITH CLEAR IDEAS AND * GOOD DESIGN THAT MAKES AN * IMPACT.</h2>
[/nectar_text_inline_images][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );





$data = array();
$data['name'] = esc_html__( 'Sticky Play Button Video', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-19-Sep-2025';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/signal-video.webp' );
$data['content'] = <<<CONTENT
[vc_section type="full_width_content" text_color="dark" left_padding_desktop="60px" constrain_group_2="yes" right_padding_desktop="60px" left_padding_tablet="25px" constrain_group_4="yes" right_padding_tablet="25px" row_border_radius="none" row_border_radius_applies="bg" content_layout="default" advanced_gradient_display_type="linear"][vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#FFFFFF" video_bg="use_video" video_mp4="https://themenectar.com/img/demo-media/mp4/agency.mp4" background_video_loading="lazy-load" scene_position="center" text_color="dark" text_align="left" row_border_radius="10px" row_border_radius_applies="bg" row_position_desktop="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type="" gradient_type="default" height_desktop="70vh" height_phone="50vh"][vc_column top_padding_desktop="20px" constrain_group_100="yes" bottom_padding_desktop="20px" left_padding_desktop="20px" constrain_group_101="yes" right_padding_desktop="20px" flex_gap_desktop="10px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" sticky_content="true" sticky_content_functionality="css" sticky_content_alignment="middle" sticky_column_mobile="true" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" flexbox_justify_content_tablet="" flexbox_align_items_tablet="" flexbox_direction_tablet="" column_padding_type="advanced" gradient_type="default" content_layout="flexbox" flex_layout_desktop="row" flex_justify_content_desktop="flex-start" flex_align_items_desktop="flex-start" flex_align_items_phone="" flex_wrap_desktop="wrap" flex_reverse_desktop="false"][nectar_cta btn_style="text-reveal" heading_tag="h6" border_radius="100" link_type="video_lightbox" button_color="custom" button_color_custom="#1212131C" text_color="#ffffff" button_border_thickness="0px" alignment="center" alignment_tablet="default" alignment_phone="default" constrain_group_3="yes" constrain_group_4="yes" backdrop_filter="blur" backdrop_filter_blur="20" display="block" display_tablet="inherit" display_phone="inherit" icon_family="none" link_text="Play Video" padding_top="0.5em" padding_bottom="0.5em" padding_left="1.5em" padding_right="1.5em"][/vc_column][/vc_row][/vc_section]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Signal Footer', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-17-Sep-2025';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/signal-footer.webp' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="custom" column_margin_custom="15vw" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="10%" bottom_padding="5%" left_padding_desktop="60px" constrain_group_2="yes" right_padding_desktop="60px" left_padding_tablet="25px" constrain_group_4="yes" right_padding_tablet="25px" top_padding_phone="5rem" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" row_position_desktop="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" id="contact" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" flex_gap_desktop="10px" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][vc_column_text css="" text_direction="default"]Add your favorite contact form here[/vc_column_text][/vc_column][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" top_margin_tablet="40px" flex_gap_desktop="5px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" content_layout="flexbox" flex_layout_desktop="column" flex_justify_content_desktop="flex-start" flex_align_items_desktop="flex-start" flex_align_items_phone="" flex_wrap_desktop="nowrap" flex_reverse_desktop="false" gradient_type="default"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" flex_gap_desktop="5px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" content_layout="flexbox" flex_layout_desktop="column" flex_justify_content_desktop="flex-start" flex_align_items_desktop="flex-start" flex_align_items_phone="" flex_wrap_desktop="nowrap" flex_reverse_desktop="false" gradient_type="default"][nectar_responsive_text inherited_font_style="h6" text_direction="default"]Say Hello[/nectar_responsive_text][nectar_cta btn_style="text-reveal" heading_tag="h3" font_size_min="20px" link_type="regular" button_color="default" button_border_thickness="0px" alignment="left" alignment_tablet="default" alignment_phone="default" display="block" display_tablet="inherit" display_phone="inherit" icon_family="none" link_text="info(at)domain.com" url="#" font_size_desktop="2vw"][/vc_column_inner][/vc_row_inner][divider line_type="No Line" custom_height="50px" custom_height_tablet="30px"][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" flex_gap_desktop="10px" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][nectar_responsive_text inherited_font_style="h6" text_direction="default"]Get Social[/nectar_responsive_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" flex_gap_desktop="20px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" content_layout="flexbox" flex_layout_desktop="row" flex_justify_content_desktop="flex-start" flex_align_items_desktop="flex-start" flex_align_items_phone="" flex_wrap_desktop="nowrap" flex_reverse_desktop="false" gradient_type="default"][nectar_cta btn_style="text-reveal" heading_tag="h3" font_size_min="20px" link_type="regular" button_color="default" button_border_thickness="0px" alignment="left" alignment_tablet="default" alignment_phone="default" display="block" display_tablet="inherit" display_phone="inherit" icon_family="none" link_text="LinkedIn" font_size_desktop="2vw"][nectar_cta btn_style="text-reveal" heading_tag="h3" font_size_min="20px" link_type="regular" button_color="default" button_border_thickness="0px" alignment="left" alignment_tablet="default" alignment_phone="default" display="block" display_tablet="inherit" display_phone="inherit" icon_family="none" link_text="Facebook" font_size_desktop="2vw"][nectar_cta btn_style="text-reveal" heading_tag="h3" font_size_min="20px" link_type="regular" button_color="default" button_border_thickness="0px" alignment="left" alignment_tablet="default" alignment_phone="default" display="block" display_tablet="inherit" display_phone="inherit" icon_family="none" link_text="Instagram" font_size_desktop="2vw"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" left_padding_desktop="60px" constrain_group_2="yes" right_padding_desktop="60px" left_padding_tablet="25px" constrain_group_4="yes" right_padding_tablet="25px" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" row_position_desktop="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" flex_gap_desktop="10px" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][split_line_heading line_reveal_by_space_text_effect="none" font_style="h1" fit_text_to_container="true" content_alignment="default" mobile_content_alignment="inherit" animation_type="line-reveal-by-space" link_target="_self" text_direction="default" text_content="SIGNAL" animation_offset="100%"][/split_line_heading][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Project Header', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['portfolio'];
$data['custom_class'] = 'portfolio date-18-Sep-2025';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/signal-project-header.webp' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="custom" column_margin_custom="17vw" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="11%" bottom_padding="7%" left_padding_desktop="60px" constrain_group_2="yes" right_padding_desktop="60px" left_padding_tablet="25px" constrain_group_4="yes" right_padding_tablet="25px" top_padding_phone="5rem" bottom_padding_phone="3rem" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" flex_gap_desktop="10px" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="3/5" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][nectar_responsive_text inherited_font_style="h6" text_direction="default"]Crystal Vibes[/nectar_responsive_text][nectar_responsive_text inherited_font_style="default" text_direction="default"]
<h1>In the Flow of Motion &amp; Form</h1>
[/nectar_responsive_text][nectar_responsive_text inherited_font_style="default" text_direction="default"]Momentum captures the energy of movement and the elegance of control — a balance between instinct and intention. It’s a study in presence, attitude, and the quiet confidence that comes from owning every step forward.[/nectar_responsive_text][/vc_column][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" top_margin_tablet="40px" column_element_direction_desktop="default" column_element_spacing="10px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="2/5" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" content_layout="default" gradient_type="default"][nectar_responsive_text inherited_font_style="h6" text_direction="default"]Expertises[/nectar_responsive_text][nectar_project_categories taxonomy="project-categories" style="default" category_display="default" direction="vertical" gap="2" font_style="h4"][divider line_type="No Line" custom_height="40px" custom_height_tablet="20px"][nectar_responsive_text inherited_font_style="h6" text_direction="default"]Services[/nectar_responsive_text][nectar_project_categories taxonomy="project-attributes" style="default" category_display="default" direction="vertical" gap="2" font_style="h4"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Personal Fullscreen Hero', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['hero_section'];
$data['custom_class'] = 'hero_section date-16-Sep-2025';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/personal-hero.webp' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_image="https://themenectar.com/img/demo-media/tn/personal-hero-red-desktop.webp" bg_image_phone="https://themenectar.com/img/demo-media/tn/personal-hero-red-mobile.webp" bg_image_type="default" bg_position="center center" background_image_loading="default" bg_repeat="no-repeat" scene_position="center" text_color="light" text_align="left" row_border_radius="none" row_border_radius_applies="bg" row_position_desktop="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type="" height_desktop="100svh"][vc_column bottom_padding_desktop="30px" left_padding_desktop="40px" constrain_group_101="yes" right_padding_desktop="40px" bottom_padding_tablet="15px" left_padding_tablet="20px" constrain_group_103="yes" right_padding_tablet="20px" flex_gap_desktop="10px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" content_layout="flexbox" gradient_type="default" flex_layout_desktop="column" flex_justify_content_desktop="flex-end" flex_align_items_desktop="stretch" flex_align_items_phone="" flex_wrap_desktop="nowrap" flex_reverse_desktop="false" height_desktop="100%"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" flex_sizing="true" overflow="visible" pointer_events="all"][vc_column_inner flex_gap_desktop="10px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" content_layout="flexbox" gradient_type="default" flex_layout_desktop="column" flex_justify_content_desktop="center" flex_align_items_desktop="flex-start" flex_align_items_phone="" flex_wrap_desktop="nowrap" flex_reverse_desktop="false"][nectar_responsive_text inherited_font_style="h6" text_direction="default" font_size_desktop="0.9vw" font_size_tablet="2vw"]Global Brand
Designer[/nectar_responsive_text][/vc_column_inner][vc_column_inner flex_gap_desktop="10px" desktop_text_alignment="right" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" content_layout="flexbox" gradient_type="default" flex_layout_desktop="column" flex_justify_content_desktop="center" flex_align_items_desktop="flex-end" flex_align_items_phone="" flex_wrap_desktop="nowrap" flex_reverse_desktop="false"][nectar_responsive_text inherited_font_style="h6" text_direction="default" font_size_desktop="0.9vw" max_width="200px" font_size_tablet="2vw"]Award-winning
Speaker[/nectar_responsive_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" flex_gap_desktop="10px" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][split_line_heading line_reveal_by_space_text_effect="none" font_style="h2" fit_text_to_container="true" content_alignment="default" mobile_content_alignment="inherit" animation_type="line-reveal-by-space" link_target="_self" text_content="ANTHONY CORNELL" text_direction="default" font_line_height="0.9"][/split_line_heading][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Minimal Feature Boxes Hero', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['hero_section'];
$data['custom_class'] = 'hero_section date-10-Sep-2025';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/minimal-feature-boxes-hero.webp' );
$data['content'] = <<<CONTENT
[vc_section type="full_width_background" text_color="dark" top_padding="6%" constrain_group_1="yes" bottom_padding="6%" row_border_radius="none" row_border_radius_applies="bg" content_layout="default" advanced_gradient_display_type="linear"][vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" left_padding_tablet="15%" constrain_group_4="yes" right_padding_tablet="15%" left_padding_phone="0" constrain_group_6="yes" right_padding_phone="0" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" row_position_desktop="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" id="overview" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" flex_gap_desktop="30px" desktop_text_alignment="center" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" content_layout="flexbox" flex_layout_desktop="column" flex_justify_content_desktop="center" flex_align_items_desktop="center" flex_align_items_phone="" flex_wrap_desktop="nowrap" flex_reverse_desktop="false" gradient_type="default"][split_line_heading line_reveal_by_space_text_effect="fade-bottom" font_style="h1" stagger_animation="true" content_alignment="default" mobile_content_alignment="inherit" animation_type="line-reveal-by-space" link_target="_self" text_content="Building stronger, more connected teams" text_direction="default" max_width="750px"][/split_line_heading][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" flex_gap_desktop="10px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="slight-fade-in-from-bottom" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" content_layout="flexbox" flex_layout_desktop="row" flex_justify_content_desktop="center" flex_align_items_desktop="center" flex_align_items_phone="" flex_wrap_desktop="nowrap" flex_reverse_desktop="false" gradient_type="default" delay="200" flex_layout_phone="row"][nectar_cta btn_style="text-reveal" heading_tag="span" link_type="regular" button_color="extra-color-1" text_color="#000000" button_border_thickness="0px" alignment="left" alignment_tablet="default" alignment_phone="default" constrain_group_3="yes" constrain_group_4="yes" display="block" display_tablet="inherit" display_phone="inherit" icon_family="none" link_text="Get started — it’s free" padding_top="0.5em" padding_bottom="0.5em" padding_left="1.4em" padding_right="1.4em"][nectar_cta btn_style="text-reveal" heading_tag="span" link_type="regular" button_color="white" text_color="#000000" button_border_thickness="0px" alignment="left" alignment_tablet="default" alignment_phone="default" constrain_group_3="yes" constrain_group_4="yes" display="block" display_tablet="inherit" display_phone="none" icon_family="none" link_text="Explore more" padding_top="0.5em" padding_bottom="0.5em" padding_left="1.4em" padding_right="1.4em" url="#clients"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" flex_gap_desktop="10px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="slight-fade-in-from-bottom" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" content_layout="flexbox" gradient_type="default" delay="325" flex_layout_desktop="column" flex_justify_content_desktop="center" flex_align_items_desktop="center" flex_align_items_phone="" flex_wrap_desktop="nowrap" flex_reverse_desktop="false"][nectar_circle_images images="https://themenectar.com/img/demo-media/unsplash/tether-circle-images-5.webp,https://themenectar.com/img/demo-media/unsplash/tether-circle-images-4.webp,https://themenectar.com/img/demo-media/unsplash/tether-circle-images-3.webp,https://themenectar.com/img/demo-media/unsplash/tether-circle-images-2.webp,https://themenectar.com/img/demo-media/unsplash/tether-circle-images-1.webp" sizing="44px" positioning="overlapping" stacking_order="ltr" border_color="#EBE9E5" alignment_desktop="left" alignment_tablet="inherit" alignment_phone="inherit" animation="none" image_size="nectar_small_square" image_loading="skip-lazy-load"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" top_margin="-20px" flex_gap_desktop="10px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="slight-fade-in-from-bottom" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" content_layout="flexbox" flex_layout_desktop="row" flex_justify_content_desktop="center" flex_align_items_desktop="center" flex_align_items_phone="" flex_wrap_desktop="nowrap" flex_reverse_desktop="false" gradient_type="default" delay="450"][nectar_responsive_text inherited_font_style="default" font_size_desktop="14px" font_line_height="1" text_direction="default"]+8k Happy users[/nectar_responsive_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row type="full_width_content" full_screen_row_position="middle" column_margin="10px" equal_height="yes" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="60px" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" row_position_desktop="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column top_padding_desktop="40px" constrain_group_100="yes" bottom_padding_desktop="40px" left_padding_desktop="40px" constrain_group_101="yes" right_padding_desktop="40px" top_padding_tablet="20px" constrain_group_102="yes" bottom_padding_tablet="20px" left_padding_tablet="20px" constrain_group_103="yes" right_padding_tablet="20px" top_padding_phone="30px" bottom_padding_phone="30px" left_padding_phone="30px" right_padding_phone="30px" bottom_margin_phone="10px" flex_gap_desktop="10px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color="#161514" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" font_color="#F9F4E9" column_shadow="none" column_border_radius="15px" column_link_target="_self" column_position="default" color_overlay="#161514" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="small_desktop" animation_type="default" enable_animation="true" animation="slight-fade-in-from-bottom" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" content_layout="flexbox" gradient_type="default" flex_layout_desktop="column" flex_justify_content_desktop="space-between" flex_align_items_desktop="flex-start" flex_align_items_phone="" flex_wrap_desktop="nowrap" flex_reverse_desktop="false" delay="450" offset="vc_col-md-4 vc_col-xs-12"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" flex_gap_desktop="10px" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][nectar_responsive_text inherited_font_style="default" font_size_max="32px" text_direction="default" font_size_tablet="17px" font_size_desktop="2vw" font_line_height="1.4"]
<h2>Keep everyone aligned and engaged with tools designed for real-time collaboration.</h2>
[/nectar_responsive_text][/vc_column_inner][/vc_row_inner][divider line_type="No Line" custom_height="25px"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="10px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" content_layout="default" gradient_type="default"][nectar_badge display_tag="body" font_size_min="15px" badge_style="default" bg_color_type="custom" text_color="#F4F2EF" padding="small" border="true" border_color="#F4F2EF75" border_radius="10px" display="block" text="Employee workflow" font_size_desktop="1vw" font_line_height="1"][nectar_badge display_tag="body" font_size_min="15px" badge_style="default" bg_color_type="custom" bg_color_custom="#FFFFFF1A" text_color="#F9F4E9" backdrop_filter="blur" backdrop_filter_blur="16" padding="small" border_radius="10px" display="block" text="Generate invoices" font_size_desktop="1vw" font_line_height="1"][nectar_badge display_tag="body" font_size_min="15px" badge_style="default" bg_color_type="custom" bg_color_custom="#FFFFFF1A" text_color="#F9F4E9" backdrop_filter="blur" backdrop_filter_blur="16" padding="small" border_radius="10px" display="block" text="Connections" font_size_desktop="1vw" font_line_height="1"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column flex_gap_desktop="0" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="15px" column_link_target="_self" column_position="default" advanced_gradient="linear-gradient(180deg, rgb(255,255,0) 1%, rgb(220,216,211) 81%)" advanced_gradient_angle="180" width="1/3" tablet_width_inherit="small_desktop" animation_type="default" enable_animation="true" animation="slight-fade-in-from-bottom" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" content_layout="flexbox" gradient_type="advanced" flex_layout_desktop="column" flex_justify_content_desktop="flex-end" flex_align_items_desktop="stretch" flex_align_items_phone="" flex_wrap_desktop="nowrap" flex_reverse_desktop="false" delay="450" advanced_gradient_display_type="linear" offset="vc_col-md-4 vc_col-xs-6"][image_with_animation image_url="https://themenectar.com/img/demo-media/tn/iphone-mockup.webp" image_size="full" max_width="100%" max_width_mobile="default" animation_type="entrance" animation="None" animation_movement_type="transform_y" hover_animation="none" alignment="" border_radius="10px" box_shadow="none" image_loading="skip-lazy-load" custom_sizes_attr="(max-width: 1000px) 40vw, 33.33vw"][/vc_column][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="15px" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="small_desktop" animation_type="default" enable_animation="true" animation="slight-fade-in-from-bottom" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" content_layout="default" gradient_type="default" delay="450" offset="vc_col-md-4 vc_col-xs-6"][image_with_animation image_url="https://themenectar.com/img/demo-media/tn/side-woman-smile.webp" image_size="medium_featured" max_width="100%" max_width_mobile="default" animation_type="entrance" animation="None" animation_movement_type="transform_y" hover_animation="none" alignment="" border_radius="15px" box_shadow="none" image_loading="skip-lazy-load" fit_to_container="1" image_object_position="center center" custom_sizes_attr="(max-width: 1000px) 40vw, 33.33vw"][/vc_column][/vc_row][/vc_section]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Condensed Client Carousel', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['about'];
$data['custom_class'] = 'about date-09-Sep-2025';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/tether-client-carousel.webp' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="4%" bottom_padding="70px" left_padding_desktop="20%" constrain_group_2="yes" right_padding_desktop="20%" top_padding_tablet="10%" bottom_padding_tablet="40px" left_padding_tablet="15%" constrain_group_4="yes" right_padding_tablet="15%" left_padding_phone="0" constrain_group_6="yes" right_padding_phone="0" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" zindex="2" row_position_desktop="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" id="clients" shape_divider_position="bottom" bg_image_animation="none" gradient_type="advanced" shape_type="" advanced_gradient_display_type="linear"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="0px" desktop_text_alignment="center" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="static" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="default" content_layout="default"][nectar_responsive_text inherited_font_style="default" text_direction="default"]
<h2>Trusted by the world’s top brands</h2>
[/nectar_responsive_text][divider line_type="No Line" custom_height="70px" custom_height_tablet="40px"][vc_gallery css="" type="flickity_static_height_style" flickity_spacing="30px" flickity_controls="none" flickity_overflow="hidden" flickity_wrap_around="wrap" flickity_autoplay="true" flickity_autorotate_type="ticker" flickity_ticker_speed="slow" flickity_mask_edges="yes" flickity_box_shadow="none" image_loading="default" onclick="link_no" flickity_img_height="35px" flickity_img_small_desktop_height="35px" flickity_img_tablet_height="35px" flickity_img_mobile_height="25px"][/vc_column][/vc_row][vc_row type="full_width_background" full_screen_row_position="middle" column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" bottom_padding="8%" bottom_padding_tablet="10%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" row_position_desktop="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" flex_gap_desktop="10px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" content_layout="flexbox" flex_layout_desktop="row" flex_justify_content_desktop="center" flex_align_items_desktop="center" flex_align_items_phone="" flex_wrap_desktop="nowrap" flex_reverse_desktop="false" gradient_type="default"][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner top_padding_desktop="10px" constrain_group_100="yes" bottom_padding_desktop="10px" left_padding_desktop="20px" constrain_group_101="yes" right_padding_desktop="20px" flex_gap_desktop="10px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="100px" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="1px" column_border_color="#0000002B" column_border_style="solid" column_padding_type="advanced" content_layout="flexbox" gradient_type="default" flex_layout_desktop="row" flex_justify_content_desktop="center" flex_align_items_desktop="center" flex_align_items_phone="" flex_wrap_desktop="nowrap" flex_reverse_desktop="false" column_link="#results" column_link_screen_reader="reviews"][vc_column_text css="" text_direction="default"]4.9/5[/vc_column_text][nectar_star_rating star_rating="5" sizing="16" icon_color="accent-color"][/nectar_star_rating][vc_column_text css="" text_direction="default"]From <strong>2k+</strong> reviews[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Stacked Sticky Content Sections', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['services'];
$data['custom_class'] = 'services date-08-Sep-2025';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/tether-sticky-content-sections.webp' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="5%" constrain_group_1="yes" bottom_padding="5%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" row_position_desktop="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" id="features" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column left_padding_tablet="15%" constrain_group_103="yes" right_padding_tablet="15%" left_padding_phone="0" constrain_group_105="yes" right_padding_phone="0" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" content_layout="default" gradient_type="default"][nectar_sticky_media_sections type="scroll-pinned-sections" effect="overlapping" overlapping_overlap_amount_desktop="20" overlapping_overlap_amount_tablet="40" stacking_effect="yes" section_height="75vh" subtract_nav_height="yes" content_alignment="stretch" border_radius="15px"][nectar_sticky_media_section section_type="color" section_color_source="custom" section_color="#FFFFFF" link_target="_self"][vc_row_inner equal_height="yes" column_margin="custom" column_margin_custom="40px" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding="30px" constrain_group_1="yes" bottom_padding="30px" left_padding_desktop="30px" constrain_group_2="yes" right_padding_desktop="30px" top_padding_tablet="20px" constrain_group_3="yes" bottom_padding_tablet="20px" left_padding_tablet="20px" constrain_group_4="yes" right_padding_tablet="20px" top_padding_phone="20px" constrain_group_5="yes" bottom_padding_phone="20px" left_padding_phone="20px" constrain_group_6="yes" right_padding_phone="20px" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner top_padding_desktop="10%" constrain_group_100="yes" bottom_padding_desktop="10%" left_padding_desktop="10%" constrain_group_101="yes" right_padding_desktop="10%" top_padding_tablet="0" constrain_group_102="yes" bottom_padding_tablet="0" left_padding_tablet="0" constrain_group_103="yes" right_padding_tablet="0" flex_justify_content_tablet="flex-start" flex_gap_desktop="15px" flex_gap_phone="10px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" content_layout="flexbox" flex_layout_desktop="column" flex_justify_content_desktop="center" flex_align_items_desktop="flex-start" flex_align_items_phone="" flex_wrap_desktop="nowrap" flex_reverse_desktop="false" gradient_type="default" flex_justify_content_phone="flex-start"][nectar_responsive_text inherited_font_style="h6" text_direction="default" font_line_height="1"]Meaning[/nectar_responsive_text][nectar_responsive_text inherited_font_style="default" text_direction="default"]
<h2>Strengthen connection</h2>
[/nectar_responsive_text][nectar_responsive_text inherited_font_style="default" font_size_phone="14px" text_direction="default"]Bring your people together through meaningful rituals, guided team-building exercises, and shared experiences.[/nectar_responsive_text][nectar_cta btn_style="text-reveal" heading_tag="span" border_radius="100" link_type="regular" button_color="accent-color" text_color="#F6F4F0" button_border_thickness="0px" alignment="left" alignment_tablet="default" alignment_phone="default" constrain_group_3="yes" constrain_group_4="yes" icon_gap="20" display="inline" display_tablet="inherit" display_phone="inherit" icon_family="none" link_text="Get Started" padding_top="0.5em" padding_bottom="0.5em" padding_left="1.4em" padding_right="1.4em" margin_top="20px"][/vc_column_inner][vc_column_inner top_padding_desktop="10%" constrain_group_100="yes" bottom_padding_desktop="10%" left_padding_desktop="10%" constrain_group_101="yes" right_padding_desktop="10%" top_padding_tablet="20px" constrain_group_102="yes" bottom_padding_tablet="20px" left_padding_tablet="20px" constrain_group_103="yes" right_padding_tablet="20px" flex_gap_desktop="10px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://themenectar.com/img/demo-media/unsplash/plant-office.webp" background_image_position="center center" background_image_stacking="default" enable_bg_scale="true" background_image_loading="default" column_backdrop_filter="none" column_shadow="none" column_border_radius="15px" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" content_layout="flexbox" gradient_type="default" flex_layout_desktop="column" flex_justify_content_desktop="center" flex_align_items_desktop="stretch" flex_align_items_phone="" flex_wrap_desktop="nowrap" flex_reverse_desktop="false"][/vc_column_inner][/vc_row_inner][/nectar_sticky_media_section][nectar_sticky_media_section section_type="color" section_color_source="custom" section_color="#DBD7D1" link_target="_self"][vc_row_inner equal_height="yes" column_margin="custom" column_margin_custom="40px" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding="30px" constrain_group_1="yes" bottom_padding="30px" left_padding_desktop="30px" constrain_group_2="yes" right_padding_desktop="30px" top_padding_tablet="20px" constrain_group_3="yes" bottom_padding_tablet="20px" left_padding_tablet="20px" constrain_group_4="yes" right_padding_tablet="20px" top_padding_phone="20px" constrain_group_5="yes" bottom_padding_phone="20px" left_padding_phone="20px" constrain_group_6="yes" right_padding_phone="20px" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner top_padding_desktop="10%" constrain_group_100="yes" bottom_padding_desktop="10%" left_padding_desktop="10%" constrain_group_101="yes" right_padding_desktop="10%" top_padding_tablet="0" constrain_group_102="yes" bottom_padding_tablet="0" left_padding_tablet="0" constrain_group_103="yes" right_padding_tablet="0" flex_justify_content_tablet="flex-start" flex_gap_desktop="15px" flex_gap_phone="10px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" content_layout="flexbox" flex_layout_desktop="column" flex_justify_content_desktop="center" flex_align_items_desktop="flex-start" flex_align_items_phone="" flex_wrap_desktop="nowrap" flex_reverse_desktop="false" gradient_type="default" flex_justify_content_phone="flex-start"][nectar_responsive_text inherited_font_style="h6" text_direction="default" font_line_height="1"]Insight[/nectar_responsive_text][nectar_responsive_text inherited_font_style="default" text_direction="default"]
<h2>Culture pulse &amp; insights</h2>
[/nectar_responsive_text][nectar_responsive_text inherited_font_style="default" font_size_phone="14px" text_direction="default"]Stay in tune with your team through lightweight check-ins and clear engagement data, giving leaders visibility.[/nectar_responsive_text][nectar_cta btn_style="text-reveal" heading_tag="span" border_radius="100" link_type="regular" button_color="accent-color" text_color="#F6F4F0" button_border_thickness="0px" alignment="left" alignment_tablet="default" alignment_phone="default" constrain_group_3="yes" constrain_group_4="yes" icon_gap="20" display="inline" display_tablet="inherit" display_phone="inherit" icon_family="none" link_text="Get Started" padding_top="0.5em" padding_bottom="0.5em" padding_left="1.4em" padding_right="1.4em" margin_top="20px"][/vc_column_inner][vc_column_inner top_padding_desktop="10%" constrain_group_100="yes" bottom_padding_desktop="10%" left_padding_desktop="10%" constrain_group_101="yes" right_padding_desktop="10%" top_padding_tablet="20px" constrain_group_102="yes" bottom_padding_tablet="20px" left_padding_tablet="20px" constrain_group_103="yes" right_padding_tablet="20px" flex_gap_desktop="10px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://themenectar.com/img/demo-media/unsplash/green-nature.webp" background_image_position="center center" background_image_stacking="default" enable_bg_scale="true" background_image_loading="default" column_backdrop_filter="none" column_shadow="none" column_border_radius="15px" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" content_layout="flexbox" gradient_type="default" flex_layout_desktop="column" flex_justify_content_desktop="center" flex_align_items_desktop="stretch" flex_align_items_phone="" flex_wrap_desktop="nowrap" flex_reverse_desktop="false"][/vc_column_inner][/vc_row_inner][/nectar_sticky_media_section][nectar_sticky_media_section section_type="color" section_color_source="custom" section_color="#FFFF00" link_target="_self"][vc_row_inner equal_height="yes" column_margin="custom" column_margin_custom="40px" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding="30px" constrain_group_1="yes" bottom_padding="30px" left_padding_desktop="30px" constrain_group_2="yes" right_padding_desktop="30px" top_padding_tablet="20px" constrain_group_3="yes" bottom_padding_tablet="20px" left_padding_tablet="20px" constrain_group_4="yes" right_padding_tablet="20px" top_padding_phone="20px" constrain_group_5="yes" bottom_padding_phone="20px" left_padding_phone="20px" constrain_group_6="yes" right_padding_phone="20px" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner top_padding_desktop="10%" constrain_group_100="yes" bottom_padding_desktop="10%" left_padding_desktop="10%" constrain_group_101="yes" right_padding_desktop="10%" top_padding_tablet="0" constrain_group_102="yes" bottom_padding_tablet="0" left_padding_tablet="0" constrain_group_103="yes" right_padding_tablet="0" flex_justify_content_tablet="flex-start" flex_gap_desktop="15px" flex_gap_phone="10px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" content_layout="flexbox" flex_layout_desktop="column" flex_justify_content_desktop="center" flex_align_items_desktop="flex-start" flex_align_items_phone="" flex_wrap_desktop="nowrap" flex_reverse_desktop="false" gradient_type="default" flex_justify_content_phone="flex-start"][nectar_responsive_text inherited_font_style="h6" text_direction="default" font_line_height="1"]Culture[/nectar_responsive_text][nectar_responsive_text inherited_font_style="default" text_direction="default"]
<h2>Recognition &amp; shared wins</h2>
[/nectar_responsive_text][nectar_responsive_text inherited_font_style="default" font_size_phone="14px" text_direction="default"]Create a culture of appreciation with built-in recognition tools that make it easy to celebrate milestones.[/nectar_responsive_text][nectar_cta btn_style="text-reveal" heading_tag="span" border_radius="100" link_type="regular" button_color="accent-color" text_color="#F6F4F0" button_border_thickness="0px" alignment="left" alignment_tablet="default" alignment_phone="default" constrain_group_3="yes" constrain_group_4="yes" icon_gap="20" display="inline" display_tablet="inherit" display_phone="inherit" icon_family="none" link_text="Get Started" padding_top="0.5em" padding_bottom="0.5em" padding_left="1.4em" padding_right="1.4em" margin_top="20px"][/vc_column_inner][vc_column_inner top_padding_desktop="10%" constrain_group_100="yes" bottom_padding_desktop="10%" left_padding_desktop="10%" constrain_group_101="yes" right_padding_desktop="10%" top_padding_tablet="20px" bottom_padding_tablet="20px" left_padding_tablet="20px" constrain_group_103="yes" right_padding_tablet="20px" flex_gap_desktop="30px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://themenectar.com/img/demo-media/tn/man-flowers.webp" background_image_position="center top" background_image_stacking="default" enable_bg_scale="true" background_image_loading="default" column_backdrop_filter="none" column_shadow="none" column_border_radius="15px" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" content_layout="flexbox" gradient_type="default" flex_layout_desktop="column" flex_justify_content_desktop="space-between" flex_align_items_desktop="stretch" flex_align_items_phone="" flex_wrap_desktop="nowrap" flex_reverse_desktop="false"][nectar_badge display_tag="body" badge_style="default" bg_color_type="custom" bg_color_custom="#EBE9E51C" text_color="#F4F2EF" backdrop_filter="blur" backdrop_filter_blur="16" padding="small" border_radius="20px" display="block" text="• Slack Champion" font_size_desktop="15px" font_line_height="1" margin_right="auto" font_size_phone="9px"][nectar_badge display_tag="body" badge_style="default" bg_color_type="custom" bg_color_custom="#EBE9E51C" text_color="#F4F2EF" backdrop_filter="blur" backdrop_filter_blur="16" padding="small" border_radius="20px" display="block" text="• New Certification" font_size_desktop="15px" font_line_height="1" margin_left="auto" font_size_phone="9px"][nectar_badge display_tag="body" badge_style="default" bg_color_type="custom" bg_color_custom="#EBE9E51C" text_color="#F4F2EF" backdrop_filter="blur" backdrop_filter_blur="16" padding="small" border_radius="20px" display="block" text="• 4 Year Milestone" font_size_desktop="15px" font_line_height="1" margin_right="auto" margin_left="auto" font_size_phone="9px"][/vc_column_inner][/vc_row_inner][/nectar_sticky_media_section][/nectar_sticky_media_sections][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );





$data = array();
$data['name'] = esc_html__( 'Tether Bento Grid', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['services'];
$data['custom_class'] = 'services date-07-Sep-2025';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/tether-bento.webp' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" flex_gap_desktop="10px" desktop_text_alignment="center" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" content_layout="flexbox" flex_layout_desktop="column" flex_justify_content_desktop="center" flex_align_items_desktop="center" flex_align_items_phone="" flex_wrap_desktop="nowrap" flex_reverse_desktop="false" gradient_type="default"][nectar_responsive_text inherited_font_style="h1" text_direction="default" max_width="700px"]Proven results with innovative AI features[/nectar_responsive_text][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" content_layout="default" gradient_type="default"][nectar_responsive_text inherited_font_style="default" text_direction="default" max_width="525px"]Thousands of teams trust Tether to deliver measurable ROI, unlock greater productivity, and harness the power of AI.[/nectar_responsive_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row type="full_width_background" full_screen_row_position="middle" column_margin="10px" equal_height="yes" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="5%" bottom_padding="10%" top_padding_tablet="10%" bottom_padding_tablet="20%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column top_padding_desktop="30px" constrain_group_100="yes" bottom_padding_desktop="30px" left_padding_desktop="30px" constrain_group_101="yes" right_padding_desktop="30px" flex_gap_desktop="10px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://themenectar.com/img/demo-media/unsplash/shutter-speed-_OZPiiW-pmo-unsplash-1-scaled.webp" background_image_type="default" background_image_position="center center" background_image_stacking="default" enable_bg_scale="true" background_image_loading="default" column_backdrop_filter="none" font_color="#FFFFFF" column_shadow="none" column_border_radius="15px" column_link_target="_self" column_position="default" advanced_gradient_radial_position="top left" width="1/2" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" parallax_bg="true" parallax_bg_speed="minimum" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" content_layout="flexbox" gradient_type="advanced" flex_layout_desktop="column" flex_justify_content_desktop="space-between" flex_align_items_desktop="stretch" flex_align_items_phone="" flex_wrap_desktop="nowrap" flex_reverse_desktop="false" advanced_gradient_display_type="radial"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding="10%" constrain_group_1="yes" bottom_padding="10%" left_padding_desktop="10%" constrain_group_2="yes" right_padding_desktop="10%" top_padding_tablet="5%" constrain_group_3="yes" bottom_padding_tablet="5%" left_padding_tablet="5%" constrain_group_4="yes" right_padding_tablet="5%" top_padding_phone="0" constrain_group_5="yes" bottom_padding_phone="0" left_padding_phone="0" constrain_group_6="yes" right_padding_phone="0" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all" height_desktop="100%" min_height_tablet="425px" min_height_phone="400px"][vc_column_inner top_padding_desktop="40px" constrain_group_100="yes" bottom_padding_desktop="40px" left_padding_desktop="40px" constrain_group_101="yes" right_padding_desktop="40px" top_padding_tablet="20px" constrain_group_102="yes" bottom_padding_tablet="20px" left_padding_tablet="20px" constrain_group_103="yes" right_padding_tablet="20px" flex_gap_desktop="10px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color="#EBE9E5" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="15px" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" content_layout="flexbox" gradient_type="default" flex_layout_desktop="column" flex_justify_content_desktop="center" flex_align_items_desktop="center" flex_align_items_phone="" flex_wrap_desktop="nowrap" flex_reverse_desktop="false" min_height_desktop="100%"][nectar_chat_thread outgoing_bubble_image="https://themenectar.com/img/demo-media/unsplash/tether-circle-images-6.webp" outgoing_bubble_name="Jacob Smith" outgoing_bubble_color="#FBFF00" outgoing_text_color="#161514" incoming_bubble_image="https://themenectar.com/img/demo-media/unsplash/grad.webp" incoming_bubble_name="Tether AI" incoming_bubble_color="#FFFFFF" incoming_text_color="#161514" image_size="30" border_radius="20" animation="typing" auto_height_animation="true" loop_animation="true"][nectar_chat_thread_bubble]How can I help you today?[/nectar_chat_thread_bubble][nectar_chat_thread_bubble direction="outgoing"]What's a fun activity that I can set up for the team meeting tomorrow?[/nectar_chat_thread_bubble][nectar_chat_thread_bubble]Let me generate a few ideas...[/nectar_chat_thread_bubble][/nectar_chat_thread][/vc_column_inner][/vc_row_inner][/vc_column][vc_column flex_gap_desktop="10px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/4" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" content_layout="flexbox" gradient_type="default" flex_layout_desktop="column" flex_justify_content_desktop="space-between" flex_align_items_desktop="stretch" flex_align_items_phone="" flex_wrap_desktop="nowrap" flex_reverse_desktop="false"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all" css=".vc_custom_1753750120307{border-radius: 15px !important;}" height_desktop="100%"][vc_column_inner top_padding_desktop="30px" constrain_group_100="yes" bottom_padding_desktop="30px" left_padding_desktop="30px" constrain_group_101="yes" right_padding_desktop="30px" flex_gap_desktop="20px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color="#FFFFFF" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="15px" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" content_layout="flexbox" gradient_type="default" height_desktop="100%" flex_layout_desktop="column" flex_justify_content_desktop="space-between" flex_align_items_desktop="flex-start" flex_align_items_phone="" flex_wrap_desktop="nowrap" flex_reverse_desktop="false" min_height_desktop="300px" min_height_phone="200px"][nectar_responsive_text inherited_font_style="default" font_line_height="1.3" text_direction="default"]
<h2>The choice of thousands</h2>
[/nectar_responsive_text][nectar_circle_images images="https://themenectar.com/img/demo-media/unsplash/tether-circle-images-3.webp,https://themenectar.com/img/demo-media/unsplash/tether-circle-images-4.webp,https://themenectar.com/img/demo-media/unsplash/tether-circle-images-5.webp" sizing="44px" positioning="overlapping" stacking_order="ltr" border_color="#FFFFFF" alignment_desktop="left" alignment_tablet="inherit" alignment_phone="inherit" animation="none" image_size="nectar_small_square" image_loading="default"][divider line_type="No Line" custom_height="100%"][vc_column_text css="" text_direction="default"]Over 8,000 clients trust Tether to connect their teams[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all" css=".vc_custom_1753757426250{background-color: #FFFFFF !important;border-radius: 15px !important;}" height_desktop="100%"][vc_column_inner top_padding_desktop="30px" constrain_group_100="yes" bottom_padding_desktop="30px" left_padding_desktop="30px" constrain_group_101="yes" right_padding_desktop="30px" flex_gap_desktop="10px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="15px" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" content_layout="flexbox" gradient_type="default" height_desktop="100%" flex_layout_desktop="column" flex_justify_content_desktop="space-between" flex_align_items_desktop="flex-start" flex_align_items_phone="" flex_wrap_desktop="nowrap" flex_reverse_desktop="false" min_height_desktop="300px" min_height_phone="200px"][milestone heading_inherit="h2" symbol_position="after" subject_padding="0" color="Default" effect="none" symbol_alignment="Default" milestone_alignment="default" number="+4" symbol="x" number_font_size="6vw" symbol_font_size="24px"][vc_column_text css="" text_direction="default"]Average increase in team productivity following our operational audits[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" flex_gap_desktop="10px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/4" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" content_layout="flexbox" gradient_type="default" flex_layout_desktop="column" flex_justify_content_desktop="flex-start" flex_align_items_desktop="stretch" flex_align_items_phone="" flex_wrap_desktop="nowrap" flex_reverse_desktop="false"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all" css=".vc_custom_1753757418353{background-color: #FFFFFF !important;border-radius: 15px !important;}" height_desktop="100%"][vc_column_inner top_padding_desktop="30px" constrain_group_100="yes" bottom_padding_desktop="30px" left_padding_desktop="30px" constrain_group_101="yes" right_padding_desktop="30px" flex_gap_desktop="10px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="15px" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" content_layout="flexbox" gradient_type="default" height_desktop="100%" flex_layout_desktop="column" flex_justify_content_desktop="space-between" flex_align_items_desktop="flex-start" flex_align_items_phone="" flex_wrap_desktop="nowrap" flex_reverse_desktop="false" min_height_desktop="250px" min_height_phone="200px"][milestone heading_inherit="h2" symbol_position="after" subject_padding="0" color="Default" effect="none" symbol_alignment="Default" milestone_alignment="default" number="92" symbol="%" number_font_size="6vw" symbol_font_size="24px"][vc_column_text css="" text_direction="default"]Of clients report measurable ROI within 90 days of using Tether[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all" css=".vc_custom_1753750120307{border-radius: 15px !important;}" height_desktop="100%"][vc_column_inner top_padding_desktop="30px" constrain_group_100="yes" bottom_padding_desktop="30px" left_padding_desktop="30px" constrain_group_101="yes" right_padding_desktop="30px" flex_gap_desktop="10px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color="#FFFFFF" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://themenectar.com/img/demo-media/tn/working.webp" background_image_position="center center" background_image_stacking="front" enable_bg_scale="true" background_image_loading="default" column_backdrop_filter="none" column_shadow="none" column_border_radius="15px" column_link_target="_self" overflow="visible" advanced_gradient="linear-gradient(0deg, rgb(224,222,219) 45%, rgb(251,255,0) 100%)" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" mask_enable="true" mask_shape="blur-gradient" column_padding_type="advanced" content_layout="flexbox" gradient_type="advanced" height_desktop="100%" flex_layout_desktop="column" flex_justify_content_desktop="flex-end" flex_align_items_desktop="stretch" flex_align_items_phone="" flex_wrap_desktop="nowrap" flex_reverse_desktop="false" min_height_desktop="450px" advanced_gradient_display_type="linear"][divider line_type="No Line" custom_height="100%"][nectar_cta btn_style="text-reveal" heading_tag="span" border_radius="100" link_type="regular" button_color="custom" button_color_custom="#FFFFFF" text_color="#000000" button_border_thickness="0px" alignment="stretch" alignment_tablet="default" alignment_phone="default" constrain_group_3="yes" constrain_group_4="yes" icon_gap="20" display="inline" display_tablet="inherit" display_phone="inherit" icon_family="none" link_text="Get Started" padding_top="0.5em" padding_bottom="0.5em" padding_left="1.4em" padding_right="1.4em" margin_top="20px"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );





$data = array();
$data['name'] = esc_html__( 'Featured Case Study', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['testimonials'];
$data['custom_class'] = 'testimonials date-06-Sep-2025';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/tether-featured-testimonial.webp' );
$data['content'] = <<<CONTENT
[vc_section type="full_width_content" text_color="dark" left_padding_desktop="10px" constrain_group_2="yes" right_padding_desktop="10px" row_border_radius="none" row_border_radius_applies="bg" content_layout="default" advanced_gradient_display_type="linear" el_id="results"][vc_row type="full_width_background" full_screen_row_position="middle" column_margin="custom" column_margin_custom="30px" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_image="https://themenectar.com/img/demo-media/unsplash/surface-3jj4P6KSZWk-unsplash-1-scaled.webp" bg_image_type="default" bg_position="center center" background_image_loading="default" bg_repeat="no-repeat" scene_position="center" top_padding="8%" constrain_group_1="yes" bottom_padding="8%" top_padding_tablet="15%" constrain_group_3="yes" bottom_padding_tablet="15%" text_color="light" text_align="left" row_border_radius="15px" row_border_radius_applies="bg" overflow="visible" advanced_gradient="linear-gradient(0deg, rgba(2,2,2,0.225) 10%, rgba(2,2,2,0.225) 10%)" shape_divider_position="bottom" bg_image_animation="none" parallax_bg="true" parallax_bg_speed="fast" gradient_type="advanced" shape_type="" advanced_gradient_display_type="linear"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" flex_gap_desktop="40px" flex_gap_tablet="30px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="small_desktop" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" content_layout="flexbox" flex_layout_desktop="column" flex_justify_content_desktop="flex-start" flex_align_items_desktop="stretch" flex_align_items_phone="" flex_wrap_desktop="nowrap" flex_reverse_desktop="false" gradient_type="default"][nectar_responsive_text inherited_font_style="default" text_direction="default"]
<h6>Case Study</h6>
[/nectar_responsive_text][nectar_responsive_text inherited_font_style="default" text_direction="default"]
<h2>Tether has <em>completely transformed</em> how our remote team connects. What used to feel like a scattered group of individuals now feels like a true culture we’re proud of.</h2>
[/nectar_responsive_text][nectar_responsive_text inherited_font_style="default" text_direction="default"]
<h2>Our people are more engaged, communication flows naturally, and we’ve seen measurable improvements in both morale and productivity</h2>
[/nectar_responsive_text][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" flex_gap_desktop="10px" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][nectar_responsive_text inherited_font_style="default" font_size_desktop="18px" text_direction="default" font_size_tablet="16px"]
<h3>Jordan Lee</h3>
[/nectar_responsive_text][nectar_responsive_text inherited_font_style="default" text_color="#EDE9DEA6" text_direction="default" font_size_desktop="16px" font_size_tablet="14px"]CFO at Brightwave[/nectar_responsive_text][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" flex_gap_desktop="10px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="small_desktop" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" content_layout="flexbox" flex_layout_desktop="column" flex_justify_content_desktop="flex-end" flex_align_items_desktop="flex-end" flex_align_items_phone="flex-start" flex_wrap_desktop="nowrap" flex_reverse_desktop="false" gradient_type="default"][nectar_cta btn_style="text-reveal" heading_tag="span" link_type="video_lightbox" button_color="custom" button_color_custom="#EDE9DE33" text_color="#FFFFFF" button_border_thickness="0px" alignment="left" alignment_tablet="default" alignment_phone="default" constrain_group_3="yes" constrain_group_4="yes" backdrop_filter="blur" backdrop_filter_blur="14" display="block" display_tablet="inherit" display_phone="inherit" icon_family="fontawesome" link_text="Play Video" url="https://www.youtube.com/watch?v=5Fv4WQ-e-0E" padding_top="0.5em" padding_bottom="0.5em" padding_left="1.5em" padding_right="1.5em" icon_fontawesome="fa fa-play"][/vc_column][/vc_row][/vc_section]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Testimonial Carousel Mixed Content', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['testimonials'];
$data['custom_class'] = 'testimonials date-05-Sep-2025';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/tether-testimonial-carousel.webp' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="10%" bottom_padding="5%" top_padding_tablet="20%" bottom_padding_tablet="10%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" row_position_desktop="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" flex_gap_desktop="10px" desktop_text_alignment="center" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" content_layout="flexbox" flex_layout_desktop="column" flex_justify_content_desktop="center" flex_align_items_desktop="center" flex_align_items_phone="" flex_wrap_desktop="nowrap" flex_reverse_desktop="false" gradient_type="default"][nectar_responsive_text inherited_font_style="h1" text_direction="default" max_width="650px"]Real stories of growth and productivity[/nectar_responsive_text][/vc_column][/vc_row][vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" bottom_padding="5%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" row_position_desktop="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="hidden" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="top" shape_divider_height="50%" bg_image_animation="none" shape_type="straight_section" gradient_type="default"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" flex_gap_desktop="10px" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" flexbox_justify_content_tablet="" flexbox_align_items_tablet="" flexbox_direction_tablet=""][carousel script="flickity" flickity_formatting="default" desktop_cols_flickity="3" desktop_small_cols_flickity="3" tablet_cols_flickity="2" phone_cols_flickity="1" flickity_subtract_from_column_width="10vw" flickity_controls="none" color="default" flickity_overflow="visible" flickity_wrap_around="wrap" flickity_spacing="5px" flickity_centered_cells="true" flickity_column_vertical_alignment="default" column_padding="30px" flickity_element_spacing="0" border_radius="15px" autorotate="true" autorotate_type="ticker" ticker_speed="slow" ticker_direction="default"][item simple_slider_bg_image_position="default" simple_slider_overlay_strength="0.3" simple_slider_bg_image_loading="default" flickity_bg_image_loading="default" flex_gap_desktop="10px" flickity_item_link_type="regular" advanced_gradient="linear-gradient(0deg, rgb(252,255,1) 48%, rgb(252,255,1) 48%)" color_layer_opacity="" color_layer_opacity_hover="" color_layer="linear-gradient(274deg, rgb(255, 96, 96) 10%, #f3f3f3 90%)" color_layer_gradient_angle="274" color_layer_gradient_radial_position="top right" color_layer_gradient_direction="left_b_to_right_t" id="1763420594500-0" title="Item" tab_id="1763420594500-5" color_layer_gradient_type="radial" advanced_gradient_display_type="linear" flickity_custom_item_width="44%" content_layout="flexbox" flex_layout_desktop="column" flex_justify_content_desktop="space-between" flex_align_items_desktop="stretch" flex_align_items_phone="" flex_wrap_desktop="nowrap" flex_reverse_desktop="false"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" flex_gap_desktop="10px" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][nectar_responsive_text inherited_font_style="h2" font_size_min="24px" font_size_desktop="1.7vw" font_line_height="1.3" text_direction="default"]“Switching to Tether streamlined our operations overnight. Meetings are shorter, tasks are clearer, and our team finally feels aligned around the same goals.”[/nectar_responsive_text][/vc_column_inner][/vc_row_inner][divider line_type="No Line" custom_height="200px" custom_height_tablet="150px" custom_height_phone="100px"][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" flex_gap_desktop="5px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="2/3" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" content_layout="flexbox" gradient_type="default" flex_layout_desktop="column" flex_justify_content_desktop="flex-end" flex_align_items_desktop="flex-start" flex_align_items_phone="" flex_wrap_desktop="nowrap" flex_reverse_desktop="false" offset="vc_col-xs-8"][nectar_responsive_text inherited_font_style="h5" text_direction="default" font_line_height="1.1"]Sophia Reynolds[/nectar_responsive_text][nectar_responsive_text inherited_font_style="default" text_color="#0000006E" text_direction="default" font_line_height="1.1" font_size_desktop="14px"]Head of Operations at Brightwave[/nectar_responsive_text][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" content_layout="default" gradient_type="default" offset="vc_col-xs-4"][image_with_animation image_url="https://themenectar.com/img/demo-media/unsplash/tether-circle-images-5.webp" image_size="regular" max_width="custom" animation_type="entrance" animation="None" animation_movement_type="transform_y" hover_animation="none" alignment="right" border_radius="custom" box_shadow="none" top_left_border_radius="40px" top_right_border_radius="40px" bottom_right_border_radius="40px" bottom_left_border_radius="40px" image_loading="default" max_width_custom="44px"][/vc_column_inner][/vc_row_inner][/item][item simple_slider_bg_image_position="default" simple_slider_overlay_strength="0.3" simple_slider_bg_image_loading="default" flickity_bg_image_url="https://themenectar.com/img/demo-media/unsplash/thiago-falcao-N404kXNcdKo-unsplash.webp" flickity_bg_image_loading="lazy-load" flex_gap_desktop="10px" flickity_item_link_type="video_lightbox" advanced_gradient="linear-gradient(0deg, rgb(0,0,0) 0%, rgba(0,0,0,0) 34%)" advanced_gradient_opacity="0.7" advanced_gradient_opacity_hover="0.7" color_layer_gradient_direction="left_to_right" id="1763420594587-6" title="Item" tab_id="1763420594588-4" flickity_custom_item_width="34%" advanced_gradient_display_type="linear" content_layout="flexbox" flex_layout_desktop="column" flex_justify_content_desktop="space-between" flex_align_items_desktop="stretch" flex_align_items_phone="" flex_wrap_desktop="nowrap" flex_reverse_desktop="false" flickity_item_url="https://www.youtube.com/watch?v=5Fv4WQ-e-0E" flickity_item_aria_label_text="Video Testimonial"][divider line_type="No Line" custom_height="200px" custom_height_tablet="150px" custom_height_phone="100px"][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="5px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" font_color="#F9F4E9" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="2/3" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" content_layout="default" gradient_type="default" offset="vc_col-xs-8"][nectar_responsive_text inherited_font_style="h5" text_direction="default" font_line_height="1.1"]Jordan Lee[/nectar_responsive_text][nectar_responsive_text inherited_font_style="default" text_color="#F9F4E9BA" text_direction="default" font_line_height="1.1" font_size_desktop="14px"]Team Lead[/nectar_responsive_text][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" flex_gap_desktop="10px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" content_layout="flexbox" flex_layout_desktop="column" flex_justify_content_desktop="flex-end" flex_align_items_desktop="flex-end" flex_align_items_phone="" flex_wrap_desktop="nowrap" flex_reverse_desktop="false" gradient_type="default" offset="vc_col-xs-4"][nectar_icon icon_family="fontawesome" icon_style="color-bg" icon_color_type="custom" icon_color_custom="#F6F4F01A" icon_color_custom_hover="#F6F4F038" icon_secondary_color_custom="#F6F4F0" icon_padding="10px" backdrop_filter="blur" backdrop_filter_blur="21" pointer_events="all" icon_fontawesome="fa fa-play" icon_size="16px"][/vc_column_inner][/vc_row_inner][/item][item simple_slider_bg_image_position="default" simple_slider_overlay_strength="0.3" simple_slider_bg_image_loading="default" flickity_bg_image_loading="default" flex_gap_desktop="10px" flickity_item_link_type="regular" advanced_gradient="linear-gradient(0deg, rgb(255,255,255) 49%, rgb(255,255,255) 49%)" color_layer_opacity="" color_layer_opacity_hover="" color_layer="linear-gradient(274deg, rgb(255, 96, 96) 10%, #f3f3f3 90%)" color_layer_gradient_angle="274" color_layer_gradient_radial_position="top right" color_layer_gradient_direction="left_b_to_right_t" id="1763420594625-7" title="Item" tab_id="1763420594625-3" color_layer_gradient_type="radial" advanced_gradient_display_type="linear" flickity_custom_item_width="44%" content_layout="flexbox" flex_layout_desktop="column" flex_justify_content_desktop="space-between" flex_align_items_desktop="stretch" flex_align_items_phone="" flex_wrap_desktop="nowrap" flex_reverse_desktop="false"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" flex_gap_desktop="10px" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][nectar_responsive_text inherited_font_style="h2" font_size_min="24px" font_size_desktop="1.7vw" font_line_height="1.3" text_direction="default"]“Switching to Tether streamlined our operations overnight. Meetings are shorter, tasks are clearer, and our team finally feels aligned around the same goals.”[/nectar_responsive_text][/vc_column_inner][/vc_row_inner][divider line_type="No Line" custom_height="200px" custom_height_tablet="150px" custom_height_phone="100px"][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" flex_gap_desktop="5px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="2/3" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" content_layout="flexbox" gradient_type="default" flex_layout_desktop="column" flex_justify_content_desktop="flex-end" flex_align_items_desktop="flex-start" flex_align_items_phone="" flex_wrap_desktop="nowrap" flex_reverse_desktop="false" offset="vc_col-xs-8"][nectar_responsive_text inherited_font_style="h5" text_direction="default" font_line_height="1.1"]Marcus Bennett[/nectar_responsive_text][nectar_responsive_text inherited_font_style="default" text_color="#0000006E" text_direction="default" font_line_height="1.1" font_size_desktop="14px"]Director of Marketing[/nectar_responsive_text][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" content_layout="default" gradient_type="default" offset="vc_col-xs-4"][image_with_animation image_url="https://themenectar.com/img/demo-media/unsplash/tether-circle-images-4.webp" image_size="regular" max_width="custom" animation_type="entrance" animation="None" animation_movement_type="transform_y" hover_animation="none" alignment="right" border_radius="custom" box_shadow="none" top_left_border_radius="40px" top_right_border_radius="40px" bottom_right_border_radius="40px" bottom_left_border_radius="40px" image_loading="default" max_width_custom="44px"][/vc_column_inner][/vc_row_inner][/item][item simple_slider_bg_image_position="default" simple_slider_overlay_strength="0.3" simple_slider_bg_image_loading="default" flickity_bg_image_url="https://themenectar.com/img/demo-media/unsplash/laurent-yasiel-ejZUnsWgY1Y-unsplash.webp" flickity_bg_image_loading="lazy-load" flex_gap_desktop="10px" flickity_item_link_type="video_lightbox" advanced_gradient="linear-gradient(0deg, rgb(0,0,0) 0%, rgba(243,243,243,0.153) 35%)" advanced_gradient_opacity="0.7" advanced_gradient_opacity_hover="0.7" color_layer_gradient_direction="left_to_right" id="1763420594684-6" title="Item" tab_id="1763420594685-10" flickity_custom_item_width="34%" advanced_gradient_display_type="linear" content_layout="flexbox" flex_layout_desktop="column" flex_justify_content_desktop="space-between" flex_align_items_desktop="stretch" flex_align_items_phone="" flex_wrap_desktop="nowrap" flex_reverse_desktop="false" flickity_item_url="https://www.youtube.com/watch?v=5Fv4WQ-e-0E" flickity_item_aria_label_text="Video Testimonial"][divider line_type="No Line" custom_height="200px" custom_height_tablet="150px" custom_height_phone="100px"][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="5px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" font_color="#F9F4E9" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="2/3" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" content_layout="default" gradient_type="default" offset="vc_col-xs-8"][nectar_responsive_text inherited_font_style="h5" text_direction="default" font_line_height="1.1"]Alexander Wright[/nectar_responsive_text][nectar_responsive_text inherited_font_style="default" text_color="#F9F4E9B8" text_direction="default" font_line_height="1.1" font_size_desktop="14px"]Chief Operating Officer[/nectar_responsive_text][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" flex_gap_desktop="10px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" content_layout="flexbox" flex_layout_desktop="column" flex_justify_content_desktop="flex-end" flex_align_items_desktop="flex-end" flex_align_items_phone="" flex_wrap_desktop="nowrap" flex_reverse_desktop="false" gradient_type="default" offset="vc_col-xs-4"][nectar_icon icon_family="fontawesome" icon_style="color-bg" icon_color_type="custom" icon_color_custom="#F6F4F01A" icon_color_custom_hover="#F6F4F038" icon_secondary_color_custom="#F6F4F0" icon_padding="10px" backdrop_filter="blur" backdrop_filter_blur="21" pointer_events="all" icon_fontawesome="fa fa-play" icon_size="16px"][/vc_column_inner][/vc_row_inner][/item][item simple_slider_bg_image_position="default" simple_slider_overlay_strength="0.3" simple_slider_bg_image_loading="default" flickity_bg_image_loading="default" flex_gap_desktop="10px" flickity_item_link_type="regular" advanced_gradient="linear-gradient(0deg, rgb(251,255,0) 49%, rgb(251,255,0) 49%)" color_layer_opacity="" color_layer_opacity_hover="" color_layer="linear-gradient(274deg, rgb(255, 96, 96) 10%, #f3f3f3 90%)" color_layer_gradient_angle="274" color_layer_gradient_radial_position="top right" color_layer_gradient_direction="left_b_to_right_t" id="1763420594742-3" title="Item" tab_id="1763420594742-7" color_layer_gradient_type="radial" advanced_gradient_display_type="linear" flickity_custom_item_width="44%" content_layout="flexbox" flex_layout_desktop="column" flex_justify_content_desktop="space-between" flex_align_items_desktop="stretch" flex_align_items_phone="" flex_wrap_desktop="nowrap" flex_reverse_desktop="false"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" flex_gap_desktop="10px" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][nectar_responsive_text inherited_font_style="h2" font_size_min="24px" font_size_desktop="1.7vw" font_line_height="1.3" text_direction="default"]“Switching to Tether streamlined our operations overnight. Meetings are shorter, tasks are clearer, and our team finally feels aligned around the same goals.”[/nectar_responsive_text][/vc_column_inner][/vc_row_inner][divider line_type="No Line" custom_height="200px" custom_height_tablet="150px" custom_height_phone="100px"][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" flex_gap_desktop="5px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="2/3" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" content_layout="flexbox" gradient_type="default" flex_layout_desktop="column" flex_justify_content_desktop="flex-end" flex_align_items_desktop="flex-start" flex_align_items_phone="" flex_wrap_desktop="nowrap" flex_reverse_desktop="false" offset="vc_col-xs-8"][nectar_responsive_text inherited_font_style="h5" text_direction="default" font_line_height="1.1"]Christopher Johnson[/nectar_responsive_text][nectar_responsive_text inherited_font_style="default" text_color="#0000006E" text_direction="default" font_line_height="1.1" font_size_desktop="14px"]Team Lead, Horizon[/nectar_responsive_text][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" content_layout="default" gradient_type="default" offset="vc_col-xs-4"][image_with_animation image_url="https://themenectar.com/img/demo-media/unsplash/tether-circle-images-3.webp" image_size="regular" max_width="custom" animation_type="entrance" animation="None" animation_movement_type="transform_y" hover_animation="none" alignment="right" border_radius="custom" box_shadow="none" top_left_border_radius="40px" top_right_border_radius="40px" bottom_right_border_radius="40px" bottom_left_border_radius="40px" image_loading="default" max_width_custom="44px"][/vc_column_inner][/vc_row_inner][/item][item simple_slider_bg_image_position="default" simple_slider_overlay_strength="0.3" simple_slider_bg_image_loading="default" flickity_bg_image_url="https://themenectar.com/img/demo-media/unsplash/thiago-falcao-N404kXNcdKo-unsplash.webp" flickity_bg_image_loading="lazy-load" flex_gap_desktop="10px" flickity_item_link_type="video_lightbox" advanced_gradient="linear-gradient(0deg, rgb(0,0,0) 0%, rgba(0,0,0,0) 34%)" advanced_gradient_opacity="0.7" advanced_gradient_opacity_hover="0.7" color_layer_gradient_direction="left_to_right" id="1763420594807-4" title="Item" tab_id="1763420594807-8" flickity_custom_item_width="34%" advanced_gradient_display_type="linear" content_layout="flexbox" flex_layout_desktop="column" flex_justify_content_desktop="space-between" flex_align_items_desktop="stretch" flex_align_items_phone="" flex_wrap_desktop="nowrap" flex_reverse_desktop="false" flickity_item_url="https://www.youtube.com/watch?v=5Fv4WQ-e-0E" flickity_item_aria_label_text="Video Testimonial"][divider line_type="No Line" custom_height="200px" custom_height_tablet="150px" custom_height_phone="100px"][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="5px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" font_color="#F9F4E9" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="2/3" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" content_layout="default" gradient_type="default" offset="vc_col-xs-8"][nectar_responsive_text inherited_font_style="h5" text_direction="default" font_line_height="1.1"]Ethan Clarke[/nectar_responsive_text][nectar_responsive_text inherited_font_style="default" text_color="#F9F4E9BA" text_direction="default" font_line_height="1.1" font_size_desktop="14px"]Customer Success[/nectar_responsive_text][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" flex_gap_desktop="10px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" content_layout="flexbox" flex_layout_desktop="column" flex_justify_content_desktop="flex-end" flex_align_items_desktop="flex-end" flex_align_items_phone="" flex_wrap_desktop="nowrap" flex_reverse_desktop="false" gradient_type="default" offset="vc_col-xs-4"][nectar_icon icon_family="fontawesome" icon_style="color-bg" icon_color_type="custom" icon_color_custom="#F6F4F01A" icon_color_custom_hover="#F6F4F038" icon_secondary_color_custom="#F6F4F0" icon_padding="10px" backdrop_filter="blur" backdrop_filter_blur="21" pointer_events="all" icon_fontawesome="fa fa-play" icon_size="16px"][/vc_column_inner][/vc_row_inner][/item][item simple_slider_bg_image_position="default" simple_slider_overlay_strength="0.3" simple_slider_bg_image_loading="default" flickity_bg_image_loading="default" flex_gap_desktop="10px" flickity_item_link_type="regular" advanced_gradient="linear-gradient(0deg, rgb(255,255,255) 46%, rgb(255,255,255) 46%)" color_layer_opacity="" color_layer_opacity_hover="" color_layer="linear-gradient(274deg, rgb(255, 96, 96) 10%, #f3f3f3 90%)" color_layer_gradient_angle="274" color_layer_gradient_radial_position="top right" color_layer_gradient_direction="left_b_to_right_t" id="1763420594861-3" title="Item" tab_id="1763420594861-9" color_layer_gradient_type="radial" advanced_gradient_display_type="linear" flickity_custom_item_width="44%" content_layout="flexbox" flex_layout_desktop="column" flex_justify_content_desktop="space-between" flex_align_items_desktop="stretch" flex_align_items_phone="" flex_wrap_desktop="nowrap" flex_reverse_desktop="false"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" flex_gap_desktop="10px" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][nectar_responsive_text inherited_font_style="h2" font_size_min="24px" font_size_desktop="1.7vw" font_line_height="1.3" text_direction="default"]“Before Tether, onboarding new hires was a headache. Now, training modules are automated, progress is tracked in real time, and new team members feel productive within days instead of weeks.”[/nectar_responsive_text][/vc_column_inner][/vc_row_inner][divider line_type="No Line" custom_height="200px" custom_height_tablet="150px" custom_height_phone="100px"][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" flex_gap_desktop="5px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="2/3" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" content_layout="flexbox" gradient_type="default" flex_layout_desktop="column" flex_justify_content_desktop="flex-end" flex_align_items_desktop="flex-start" flex_align_items_phone="" flex_wrap_desktop="nowrap" flex_reverse_desktop="false" offset="vc_col-xs-8"][nectar_responsive_text inherited_font_style="h5" text_direction="default" font_line_height="1.1"]Ethan Ramirez[/nectar_responsive_text][nectar_responsive_text inherited_font_style="default" text_color="#0000006E" text_direction="default" font_line_height="1.1" font_size_desktop="14px"]Director of IT[/nectar_responsive_text][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" content_layout="default" gradient_type="default" offset="vc_col-xs-4"][image_with_animation image_url="https://themenectar.com/img/demo-media/unsplash/tether-circle-images-2.webp" image_size="regular" max_width="custom" animation_type="entrance" animation="None" animation_movement_type="transform_y" hover_animation="none" alignment="right" border_radius="custom" box_shadow="none" top_left_border_radius="40px" top_right_border_radius="40px" bottom_right_border_radius="40px" bottom_left_border_radius="40px" image_loading="default" max_width_custom="44px"][/vc_column_inner][/vc_row_inner][/item][item simple_slider_bg_image_position="default" simple_slider_overlay_strength="0.3" simple_slider_bg_image_loading="default" flickity_bg_image_url="https://themenectar.com/img/demo-media/unsplash/laurent-yasiel-ejZUnsWgY1Y-unsplash.webp" flickity_bg_image_loading="lazy-load" flex_gap_desktop="10px" flickity_item_link_type="video_lightbox" advanced_gradient="linear-gradient(0deg, rgb(0,0,0) 0%, rgba(243,243,243,0.153) 35%)" advanced_gradient_opacity="0.7" advanced_gradient_opacity_hover="0.7" color_layer_gradient_direction="left_to_right" id="1763420594948-7" title="Item" tab_id="1763420594948-0" flickity_custom_item_width="34%" advanced_gradient_display_type="linear" content_layout="flexbox" flex_layout_desktop="column" flex_justify_content_desktop="space-between" flex_align_items_desktop="stretch" flex_align_items_phone="" flex_wrap_desktop="nowrap" flex_reverse_desktop="false" flickity_item_url="https://www.youtube.com/watch?v=5Fv4WQ-e-0E" flickity_item_aria_label_text="Video Testimonial"][divider line_type="No Line" custom_height="200px" custom_height_tablet="150px" custom_height_phone="100px"][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="5px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" font_color="#F9F4E9" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="2/3" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" content_layout="default" gradient_type="default" offset="vc_col-xs-8"][nectar_responsive_text inherited_font_style="h5" text_direction="default" font_line_height="1.1"]Michael Lawson[/nectar_responsive_text][nectar_responsive_text inherited_font_style="default" text_color="#F9F4E9B8" text_direction="default" font_line_height="1.1" font_size_desktop="14px"]Chief Operating Officer[/nectar_responsive_text][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" flex_gap_desktop="10px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" content_layout="flexbox" flex_layout_desktop="column" flex_justify_content_desktop="flex-end" flex_align_items_desktop="flex-end" flex_align_items_phone="" flex_wrap_desktop="nowrap" flex_reverse_desktop="false" gradient_type="default" offset="vc_col-xs-4"][nectar_icon icon_family="fontawesome" icon_style="color-bg" icon_color_type="custom" icon_color_custom="#F6F4F01A" icon_color_custom_hover="#F6F4F038" icon_secondary_color_custom="#F6F4F0" icon_padding="10px" backdrop_filter="blur" backdrop_filter_blur="21" pointer_events="all" icon_fontawesome="fa fa-play" icon_size="16px"][/vc_column_inner][/vc_row_inner][/item][/carousel][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Sticky FAQ', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-04-Sep-2025';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/tether-faq.webp' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="custom" column_margin_custom="15vw" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="5%" constrain_group_1="yes" bottom_padding="5%" top_padding_tablet="10%" constrain_group_3="yes" bottom_padding_tablet="10%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" flex_layout_tablet="row" flex_justify_content_tablet="space-between" flex_align_items_tablet="flex-end" flex_gap_desktop="10px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" content_layout="flexbox" flex_layout_desktop="column" flex_justify_content_desktop="flex-start" flex_align_items_desktop="flex-start" flex_align_items_phone="flex-start" flex_wrap_desktop="nowrap" flex_reverse_desktop="false" gradient_type="default" flex_layout_phone="column" flex_justify_content_phone="flex-start"][nectar_responsive_text inherited_font_style="default" text_direction="default"]
<h2>Everything you need to know</h2>
[/nectar_responsive_text][nectar_cta btn_style="text-reveal" heading_tag="span" border_radius="100" link_type="regular" button_color="accent-color" text_color="#F6F4F0" button_border_thickness="0px" alignment="left" alignment_tablet="default" alignment_phone="default" constrain_group_3="yes" constrain_group_4="yes" icon_gap="20" display="inline" display_tablet="inherit" display_phone="inherit" icon_family="none" link_text="Contact us" padding_top="0.5em" padding_bottom="0.5em" padding_left="1.4em" padding_right="1.4em" margin_top="10px"][/vc_column][vc_column top_padding_desktop="10px" constrain_group_100="yes" bottom_padding_desktop="10px" left_padding_desktop="10px" constrain_group_101="yes" right_padding_desktop="10px" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color="#EBE9E5" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="15px" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="2/3" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" content_layout="default" gradient_type="default"][toggles style="animated_circle" animated_circle_position="right" animated_circle_size="40" animated_circle_bg_color="#FFFFFF" animated_circle_gap="10" accordion="true" accordion_starting_functionality="default" border_radius="15px"][toggle color="Default" heading_tag="h4" heading_tag_functionality="default" title="What exactly is Tether?"][vc_column_text css="" text_direction="default"]Tether is a SaaS platform designed to help teams build stronger connections through real-time collaboration, guided team-building exercises, and meaningful rituals. It keeps everyone aligned and engaged, whether working remotely or in person.[/vc_column_text][/toggle][toggle color="Default" heading_tag="h4" heading_tag_functionality="default" title="How does Tether improve team collaboration?"][vc_column_text css="" text_direction="default"]Tether provides tools for real-time communication, shared rituals, and structured team-building activities. By integrating these into daily workflows, Tether ensures teams stay in sync, feel connected, and work together more effectively.[/vc_column_text][/toggle][toggle color="Accent-Color" heading_tag="h4" heading_tag_functionality="default" title="Can Tether work with remote or hybrid teams?"][vc_column_text css="" text_direction="default"]Absolutely. Tether is designed with flexibility in mind, making it ideal for remote, hybrid, and in-office teams. The platform helps bridge distance by creating shared experiences that keep people engaged no matter where they’re working from.[/vc_column_text][/toggle][toggle color="Default" heading_tag="h4" heading_tag_functionality="default" title="What makes Tether different from other collaboration tools?"][vc_column_text css="" text_direction="default"]Unlike standard productivity tools, Tether focuses on strengthening human connection. It combines collaboration features with rituals and team-building practices that nurture culture, trust, and alignment—not just task management.[/vc_column_text][/toggle][toggle color="Default" heading_tag="h4" heading_tag_functionality="default" title="Does Tether integrate with the tools we already use?"][vc_column_text css="" text_direction="default"]Yes. Tether is designed to fit seamlessly into your existing workflow. It integrates with popular workplace tools so your team can stay connected without adding extra complexity.[/vc_column_text][/toggle][/toggles][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Tether CTA', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['cta'];
$data['custom_class'] = 'cta date-04-Sep-2025';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/tether-cta.webp' );
$data['content'] = <<<CONTENT
[vc_section type="full_width_content" text_color="dark" top_padding="5%" left_padding_desktop="10px" constrain_group_2="yes" right_padding_desktop="10px" top_padding_tablet="10%" row_border_radius="none" row_border_radius_applies="bg" content_layout="default" advanced_gradient_display_type="linear"][vc_row type="full_width_background" full_screen_row_position="middle" column_margin="10px" equal_height="yes" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_image="https://themenectar.com/img/demo-media/unsplash/mountains-3-1.webp" bg_image_type="default" bg_position="center center" background_image_loading="default" bg_repeat="no-repeat" scene_position="center" top_padding="10%" constrain_group_1="yes" bottom_padding="10%" text_color="light" text_align="left" row_border_radius="15px" row_border_radius_applies="bg" overflow="visible" color_overlay="#16151499" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" parallax_bg="true" parallax_bg_speed="fast" gradient_type="default" shape_type=""][vc_column top_padding_desktop="40px" constrain_group_100="yes" bottom_padding_desktop="40px" left_padding_desktop="40px" constrain_group_101="yes" right_padding_desktop="40px" left_padding_phone="25px" constrain_group_105="yes" right_padding_phone="25px" flex_gap_desktop="30px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="15px" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" parallax_bg="true" parallax_bg_speed="minimum" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" content_layout="flexbox" gradient_type="default" flex_layout_desktop="column" flex_justify_content_desktop="space-between" flex_align_items_desktop="stretch" flex_align_items_phone="" flex_wrap_desktop="nowrap" flex_reverse_desktop="false"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner flex_gap_desktop="10px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" content_layout="flexbox" gradient_type="default" flex_layout_desktop="column" flex_justify_content_desktop="flex-start" flex_align_items_desktop="center" flex_align_items_phone="" flex_wrap_desktop="nowrap" flex_reverse_desktop="false"][nectar_badge display_tag="body" badge_style="default" bg_color_type="custom" bg_color_custom="#EDE9DE1A" backdrop_filter="blur" backdrop_filter_blur="10" padding="small" border_radius="20px" display="block" blur_background="true" text="Tether"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" left_position_desktop="10%" right_position_desktop="10%" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" flex_gap_desktop="20px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" content_layout="flexbox" flex_layout_desktop="column" flex_justify_content_desktop="flex-start" flex_align_items_desktop="center" flex_align_items_phone="" flex_wrap_desktop="nowrap" flex_reverse_desktop="false" gradient_type="default"][nectar_responsive_text inherited_font_style="h1" text_direction="default" font_line_height="1.2" max_width="700px"]
<h2 style="text-align: center;">From collaboration to breakthroughs</h2>
[/nectar_responsive_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" flex_gap_desktop="20px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" content_layout="flexbox" flex_layout_desktop="column" flex_justify_content_desktop="flex-start" flex_align_items_desktop="center" flex_align_items_phone="" flex_wrap_desktop="nowrap" flex_reverse_desktop="false" gradient_type="default"][nectar_cta btn_style="text-reveal" heading_tag="span" link_type="regular" button_color="extra-color-1" text_color="#000000" button_border_thickness="0px" alignment="left" alignment_tablet="default" alignment_phone="default" constrain_group_3="yes" constrain_group_4="yes" display="block" display_tablet="inherit" display_phone="inherit" icon_family="none" link_text="Get started — it’s free" padding_top="0.75em" padding_bottom="0.75em" padding_left="1.5em" padding_right="1.5em"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][/vc_section]
CONTENT;

vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Tether Footer', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-03-Sep-2025';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/tether-footer.webp' );
$data['content'] = <<<CONTENT
[vc_section type="full_width_background" flex_gap_desktop="30px" text_color="dark" top_padding="5%" constrain_group_1="yes" bottom_padding="5%" top_padding_tablet="10%" constrain_group_3="yes" bottom_padding_tablet="10%" row_border_radius="none" row_border_radius_applies="bg" content_layout="flexbox" advanced_gradient_display_type="linear" flex_layout_desktop="column" flex_justify_content_desktop="flex-start" flex_align_items_desktop="flex-start" flex_align_items_phone="" flex_wrap_desktop="nowrap" flex_reverse_desktop="false"][vc_row type="full_width_background" full_screen_row_position="middle" column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" row_position_desktop="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="hidden" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column right_padding_desktop="50%" right_padding_phone="0" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="2/3" tablet_width_inherit="small_desktop" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" content_layout="default" gradient_type="default"][nectar_responsive_text inherited_font_style="default" text_direction="default" font_line_height="1.3"]
<h2>Building Stronger, More Connected Teams</h2>
[/nectar_responsive_text][/vc_column][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" top_margin_phone="30px" flex_gap_desktop="" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="small_desktop" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" content_layout="flexbox" gradient_type="default" flex_layout_desktop="column" flex_justify_content_desktop="flex-start" flex_align_items_desktop="flex-end" flex_align_items_phone="stretch" flex_wrap_desktop="nowrap" flex_reverse_desktop="false"][vc_row_inner column_margin="50px" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" min_width_desktop="325px" min_width_phone="0px" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" flex_gap_desktop="10px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="small_desktop" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" content_layout="flexbox" flex_layout_desktop="column" flex_justify_content_desktop="flex-start" flex_align_items_desktop="flex-start" flex_align_items_phone="" flex_wrap_desktop="nowrap" flex_reverse_desktop="false" gradient_type="default" offset="vc_col-xs-6"][nectar_cta btn_style="underline" heading_tag="span" link_type="regular" button_color="default" button_border_thickness="0px" alignment="left" alignment_tablet="default" alignment_phone="default" display="block" display_tablet="inherit" display_phone="inherit" icon_family="none" link_text="Overview" url="#overview"][nectar_cta btn_style="underline" heading_tag="span" link_type="regular" button_color="default" button_border_thickness="0px" alignment="left" alignment_tablet="default" alignment_phone="default" display="block" display_tablet="inherit" display_phone="inherit" icon_family="none" link_text="Features" url="#features"][nectar_cta btn_style="underline" heading_tag="span" link_type="regular" button_color="default" button_border_thickness="0px" alignment="left" alignment_tablet="default" alignment_phone="default" display="block" display_tablet="inherit" display_phone="inherit" icon_family="none" link_text="Results" url="#results"][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" flex_align_items_tablet="flex-start" flex_gap_desktop="10px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="small_desktop" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" content_layout="flexbox" flex_layout_desktop="column" flex_justify_content_desktop="flex-start" flex_align_items_desktop="flex-end" flex_align_items_phone="" flex_wrap_desktop="nowrap" flex_reverse_desktop="false" gradient_type="default" offset="vc_col-xs-6"][nectar_cta btn_style="underline" heading_tag="span" link_type="regular" button_color="default" button_border_thickness="0px" alignment="left" alignment_tablet="default" alignment_phone="default" display="block" display_tablet="inherit" display_phone="inherit" icon_family="none" link_text="Changelog"][nectar_cta btn_style="underline" heading_tag="span" link_type="regular" button_color="default" button_border_thickness="0px" alignment="left" alignment_tablet="default" alignment_phone="default" display="block" display_tablet="inherit" display_phone="inherit" icon_family="none" link_text="Privacy Policy"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" row_position_desktop="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="2/3" tablet_width_inherit="small_desktop" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" content_layout="default" gradient_type="default"][nectar_responsive_text inherited_font_style="default" text_direction="default"]©[nectar_current_year]. All rights reserved.[/nectar_responsive_text][/vc_column][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" flex_gap_desktop="10px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="small_desktop" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" content_layout="flexbox" flex_layout_desktop="row" flex_justify_content_desktop="flex-end" flex_align_items_desktop="flex-start" flex_align_items_phone="" flex_wrap_desktop="nowrap" flex_reverse_desktop="false" gradient_type="default" flex_justify_content_phone="flex-start"][nectar_icon icon_family="nectarbrands" icon_style="color-bg" icon_color_type="custom" icon_color_custom="#0000000F" icon_color_custom_hover="#0000001C" icon_secondary_color_custom="#000000" open_new_tab="true" icon_padding="5px" pointer_events="all" icon_nectarbrands="nectar-brands-x-twitter" icon_size="14" url="https://twitter.com"][nectar_icon icon_family="nectarbrands" icon_style="color-bg" icon_color_type="custom" icon_color_custom="#0000000F" icon_color_custom_hover="#0000001C" icon_secondary_color_custom="#000000" open_new_tab="true" icon_padding="5px" pointer_events="all" icon_nectarbrands="nectar-brands-bluesky" icon_size="14" url="https://bluesky.com"][nectar_icon icon_family="nectarbrands" icon_style="color-bg" icon_color_type="custom" icon_color_custom="#0000000F" icon_color_custom_hover="#0000001C" icon_secondary_color_custom="#000000" open_new_tab="true" icon_padding="5px" pointer_events="all" icon_nectarbrands="nectar-brands-instagram" icon_size="14" url="https://instagram.com"][/vc_column][/vc_row][/vc_section]
CONTENT;

vc_add_default_templates( $data );






$data = array();
$data['name'] = esc_html__( 'Layered Hero Section', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['hero_section'];
$data['custom_class'] = 'hero_section date-06-July-2024';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/layered-hero.webp' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#262626" bg_image="https://themenectar.com/img/demo-media/unsplash/personal-portfolio-hero-greyscale.avif" bg_position="center center" background_image_loading="skip-lazy-load" bg_repeat="no-repeat" full_height="yes" columns_placement="bottom" scene_position="center" text_color="light" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient="linear-gradient(0deg, rgb(0,0,0) 0%, rgba(0,0,0,252) 0%, rgba(0,0,0,0) 43%)" shape_divider_position="bottom" bg_image_animation="zoom-out" mobile_disable_bg_image_animation="true" parallax_bg="true" parallax_bg_speed="medium_fast" gradient_type="advanced" shape_type="" advanced_gradient_display_type="linear"][vc_column bottom_padding_desktop="40px" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" gradient_type="default"][vc_row_inner equal_height="yes" content_placement="bottom" column_margin="10px" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner right_padding_desktop="15%" right_padding_tablet="50%" right_padding_phone="15%" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" gradient_type="default"][split_line_heading animation_type="line-reveal-by-space" font_style="h1" font_size_max="108px" line_reveal_by_space_text_effect="letter-reveal-bottom" stagger_animation="true" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="Adrian Uchenna" text_direction="default" font_size="6vw" font_line_height="1" font_size_tablet="10vw" font_size_phone="12vw"][/split_line_heading][/vc_column_inner][vc_column_inner left_padding_desktop="30%" left_padding_tablet="0" right_padding_tablet="30%" right_padding_phone="0" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" gradient_type="default" delay="300" offset="vc_col-xs-9"][nectar_responsive_text inherited_font_style="default" font_size_min="16px" font_size_max="22px" font_size_desktop="1.3vw" font_line_height="1.6" text_direction="default" max_width="375px"]A multi-disciplinary designer currently based in Philadelphia, PA.[/nectar_responsive_text][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="right" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/6" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default" delay="500" offset="vc_col-xs-3"][nectar_cta btn_style="next-section" btn_type="minimal-arrow" alignment="right" alignment_tablet="right" alignment_phone="default" display_tablet="inherit" display_phone="inherit"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );




	$data = array();
$data['name'] = esc_html__( 'Layered Portfolio', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['portfolio'];
$data['custom_class'] = 'general date-05-July-2024';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/layered-stacked.webp' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="80" constrain_group_1="yes" bottom_padding="80" left_padding_desktop="40" constrain_group_2="yes" right_padding_desktop="40" top_padding_tablet="40" constrain_group_3="yes" bottom_padding_tablet="40" left_padding_tablet="6%" constrain_group_4="yes" right_padding_tablet="6%" text_color="light" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" id="work" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][nectar_post_grid post_type="portfolio" portfolio_category="all" portfolio_starting_category="all" order="DESC" orderby="date" stack_animation_effect="blurred_scale" columns="1" columns_tablet="default" columns_phone="default" grid_item_spacing="40px" grid_item_height="80vh" image_size="full" image_loading="lazy-load" heading_tag="h2" font_size_max="220px" enable_indicator="yes" mouse_indicator_style="tooltip_text" mouse_indicator_text="view" mouse_indicator_color="rgba(0,0,0,0.23)" mouse_indicator_text_color="#ffffff" mouse_indicator_blurred_bg="yes" display_categories="yes" category_functionality="static" category_style="see-through-button" category_display="parent_only" display_excerpt="yes" excerpt_display="default" display_date="yes" additional_meta_size="small" custom_fields_location="before_post_meta" custom_fields="%5B%5D" grid_style="content_overlaid" text_content_layout="all_middle" color_overlay="#141414" color_overlay_opacity="0.3" color_overlay_hover_opacity="0.3" text_color="light" text_color_hover="light" text_opacity="1" text_hover_opacity="1" hover_effect="none" border_radius="25px" posts_per_page="5" display_type="stack" custom_font_size="12vw" font_size_tablet="12vw" image_loading_lazy_skip="1"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Layered Awards', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-04-July-2024';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/layered-awards.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="10%" bottom_padding="6%" top_padding_tablet="14%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" id="awards" overlay_strength="0.8" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type="" gradient_type="default"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="20px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding="1%" right_padding_desktop="40%" right_padding_phone="0" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][split_line_heading animation_type="line-reveal-by-space" font_style="h2" font_size_max="108px" line_reveal_by_space_text_effect="letter-reveal-bottom" stagger_animation="true" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="Professional Achievements" font_size="6vw" text_direction="default" font_line_height="1" font_size_tablet="7vw"][/split_line_heading][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][nectar_horizontal_list_item columns="4" column_layout_using_4_columns="even" responsive_display="multiple_columns" col_1_text_align="left" col_2_text_align="left" col_3_text_align="left" col_4_text_align="right" col_1_text_element="h3" col_2_text_element="p" col_3_text_element="h4" col_4_text_element="p" font_family="p" hover_effect="none" border_animation="true" border_color="#ffffff" icon_family="none" icon_size="large" col_1_content="Nectar Studio" col_2_content="AWWWARDS" col_3_content="Site Of The Day" col_4_content="2024"][nectar_horizontal_list_item columns="4" column_layout_using_4_columns="even" responsive_display="multiple_columns" col_1_text_align="left" col_2_text_align="left" col_3_text_align="left" col_4_text_align="right" col_1_text_element="h3" col_2_text_element="p" col_3_text_element="h4" col_4_text_element="p" font_family="p" hover_effect="none" border_animation="true" border_color="#ffffff" icon_family="none" icon_size="large" col_1_content="DesignWave" col_2_content="AWWWARDS" col_3_content="Site Of The Day" col_4_content="2023"][nectar_horizontal_list_item columns="4" column_layout_using_4_columns="even" responsive_display="multiple_columns" col_1_text_align="left" col_2_text_align="left" col_3_text_align="left" col_4_text_align="right" col_1_text_element="h3" col_2_text_element="p" col_3_text_element="h4" col_4_text_element="p" font_family="p" hover_effect="none" border_animation="true" border_color="#ffffff" icon_family="none" icon_size="large" col_1_content="Visionary" col_2_content="Web Awards" col_3_content="Best Innovation" col_4_content="2023"][nectar_horizontal_list_item columns="4" column_layout_using_4_columns="even" responsive_display="multiple_columns" col_1_text_align="left" col_2_text_align="left" col_3_text_align="left" col_4_text_align="right" col_1_text_element="h3" col_2_text_element="p" col_3_text_element="h4" col_4_text_element="p" font_family="p" hover_effect="none" border_animation="true" border_color="#ffffff" icon_family="none" icon_size="large" col_1_content="Lunar" col_2_content="MUSE Awards" col_3_content="Platinum Winner" col_4_content="2023"][nectar_horizontal_list_item columns="4" column_layout_using_4_columns="even" responsive_display="multiple_columns" col_1_text_align="left" col_2_text_align="left" col_3_text_align="left" col_4_text_align="right" col_1_text_element="h3" col_2_text_element="p" col_3_text_element="h4" col_4_text_element="p" font_family="p" hover_effect="none" border_animation="true" border_color="#ffffff" icon_family="none" icon_size="large" col_1_content="Pixel Forged" col_2_content="CSS Awards" col_3_content="Top UI Design" col_4_content="2022"][nectar_horizontal_list_item columns="4" column_layout_using_4_columns="even" responsive_display="multiple_columns" col_1_text_align="left" col_2_text_align="left" col_3_text_align="left" col_4_text_align="right" col_1_text_element="h3" col_2_text_element="p" col_3_text_element="h4" col_4_text_element="p" font_family="p" hover_effect="none" border_animation="true" border_color="#ffffff" icon_family="none" icon_size="large" col_1_content="NectarMade" col_2_content="AWWARDS" col_3_content="Developer Award" col_4_content="2022"][nectar_horizontal_list_item columns="4" column_layout_using_4_columns="even" responsive_display="multiple_columns" col_1_text_align="left" col_2_text_align="left" col_3_text_align="left" col_4_text_align="right" col_1_text_element="h3" col_2_text_element="p" col_3_text_element="h4" col_4_text_element="p" font_family="p" hover_effect="none" border_animation="true" border_color="#ffffff" icon_family="none" icon_size="large" col_1_content="Personal Portfolio" col_2_content="CSS Awards" col_3_content="Site of the Day" col_4_content="2022"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Layered Related Projects', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['portfolio'];
$data['custom_class'] = 'portfolio date-03-July-2024';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/layered-related-projects.webp' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#000000" scene_position="center" top_padding="6%" bottom_padding="4%" text_color="light" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="30px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][nectar_responsive_text inherited_font_style="default" font_size_max="60px" font_size_desktop="3.5vw" text_direction="default" font_line_height="1.2" font_size_tablet="5vw"]
<h2>Explore More Work</h2>
[/nectar_responsive_text][nectar_post_grid post_type="portfolio" portfolio_category="all" order="DESC" orderby="rand" pagination="none" exclude_current_post="yes" columns="3" columns_tablet="2" columns_phone="2" grid_item_spacing="5px" grid_item_height="30vh" 3_col_masonry_layout="default" image_size="large" aspect_ratio_image_size="yes" custom_image_aspect_ratio="4-5" image_loading="default" animation="fade-in-from-bottom" animation_stagger="90" animation_easing="default" heading_tag="default" font_size_max="40" display_categories="yes" category_functionality="static" category_position="below_title" category_style="underline" category_display="default" additional_meta_size="default" custom_fields_location="before_post_meta" grid_style="content_under_image" content_under_image_text_align="left" text_color="light" hover_effect="animated_underline_zoom" border_radius="5px" shadow_on_hover="yes" posts_per_page="3" display_type="grid" custom_font_size="2vw" css_class_name="related-projects"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Layered Bold Footer', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-02-July-2024';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/layered-copyright.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="none" equal_height="yes" content_placement="top" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="4%" bottom_padding="40" left_padding_desktop="40" constrain_group_2="yes" right_padding_desktop="40" bottom_padding_tablet="6%" left_padding_tablet="6%" constrain_group_4="yes" right_padding_tablet="6%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="hidden" overlay_strength="0.8" gradient_direction="radial" shape_divider_position="bottom" bg_image_animation="none" shape_type="straight_section" gradient_type="default"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="0px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][split_line_heading animation_type="line-reveal-by-space" font_style="h1" fit_text_to_container="true" line_reveal_by_space_text_effect="letter-reveal-bottom" stagger_animation="true" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="© — `{`nectar_current_year`}`" text_direction="default" animation_offset="96%"][/split_line_heading][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Layered Project Description', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['hero_section'] . ', ' .$cat_display_names['general'];
$data['custom_class'] = 'portfolio general date-01-July-2024';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/layered-project-desc.webp' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="6%" constrain_group_1="yes" bottom_padding="6%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="0px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][vc_column_text css="" text_direction="default"]
<h6>The Challenge</h6>
[/vc_column_text][/vc_column_inner][vc_column_inner right_padding_desktop="15%" right_padding_tablet="0" column_element_direction_desktop="default" column_element_spacing="30px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="2/3" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" gradient_type="default"][nectar_responsive_text inherited_font_style="default" font_size_desktop="1.5em" font_line_height="1.6" text_direction="default" font_size_tablet="1em"]We were commissioned to design a comprehensive website and develop a cohesive brand identity for Spectral, a graphic design agency renowned for its creative and innovative approach to visual communication.

The website needed to reflect Spectral's artistic flair and design expertise, featuring an immersive user experience that showcases their portfolio, highlights their design process, and captures the essence of their brand. The branding elements, including a striking logo and unified visual style, were crafted to position Spectral as a leader in the graphic design industry.[/nectar_responsive_text][nectar_cta btn_style="underline" heading_tag="p" button_color="default" button_border_thickness="0px" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" display="block" display_tablet="inherit" display_phone="inherit" icon_family="none" font_size_desktop="1rem" link_text="View Website" margin_top="50" url="#"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Layered Project Header', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['portfolio'];
$data['custom_class'] = 'portfolio date-01-July-2024';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/layered-project-heading.webp' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#000000" scene_position="center" top_padding="3em" bottom_padding="3em" text_color="light" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="0px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding="6%" constrain_group_1="yes" bottom_padding="6%" right_padding_desktop="20%" right_padding_tablet="0" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][split_line_heading animation_type="line-reveal-by-space" font_style="h1" font_size_max="104px" line_reveal_by_space_text_effect="default" stagger_animation="true" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="Solutions that transform ideas into masterpieces." text_direction="default" font_size="6vw" font_line_height="1.2"][/split_line_heading][/vc_column_inner][/vc_row_inner][vc_row_inner equal_height="yes" content_placement="bottom" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="0px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/4" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default" offset="vc_col-xs-6"][vc_column_text css="" text_direction="default"]
<h6>Year</h6>
[/vc_column_text][nectar_responsive_text inherited_font_style="default" text_direction="default"]2023[/nectar_responsive_text][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="0px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/4" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default" offset="vc_col-xs-6"][vc_column_text css="" text_direction="default"]
<h6>Client</h6>
[/vc_column_text][nectar_responsive_text inherited_font_style="default" text_direction="default"]Spectral[/nectar_responsive_text][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" top_margin_tablet="30" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][nectar_project_categories style="outline" category_display="parent_only" alignment_desktop="right" alignment_tablet="default" alignment_phone="default" font_style="label" alignment="right"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#000000" scene_position="center" text_color="light" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][image_with_animation image_url="https://themenectar.com/img/demo-media/unsplash/large-adventure.jpeg" image_size="large_featured" animation_type="entrance" animation="None" animation_movement_type="transform_y" hover_animation="none" alignment="" border_radius="none" box_shadow="none" image_loading="skip-lazy-load" max_width="none" max_width_mobile="default"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Quantum Portfolio', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['portfolio'];
$data['custom_class'] = 'portfolio date-30-June-2024';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/quantum-portfolio.webp' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" bottom_margin="10" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="slight-fade-in-from-bottom" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default" delay="100"][nectar_post_grid post_type="portfolio" portfolio_category="all" portfolio_starting_category="all" order="DESC" orderby="date" pagination="none" columns="2" columns_tablet="default" columns_phone="default" grid_item_spacing="10px" grid_item_height="30vh" enable_masonry="yes" 2_col_masonry_layout="default_alt" image_size="full" overlaid_aspect_ratio_image_size="yes" overlaid_custom_image_aspect_ratio="1-1" image_loading="lazy-load" animation="none" animation_stagger="90" animation_easing="default" parallax_scrolling="yes" heading_tag="default" font_size_max="54px" display_categories="yes" category_functionality="static" category_position="overlaid" category_style="button" category_button_color="rgba(10,10,10,0.2)" category_display="default" additional_meta_size="default" custom_fields_location="before_post_meta" grid_style="content_overlaid" text_content_layout="corners" color_overlay="#0a0a0a" color_overlay_opacity="0" color_overlay_hover_opacity="0.2" text_color="light" text_color_hover="light" text_opacity="1" text_hover_opacity="1" hover_effect="zoom" border_radius="25px" display_type="grid" custom_font_size="3vw" image_loading_lazy_skip="3" font_size_tablet="5vw" font_size_phone="34px"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );




	$data = array();
$data['name'] = esc_html__( 'Quantum Header', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['hero_section'] . ', ' .$cat_display_names['general'];
$data['custom_class'] = 'hero_section general date-29-June-2024';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/quantum-header.webp' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column bottom_padding_desktop="20" column_element_direction_desktop="default" column_element_spacing="20px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="slight-fade-in-from-bottom" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" gradient_type="default"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding="10" constrain_group_1="yes" bottom_padding="10" top_padding_tablet="20" bottom_padding_tablet="0" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][split_line_heading animation_type="line-reveal-by-space" font_style="h1" fit_text_to_container="true" line_reveal_by_space_text_effect="none" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="Ronan Bradford" text_direction="default"][/split_line_heading][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="center" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="2/3" tablet_width_inherit="small_desktop" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][nectar_responsive_text inherited_font_style="default" text_direction="default" font_line_height="1.5"]Web &amp; Digital Experiences
Design, Development, Brand Identity[/nectar_responsive_text][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="right" tablet_text_alignment="default" phone_text_alignment="center" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="small_desktop" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][nectar_responsive_text inherited_font_style="default" text_direction="default" font_line_height="1.5"]Philadelphia, PA
[nectar_current_year][/nectar_responsive_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



	$data = array();
$data['name'] = esc_html__( 'Quantum CTA', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['cta'];
$data['custom_class'] = 'cta date-29-June-2024';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/quantum-cta.webp' );
$data['content'] = <<<CONTENT
[vc_row type="in_container" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#ede8e4" scene_position="center" bottom_margin="20" text_color="custom" custom_text_color="#000000" text_align="left" row_border_radius="custom" row_border_radius_applies="bg" top_left_border_radius="25" top_right_border_radius="25" bottom_right_border_radius="25" bottom_left_border_radius="25" zindex="1000" overflow="visible" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column top_padding_desktop="30" constrain_group_100="yes" bottom_padding_desktop="30" left_padding_desktop="30" constrain_group_101="yes" right_padding_desktop="30" column_element_direction_desktop="default" column_element_spacing="20px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" gradient_type="default"][divider line_type="No Line" custom_height="4vw"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="horizontal" column_element_direction_tablet="horizontal" column_element_direction_phone="horizontal" column_element_alignment="center" column_element_spacing="10px" desktop_text_alignment="center" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][nectar_icon icon_family="pulsating-circle" icon_style="default" icon_color_type="custom" icon_color_custom="#55c91c" icon_padding="0px" pointer_events="all" icon_size="8"][nectar_responsive_text inherited_font_style="default" text_direction="default"]Available for Work[/nectar_responsive_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="center" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][nectar_cta btn_style="text-reveal" heading_tag="h2" font_size_max="130px" button_color="default" button_border_thickness="0px" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" display="block" display_tablet="inherit" display_phone="inherit" icon_family="none" font_size_desktop="7vw" link_text="Get in Touch" url="mailto:hello@themenectar.com" font_size_phone="10vw"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="horizontal" column_element_direction_tablet="horizontal" column_element_alignment="center" column_element_spacing="10px" desktop_text_alignment="center" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][nectar_cta btn_style="underline" heading_tag="p" button_color="default" button_border_thickness="0px" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" constrain_group_2="yes" display="block" display_tablet="inherit" display_phone="inherit" icon_family="none" link_text="Behance" url="https://behance.com" margin_left="10" margin_right="10"][nectar_cta btn_style="underline" heading_tag="p" button_color="default" button_border_thickness="0px" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" constrain_group_2="yes" display="block" display_tablet="inherit" display_phone="inherit" icon_family="none" link_text="Dribbble" url="https://dribbble.com" margin_left="10" margin_right="10"][nectar_cta btn_style="underline" heading_tag="p" button_color="default" button_border_thickness="0px" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" constrain_group_2="yes" display="block" display_tablet="inherit" display_phone="inherit" icon_family="none" link_text="Instagram" url="https://instagram.com" margin_left="10" margin_right="10"][nectar_cta btn_style="underline" heading_tag="p" button_color="default" button_border_thickness="0px" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" constrain_group_2="yes" display="block" display_tablet="inherit" display_phone="inherit" icon_family="none" link_text="LinkedIn" url="https://linkedin.com" margin_left="10" margin_right="10"][/vc_column_inner][/vc_row_inner][divider line_type="No Line" custom_height="3vw"][vc_row_inner column_margin="10px" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="center" phone_text_alignment="center" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][nectar_responsive_text inherited_font_style="default" text_direction="default" font_line_height="1"]
<h6>© [nectar_current_year]. All rights reserved.</h6>
[/nectar_responsive_text][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="right" tablet_text_alignment="center" phone_text_alignment="center" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][nectar_responsive_text inherited_font_style="default" text_direction="default" font_line_height="1"]
<h6>Made by <a href="#">ThemeNectar</a></h6>
[/nectar_responsive_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Quantum Related Projects', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['portfolio'];
$data['custom_class'] = 'portfolio date-27-June-2024';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/quantum-related-projects.webp' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="10" bottom_padding="10" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="0px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding="5%" constrain_group_1="yes" bottom_padding="5%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][nectar_scrolling_text scroll_direction="ltr" scroll_speed="slow" style="default" outline_applies_to="text_only" text_repeat_number="4" text_repeat_divider="space" text_space_amount="medium" overflow="hidden" background_image_animation="None" custom_font_size="7vw" custom_font_size_mobile="10vw"]
<h2>Explore More</h2>
[/nectar_scrolling_text][/vc_column_inner][/vc_row_inner][nectar_post_grid post_type="portfolio" portfolio_category="all" portfolio_starting_category="all" order="DESC" orderby="rand" pagination="none" exclude_current_post="yes" columns="2" columns_tablet="default" columns_phone="default" grid_item_spacing="10px" grid_item_height="30vh" 2_col_masonry_layout="default" image_size="large" overlaid_aspect_ratio_image_size="yes" overlaid_custom_image_aspect_ratio="1-1" image_loading="default" animation="none" animation_stagger="90" animation_easing="default" parallax_scrolling="yes" heading_tag="default" font_size_max="54px" display_categories="yes" category_functionality="static" category_position="default" category_style="button" category_button_color="rgba(10,10,10,0.2)" category_display="parent_only" additional_meta_size="default" custom_fields_location="before_post_meta" grid_style="content_overlaid" text_content_layout="corners" color_overlay="#000000" color_overlay_opacity="0.1" color_overlay_hover_opacity="0.2" text_color="light" text_color_hover="light" text_opacity="1" text_hover_opacity="1" hover_effect="zoom" border_radius="25px" display_type="grid" posts_per_page="2" custom_font_size="3vw" font_size_tablet="5vw" font_size_phone="34px"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Quantum Project', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['portfolio'];
$data['custom_class'] = 'portfolio date-26-June-2024';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/quantum-project.webp' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="custom" column_margin_custom="4%" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding_phone="10" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="30px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" sticky_content="true" sticky_content_functionality="css" sticky_content_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][nectar_responsive_text inherited_font_style="default" font_size_max="54px" text_direction="default" font_size_desktop="3vw" font_line_height="1.1" font_size_tablet="5vw" font_size_phone="34px"]
<h3>Neon Grove</h3>
[/nectar_responsive_text][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="5px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default" offset="vc_col-xs-6"][nectar_responsive_text inherited_font_style="default" text_direction="default" font_line_height="1.2"]
<h5>What we did</h5>
[/nectar_responsive_text][nectar_project_categories style="default" category_display="default" alignment_desktop="left" alignment_tablet="default" alignment_phone="default" font_style="p"][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="5px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default" offset="vc_col-xs-6"][nectar_responsive_text inherited_font_style="default" text_direction="default" font_line_height="1.2"]
<h5>Industry</h5>
[/nectar_responsive_text][nectar_responsive_text inherited_font_style="default" text_direction="default"]Tech[/nectar_responsive_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="10px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][nectar_responsive_text inherited_font_style="default" text_direction="default" font_line_height="1.2"]
<h5>Description</h5>
[/nectar_responsive_text][nectar_responsive_text inherited_font_style="default" text_direction="default"]I collaborated with Neon Grove, an emerging force in the tech sector, to create a dynamic series of photographs. The work focused on showcasing their innovative products and sleek designs, capturing the essence of their technological vision through sharp, modern imagery.[/nectar_responsive_text][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="20px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="2/3" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][image_with_animation image_url="https://themenectar.com/img/demo-media/unsplash/blue-guy.webp" image_size="full" animation_type="entrance" animation="None" animation_movement_type="transform_y" hover_animation="none" alignment="" border_radius="20px" box_shadow="none" image_loading="skip-lazy-load" max_width="100%" max_width_mobile="default"][image_with_animation image_url="https://themenectar.com/img/demo-media/unsplash/blue-abstract.webp" image_size="portfolio-thumb_large" animation_type="entrance" animation="None" animation_movement_type="transform_y" hover_animation="none" alignment="" border_radius="20px" box_shadow="none" image_loading="default" max_width="none" max_width_mobile="default"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Quantum About', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['about'];
$data['custom_class'] = 'about date-26-June-2024';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/quantum-about-header.webp' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="5%" constrain_group_1="yes" bottom_padding="5%" top_padding_phone="10%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="slight-fade-in-from-bottom" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" centered_text="true" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="scroll_pos_advanced" animation_trigger_offset="0.00,100.00" animation_end_translate_y="90%" animation_end_opacity="0" persist_animation_on_mobile="true" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default" animation_adv_start_end="end"][split_line_heading animation_type="line-reveal-by-space" font_style="h1" font_size_max="200px" line_reveal_by_space_text_effect="none" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="Fullstack Developer" text_direction="default" font_size="11vw" font_line_height="0.9" font_size_tablet="11vw"][/split_line_heading][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding="50" top_padding_tablet="20" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][image_with_animation image_url="https://themenectar.com/salient/portfolio-quantum/wp-content/uploads/sites/43/2024/09/pexels-sherlocked124578-60778-scaled.webp" image_size="full" animation_type="entrance" animation="None" animation_movement_type="transform_y" hover_animation="none" alignment="center" border_radius="20px" box_shadow="none" image_loading="skip-lazy-load" max_width="custom" max_width_custom="40%" max_width_custom_tablet="50%" max_width_custom_phone="60%"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Quantum Text Inline Images', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-26-June-2024';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/quantum-about-text-inline.webp' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="12%" bottom_padding="10%" left_padding_desktop="18%" constrain_group_2="yes" right_padding_desktop="18%" bottom_padding_tablet="15%" left_padding_tablet="18%" constrain_group_4="yes" right_padding_tablet="18%" left_padding_phone="8%" constrain_group_6="yes" right_padding_phone="8%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" centered_text="true" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="slight-fade-in-from-bottom" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="default"][nectar_text_inline_images media_type="images" image_size="large__h_rect" image_effect="none" media_roundness="10px" image_loading="default" line_reveal_by_space_text_effect="" content_alignment="" font_style="h1" font_size="3vw" font_line_height="1.4" font_size_desktop="4vw" font_size_tablet="6vw" max_width="" font_size_phone="7vw" text_direction="default"]
<h3>I’m * passionate about creating seamless digital experiences, and I collaborate with businesses and agencies * worldwide to bring their visions to life through innovative * web solutions.</h3>
[/nectar_text_inline_images][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Quantum Services', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['services'];
$data['custom_class'] = 'services date-25-June-2024';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/quantum-about-services.webp' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="custom" column_margin_custom="7%" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="8%" constrain_group_1="yes" bottom_padding="8%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" sticky_content="true" sticky_content_functionality="css" sticky_content_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][nectar_responsive_text inherited_font_style="default" font_size_max="90px" text_direction="default" font_size_desktop="5vw" font_line_height="1" font_size_tablet="7vw"]
<h3>Services</h3>
[/nectar_responsive_text][nectar_responsive_text inherited_font_style="default" text_direction="default"]I offer a comprehensive range of web services, carefully tailored to meet each client’s unique needs and their project budgets.[/nectar_responsive_text][/vc_column][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="2/3" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="custom" column_margin_custom="7%" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="5px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="slight-fade-in-from-bottom" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][nectar_responsive_text inherited_font_style="default" text_direction="default"]
<h6>01</h6>
[/nectar_responsive_text][nectar_responsive_text inherited_font_style="default" text_direction="default"]
<h4>Responsive Design</h4>
[/nectar_responsive_text][nectar_responsive_text inherited_font_style="default" text_direction="default"]Websites that function flawlessly on all devices, while also being optimized for speed, SEO, and accessibility.[/nectar_responsive_text][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="5px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="slight-fade-in-from-bottom" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default" delay="100"][nectar_responsive_text inherited_font_style="default" text_direction="default"]
<h6>02</h6>
[/nectar_responsive_text][nectar_responsive_text inherited_font_style="default" text_direction="default"]
<h4>eCommerce</h4>
[/nectar_responsive_text][nectar_responsive_text inherited_font_style="default" text_direction="default"]Secure, user-friendly online stores that streamline sales, manage inventory, and enhance the shopping experience.[/nectar_responsive_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="custom" column_margin_custom="7%" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding="50" top_padding_tablet="0" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="5px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="slight-fade-in-from-bottom" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][nectar_responsive_text inherited_font_style="default" text_direction="default"]
<h6>03</h6>
[/nectar_responsive_text][nectar_responsive_text inherited_font_style="default" text_direction="default"]
<h4>Maintenance</h4>
[/nectar_responsive_text][nectar_responsive_text inherited_font_style="default" text_direction="default"]I provide ongoing technical support, updates, and performance optimization to keep your website running smoothly.[/nectar_responsive_text][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="5px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="slight-fade-in-from-bottom" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default" delay="100"][nectar_responsive_text inherited_font_style="default" text_direction="default"]
<h6>04</h6>
[/nectar_responsive_text][nectar_responsive_text inherited_font_style="default" text_direction="default"]
<h4>Development</h4>
[/nectar_responsive_text][nectar_responsive_text inherited_font_style="default" text_direction="default"]Fully customized websites using the latest technologies to match your brand and business goals, ensuring a unique online presence.[/nectar_responsive_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Quantum Awards', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['about'];
$data['custom_class'] = 'general date-24-June-2024';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/quantum-about-awards.webp' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="custom" column_margin_custom="7%" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="8%" constrain_group_1="yes" bottom_padding="8%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="30px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" sticky_content="true" sticky_content_functionality="css" sticky_content_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][nectar_responsive_text inherited_font_style="default" font_size_max="90px" text_direction="default" font_size_desktop="5vw" font_line_height="1" font_size_tablet="7vw"]
<h3>Awards</h3>
[/nectar_responsive_text][nectar_responsive_text inherited_font_style="default" text_direction="default"]I provide ongoing technical support, updates, and performance optimization to keep your website running smoothly.[/nectar_responsive_text][/vc_column][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="2/3" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][nectar_horizontal_list_item columns="4" column_layout_using_4_columns="even" responsive_display="multiple_columns" col_1_text_align="left" col_2_text_align="left" col_3_text_align="left" col_4_text_align="right" col_1_text_element="h3" col_2_text_element="p" col_3_text_element="p" col_4_text_element="p" font_family="p" hover_effect="none" border_animation="true" border_color="#424242" icon_family="none" icon_size="large" col_1_content="Nectar Studio" col_2_content="AWWWARDS" col_3_content="Site Of The Day" col_4_content="2024"][nectar_horizontal_list_item columns="4" column_layout_using_4_columns="even" responsive_display="multiple_columns" col_1_text_align="left" col_2_text_align="left" col_3_text_align="left" col_4_text_align="right" col_1_text_element="h3" col_2_text_element="p" col_3_text_element="p" col_4_text_element="p" font_family="p" hover_effect="none" border_animation="true" border_color="#424242" icon_family="none" icon_size="large" col_1_content="DesignWave" col_2_content="AWWWARDS" col_3_content="Site Of The Day" col_4_content="2023"][nectar_horizontal_list_item columns="4" column_layout_using_4_columns="even" responsive_display="multiple_columns" col_1_text_align="left" col_2_text_align="left" col_3_text_align="left" col_4_text_align="right" col_1_text_element="h3" col_2_text_element="p" col_3_text_element="p" col_4_text_element="p" font_family="p" hover_effect="none" border_animation="true" border_color="#424242" icon_family="none" icon_size="large" col_1_content="Visionary" col_2_content="Web Awards" col_3_content="Best Innovation" col_4_content="2023"][nectar_horizontal_list_item columns="4" column_layout_using_4_columns="even" responsive_display="multiple_columns" col_1_text_align="left" col_2_text_align="left" col_3_text_align="left" col_4_text_align="right" col_1_text_element="h3" col_2_text_element="p" col_3_text_element="p" col_4_text_element="p" font_family="p" hover_effect="none" border_animation="true" border_color="#424242" icon_family="none" icon_size="large" col_1_content="Lunar" col_2_content="MUSE Awards" col_3_content="Platinum Winner" col_4_content="2023"][nectar_horizontal_list_item columns="4" column_layout_using_4_columns="even" responsive_display="multiple_columns" col_1_text_align="left" col_2_text_align="left" col_3_text_align="left" col_4_text_align="right" col_1_text_element="h3" col_2_text_element="p" col_3_text_element="p" col_4_text_element="p" font_family="p" hover_effect="none" border_animation="true" border_color="#424242" icon_family="none" icon_size="large" col_1_content="Pixel Forged" col_2_content="CSS Awards" col_3_content="Top UI Design" col_4_content="2022"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Magazine Hero Section', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['blog'];
$data['custom_class'] = 'blog date-24-June-2023';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/2023-mag-hero.webp' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="custom" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" bottom_padding="4%" top_padding_tablet="15" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_element_direction_desktop="default" column_element_spacing="0px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="advanced"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" bottom_margin="-15px" bottom_margin_tablet="0" column_element_direction_desktop="default" column_element_spacing="0px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in" animation_easing="easeOutSine" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][split_line_heading animation_type="line-reveal-by-space" font_style="h1" fit_text_to_container="true" line_reveal_by_space_text_effect="none" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="SALIENT MAG" font_size="13.6vw" font_line_height="1"][/split_line_heading][/vc_column_inner][/vc_row_inner][nectar_post_grid post_type="post" blog_category="all" order="DESC" orderby="date" pagination="none" columns="4" columns_tablet="default" columns_phone="default" grid_item_spacing="15px" grid_item_height="30vh" enable_masonry="yes" 4_col_masonry_layout="mixed" image_size="large" aspect_ratio_image_size="yes" custom_image_aspect_ratio="4-3" image_loading="skip-lazy-load" animation="zoom-out-reveal" animation_stagger="1" animation_easing="easeInOutCubic" parallax_scrolling="yes" heading_tag="default" font_size_min="16px" font_size_max="24px" display_categories="yes" category_functionality="default" category_position="default" category_style="button" category_display="parent_only" additional_meta_display="large_items_only" display_date="yes" display_author="yes" author_functionality="default" author_position="multiline" additional_meta_size="small" grid_style="content_under_image" content_under_image_text_align="left" text_color="dark" hover_effect="zoom" border_radius="10px" custom_font_size="1.3vw" posts_per_page="5" display_type="grid" font_line_height="1.4"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Modern Blog Carousel', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['blog'];
$data['custom_class'] = 'blog date-23-June-2023';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/2023-mag-carousel.webp' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="4%" bottom_padding="8%" left_padding_phone="0" constrain_group_6="yes" right_padding_phone="0" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="0px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="default"][vc_row_inner equal_height="yes" content_placement="bottom" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding="1%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner right_padding_desktop="30%" right_padding_phone="5%" column_element_direction_desktop="default" column_element_spacing="5px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" gradient_type="default" offset="vc_col-xs-8"][vc_column_text]Featured Headlines[/vc_column_text][nectar_responsive_text font_size_min="20" font_size_max="44px" font_size_desktop="2.2vw" font_line_height="1.3"]
<h4>Check out the latest news from around the world</h4>
[/nectar_responsive_text][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default" offset="vc_col-xs-4"][nectar_cta btn_style="curved-arrow-animation" heading_tag="h6" button_color="default" button_border_thickness="0px" link_type="regular" alignment="right" alignment_tablet="default" alignment_phone="default" display="block" display_tablet="inherit" display_phone="inherit" link_text="View all"][/vc_column_inner][/vc_row_inner][nectar_post_grid post_type="post" blog_category="all" order="DESC" orderby="date" flickity_controls="touch_total" flickity_touch_total_style="tooltip_text" flickity_touch_total_blurred_bg="yes" flickity_touch_total_indicator_bg_color="rgba(255,255,255,0.25)" flickity_touch_total_indicator_icon_color="#000000" flickity_overflow="visible" flickity_wrap_around="no-wrap" columns="3" columns_tablet="default" columns_phone="default" desktop_small_cols_flickity="3" tablet_cols_flickity="2" phone_cols_flickity="1" grid_item_spacing="15px" grid_item_height="50vh" 3_col_masonry_layout="default" image_size="large" image_loading="lazy-load" animation="none" animation_stagger="90" animation_easing="default" heading_tag="default" font_size_min="16px" font_size_max="28px" enable_indicator="yes" mouse_indicator_style="default" mouse_indicator_text="read" mouse_indicator_color="rgba(10,10,10,0.24)" mouse_indicator_text_color="#ffffff" mouse_indicator_blurred_bg="yes" display_categories="yes" category_functionality="default" category_position="default" category_style="button" category_display="parent_only" display_date="yes" display_author="yes" author_functionality="default" author_position="default" additional_meta_size="small" grid_style="content_overlaid" text_content_layout="all_bottom_left_shadow" color_overlay="#0a0a0a" color_overlay_opacity="0" color_overlay_hover_opacity="0" text_color="light" text_color_hover="light" text_opacity="1" text_hover_opacity="1" hover_effect="animated_underline_zoom" border_radius="10px" custom_font_size="1.8vw" posts_per_page="5" display_type="carousel"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Sticky Posts Section', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['blog'];
$data['custom_class'] = 'blog date-22-June-2023';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/2023-mag-hot-posts-simple.webp' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="8%" bottom_padding="8%" left_padding_phone="0" constrain_group_6="yes" right_padding_phone="0" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" top_margin="-7.5%" top_margin_tablet="-10%" column_element_direction_desktop="default" column_element_spacing="0px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="7/12" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="default"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding="15" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][nectar_post_grid post_type="post" blog_category="all" blog_starting_category="all" order="DESC" orderby="date" pagination="none" columns="1" columns_tablet="default" columns_phone="default" grid_item_spacing="15px" grid_item_height="60vh" image_size="full" image_loading="lazy-load" animation="none" animation_stagger="90" animation_easing="default" parallax_scrolling="yes" heading_tag="default" font_size_max="48px" display_categories="yes" category_functionality="default" category_position="default" category_style="button" category_display="parent_only" display_date="yes" display_author="yes" author_functionality="default" author_position="multiline" additional_meta_size="small" custom_fields_location="before_post_meta" grid_style="content_overlaid" text_content_layout="all_bottom_left_shadow" color_overlay_opacity="0.3" color_overlay_hover_opacity="0.4" text_color="light" text_color_hover="light" text_opacity="1" text_hover_opacity="1" hover_effect="zoom" border_radius="10px" content_overlaid_padding_desktop="50px" content_overlaid_padding_tablet="35px" posts_per_page="1" display_type="grid" custom_font_size="2.4vw" font_size_tablet="26px"][/vc_column_inner][/vc_row_inner][nectar_post_grid post_type="post" blog_category="all" blog_starting_category="all" order="DESC" orderby="date" pagination="none" columns="2" columns_tablet="default" columns_phone="default" grid_item_spacing="15px" grid_item_height="60vh" 2_col_masonry_layout="default" image_size="full" aspect_ratio_image_size="yes" custom_image_aspect_ratio="4-3" image_loading="lazy-load" animation="none" animation_stagger="90" animation_easing="default" parallax_scrolling="yes" heading_tag="default" font_size_min="16px" font_size_max="24px" display_categories="yes" category_functionality="default" category_position="default" category_style="button" category_display="parent_only" display_date="yes" display_author="yes" author_functionality="default" author_position="default" additional_meta_size="small" custom_fields_location="before_post_meta" grid_style="content_under_image" card_design="yes" card_bg_color="#ffffff" content_under_image_text_align="left" text_color="dark" hover_effect="zoom" border_radius="10px" custom_font_size="1.4vw" posts_per_page="2" display_type="grid" post_offset="1"][/vc_column][vc_column top_padding_desktop="6%" bottom_padding_desktop="2%" left_padding_desktop="14%" right_padding_desktop="5%" left_padding_tablet="0" right_padding_tablet="0" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" sticky_content="true" sticky_content_functionality="css" sticky_content_alignment="middle" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="5/12" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" gradient_type="default"][nectar_post_grid post_type="post" blog_category="all" blog_starting_category="all" order="DESC" orderby="date" pagination="none" ignore_sticky_posts="yes" columns="1" columns_tablet="default" columns_phone="default" grid_item_spacing="10px" image_size="portfolio-thumb_large" aspect_ratio_image_size="yes" custom_image_aspect_ratio="3-2" content_next_to_image_image_width="33.3%" content_next_to_image_image_gap="10%" content_next_to_image_image_position="right" image_loading="lazy-load" animation="none" animation_stagger="90" animation_easing="default" heading_tag="h3" font_size_min="16px" font_size_max="24px" display_categories="yes" category_functionality="static" category_position="default" category_style="underline" category_display="parent_only" display_date="yes" additional_meta_size="small" custom_fields_location="before_post_meta" grid_style="content_next_to_image" text_color="dark" content_next_to_image_vertical_align="middle" hover_effect="animated_underline" border_radius="10px" content_next_to_image_divider="yes" content_next_to_image_divider_color="#e5e5e5" posts_per_page="4" display_type="grid" custom_font_size="1.4vw" font_line_height="1.3" post_offset="3"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Friendly Sign Up Form', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['blog'];
$data['custom_class'] = 'blog date-22-June-2023';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/2023-mag-form.webp' );
$data['content'] = <<<CONTENT
[vc_row type="in_container" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" bottom_margin="4%" text_color="dark" text_align="left" row_border_radius="15px" row_border_radius_applies="bg" overflow="visible" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type="" gradient_type="default"][vc_column top_padding_desktop="6%" constrain_group_100="yes" bottom_padding_desktop="6%" left_padding_desktop="6%" constrain_group_101="yes" right_padding_desktop="6%" column_element_direction_desktop="default" column_element_spacing="default" centered_text="true" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="15px" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" gradient_type="default"][nectar_lottie trigger_type="play" mobile_func="default" loop="true" trigger_offset="0.00,100.00" frame_constraint="0.00,100.00" width_desktop="50" alignment="center" preserve_aspect_ratio="xMidYMid meet" json_url="https://assets1.lottiefiles.com/packages/lf20_UyIC2q.json"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding="20" left_padding_desktop="30%" constrain_group_2="yes" right_padding_desktop="30%" left_padding_phone="13%" constrain_group_6="yes" right_padding_phone="13%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][nectar_responsive_text font_size_min="20px" font_size_max="60px" font_size_desktop="3vw" font_line_height="1.3"]
<h3>Stay up to date and never miss out.</h3>
[/nectar_responsive_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" left_padding_desktop="25%" constrain_group_2="yes" right_padding_desktop="25%" left_padding_tablet="0" constrain_group_4="yes" right_padding_tablet="0" left_padding_phone="0" constrain_group_6="yes" right_padding_phone="0" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][vc_column_text]Add your form shortcode here[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="10px" centered_text="true" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][nectar_circle_images images="https://themenectar.com/img/demo-media/unsplash/webp/ff1dfc85f81f.webp,https://themenectar.com/img/demo-media/unsplash/webp/fc2fcf082f87.webp,https://themenectar.com/img/demo-media/unsplash/webp/c5799533a786.webp" sizing="50px" positioning="overlapping" stacking_order="ltr" border_color="#f7f7f7" alignment_desktop="middle" alignment_tablet="inherit" alignment_phone="inherit" animation="none" image_size="nectar_small_square" image_loading="lazy-load" numerical_circle="true" alignment="left" text_content="Join the community" numerical_circle_number="+1k"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Single Featured Blog Post', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['blog'];
$data['custom_class'] = 'blog date-22-June-2023';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/2023-mag-recent-post.webp' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type="" gradient_type="default"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][recent_posts style="single_large_featured" large_featured_padding="18%" button_color="Extra-Color-3" button_arrow_style="curved" load_in_animation="zoom_out_reveal" single_large_featured_content_side_spacing="default" single_large_featured_content_alignment="bottom" large_featured_content_max_width="default" font_size_max="48px" bg_overlay="diagonal_gradient" large_featured_heading_tag="h3" category="all" order="DESC" orderby="date" image_loading="lazy-load" single_large_featured_content_side-spacing="" large_featured_font_size="8vw" font_size_phone="26px" font_size_desktop="3vw" font_line_height="1.2" post_offset=""][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Mixed Style Recent Posts', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['blog'];
$data['custom_class'] = 'blog date-21-June-2023';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/2023-mag-triple.webp' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="custom" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="5%" bottom_padding="10%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="0px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="default"][vc_row_inner equal_height="yes" content_placement="bottom" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding="1%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner right_padding_desktop="24%" right_padding_phone="5%" column_element_direction_desktop="default" column_element_spacing="5px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" gradient_type="default" offset="vc_col-xs-8"][vc_column_text]Featured Headlines[/vc_column_text][nectar_responsive_text font_size_min="20" font_size_max="44px" font_size_desktop="2.2vw" font_line_height="1.3"]
<h4>Technology</h4>
[/nectar_responsive_text][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default" offset="vc_col-xs-4"][nectar_cta btn_style="curved-arrow-animation" heading_tag="h6" button_color="default" button_border_thickness="0px" link_type="regular" alignment="right" alignment_tablet="default" alignment_phone="default" display="block" display_tablet="inherit" display_phone="inherit" link_text="View all"][/vc_column_inner][/vc_row_inner][nectar_post_grid post_type="post" blog_category="all" order="DESC" orderby="date" pagination="none" columns="4" columns_tablet="default" columns_phone="default" grid_item_spacing="15px" grid_item_height="50vh" enable_masonry="yes" 4_col_masonry_layout="vert_staggered_middle" image_size="full" image_loading="lazy-load" animation="zoom-out-reveal" animation_stagger="1" animation_easing="easeInOutCubic" heading_tag="default" font_size_min="16px" font_size_max="24px" additional_meta_display="large_items_only" display_date="yes" display_author="yes" author_functionality="default" author_position="multiline" additional_meta_size="small" grid_style="content_under_image" content_under_image_text_align="left" text_color="dark" hover_effect="zoom" border_radius="10px" shadow_on_hover="yes" custom_font_size="1.4vw" posts_per_page="3" display_type="grid"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Dark Featured Posts', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['blog'];
$data['custom_class'] = 'blog date-20-June-2023';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/2023-mag-dark.webp' );
$data['content'] = <<<CONTENT
[vc_row type="in_container" full_screen_row_position="middle" column_margin="custom" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#0f0f0f" scene_position="center" top_padding="6%" constrain_group_1="yes" bottom_padding="6%" left_padding_desktop="6%" constrain_group_2="yes" right_padding_desktop="6%" text_color="light" text_align="left" row_border_radius="15px" row_border_radius_applies="bg" overflow="visible" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column left_padding_desktop="13%" constrain_group_101="yes" right_padding_desktop="13%" bottom_margin="5%" column_element_direction_desktop="default" column_element_spacing="10px" centered_text="true" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" gradient_type="default"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" zindex="1" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default" animation_offset="75%"][vc_column_text]Business Mastery[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][split_line_heading animation_type="line-reveal-by-space" font_style="h2" font_size_max="130px" line_reveal_by_space_text_effect="letter-reveal-bottom" stagger_animation="true" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="THE STRATEGIC ADVANTAGE" font_size="8vw" font_line_height="1"][/split_line_heading][/vc_column_inner][/vc_row_inner][/vc_column][vc_column right_padding_tablet="15" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" zindex="10" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" gradient_type="default" offset="vc_col-xs-8"][nectar_post_grid post_type="post" blog_category="all" order="DESC" orderby="date" pagination="none" columns="2" columns_tablet="1" columns_phone="1" grid_item_spacing="35px" grid_item_height="30vh" image_size="full" aspect_ratio_image_size="yes" custom_image_aspect_ratio="3-2" image_loading="default" animation="none" animation_stagger="90" animation_easing="default" parallax_scrolling="yes" heading_tag="default" font_size_max="48px" display_categories="yes" category_functionality="default" category_position="overlaid" category_style="button" category_display="parent_only" display_excerpt="yes" excerpt_display="default" additional_meta_size="default" grid_style="content_under_image" content_under_image_text_align="left" text_color="light" hover_effect="zoom" border_radius="10px" posts_per_page="2" display_type="grid" custom_font_size="2.4vw" font_line_height="1.2"][/vc_column][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default" offset="vc_col-xs-4"][vc_row_inner column_margin="custom" column_margin_custom="70" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="3/4" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][nectar_post_grid post_type="post" blog_category="all" order="DESC" orderby="date" pagination="none" columns="3" columns_tablet="1" columns_phone="1" grid_item_spacing="35px" grid_item_height="30vh" 3_col_masonry_layout="default" image_size="large" aspect_ratio_image_size="yes" custom_image_aspect_ratio="1-1" image_loading="default" animation="none" animation_stagger="90" animation_easing="default" heading_tag="default" font_size_min="14px" font_size_max="24px" additional_meta_size="default" grid_style="content_under_image" content_under_image_text_align="left" text_color="light" hover_effect="zoom" border_radius="10px" read_more_button="yes" posts_per_page="3" display_type="grid" custom_font_size="1.3vw" font_size_tablet="1.3vw" font_size_phone="14px" post_offset="3"][/vc_column_inner][vc_column_inner bottom_padding_desktop="100%" top_margin="35" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="10px" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/4" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" gradient_type="default" offset="vc_hidden-sm vc_hidden-xs"][nectar_cta btn_style="curved-arrow-animation" heading_tag="p" border_radius="200" button_color="default" text_color="#ffffff" button_border_color="#c1c1c1" button_border_color_hover="#ffffff" button_border_thickness="1px" link_type="regular" alignment="right" alignment_tablet="default" alignment_phone="default" display="block" display_tablet="inherit" display_phone="inherit" position_desktop="absolute" top_position_desktop="0" bottom_position_desktop="0" left_position_desktop="0" right_position_desktop="0" link_text="View all" font_size_desktop="1.2vw"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Dark Recent Posts', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['blog'];
$data['custom_class'] = 'blog date-20-June-2023';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/2023-mag-dark-small.webp' );
$data['content'] = <<<CONTENT
[vc_row type="in_container" full_screen_row_position="middle" column_margin="custom" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#0f0f0f" scene_position="center" top_padding="3%" constrain_group_1="yes" bottom_padding="3%" left_padding_desktop="6%" constrain_group_2="yes" right_padding_desktop="6%" text_color="light" text_align="left" row_border_radius="15px" row_border_radius_applies="bg" overflow="visible" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_element_direction_desktop="default" column_element_spacing="10px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" gradient_type="default"][vc_row_inner column_margin="custom" column_margin_custom="70" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="3/4" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][nectar_post_grid post_type="post" blog_category="all" order="DESC" orderby="date" pagination="none" columns="3" columns_tablet="1" columns_phone="1" grid_item_spacing="35px" grid_item_height="30vh" 3_col_masonry_layout="default" image_size="large" aspect_ratio_image_size="yes" custom_image_aspect_ratio="1-1" image_loading="default" animation="none" animation_stagger="90" animation_easing="default" heading_tag="default" font_size_min="14px" font_size_max="24px" additional_meta_size="default" grid_style="content_under_image" content_under_image_text_align="left" text_color="light" hover_effect="zoom" border_radius="10px" read_more_button="yes" posts_per_page="3" display_type="grid" custom_font_size="1.3vw" font_size_tablet="1.3vw" font_size_phone="14px" post_offset="3"][/vc_column_inner][vc_column_inner bottom_padding_desktop="100%" top_margin="35" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="10px" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/4" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" gradient_type="default" offset="vc_hidden-sm vc_hidden-xs"][nectar_cta btn_style="curved-arrow-animation" heading_tag="p" border_radius="200" button_color="default" text_color="#ffffff" button_border_color="#c1c1c1" button_border_color_hover="#ffffff" button_border_thickness="1px" link_type="regular" alignment="right" alignment_tablet="default" alignment_phone="default" display="block" display_tablet="inherit" display_phone="inherit" position_desktop="absolute" top_position_desktop="0" bottom_position_desktop="0" left_position_desktop="0" right_position_desktop="0" link_text="View all" font_size_desktop="1.2vw"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Sticky Posts Section With Creative Header', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['blog'];
$data['custom_class'] = 'blog date-19-June-2023';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/2023-mag-hot.webp' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="5%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" zindex="100" overflow="hidden" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" enable_shape_divider="true" shape_divider_color="#000000" shape_divider_position="bottom" shape_divider_height="1px" bg_image_animation="none" gradient_type="default" shape_type="straight_section"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="0px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="default"][nectar_scrolling_text scroll_direction="ltr" scroll_speed="slow" text_color="#0a0a0a" move_on_scroll_animation="yes" style="text_outline" outline_thickness="ultra-thin" outline_applies_to="text_only" text_repeat_number="3" text_repeat_divider="custom" text_repeat_divider_scale="half" text_repeat_divider_custom_color="#000000" text_repeat_divider_custom_spin_animation="yes" overflow="visible" background_image_animation="None" custom_font_size="10vw" custom_font_size_mobile="13vw" text_repeat_divider_custom="✱"]
<h2>HOT POSTS</h2>
[/nectar_scrolling_text][/vc_column][/vc_row][vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" zindex="auto" overflow="hidden" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" enable_shape_divider="true" shape_divider_color="#000000" shape_divider_position="bottom" shape_divider_height="1px" bg_image_animation="none" gradient_type="default" shape_type="straight_section"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="0px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="default"][nectar_scrolling_text scroll_direction="rtl" scroll_speed="slow" text_color="#0a0a0a" move_on_scroll_animation="yes" style="text_outline" outline_thickness="ultra-thin" outline_applies_to="text_only" text_repeat_number="3" text_repeat_divider="custom" text_repeat_divider_scale="half" text_repeat_divider_custom_spin_animation="yes" overflow="visible" background_image_animation="None" custom_font_size="10vw" custom_font_size_mobile="13vw" text_repeat_divider_custom="✱"]
<h2>HOT POSTS</h2>
[/nectar_scrolling_text][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="absolute" row_position_tablet="inherit" row_position_phone="inherit" top_position_desktop="0" left_position_desktop="0" max_width_desktop="100%" zindex="500" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][nectar_scrolling_text scroll_direction="rtl" scroll_speed="slow" text_color="#0a0a0a" move_on_scroll_animation="yes" style="text_outline" outline_thickness="ultra-thin" outline_applies_to="both" text_repeat_number="3" text_repeat_divider="custom" text_repeat_divider_scale="half" text_repeat_divider_custom_spin_animation="yes" overflow="visible" background_image_animation="None" custom_font_size="10vw" custom_font_size_mobile="13vw" text_repeat_divider_custom="✱"]
<h2><em>HOT POSTS</em></h2>
[/nectar_scrolling_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row type="full_width_background" full_screen_row_position="middle" column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="2%" bottom_padding="8%" left_padding_phone="0" constrain_group_6="yes" right_padding_phone="0" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" top_margin="-7.5%" top_margin_tablet="-10%" column_element_direction_desktop="default" column_element_spacing="0px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="7/12" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="default"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding="15" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][nectar_post_grid post_type="post" blog_category="all" blog_starting_category="all" order="DESC" orderby="date" pagination="none" columns="1" columns_tablet="default" columns_phone="default" grid_item_spacing="15px" grid_item_height="60vh" image_size="full" image_loading="lazy-load" animation="none" animation_stagger="90" animation_easing="default" parallax_scrolling="yes" heading_tag="default" font_size_max="48px" display_categories="yes" category_functionality="default" category_position="default" category_style="button" category_display="parent_only" display_date="yes" display_author="yes" author_functionality="default" author_position="multiline" additional_meta_size="small" custom_fields_location="before_post_meta" grid_style="content_overlaid" text_content_layout="all_bottom_left_shadow" color_overlay_opacity="0.3" color_overlay_hover_opacity="0.4" text_color="light" text_color_hover="light" text_opacity="1" text_hover_opacity="1" hover_effect="zoom" border_radius="10px" content_overlaid_padding_desktop="50px" content_overlaid_padding_tablet="35px" posts_per_page="1" display_type="grid" custom_font_size="2.4vw" font_size_tablet="26px"][/vc_column_inner][/vc_row_inner][nectar_post_grid post_type="post" blog_category="all" blog_starting_category="all" order="DESC" orderby="date" pagination="none" columns="2" columns_tablet="default" columns_phone="default" grid_item_spacing="15px" grid_item_height="60vh" 2_col_masonry_layout="default" image_size="full" aspect_ratio_image_size="yes" custom_image_aspect_ratio="4-3" image_loading="lazy-load" animation="none" animation_stagger="90" animation_easing="default" parallax_scrolling="yes" heading_tag="default" font_size_min="16px" font_size_max="24px" display_categories="yes" category_functionality="default" category_position="default" category_style="button" category_display="parent_only" display_date="yes" display_author="yes" author_functionality="default" author_position="default" additional_meta_size="small" custom_fields_location="before_post_meta" grid_style="content_under_image" card_design="yes" card_bg_color="#ffffff" content_under_image_text_align="left" text_color="dark" hover_effect="zoom" border_radius="10px" custom_font_size="1.4vw" posts_per_page="2" display_type="grid" post_offset="1"][/vc_column][vc_column top_padding_desktop="6%" bottom_padding_desktop="2%" left_padding_desktop="14%" right_padding_desktop="5%" left_padding_tablet="0" right_padding_tablet="0" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" sticky_content="true" sticky_content_functionality="css" sticky_content_alignment="middle" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="5/12" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" gradient_type="default"][nectar_post_grid post_type="post" blog_category="all" blog_starting_category="all" order="DESC" orderby="date" pagination="none" ignore_sticky_posts="yes" columns="1" columns_tablet="default" columns_phone="default" grid_item_spacing="10px" image_size="portfolio-thumb_large" aspect_ratio_image_size="yes" custom_image_aspect_ratio="3-2" content_next_to_image_image_width="33.3%" content_next_to_image_image_gap="10%" content_next_to_image_image_position="right" image_loading="lazy-load" animation="none" animation_stagger="90" animation_easing="default" heading_tag="h3" font_size_min="16px" font_size_max="24px" display_categories="yes" category_functionality="static" category_position="default" category_style="underline" category_display="parent_only" display_date="yes" additional_meta_size="small" custom_fields_location="before_post_meta" grid_style="content_next_to_image" text_color="dark" content_next_to_image_vertical_align="middle" hover_effect="animated_underline" border_radius="10px" content_next_to_image_divider="yes" content_next_to_image_divider_color="#e5e5e5" posts_per_page="4" display_type="grid" custom_font_size="1.4vw" font_line_height="1.3" post_offset="3"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Scroll Opacity Reveal Text', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['blog'];
$data['custom_class'] = 'blog date-9-June-2023';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/2023-mag-text-fade.webp' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="custom" column_margin_custom="5%" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="8%" constrain_group_1="yes" bottom_padding="8%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type="" gradient_type="default"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" sticky_content="true" sticky_content_functionality="css" sticky_content_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://themenectar.com/img/demo-media/unsplash/webp/photo-1525440584458-b53d13a848de.webp" background_image_position="center center" background_image_stacking="default" background_image_loading="default" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" mask_enable="true" mask_shape="circle-rect" mask_size="contain" mask_alignment_desktop="left-top" column_padding_type="default" gradient_type="default" offset="vc_col-xs-3 vc_hidden-xs"][divider line_type="No Line" custom_height="45vh" custom_height_tablet="35vw" custom_height_phone="25vw"][/vc_column][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="10px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="2/3" tablet_width_inherit="small_desktop" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][vc_column_text]Only the educated are free[/vc_column_text][split_line_heading animation_type="line-reveal-by-space" font_style="h3" font_size_max="90px" line_reveal_by_space_text_effect="scroll-opacity-reveal" stagger_animation="true" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="Reading is a passport to countless adventures and a key to unlocking the vast treasury of human wisdom." font_size="4.5vw" font_size_phone="3em" font_line_height="1.3" font_size_tablet="7vw"][/split_line_heading][divider line_type="No Line" custom_height="3vw"][split_line_heading animation_type="line-reveal-by-space" font_style="h3" font_size_max="90px" line_reveal_by_space_text_effect="scroll-opacity-reveal" stagger_animation="true" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="And the beautiful thing about learning is nobody can take it away from you." font_size="4.5vw" font_size_phone="3em" font_line_height="1.3" font_size_tablet="7vw"][/split_line_heading][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding="10%" top_padding_tablet="5%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][/vc_column_inner][vc_column_inner left_padding_desktop="10%" left_padding_tablet="0" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" gradient_type="default"][nectar_responsive_text]From expert tips to step-by-step guides, our magazine serves as a trusted companion on your journey toward personal and professional growth.[/nectar_responsive_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Magazine Carousel Natural Aspect Ratio', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['blog'];
$data['custom_class'] = 'blog date-18-June-2023';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/2023-mag-carousel-2.webp' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="4%" constrain_group_1="yes" bottom_padding="4%" left_padding_phone="0" constrain_group_6="yes" right_padding_phone="0" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="0px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="default"][vc_row_inner equal_height="yes" content_placement="bottom" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding="1%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner right_padding_desktop="24%" right_padding_phone="5%" column_element_direction_desktop="default" column_element_spacing="5px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" gradient_type="default" offset="vc_col-xs-8"][vc_column_text]Updated Daily[/vc_column_text][nectar_responsive_text font_size_min="20" font_size_max="44px" font_size_desktop="2.6vw" font_line_height="1.3"]
<h4>All Categories</h4>
[/nectar_responsive_text][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" enable_border_animation="true" column_padding_type="default" gradient_type="default" offset="vc_col-xs-4"][nectar_cta btn_style="curved-arrow-animation" heading_tag="h6" button_color="default" button_border_thickness="0px" link_type="regular" alignment="right" alignment_tablet="default" alignment_phone="default" display="block" display_tablet="inherit" display_phone="inherit" link_text="View all"][/vc_column_inner][/vc_row_inner][nectar_post_grid post_type="post" blog_category="all" order="DESC" orderby="date" flickity_controls="touch_total" flickity_touch_total_style="tooltip_text" flickity_touch_total_blurred_bg="yes" flickity_touch_total_indicator_bg_color="rgba(255,255,255,0.46)" flickity_touch_total_indicator_icon_color="#000000" flickity_overflow="visible" flickity_wrap_around="no-wrap" columns="3" columns_tablet="default" columns_phone="default" desktop_small_cols_flickity="3" tablet_cols_flickity="2" phone_cols_flickity="1" grid_item_spacing="15px" grid_item_height="50vh" 3_col_masonry_layout="default" image_size="large" aspect_ratio_image_size="yes" custom_image_aspect_ratio="default" image_loading="lazy-load" animation="none" animation_stagger="90" animation_easing="default" heading_tag="default" font_size_max="24px" enable_indicator="yes" mouse_indicator_style="default" mouse_indicator_text="read" mouse_indicator_color="rgba(10,10,10,0.24)" mouse_indicator_text_color="#ffffff" mouse_indicator_blurred_bg="yes" display_categories="yes" category_functionality="default" category_position="overlaid" category_style="button" category_display="parent_only" display_excerpt="yes" excerpt_display="default" additional_meta_size="small" grid_style="content_under_image" content_under_image_text_align="left" text_color="dark" hover_effect="animated_underline_zoom" border_radius="10px" read_more_button="yes" custom_font_size="1.8vw" posts_per_page="5" display_type="carousel"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );





$data = array();
$data['name'] = esc_html__( 'Huge Impact Text Animation Hero', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['hero_section'];
$data['custom_class'] = 'hero_section date-8-June-2023';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/yellow-grad-hero.webp' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" full_height="yes" animated_gradient_bg="true" animated_gradient_bg_color_1="#ffc90a" animated_gradient_bg_speed="850" animated_gradient_bg_blending_mode="linear" scene_position="center" left_padding_desktop="19%" constrain_group_2="yes" right_padding_desktop="19%" left_padding_phone="10%" constrain_group_6="yes" right_padding_phone="10%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient="linear-gradient(0deg, rgb(255,255,255) 1%, rgba(243,243,243,0) 32%)" shape_divider_position="bottom" bg_image_animation="none" gradient_type="advanced" shape_type="" advanced_gradient_display_type="linear"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="0px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="horizontal" column_element_direction_tablet="horizontal" column_element_direction_phone="horizontal" column_element_alignment="center" column_element_spacing="20px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][split_line_heading animation_type="line-reveal-by-space" font_style="h1" line_reveal_by_space_text_effect="twist-bottom-2" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="Transform" font_size="7vw" font_line_height="1.1" font_size_tablet="8vw" font_size_phone="8vw"][/split_line_heading][split_line_heading animation_type="line-reveal-by-space" font_style="i" line_reveal_by_space_text_effect="twist-bottom-2" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" font_size="7vw" font_line_height="1.1" animation_delay="100" text_content="ideas" font_size_tablet="8vw" font_size_phone="8vw"][/split_line_heading][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="right" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all" class="middle-heading"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="horizontal" column_element_direction_tablet="horizontal" column_element_direction_phone="horizontal" column_element_alignment="center" column_element_spacing="20px" desktop_text_alignment="right" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][split_line_heading animation_type="line-reveal-by-space" font_style="i" line_reveal_by_space_text_effect="twist-bottom-2" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="into" font_size="7vw" font_line_height="1.1" animation_offset="100%" animation_delay="200" font_size_tablet="8vw" font_size_phone="8vw"][/split_line_heading][split_line_heading animation_type="line-reveal-by-space" font_style="i" line_reveal_by_space_text_effect="twist-bottom-2" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="beautiful," font_size="7vw" font_line_height="1.1" animation_offset="100%" animation_delay="300" font_size_tablet="8vw" font_size_phone="8vw"][/split_line_heading][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" left_padding_desktop="5vw" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="horizontal" column_element_direction_tablet="horizontal" column_element_direction_phone="horizontal" column_element_alignment="center" column_element_spacing="20px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][split_line_heading animation_type="line-reveal-by-space" font_style="i" line_reveal_by_space_text_effect="twist-bottom-2" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="fast" font_size="7vw" font_line_height="1.1" animation_offset="100%" animation_delay="400" font_size_tablet="8vw" font_size_phone="8vw"][/split_line_heading][split_line_heading animation_type="line-reveal-by-space" font_style="h1" line_reveal_by_space_text_effect="twist-bottom-2" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="websites" font_size="7vw" font_line_height="1.1" animation_offset="100%" animation_delay="500" font_size_tablet="8vw" font_size_phone="8vw"][/split_line_heading][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );





$data = array();
$data['name'] = esc_html__( 'Dark Radial Gradient 404', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-8-June-2023';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/2023-dark-404.webp' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#000000" full_height="yes" video_bg="use_video" video_mp4="https://themenectar.com/salient/mag/wp-content/uploads/sites/41/2023/07/pexels-michael-james-16296844-2160p-1-1.mp4" background_video_loading="default" scene_position="center" text_color="light" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient="radial-gradient(circle at center, rgba(0,0,0,0) 19%, rgb(0,0,0) 77%)" shape_divider_position="bottom" bg_image_animation="none" gradient_type="advanced" shape_type="" advanced_gradient_display_type="radial"][vc_column top_padding_desktop="8%" column_element_direction_desktop="default" column_element_spacing="0px" centered_text="true" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" gradient_type="default"][nectar_responsive_text font_size_desktop="20vw" font_line_height="1" font_size_tablet="23vw"]
<h1>404</h1>
[/nectar_responsive_text][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" zindex="100" overflow="visible" pointer_events="all"][vc_column_inner top_padding_desktop="3%" left_padding_desktop="32%" constrain_group_101="yes" right_padding_desktop="32%" left_padding_tablet="30%" constrain_group_103="yes" right_padding_tablet="30%" left_padding_phone="20%" constrain_group_105="yes" right_padding_phone="20%" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="15px" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" gradient_type="default"][nectar_responsive_text font_size_desktop="3vw" font_line_height="1.3" font_size_tablet="4vw" font_size_phone="5vw"]
<h2>Oh, no! This page doesn't exist.</h2>
[/nectar_responsive_text][nectar_cta btn_style="curved-arrow-animation" heading_tag="h6" button_color="default" text_color="#ffffff" button_border_color="#919191" button_border_color_hover="#ffffff" button_border_thickness="1px" link_type="regular" alignment="center" alignment_tablet="default" alignment_phone="default" constrain_group_3="yes" constrain_group_4="yes" display="block" display_tablet="inherit" display_phone="inherit" font_size_desktop="1.1vw" link_text="Back to Home" url="https://themenectar.com/salient/mag" margin_top="60" padding_top="1em" padding_bottom="1em" padding_left="2em" padding_right="2em" font_size_tablet="16px"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Video Mask 404', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-8-June-2023';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/2023-404-light.webp' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#ffffff" full_height="yes" scene_position="center" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column top_padding_desktop="8%" column_element_direction_desktop="default" column_element_spacing="0px" centered_text="true" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" gradient_type="default"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="relative" row_position_tablet="inherit" row_position_phone="inherit" zindex="1" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/4" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" video_bg="use_video" video_mp4="https://themenectar.com/demo-media/dark-ink.mp4" background_video_loading="default" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" mask_enable="true" mask_shape="custom" mask_custom_image="LOCAL_SVG_ASSET__404" mask_size="contain" column_padding_type="default" gradient_type="default"][divider line_type="No Line" custom_height="25vh" custom_height_tablet="25vw"][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/4" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="relative" row_position_tablet="inherit" row_position_phone="inherit" zindex="1000" overflow="visible" pointer_events="all"][vc_column_inner top_padding_desktop="8%" bottom_padding_desktop="6%" left_padding_desktop="32%" constrain_group_101="yes" right_padding_desktop="32%" left_padding_tablet="30%" constrain_group_103="yes" right_padding_tablet="30%" left_padding_phone="20%" constrain_group_105="yes" right_padding_phone="20%" top_margin="-5%" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color="#ffffff" background_color_opacity="0.2" background_hover_color_opacity="1" column_backdrop_filter="blur" column_backdrop_filter_blur="15" column_shadow="none" column_border_radius="15px" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" gradient_type="default"][nectar_responsive_text font_size_desktop="4vw" font_line_height="1.3" font_size_tablet="5vw" font_size_phone="6vw"]
<h2>Well, it seems like you're lost.</h2>
[/nectar_responsive_text][nectar_cta btn_style="curved-arrow-animation" heading_tag="h6" button_color="default" text_color="#000000" button_border_color="#3452ff" button_border_thickness="1px" link_type="regular" alignment="center" alignment_tablet="default" alignment_phone="default" constrain_group_3="yes" constrain_group_4="yes" display="block" display_tablet="inherit" display_phone="inherit" font_size_desktop="1.1vw" link_text="Back to Home" url="https://themenectar.com/salient/mag" margin_top="60" padding_top="1em" padding_bottom="1em" padding_left="2em" padding_right="2em" font_size_tablet="16px"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Dark Footer with Fit Text', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-8-June-2023';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/2023-mag-footer.webp' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="none" equal_height="yes" content_placement="top" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#111111" scene_position="center" top_padding="8%" bottom_padding="0" text_color="light" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" overlay_strength="0.8" gradient_direction="radial" shape_divider_position="bottom" bg_image_animation="none" shape_type="straight_section" gradient_type="default"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="0px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" left_padding_desktop="15%" constrain_group_2="yes" right_padding_desktop="15%" left_padding_phone="20%" constrain_group_6="yes" right_padding_phone="20%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" centered_text="true" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="small_desktop" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][nectar_responsive_text font_size_min="20px" text_color="#ffffff" font_size_desktop="1.8vw" font_line_height="1.2" font_size_tablet="20px" font_size_phone="20px"]
<h3>Subscribe and never miss out</h3>
[/nectar_responsive_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding="2%" constrain_group_1="yes" bottom_padding="2%" left_padding_desktop="30%" constrain_group_2="yes" right_padding_desktop="30%" left_padding_tablet="10%" constrain_group_4="yes" right_padding_tablet="10%" left_padding_phone="0" constrain_group_6="yes" right_padding_phone="0" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][vc_column_text]
<p style="text-align: center;">Add your form shortcode here</p>
[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding="20" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="0px" centered_text="true" desktop_text_alignment="default" tablet_text_alignment="center" phone_text_alignment="center" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][nectar_cta btn_style="underline" heading_tag="h6" button_color="default" text_color="#ffffff" button_border_thickness="0px" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" constrain_group_3="yes" constrain_group_4="yes" display="inline" display_tablet="inline-block" display_phone="inline-block" icon_family="none" link_text="Home" padding_top="1em" padding_bottom="1em" padding_left="1em" padding_right="1em"][nectar_cta btn_style="underline" heading_tag="h6" button_color="default" text_color="#ffffff" button_border_thickness="0px" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" constrain_group_3="yes" constrain_group_4="yes" display="inline" display_tablet="inline-block" display_phone="inline-block" icon_family="none" link_text="About" padding_top="1em" padding_bottom="1em" padding_left="1em" padding_right="1em"][nectar_cta btn_style="underline" heading_tag="h6" button_color="default" text_color="#ffffff" button_border_thickness="0px" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" constrain_group_3="yes" constrain_group_4="yes" display="inline" display_tablet="inline-block" display_phone="inline-block" icon_family="none" link_text="More Demos" padding_top="1em" padding_bottom="1em" padding_left="1em" padding_right="1em"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding="30" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][split_line_heading animation_type="line-reveal-by-space" font_style="h1" fit_text_to_container="true" line_reveal_by_space_text_effect="none" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="SALIENT MAG" font_line_height="1"][/split_line_heading][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'SVG Mask Quote Section', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'] . ' ' . $cat_display_names['testimonials'];
$data['custom_class'] = 'general testimonials date-7-June-2023';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/2023-quote.webp' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="3%" constrain_group_1="yes" bottom_padding="3%" bottom_padding_phone="15%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="0px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][vc_row_inner equal_height="yes" content_placement="middle" column_margin="custom" column_margin_custom="7%" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding_tablet="7%" constrain_group_3="yes" bottom_padding_tablet="7%" top_padding_phone="0" constrain_group_5="yes" bottom_padding_phone="0" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner left_padding_phone="10%" constrain_group_105="yes" right_padding_phone="10%" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="small_desktop" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" gradient_type="default"][image_with_animation image_url="https://themenectar.com/img/demo-media/unsplash/webp/600-600-guy.webp" image_size="large" animation_type="entrance" animation="None" animation_movement_type="transform_y" hover_animation="none" alignment="" border_radius="none" box_shadow="none" image_loading="default" max_width="100%" max_width_mobile="default" mask_enable="true" mask_shape="circle-rect" mask_size="contain"][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="2/3" tablet_width_inherit="small_desktop" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][nectar_badge display_tag="label" badge_style="default" bg_color_type="global" color="accent-color" text_color="#ffffff" padding="small" border_radius="5px" display="block" text="Quality Work" margin_bottom="10"][nectar_responsive_text font_size_max="32px" font_size_desktop="2vw" font_line_height="1.5" font_size_phone="4.7vw" font_size_tablet="2.5vw"]
<h4>“I have used ThemeNectar 3 times and they have been fantastic every time. They communicated clearly upfront and delivered exactly what was promised right on time.”</h4>
[/nectar_responsive_text][nectar_responsive_text]Corey Barnes, SEO Mania[/nectar_responsive_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Vertical Staggered Post Grid', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['blog'];
$data['custom_class'] = 'blog date-9-June-2023';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/2023-tight-masonry-post-grid.webp' );
$data['content'] = <<<CONTENT
[vc_row type="in_container" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][nectar_post_grid post_type="post" blog_category="all" order="DESC" orderby="rand" pagination="none" columns="3" columns_tablet="default" columns_phone="default" grid_item_spacing="5px" grid_item_height="40vh" enable_masonry="yes" 3_col_masonry_layout="vert_staggered" image_size="full" image_loading="lazy-load" animation="none" animation_stagger="100" animation_easing="easeInOutCubic" heading_tag="default" font_size_min="16px" font_size_max="24px" enable_indicator="yes" mouse_indicator_style="tooltip_text" mouse_indicator_text="read" mouse_indicator_color="rgba(255,255,255,0.25)" mouse_indicator_text_color="#000000" mouse_indicator_blurred_bg="yes" display_categories="yes" category_functionality="default" category_position="default" category_style="button" category_display="parent_only" display_date="yes" display_author="yes" author_functionality="default" author_position="default" additional_meta_size="small" grid_style="content_overlaid" text_content_layout="all_bottom_left_shadow" color_overlay_opacity="0.3" color_overlay_hover_opacity="0.4" text_color="light" text_color_hover="light" text_opacity="1" text_hover_opacity="1" hover_effect="animated_underline_zoom" border_radius="10px" custom_font_size="1.3vw" posts_per_page="9" display_type="grid" image_loading_lazy_skip="3" font_line_height="1.4"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Lottie Helpful Hero', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'] . ' ' . $cat_display_names['lottie'];
$data['custom_class'] = 'general lottie date-19-June-2023';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/2023-lottie-header.webp' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="none" equal_height="yes" content_placement="middle" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="8%" constrain_group_1="yes" bottom_padding="8%" top_padding_tablet="8%" constrain_group_3="yes" bottom_padding_tablet="8%" top_padding_phone="7%" constrain_group_5="yes" bottom_padding_phone="7%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column right_padding_desktop="15%" right_padding_phone="0" bottom_margin_tablet="10%" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.8" width="1/2" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="advanced"][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" right_padding_desktop="10%" right_padding_tablet="5%" right_padding_phone="3%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="0px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="default"][nectar_badge display_tag="label" badge_style="line" text_color="#3452ff" line_width="15" text="Theme Partner" margin_left="-25px" margin_bottom="10"][nectar_responsive_text font_size_max="50px" font_size_desktop="3vw" font_line_height="1.2" font_size_phone="6vw" font_size_tablet="4vw"]
<h1>Professional Salient Customization</h1>
[/nectar_responsive_text][divider line_type="No Line" custom_height="20"][nectar_responsive_text font_size_min="16px" font_size_max="20px" font_size_desktop="1.1vw" font_line_height="1.6"]Get top-tier development services delivered by our handpicked network of skilled Salient and WordPress experts, exclusively through our partners at ThemeNectar.[/nectar_responsive_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding="2vw" top_padding_tablet="5vw" top_padding_phone="6vw" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="horizontal" column_element_direction_tablet="horizontal" column_element_direction_phone="horizontal" column_element_alignment="center" column_element_spacing="20px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="default"][nectar_cta btn_style="text-reveal-wave" heading_tag="span" button_color="accent-color" text_color="#ffffff" button_border_thickness="0px" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" constrain_group_3="yes" constrain_group_4="yes" display="inline" display_tablet="inherit" display_phone="inherit" icon_family="none" link_text="Start a project" padding_top="0.8em" padding_bottom="0.8em" padding_left="2.2em" padding_right="2.2em" margin_right="0.8em" font_size_desktop="1.1vw" font_size_tablet="14"][nectar_cta btn_style="underline" heading_tag="span" button_color="default" text_color="#000000" button_border_thickness="0px" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" constrain_group_3="yes" display="inline" display_tablet="inherit" display_phone="inherit" icon_family="none" link_text="Explore service" padding_top="4" padding_bottom="4" font_size_desktop="1.1vw" font_size_tablet="16"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="padding-5-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="left-right" column_element_direction_desktop="default" column_element_spacing="0px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color="#e3f3e2" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="20px" column_link_target="_self" column_position="relative" advanced_gradient_angle="180" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="default"][nectar_lottie trigger_type="play" mobile_func="default" loop="true" trigger_offset="0.00,100.00" frame_constraint="0.00,100.00" speed="0.8" width_desktop="100%" alignment="center" preserve_aspect_ratio="xMidYMid meet" css_animation="fade-in" json_url="https://lottie.host/c2ca6359-99d3-4340-b4ce-46fc276f2a82/S5qDD0tPKS.json" class_name="multiply-blend"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Colorful Personal Header', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['hero_section'];
$data['custom_class'] = 'hero_section date-10-June-2023';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/multi-grad-hero.webp' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="40" constrain_group_1="yes" bottom_padding="40" left_padding_desktop="40" constrain_group_2="yes" right_padding_desktop="40" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" overlay_strength="0.3" gradient_direction="radial" shape_divider_color="#ffffff" shape_divider_position="bottom" bg_image_animation="zoom-out" shape_type="curve" gradient_type="default"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="0px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="center" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="radial" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" zindex="20" overflow="visible" pointer_events="all"][vc_column_inner top_padding_desktop="6%" constrain_group_100="yes" bottom_padding_desktop="6%" left_padding_desktop="10%" constrain_group_101="yes" right_padding_desktop="10%" column_element_direction_desktop="default" column_element_spacing="0px" centered_text="true" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://themenectar.com/img/demo-media/unsplash/mullti-gradient-large.webp" background_image_position="center center" background_image_stacking="default" enable_bg_scale="true" background_image_loading="default" column_backdrop_filter="none" font_color="#000000" column_shadow="none" column_border_radius="15px" column_link_target="_self" overflow="visible" advanced_gradient="linear-gradient(0deg, rgba(243,243,243,0) 19%, rgb(255,255,255) 100%)" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" parallax_bg="true" parallax_bg_speed="fast" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" gradient_type="advanced" advanced_gradient_display_type="linear"][divider line_type="No Line" custom_height="10vh"][split_line_heading animation_type="line-reveal-by-space" font_style="h1" line_reveal_by_space_text_effect="none" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="Hi, I'm Amelia! I like to share business wisdom as an entrepreneur to empower others." font_size="6vw" font_line_height="1.2" font_size_tablet="6vw"][/split_line_heading][nectar_cta btn_style="underline" heading_tag="h5" button_color="default" text_color="#0a0a0a" button_border_thickness="0px" link_type="regular" alignment="center" alignment_tablet="default" alignment_phone="default" constrain_group_3="yes" display="block" display_tablet="inherit" display_phone="inherit" icon_family="none" link_text="Explore" margin_top="40" padding_top="18" padding_bottom="18" font_size_desktop="20" font_size_tablet="18" font_size_phone="16"][divider line_type="No Line" custom_height="10vh"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'SaaS Dark Hero', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['hero_section'];
$data['custom_class'] = 'hero_section date-11-July-2022';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/promo-header-dark.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" equal_height="yes" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#000000" animated_gradient_bg="true" animated_gradient_bg_color_1="#000775" animated_gradient_bg_speed="850" animated_gradient_bg_blending_mode="organic" scene_position="center" text_color="light" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="hidden" advanced_gradient_angle="15" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="clip-path" clip_path_animation_type="default" clip_path_animation_applies="row" clip_path_start_top_desktop="0" clip_path_start_bottom_desktop="0" clip_path_start_left_desktop="0" clip_path_start_right_desktop="0" clip_path_end_top_desktop="80px" clip_path_end_bottom_desktop="0" clip_path_end_left_desktop="30px" clip_path_end_right_desktop="30px" clip_path_end_top_phone="50px" clip_path_end_bottom_phone="24px" clip_path_end_left_phone="24px" clip_path_end_right_phone="24px" clip_path_start_roundness="0" clip_path_end_roundness="20px" clip_path_animation_addon="fade" video_mute="true" shape_type="straight_section" gradient_type="default" bg_image_animation_delay="100"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="0px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="static" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="parallax" animation_movement_type="default" column_parallax_intensity="-4" persist_movement_on_mobile="true" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="default"][vc_row_inner equal_height="yes" content_placement="bottom" column_margin="custom" column_margin_custom="6vw" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding="13%" left_padding_desktop="10%" constrain_group_2="yes" right_padding_desktop="10%" top_padding_tablet="20%" top_padding_phone="25%" left_padding_phone="14%" constrain_group_6="yes" right_padding_phone="14%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner left_padding_tablet="10%" constrain_group_103="yes" right_padding_tablet="10%" left_padding_phone="0" right_padding_phone="0" column_element_direction_desktop="default" column_element_spacing="5px" desktop_text_alignment="default" tablet_text_alignment="center" phone_text_alignment="center" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="1" width="3/5" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="slight-fade-in-from-bottom" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_color="rgba(255,255,255,0.22)" column_border_style="solid" gradient_type="default" column_padding_type="advanced" delay="400"][nectar_highlighted_text scribble_color="#ffffff" style="scribble" scribble_shape="basic-underline" scribble_thickness="thin" scribble_speed="1.3s" scribble_easing="ease_in_out" custom_font_size="5vw" font_size_tablet="7vw" font_line_height="1.1" font_size_phone="8vw" delay="400"]
<h1><em><strong>Beautiful</strong></em> websites with less work</h1>
[/nectar_highlighted_text][divider line_type="No Line" custom_height="50" custom_height_tablet="30"][nectar_cta btn_style="text-reveal-wave" heading_tag="span" button_color="default" button_color_hover="#3452ff" text_color="#ffffff" button_border_color="#3452ff" button_border_color_hover="#3452ff" button_border_thickness="1px" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" constrain_group_3="yes" constrain_group_4="yes" display="block" display_tablet="inherit" display_phone="inherit" icon_family="none" link_text="Explore Features" padding_top="1em" padding_bottom="1em" padding_left="2.3em" padding_right="2.3em" url="#features" margin_bottom="16" font_size_desktop="1.1vw" font_size_tablet="2vw" font_size_phone="16px"][/vc_column_inner][vc_column_inner left_padding_tablet="20%" constrain_group_103="yes" right_padding_tablet="20%" left_padding_phone="8%" constrain_group_105="yes" right_padding_phone="8%" top_margin_tablet="40" column_element_direction_desktop="default" column_element_spacing="10px" desktop_text_alignment="default" tablet_text_alignment="center" phone_text_alignment="center" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="2/5" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="slight-fade-in-from-bottom" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" gradient_type="default" delay="500"][split_line_heading animation_type="line-reveal-by-space" font_style="p" line_reveal_by_space_text_effect="default" stagger_animation="true" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="Salient is a next-generation WordPress theme that brings professional design results to anyone, without any coding required." font_size="1.3vw" font_line_height="1.4" animation_delay="400" font_size_tablet="2vw" font_size_phone="16px"][/split_line_heading][divider line_type="No Line" custom_height="30"][nectar_circle_images images="https://themenectar.com/img/demo-media/unsplash/webp/ff1dfc85f81f.webp,https://themenectar.com/img/demo-media/unsplash/webp/fc2fcf082f87.webp,https://themenectar.com/img/demo-media/unsplash/webp/c5799533a786.webp,https://themenectar.com/img/demo-media/unsplash/webp/adf270f4f417.webp" sizing="40px" positioning="overlapping" stacking_order="ltr" alignment_desktop="left" alignment_tablet="middle" alignment_phone="middle" animation="none" image_size="nectar_small_square" image_loading="skip-lazy-load" alignment="left"][nectar_responsive_text]<strong>6k+ reviews</strong> (4.8 of 5)[/nectar_responsive_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding="7%" left_padding_desktop="10%" constrain_group_2="yes" right_padding_desktop="10%" left_padding_tablet="17%" constrain_group_4="yes" right_padding_tablet="17%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color="rgba(255,255,255,0.06)" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="20px" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="slight-fade-in-from-bottom" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default" delay="600"][image_with_animation image_url="https://themenectar.com/img/demo-media/promo/landing-toolbar.webp" image_size="full" animation_type="entrance" animation="None" animation_movement_type="transform_y" hover_animation="none" alignment="center" border_radius="none" box_shadow="none" image_loading="default" max_width="100%" max_width_mobile="default"][image_with_animation image_url="https://themenectar.com/img/demo-media/promo/promo-landing-builder.webp" image_size="full" animation_type="entrance" animation="None" animation_movement_type="transform_y" hover_animation="none" alignment="" border_radius="none" box_shadow="none" image_loading="skip-lazy-load" max_width="none" max_width_mobile="default"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Staggered Impact Text', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['hero_section'] . ', ' .$cat_display_names['general'];
$data['custom_class'] = 'general hero_section date-3-July-2022';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/promo-staggered-text.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="10%" bottom_padding="10%" left_padding_desktop="18%" constrain_group_2="yes" right_padding_desktop="18%" left_padding_phone="10%" constrain_group_6="yes" right_padding_phone="10%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="20px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="horizontal" column_element_direction_tablet="horizontal" column_element_direction_phone="horizontal" column_element_alignment="center" column_element_spacing="20px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][split_line_heading animation_type="line-reveal-by-space" font_style="h1" line_reveal_by_space_text_effect="none" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="ENCHANT" font_size="10vw" font_line_height="0.9" font_size_tablet="11vw" font_size_phone="13vw"][/split_line_heading][nectar_lottie trigger_type="play" mobile_func="default" loop="true" trigger_offset="0.00,100.00" frame_constraint="0.00,100.00" speed="0.7" width_desktop="8vw" width_tablet="10vw" width_phone="12vw" alignment="left" preserve_aspect_ratio="xMidYMid meet" json_url="https://assets5.lottiefiles.com/packages/lf20_9r65d17y.json"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="right" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][split_line_heading animation_type="line-reveal-by-space" font_style="h1" line_reveal_by_space_text_effect="none" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="YOUR" font_size="10vw" font_line_height="0.9" animation_offset="100%" font_size_tablet="11vw" font_size_phone="13vw"][/split_line_heading][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="30px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][split_line_heading animation_type="line-reveal-by-space" font_style="h1" line_reveal_by_space_text_effect="none" content_alignment="center" mobile_content_alignment="inherit" link_target="_self" text_content="AUDIENCE" font_size="10vw" font_line_height="0.9" animation_offset="100%" font_size_tablet="11vw" font_size_phone="13vw"][/split_line_heading][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Split Gradient Columns', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['about'];
$data['custom_class'] = 'about date-3-July-2022';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/design-split-gradient.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" equal_height="yes" content_placement="middle" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="padding-7-percent" column_padding_tablet="padding-10-percent" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="0px" centered_text="true" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" font_color="#ffffff" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient="radial-gradient(circle at top right, rgb(251,189,16) 5%, rgba(193,202,215,255) 43%, rgb(192,202,218) 58%, rgb(51,97,255) 94%)" advanced_gradient_radial_position="top right" width="1/2" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="advanced" advanced_gradient_display_type="radial"][split_line_heading animation_type="line-reveal-by-space" font_style="h2" text_color="#ffffff" line_reveal_by_space_text_effect="default" stagger_animation="true" mobile_disable_animation="true" content_alignment="center" mobile_content_alignment="inherit" link_target="_self" text_content="DEEP SPACE EXPLORATION" font_size="4vw" font_line_height="1.1" font_size_tablet="7vw"][/split_line_heading][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding="8%" constrain_group_1="yes" bottom_padding="8%" left_padding_desktop="25%" constrain_group_2="yes" right_padding_desktop="25%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][image_with_animation image_url="https://themenectar.com/img/demo-media/unsplash/webp/511cafe4a5c7.webp" image_size="full" animation_type="entrance" animation="None" animation_movement_type="transform_y" hover_animation="none" alignment="" border_radius="custom" box_shadow="none" top_left_border_radius="200" top_right_border_radius="200" bottom_right_border_radius="200" bottom_left_border_radius="200" image_loading="default" max_width="100%" max_width_mobile="default"][/vc_column_inner][/vc_row_inner][split_line_heading animation_type="line-reveal-by-space" font_style="p" text_color="#ffffff" line_reveal_by_space_text_effect="default" stagger_animation="true" mobile_disable_animation="true" content_alignment="center" mobile_content_alignment="inherit" link_target="_self" text_content="Retention is key to successful business growth. Our platform gives your customers a better experience from start to finish in order for you to easily turn them into lifelong fans." font_size="1.1vw" font_line_height="1.7" animation_offset="96%" font_size_tablet="2.5vw" font_size_phone="16px"][/split_line_heading][/vc_column][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://themenectar.com/img/demo-media/unsplash/webp/photo-1658498042419-be460a938f93.webp" background_image_position="center top" background_image_stacking="default" enable_bg_scale="true" background_image_loading="default" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" parallax_bg="true" parallax_bg_speed="very_subtle" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][divider line_type="No Line" custom_height="40vh"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'SAAS Hero', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['hero_section'];
$data['custom_class'] = 'hero_section date-14-July-2022';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/saas-header.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="none" equal_height="yes" content_placement="middle" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="5%" bottom_padding="5%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="hidden" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column top_padding_desktop="4vw" bottom_padding_desktop="6vw" left_padding_desktop="7vw" constrain_group_101="yes" right_padding_desktop="7vw" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.8" width="1/2" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="advanced"][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding="5%" right_padding_desktop="10%" top_padding_tablet="8%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="0px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" mobile_disable_entrance_animation="true" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="default" delay="900"][nectar_highlighted_text scribble_color="#ffce59" style="scribble" scribble_shape="basic-underline" scribble_thickness="regular" scribble_speed="0s" scribble_easing="ease_in_out" disable_mobile_animation="true" custom_font_size="5vw" font_size_tablet="7vw" font_line_height="1.1em"]
<h1>Where marketing &amp; automation <em>intersect.</em></h1>
[/nectar_highlighted_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding="3vw" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="horizontal" column_element_direction_tablet="horizontal" column_element_direction_phone="horizontal" column_element_alignment="center" column_element_spacing="20px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" mobile_disable_entrance_animation="true" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" delay="1100" column_padding_type="default" animation_offset="100%"][nectar_cta btn_style="text-reveal-wave" heading_tag="span" button_color="accent-color" text_color="#ffffff" button_border_thickness="0px" link_type="new_tab" alignment="left" alignment_tablet="default" alignment_phone="default" constrain_group_3="yes" constrain_group_4="yes" display="inline" display_tablet="inherit" display_phone="inherit" icon_family="none" link_text="Get started" padding_top="0.8em" padding_bottom="0.8em" padding_left="2.2em" padding_right="2.2em" margin_right="1em" font_size_desktop="1.1vw" url="https://themenectar.com/demo/resort" font_size_tablet="14"][nectar_cta btn_style="underline" heading_tag="span" button_color="default" text_color="#000000" button_border_thickness="0px" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" constrain_group_3="yes" display="inline" display_tablet="inherit" display_phone="inherit" icon_family="iconsmind" link_text="Explore features" padding_top="4" padding_bottom="4" font_size_desktop="1.1vw" icon_iconsmind="iconsmind-Leafs" url="#features" font_size_tablet="16"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column right_padding_desktop="7vw" top_padding_tablet="30" left_padding_tablet="7vw" constrain_group_103="yes" right_padding_tablet="7vw" column_element_direction_desktop="default" column_element_spacing="0px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="relative" advanced_gradient_angle="180" width="1/2" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="advanced" advanced_gradient_display_type="linear" column_padding_type="advanced"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="20px" column_link_target="_self" overflow="hidden" advanced_gradient="radial-gradient(circle at bottom, rgb(43,198,255) 0%, rgb(47,86,255) 76%)" advanced_gradient_radial_position="bottom" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="mask-reveal" animation_mask_direction="left" animation_mask_shape="straight" mobile_disable_entrance_animation="true" animation_easing="easeInOutCubic" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="advanced" column_padding_type="default" advanced_gradient_display_type="radial"][nectar_animated_shape shape_color="#ffce59" width_desktop="77vw" width_tablet="154vw" animation="grow-in" animation_disable_mobile="true" animation_easing="easeInOutCubic" animation_movement_type="transform_y" position_desktop="absolute" top_position_desktop="0" left_position_desktop="0" translate_y_desktop="-50%" translate_x_desktop="-50%" zindex="-1" animation_delay="30"][image_with_animation image_url="https://themenectar.com/img/demo-media/saas/sass-guy.webp" image_size="full" animation_type="entrance" animation="slide-up" disable_mobile_animation="true" animation_easing="easeInOutCubic" animation_movement_type="transform_y" hover_animation="none" alignment="center" border_radius="none" box_shadow="none" image_loading="skip-lazy-load" max_width="100%" max_width_mobile="default"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" translate_x="-35%" text_align="left" row_position="absolute" row_position_tablet="inherit" row_position_phone="inherit" top_position_desktop="20%" left_position_desktop="-1%" left_position_tablet="14%" zindex="500" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="entrance_and_parallax" animation_movement_type="default" column_parallax_intensity="1.2" persist_movement_on_mobile="true" enable_animation="true" animation="fade-in-from-bottom" mobile_disable_entrance_animation="true" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="default" delay="900"][image_with_animation image_url="https://themenectar.com/img/demo-media/saas/saas-sales.jpeg" image_size="full" animation_type="entrance" animation="None" animation_movement_type="transform_y" hover_animation="none" alignment="" border_radius="15px" box_shadow="custom" box_shadow_method="default" image_loading="skip-lazy-load" max_width="custom" max_width_custom="18vw" custom_box_shadow="horizontal:50,vertical:60,blur:60,spread:-20,opacity:0.175" custom_sizes_attr="(min-width: 1000px) 18vw, 30vw" max_width_custom_tablet="30vw"][nectar_lottie trigger_type="play" mobile_func="remove" trigger_offset="0.00,100.00" frame_constraint="0.00,100.00" width_desktop="6vw" alignment="center" preserve_aspect_ratio="xMidYMid meet" position_desktop="absolute" top_position_desktop="6%" left_position_desktop="5%" mobile_disable_css_animation="true" preserveaspectratio="center" json_url="https://assets4.lottiefiles.com/packages/lf20_d1q2zqsv.json" trigger_delay="900"][/vc_column_inner][/vc_row_inner]
[vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" translate_x="0%" text_align="left" row_position="absolute" row_position_tablet="inherit" row_position_phone="inherit" top_position_desktop="70%" right_position_desktop="6%" right_position_tablet="4%" zindex="500" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="entrance_and_parallax" animation_movement_type="default" column_parallax_intensity="2" persist_movement_on_mobile="true" enable_animation="true" animation="fade-in-from-bottom" mobile_disable_entrance_animation="true" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" delay="1100" column_padding_type="default" animation_offset="120%"][image_with_animation image_url="https://themenectar.com/img/demo-media/saas/saas-user-badge.jpeg" image_size="full" animation_type="entrance" animation="None" animation_movement_type="transform_y" hover_animation="none" alignment="" border_radius="15px" box_shadow="custom" box_shadow_method="default" image_loading="skip-lazy-load" max_width="custom" max_width_custom="15vw" custom_sizes_attr="(min-width: 1000px) 15vw, 30vw" custom_box_shadow="horizontal:30,vertical:45,blur:50,spread:-20,opacity:0.175" max_width_custom_tablet="30vw"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Animated Gradient Footer', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'] . ', ' . $cat_display_names['cta'];
$data['custom_class'] = 'general cta date-3-July-2022';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/2022-promo-footer.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#0a0a0a" animated_gradient_bg="true" animated_gradient_bg_color_1="#233caf" animated_gradient_bg_speed="850" animated_gradient_bg_blending_mode="linear" scene_position="center" text_color="light" text_align="left" row_border_radius="none" row_border_radius_applies="bg" zindex="1" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="5px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="static" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="default"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding="13%" bottom_padding="11%" left_padding_desktop="20%" constrain_group_2="yes" right_padding_desktop="20%" top_padding_tablet="30%" bottom_padding_tablet="25%" left_padding_phone="12%" constrain_group_6="yes" right_padding_phone="12%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" centered_text="true" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="default"][nectar_highlighted_text scribble_color="#ffffff" style="scribble" scribble_shape="squiggle-underline-2" scribble_thickness="thin" scribble_speed="1.6s" scribble_easing="ease_in_out" custom_font_size="6vw" font_size_phone="8vw"]
<h1>Build a website that you are <strong><em>proud of</em></strong></h1>
[/nectar_highlighted_text][divider line_type="No Line" custom_height="5vw"][nectar_cta btn_style="text-reveal-wave" heading_tag="span" text_color="#000000" button_color="white" button_color_hover="#f4f4f4" button_border_thickness="0px" link_type="new_tab" alignment="center" alignment_tablet="default" alignment_phone="default" constrain_group_3="yes" constrain_group_4="yes" display="block" display_tablet="inherit" display_phone="inherit" icon_family="none" link_text="Purchase Salient" padding_top="12" padding_bottom="12" padding_left="35" padding_right="35" url="#"][/vc_column_inner][/vc_row_inner][vc_row_inner equal_height="yes" content_placement="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding="2%" constrain_group_1="yes" bottom_padding="2%" left_padding_desktop="3%" constrain_group_2="yes" right_padding_desktop="3%" top_padding_phone="5%" constrain_group_5="yes" bottom_padding_phone="5%" left_padding_phone="5%" constrain_group_6="yes" right_padding_phone="5%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all" css=".vc_custom_1659042013149{border-top-width: 1px !important;border-top-color: rgba(255,255,255,0.2) !important;border-top-style: solid !important;}"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="small_desktop" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default" offset="vc_col-xs-5"][nectar_responsive_text]<b>© </b>[nectar_current_year] Salient.[/nectar_responsive_text][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="0px" desktop_text_alignment="right" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="small_desktop" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default" offset="vc_col-xs-7"][nectar_cta btn_style="underline" heading_tag="p" text_color="#ffffff" button_color="default" button_border_thickness="0px" link_type="regular" alignment="right" alignment_tablet="right" alignment_phone="right" constrain_group_4="yes" display="inline" display_tablet="inline-block" display_phone="inline-block" icon_family="none" link_text="Docs" padding_left="15" padding_right="15"][nectar_cta btn_style="underline" heading_tag="p" text_color="#ffffff" button_color="default" button_border_thickness="0px" link_type="regular" alignment="right" alignment_tablet="right" alignment_phone="right" display="inline" display_tablet="inline-block" display_phone="inline-block" icon_family="none" link_text="Help Center" padding_left="15"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Hand-Drawn Underline Intro Text', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-3-July-2022';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/saas-text-intro.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" equal_height="yes" content_placement="middle" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="12%" bottom_padding="5%" left_padding_desktop="27vw" constrain_group_2="yes" right_padding_desktop="27vw" bottom_padding_tablet="12%" left_padding_tablet="20vw" constrain_group_4="yes" right_padding_tablet="20vw" left_padding_phone="7vw" constrain_group_6="yes" right_padding_phone="7vw" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_element_direction_desktop="default" column_element_spacing="0px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="static" advanced_gradient_angle="65" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" gradient_type="advanced" advanced_gradient_display_type="linear"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding="7%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="0px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default" animation_offset="90%"][nectar_animated_shape shape_color="#ffffff" width_desktop="15vw" animation="none" animation_easing="default" animation_movement_type="transform_y" animation_movement_intensity="0.6" animation_movement_persist_on_mobile="true" position_desktop="absolute" top_position_desktop="0" left_position_desktop="0" translate_y_desktop="-30%" translate_x_desktop="-50%" zindex="-1"][nectar_highlighted_text scribble_color="#318fff" style="scribble" scribble_shape="squiggle-underline" scribble_thickness="thick" scribble_speed="1.6s" scribble_easing="ease_in_out" custom_font_size="3vw" id="circle-highlight2" font_line_height="1.4" font_size_tablet="4vw" font_size_phone="5vw"]
<h2>The best customer relationship management platform for just about <em>everything.</em></h2>
[/nectar_highlighted_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][split_line_heading animation_type="line-reveal-by-space" font_style="p" line_reveal_by_space_text_effect="default" stagger_animation="true" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="Convert leads into customers and then turn those customers into loyal fans of your brand by leveraging next-generation automation and AI. Yes, it really can be automated, and no, you're not dreaming." font_size="1.2vw" max_width="90%" font_line_height="1.8" font_size_tablet="16px"][/split_line_heading][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Clip Path Expanding Video', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-9-July-2022';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/saas-video.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" video_bg="use_video" video_external="https://www.youtube.com/watch?v=6oTurM7gESE" background_video_loading="lazy-load" scene_position="center" text_color="light" text_align="left" row_border_radius="none" row_border_radius_applies="bg" zindex="10" overflow="visible" advanced_gradient="linear-gradient(0deg, rgba(0,0,0,0.478) 0%, rgba(243,243,243,0) 48%)" shape_divider_position="top" bg_image_animation="clip-path" clip_path_animation_type="scroll" clip_path_animation_applies="row" clip_path_start_left_desktop="14%" clip_path_start_right_desktop="14%" clip_path_end_left_desktop="0%" clip_path_end_right_desktop="0%" clip_path_start_roundness="20px" clip_path_end_roundness="0px" animation_trigger_offset="0.00,100.00" animation_trigger_origin="top" trigger_offset="30.00,60.00" gradient_type="advanced" shape_type="straight_section" advanced_gradient_display_type="linear"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="0px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][nectar_video_player_self_hosted el_aspect_tablet="43" player_functionality="lightbox" play_button_style="follow_mouse" play_button_hide="yes" play_button_color="#0a0a0a" play_button_icon_color="#ffffff" border_radius="none" box_shadow="none" video_lightbox_url="https://vimeo.com/118023315" advanced_gradient_display_type="linear"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" left_padding_desktop="10%" constrain_group_2="yes" right_padding_desktop="10%" text_align="left" min_width_desktop="100%" row_position="absolute" row_position_tablet="inherit" row_position_phone="inherit" bottom_position_desktop="5vw" zindex="1000" overflow="visible" pointer_events="none"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="5px" centered_text="true" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][nectar_responsive_text text_color="#ffffff" font_size_desktop="2vw" font_size_tablet="4vw"]
<h3>Automate your growth</h3>
[/nectar_responsive_text][nectar_responsive_text text_color="#ffffff" font_size_desktop="1.2vw" font_line_height="2.5" font_size_tablet="14"]3:45 duration[/nectar_responsive_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'SAAS Trust-builder', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-12-July-2022';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/saas-above-testimonial.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="5%" constrain_group_1="yes" bottom_padding="5%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="0px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding="5%" left_padding_desktop="25vw" constrain_group_2="yes" right_padding_desktop="25vw" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" centered_text="true" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][nectar_text_inline_images media_type="images" image_size="large" image_effect="circle_fade_in" image_effect_stagger="yes" right_margin_desktop="-6%" image_loading="skip-lazy-load" line_reveal_by_space_text_effect="" content_alignment="" font_style="h1" font_size="3vw" font_line_height="1.4" font_size_desktop="4vw" font_size_tablet="4vw" max_width="" font_size_phone="5vw"]
<h2>Trusted by over 4,000 clients worldwide ***</h2>
[/nectar_text_inline_images][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'SAAS Testimonial Slider', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['testimonials'];
$data['custom_class'] = 'testimonials date-8-July-2022';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/saas-testimonials.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="5%" constrain_group_1="yes" bottom_padding="5%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="0px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][testimonial_slider style="multiple_visible" color="accent-color-dark" slider_controls="next_prev_arrows" flickity_border_radius="20px" enable_shadow="true" custom_width_desktop="40%" font_size_desktop="1.3vw" font_line_height="1.7" shadow="horizontal:22,vertical:20,blur:60,spread:0,opacity:0.575" custom_box_shadow="horizontal:40,vertical:60,blur:60,spread:-20,opacity:0.175" font_size_tablet="16"][testimonial star_rating="none" title="Testimonial" id="1659387611495-9" name="Aura Brooks" subtitle="Marketing Director, Owl Eyes" quote="We checked out Salient to see what all the hype was about and here we are a year later with a 30% increased bottom line! If you're looking for the latest and greatest, I can't recommend this CRM platform enough." tab_id="1659387611495-2"][testimonial star_rating="none" title="Testimonial" id="1659387611509-0" name="Eve Crawford" subtitle="CEO at ThemeNectar" quote="Our productivity has noticably gone up since implementing the platform. We are now able to dedicate more time on our products while having the peace of mind that our customer experience has improved." tab_id="1659387611510-3"][testimonial star_rating="none" title="Testimonial" id="1659387611517-0" name="Jack Graham" subtitle="Project Manager, Coffee Inc" quote="Salient has enhanced our user experience and allowed us to move faster than ever and our company is now positioned to scale. We've seen a rediculous growth of 80% in just a few months!" tab_id="1659387611517-5"][testimonial star_rating="none" title="Testimonial" id="1659387611525-8" name="Zak Reid" subtitle="CTO at Envato" quote="Simply put, Salient is an excellent tool to accelerate growth and save time. We've been very pleased with the results from implementing the platform into our company." tab_id="1659387611525-4"][/testimonial_slider][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Feature Split #1', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'] . ', ' . $cat_display_names['lottie'];
$data['custom_class'] = 'general lottie date-11-July-2022';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/saas-lottie-1.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="none" equal_height="yes" content_placement="middle" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="5%" bottom_padding="7%" left_padding_desktop="7%" constrain_group_2="yes" right_padding_desktop="7%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="0px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="relative" advanced_gradient_angle="180" width="1/2" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="advanced" advanced_gradient_display_type="linear" column_padding_type="default"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner top_padding_desktop="60vh" top_padding_tablet="50vh" top_padding_phone="40vh" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://themenectar.com/img/demo-media/saas/saas-feature-bg.webp" background_image_position="center center" background_image_stacking="front" enable_bg_scale="true" background_image_loading="default" column_backdrop_filter="none" column_shadow="none" column_border_radius="20px" column_link_target="_self" overflow="visible" advanced_gradient_angle="312" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" parallax_bg="true" parallax_bg_speed="minimum" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="advanced"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="absolute" row_position_tablet="inherit" row_position_phone="inherit" bottom_position_desktop="30" left_position_desktop="30" zindex="500" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color="#ffffff" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="15px" column_link_target="_self" overflow="hidden" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="mask-reveal" animation_mask_direction="left_bottom" animation_mask_shape="circle" animation_easing="easeInOutCubic" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="default" animation_offset="95%"][nectar_lottie trigger_type="play" mobile_func="default" trigger_offset="0.00,100.00" frame_constraint="0.00,100.00" width_desktop="18vw" width_tablet="36vw" alignment="center" preserve_aspect_ratio="xMidYMid meet" css_animation="fade-in" preserveaspectratio="center" json_url="https://assets10.lottiefiles.com/packages/lf20_erb8mppf.json" trigger_delay="500"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column left_padding_desktop="7vw" column_element_direction_desktop="default" column_element_spacing="30px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="static" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="advanced"][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" right_padding_desktop="5%" top_padding_tablet="8%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][split_line_heading animation_type="line-reveal-by-space" font_style="h2" text_color="#000000" line_reveal_by_space_text_effect="default" stagger_animation="true" mobile_disable_animation="true" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="Create loyal customers that love your brand" font_size="3vw" font_line_height="1.3"][/split_line_heading][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" right_padding_desktop="14%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in" animation_easing="easeInOutQuad" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][nectar_responsive_text font_size_min="16px" font_size_desktop="1.1vw" font_line_height="1.8"]Retention is key to successful business growth. Our platform gives your customers a better experience from start to finish in order for you to easily turn them into lifelong fans.[/nectar_responsive_text][nectar_cta btn_style="underline" heading_tag="span" button_color="default" text_color="#ff6b3d" button_border_thickness="0px" link_type="new_tab" alignment="left" alignment_tablet="default" alignment_phone="default" constrain_group_3="yes" display="block" display_tablet="inherit" display_phone="inherit" icon_family="none" link_text="Start your trial" padding_top="4" padding_bottom="4" url="#" font_size_desktop="1.1vw" font_size_tablet="16"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Feature Box', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'] . ', ' . $cat_display_names['lottie'];
$data['custom_class'] = 'general lottie date-10-July-2022';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/2022-promo-features-3.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="20px" equal_height="yes" content_placement="middle" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#f0f2f6" scene_position="center" top_padding="4%" constrain_group_1="yes" bottom_padding="4%" left_padding_desktop="5%" constrain_group_2="yes" right_padding_desktop="5%" left_padding_phone="14px" constrain_group_6="yes" right_padding_phone="14px" text_color="light" text_align="left" row_border_radius="none" row_border_radius_applies="bg" zindex="10" overflow="visible" id="studio" advanced_gradient_angle="0" shape_divider_position="bottom" bg_image_animation="none" shape_type="" gradient_type="advanced" advanced_gradient_display_type="linear"][vc_column top_padding_desktop="7%" left_padding_desktop="18%" constrain_group_101="yes" right_padding_desktop="18%" top_padding_tablet="8vw" left_padding_phone="8vw" constrain_group_105="yes" right_padding_phone="8vw" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://themenectar.com/img/demo-media/promo/ecommerce-bg.jpeg" background_image_position="center center" background_image_stacking="default" background_image_loading="default" column_backdrop_filter="none" column_shadow="none" column_border_radius="20px" column_link_target="_self" column_position="default" overflow="hidden" advanced_gradient_angle="0" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" parallax_bg="true" parallax_bg_speed="minimum" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="advanced" column_padding_type="advanced" advanced_gradient_display_type="linear"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding="5%" left_padding_desktop="18%" constrain_group_2="yes" right_padding_desktop="18%" left_padding_tablet="10%" constrain_group_4="yes" right_padding_tablet="10%" left_padding_phone="0" constrain_group_6="yes" right_padding_phone="0" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="10px" centered_text="true" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][nectar_responsive_text font_size_desktop="1.8vw" font_line_height="1.3" font_size_tablet="22px"]
<h3>Powerful WooCommerce Functionality</h3>
[/nectar_responsive_text][nectar_responsive_text font_size_min="14px" font_size_max="20px" font_size_desktop="1.1vw" font_line_height="1.5"]Unlock incredible store building potential with an AJAX off-canvas cart, product quickview, advanced reviews, premium gallery styles, collapsable product widget area, and much more.[/nectar_responsive_text][nectar_cta btn_style="text-reveal-wave" heading_tag="span" button_color="black" text_color="#ffffff" button_border_thickness="0px" link_type="regular" alignment="center" alignment_tablet="default" alignment_phone="default" constrain_group_3="yes" constrain_group_4="yes" display="block" display_tablet="inherit" display_phone="inherit" icon_family="none" link_text="View All Features" margin_top="40" padding_top="12" padding_bottom="12" padding_left="35" padding_right="35"][/vc_column_inner][/vc_row_inner][vc_row_inner equal_height="yes" content_placement="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" left_padding_tablet="5%" constrain_group_4="yes" right_padding_tablet="5%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_element_direction_desktop="default" column_element_spacing="default" centered_text="true" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" advanced_gradient_angle="0" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" parallax_bg="true" parallax_bg_speed="very_subtle" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="advanced" advanced_gradient_display_type="linear" column_padding_type="advanced"][nectar_lottie trigger_type="play" mobile_func="default" trigger_offset="15.00,100.00" frame_constraint="0.00,100.00" width_desktop="14vw" alignment="center" preserve_aspect_ratio="xMidYMid meet" enable_shadow="true" position_desktop="absolute" top_position_desktop="50%" right_position_desktop="0" translate_y_desktop="-50%" translate_x_desktop="50%" json_url="https://assets7.lottiefiles.com/packages/lf20_thwjheep.json" zindex="10" custom_box_shadow="horizontal:0,vertical:25,blur:30,spread:0,opacity:0.2"][image_with_animation image_url="https://themenectar.com/img/demo-media/promo/ecommerce-robust-preview.jpeg" image_size="full" animation_type="entrance" animation="None" animation_movement_type="transform_y" hover_animation="none" alignment="" border_radius="custom" box_shadow="none" top_left_border_radius="20px" top_right_border_radius="20px" image_loading="default" max_width="100%" max_width_mobile="default"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Feature Split #2', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-2-July-2022';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/saas-feature-3.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="none" equal_height="yes" content_placement="middle" column_direction="default" column_direction_tablet="column_reverse" column_direction_phone="column_reverse" scene_position="center" top_padding="7%" constrain_group_1="yes" bottom_padding="7%" left_padding_desktop="7%" constrain_group_2="yes" right_padding_desktop="7%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column right_padding_desktop="7vw" left_padding_tablet="7vw" right_padding_tablet="0" column_element_direction_desktop="default" column_element_spacing="30px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="static" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="advanced"][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" right_padding_desktop="5%" top_padding_tablet="8%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][split_line_heading animation_type="line-reveal-by-space" font_style="h2" text_color="#000000" line_reveal_by_space_text_effect="default" stagger_animation="true" mobile_disable_animation="true" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="AI driven solutions for exceptional outcomes" font_size="3vw" font_line_height="1.3"][/split_line_heading][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" right_padding_desktop="10%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in" mobile_disable_entrance_animation="true" animation_easing="easeInOutQuad" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="default"][fancy-ul icon_type="standard_check" color="Accent-Color" alignment="left" spacing="10px" font_size_min="16px" font_size_desktop="1.1vw" font_line_height="1.6"]
<ul>
 	<li>AI-Powered marketing strategies</li>
 	<li>Live customer support chat widget</li>
 	<li>Automatic scaling campaign tools</li>
 	<li>Adaptive testing/reporting</li>
</ul>
[/fancy-ul][nectar_cta btn_style="underline" heading_tag="span" button_color="default" text_color="#ff6b3d" button_border_thickness="0px" link_type="new_tab" alignment="left" alignment_tablet="default" alignment_phone="default" constrain_group_3="yes" display="block" display_tablet="inherit" display_phone="inherit" icon_family="none" link_text="View A Demo" padding_top="4" padding_bottom="4" url="#" font_size_desktop="1.1vw" font_size_tablet="16"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_element_direction_desktop="default" column_element_spacing="0px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="relative" overflow="hidden" advanced_gradient_angle="180" width="1/2" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="advanced" advanced_gradient_display_type="linear" column_padding_type="advanced"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color="#d3dbe1" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="20px" column_link_target="_self" overflow="hidden" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="advanced"][nectar_animated_shape shape_color="rgba(0,0,0,0.11)" width_desktop="50vw" animation="grow-in" animation_disable_mobile="true" animation_easing="easeInOutCubic" animation_movement_type="transform_y" position_desktop="absolute" top_position_desktop="0" right_position_desktop="0" translate_y_desktop="-50%" translate_x_desktop="50%" zindex="-1" animation_offset="80%"][image_with_animation image_url="https://themenectar.com/img/demo-media/saas/saas-phone.webp" image_size="full" animation_type="entrance" animation="None" animation_movement_type="transform_y" animation_movement_intensity=".7" animation_movement_persist_on_mobile="true" hover_animation="none" alignment="center" border_radius="none" box_shadow="custom" box_shadow_method="filter" image_loading="default" max_width="custom" max_width_custom="60%" custom_box_shadow="horizontal:30,vertical:60,blur:60,spread:-20,opacity:0.25" margin_bottom="-12%" margin_top="14%"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Large Gradient Hero', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['hero_section'];
$data['custom_class'] = 'hero_section date-10-July-2022';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/yellow-gradient-landing.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="custom" column_margin_custom="8%" equal_height="yes" content_placement="bottom" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="8%" left_padding_desktop="8%" constrain_group_2="yes" right_padding_desktop="8%" top_padding_tablet="15%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="hidden" advanced_gradient="radial-gradient(circle at top right, rgb(255,189,36) 4%, rgb(247,243,239) 81%)" advanced_gradient_radial_position="top right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="advanced" advanced_gradient_display_type="radial" shape_type=""][vc_column bottom_padding_desktop="8vw" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="center" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/4" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" gradient_type="default"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="padding-4-percent" column_padding_phone="padding-2-percent" column_padding_position="all" bottom_margin="4vw" bottom_margin_tablet="0" column_element_direction_desktop="default" column_element_spacing="5px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default" animation_offset="100%" offset="vc_col-xs-6"][nectar_responsive_text font_size_desktop="1.3vw" font_line_height="1.4" font_size_tablet="16px" font_size_phone="14px"]All that you need to create your own beautiful website.[/nectar_responsive_text][nectar_cta btn_style="underline" heading_tag="h6" button_color="default" button_border_thickness="0px" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" display="block" display_tablet="inherit" display_phone="inherit" icon_family="none" link_text="Take a tour" font_size_desktop="1.3vw" font_size_tablet="16px" font_size_phone="14px" margin_top="20"][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="padding-4-percent" column_padding_phone="padding-2-percent" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="5px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default" delay="150" offset="vc_col-xs-6"][nectar_responsive_text font_size_desktop="1.3vw" font_line_height="1.4" font_size_tablet="16px" font_size_phone="14px"]Innovative design that makes people stop and stare.[/nectar_responsive_text][nectar_cta btn_style="underline" heading_tag="h6" button_color="default" button_border_thickness="0px" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" display="block" display_tablet="inherit" display_phone="inherit" icon_family="none" link_text="Sign up now" font_size_desktop="1.3vw" font_size_tablet="16px" font_size_phone="14px" margin_top="20"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_element_direction_desktop="default" column_element_spacing="5px" centered_text="true" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" gradient_type="default"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" zindex="100" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="5px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][split_line_heading animation_type="line-reveal-by-space" font_style="h1" line_reveal_by_space_text_effect="letter-reveal-bottom" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="salient" font_size="8vw" font_line_height="1" font_size_tablet="12vw"][/split_line_heading][split_line_heading animation_type="line-reveal-by-space" font_style="h1" line_reveal_by_space_text_effect="letter-reveal-bottom" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="DESIGN" font_size="8vw" font_line_height="1" animation_delay="200" font_size_tablet="12vw"][/split_line_heading][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" translate_x="50%" text_align="left" row_position="absolute" row_position_tablet="inherit" row_position_phone="inherit" top_position_desktop="45%" right_position_desktop="0" top_position_tablet="40%" right_position_tablet="7%" zindex="100" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://themenectar.com/img/demo-media/unsplash/webp/photo-1587613727490-514da4285de3.webp" background_image_position="center center" background_image_stacking="default" enable_bg_scale="true" background_image_loading="default" column_backdrop_filter="none" column_shadow="custom" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="grow-in" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" mask_enable="true" mask_size="custom" mask_scale="70" mask_alignment_desktop="center-center" column_padding_type="default" gradient_type="default" custom_box_shadow="horizontal:0,vertical:30,blur:40,spread:0,opacity:0.45"][nectar_icon icon_family="fontawesome" icon_style="default" icon_color_type="color_scheme" icon_color="white" icon_padding="20px" zindex="10" pointer_events="all" position_desktop="absolute" top_position_desktop="50%" left_position_desktop="50%" translate_y_desktop="-50%" translate_x_desktop="-50%" icon_fontawesome="fa fa-play" icon_size="20"]
[image_with_animation image_url="https://themenectar.com/img/demo-media/spinners/play-video-dark.png" image_size="full" animation_type="looped" loop_animation="rotate" animation_movement_type="transform_y" hover_animation="none" alignment="" img_link_target="lightbox" border_radius="none" image_loading="default" max_width="custom" position_desktop="relative" max_width_custom="8vw" img_link="https://www.youtube.com/watch?v=6oTurM7gESE" zindex="1000" max_width_custom_tablet="15vw"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner top_margin="-4vw" top_margin_tablet="-7vw" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color="#f7f3ef" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" mask_enable="true" mask_shape="circle-rect" mask_size="cover" mask_alignment_desktop="center-top" column_padding_type="advanced" gradient_type="default"][image_with_animation image_url="https://themenectar.com/img/demo-media/saas/sunglasses-guy.webp" image_size="full" animation_type="entrance" animation="slide-up" animation_easing="default" animation_movement_type="transform_y" hover_animation="none" alignment="center" border_radius="none" box_shadow="none" image_loading="default" max_width="125%" max_width_mobile="default"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column bottom_padding_desktop="8vw" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/4" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" gradient_type="default" offset="vc_hidden-sm vc_hidden-xs"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="5px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][nectar_responsive_text font_size_desktop="3vw" font_line_height="1.3"]
<h3>98%</h3>
[/nectar_responsive_text][nectar_responsive_text font_size_desktop="1.3vw" font_line_height="1"]
<h6>Customer</h6>
[/nectar_responsive_text][nectar_responsive_text font_size_desktop="1.3vw" font_line_height="1"]
<h6>Satisfaction</h6>
[/nectar_responsive_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Feature Split #3', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'] . ', ' . $cat_display_names['lottie'];
$data['custom_class'] = 'general lottie date-10-July-2022';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/saas-lottie-2.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" equal_height="yes" content_placement="middle" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="5%" bottom_padding="7%" left_padding_desktop="7%" constrain_group_2="yes" right_padding_desktop="7%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="0px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="relative" advanced_gradient_angle="180" width="1/2" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="advanced" advanced_gradient_display_type="linear" column_padding_type="default"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner top_padding_desktop="60vh" top_padding_tablet="50vh" top_padding_phone="40vh" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://themenectar.com/img/demo-media/unsplash/webp/photo-1587613727490-514da4285de3.webp" background_image_position="center center" background_image_stacking="front" enable_bg_scale="true" background_image_loading="default" column_backdrop_filter="none" column_shadow="none" column_border_radius="20px" column_link_target="_self" overflow="visible" advanced_gradient_angle="312" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" parallax_bg="true" parallax_bg_speed="minimum" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="advanced"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="absolute" row_position_tablet="inherit" row_position_phone="inherit" bottom_position_desktop="30" right_position_desktop="30" zindex="500" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color="#ffffff" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="15px" column_link_target="_self" overflow="hidden" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="mask-reveal" animation_mask_direction="right_bottom" animation_mask_shape="circle" animation_easing="easeInOutCubic" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="default" animation_offset="95%"][nectar_lottie trigger_type="play" mobile_func="default" trigger_offset="0.00,100.00" frame_constraint="0.00,100.00" width_desktop="18vw" width_tablet="36vw" alignment="center" preserve_aspect_ratio="xMidYMid meet" css_animation="fade-in" preserveaspectratio="center" json_url="https://assets4.lottiefiles.com/packages/lf20_yvkok161.json" trigger_delay="500"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column left_padding_desktop="7vw" column_element_direction_desktop="default" column_element_spacing="30px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="static" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="advanced"][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" right_padding_desktop="5%" top_padding_tablet="8%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][split_line_heading animation_type="line-reveal-by-space" font_style="h2" text_color="#000000" line_reveal_by_space_text_effect="default" stagger_animation="true" mobile_disable_animation="true" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="Seriously improve your lead conversion rate" font_size="3vw" font_line_height="1.3"][/split_line_heading][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" right_padding_desktop="10%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in" mobile_disable_entrance_animation="true" animation_easing="easeOutQuad" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="default"][fancy-ul icon_type="standard_check" color="Accent-Color" alignment="left" spacing="10px" font_size_min="16px" font_size_desktop="1.1vw" font_line_height="1.6"]
<ul>
 	<li>Intuitive customer analytics</li>
 	<li>Advertisement conversion events</li>
 	<li>Automation of sales/marketing</li>
</ul>
[/fancy-ul][nectar_cta btn_style="underline" heading_tag="span" button_color="default" text_color="#ff6b3d" button_border_thickness="0px" link_type="new_tab" alignment="left" alignment_tablet="default" alignment_phone="default" constrain_group_3="yes" display="block" display_tablet="inherit" display_phone="inherit" icon_family="none" link_text="Start your trial" padding_top="4" padding_bottom="4" url="https://themenectar.com/salient" font_size_desktop="1.1vw" font_size_tablet="16"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Hand-drawn text underline', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-10-July-2022';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/saas-pricing-text.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="8%" constrain_group_1="yes" bottom_padding="8%" left_padding_desktop="7%" constrain_group_2="yes" right_padding_desktop="7%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" padding_type="default" gradient_type="default"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding="3%" left_padding_desktop="24%" constrain_group_2="yes" right_padding_desktop="24%" left_padding_phone="5%" constrain_group_6="yes" right_padding_phone="5%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" centered_text="true" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="default"][nectar_highlighted_text scribble_color="#ffce59" style="scribble" scribble_shape="squiggle-underline-2" scribble_thickness="thick" scribble_speed="1.1s" scribble_easing="ease_in_out" custom_font_size="4vw"]
<h2>Tailored pricing plans <em>designed</em> for you</h2>
[/nectar_highlighted_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Toggle Pricing Tables', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['pricing']. ', ' . $cat_display_names['lottie'];
$data['custom_class'] = 'pricing lottie date-9-July-2022';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/saas-pricing.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="8%" constrain_group_1="yes" bottom_padding="8%" left_padding_desktop="7%" constrain_group_2="yes" right_padding_desktop="7%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" padding_type="default" gradient_type="default"][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" translate_y="-44px" translate_x="170px" rotate_desktop="350" text_align="left" row_position="absolute" row_position_tablet="inherit" row_position_phone="inherit" left_position_desktop="50%" overflow="visible" pointer_events="none"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="5px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="default" offset="vc_hidden-xs"][nectar_badge display_tag="italic" badge_style="default" bg_color_type="custom" text_color="#000000" padding="none" border_radius="20px" display="block" text="Save 25%"][nectar_lottie trigger_type="play" mobile_func="default" trigger_offset="8.00,100.00" frame_constraint="0.00,100.00" speed="0.9" width_desktop="40px" alignment="left" preserve_aspect_ratio="xMidYMid meet" preserveaspectratio="center" json_url="https://assets2.lottiefiles.com/packages/lf20_ddvwtafj.json"][/vc_column_inner][/vc_row_inner][tabbed_section style="toggle_button" tab_change_animation="none" tab_color="Accent-Color" vs_content_animation="fade" vs_link_animation="opacity" vs_navigation_alignment="left" vs_navigation_width_2="25%" vs_navigation_func="default" vs_navigation_width="regular" vs_navigation_spacing="15px" vs_navigation_mobile_display="visible" vs_tab_spacing="5%" animation=""][tab icon_family="none" title="Pay Monthly" id="1659385701588-4" tab_id="1659385701589-2"][vc_row_inner equal_height="yes" column_margin="40px" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner top_padding_desktop="40" constrain_group_100="yes" bottom_padding_desktop="40" left_padding_desktop="40" constrain_group_101="yes" right_padding_desktop="40" column_element_direction_desktop="default" column_element_spacing="10px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color="#ff6b3d" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" font_color="#ffffff" column_shadow="custom" column_border_radius="15px" column_link_target="_self" zindex="100" overflow="hidden" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" padding_type="advanced" column_padding_type="advanced" column_shadow_custom="" custom_box_shadow="horizontal:40,vertical:60,blur:60,spread:-20,opacity:0.175"][nectar_lottie trigger_type="play" mobile_func="default" loop="true" trigger_offset="0.00,100.00" frame_constraint="0.00,100.00" speed="0.2" width_desktop="150%" height_desktop="150%" alignment="center" preserve_aspect_ratio="xMidYMid meet" position_desktop="absolute" top_position_desktop="0" left_position_desktop="0" translate_y_desktop="-50%" translate_x_desktop="25%" preserveaspectratio="none" json_url="https://assets1.lottiefiles.com/packages/lf20_w4NUp4.json" zindex="-1"][nectar_icon icon_family="iconsmind" icon_style="default" icon_color_type="color_scheme" icon_color="white" icon_padding="0px" pointer_events="all" icon_iconsmind="iconsmind-Plant"][nectar_responsive_text font_style="h4" content_alignment="default" mobile_content_alignment="inherit" font_size="5vw" font_line_height="1" font_size_desktop="2vw" font_size_tablet="3vw" font_size_phone="16"]Basic[/nectar_responsive_text][nectar_responsive_text font_style="h3" content_alignment="default" mobile_content_alignment="inherit" font_size="5vw" font_line_height="1" font_size_desktop="4vw" font_size_tablet="7vw"]Free[/nectar_responsive_text][divider line_type="No Line" custom_height="15"][fancy-ul icon_type="standard_dot" alignment="left" spacing="10px" font_size_min="16px" font_size_desktop="1.1vw"]</p>
<ul>
<li>Live chat widget</li>
<li>Email marketing</li>
<li>Custom Forms</li>
<li>Traffic analytics</li>
</ul>
<p>[/fancy-ul][divider line_type="No Line" custom_height="90"][nectar_cta btn_style="text-reveal-wave" heading_tag="span" button_color="white" text_color="#000000" button_border_thickness="0px" link_type="regular" alignment="center" alignment_tablet="default" alignment_phone="default" constrain_group_3="yes" constrain_group_4="yes" display="block" display_tablet="inherit" display_phone="inherit" icon_family="none" position_desktop="absolute" bottom_position_desktop="40" left_position_desktop="40" right_position_desktop="40" padding_top="0.8em" padding_bottom="0.8em" padding_left="40" padding_right="40" link_text="Get Started"][/vc_column_inner][vc_column_inner top_padding_desktop="40" constrain_group_100="yes" bottom_padding_desktop="40" left_padding_desktop="40" constrain_group_101="yes" right_padding_desktop="40" column_element_direction_desktop="default" column_element_spacing="10px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color="#ffffff" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" font_color="#000000" column_shadow="none" column_border_radius="15px" column_link_target="_self" overflow="visible" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" gradient_type="default"][nectar_icon icon_family="iconsmind" icon_style="default" icon_color_type="color_scheme" icon_color="black" icon_padding="0px" pointer_events="all" icon_iconsmind="iconsmind-Leafs"][nectar_responsive_text font_style="h4" content_alignment="default" mobile_content_alignment="inherit" font_size="5vw" font_line_height="1" font_size_desktop="2vw" font_size_tablet="3vw" font_size_phone="16px"]Premium[/nectar_responsive_text][nectar_price_typography before_text_scale="0.4" after_text_scale="0.4" font_style="h3" price_text="29" before_text="$" after_text="/ month" font_size_desktop="4vw" font_size_tablet="7vw" font_line_height="1.5"][divider line_type="No Line" custom_height="15"][fancy-ul icon_type="standard_dot" alignment="left" spacing="10px" font_size_min="16px" font_size_desktop="1.1vw"]</p>
<ul>
<li>Everything in basic</li>
<li>Marketing automation</li>
<li>Advanced chatbot</li>
<li>Campaign management</li>
<li>Collaboration tools</li>
</ul>
<p>[/fancy-ul][divider line_type="No Line" custom_height="90"][nectar_cta btn_style="text-reveal-wave" heading_tag="span" button_color="accent-color" text_color="#ffffff" button_border_thickness="0px" link_type="regular" alignment="center" alignment_tablet="default" alignment_phone="default" constrain_group_3="yes" constrain_group_4="yes" display="block" display_tablet="inherit" display_phone="inherit" icon_family="none" position_desktop="absolute" bottom_position_desktop="40" left_position_desktop="40" right_position_desktop="40" padding_top="0.8em" padding_bottom="0.8em" padding_left="40" padding_right="40" link_text="Get Started"][/vc_column_inner][vc_column_inner top_padding_desktop="40" constrain_group_100="yes" bottom_padding_desktop="40" left_padding_desktop="40" constrain_group_101="yes" right_padding_desktop="40" column_element_direction_desktop="default" column_element_spacing="10px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color="#ffffff" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="15px" column_link_target="_self" overflow="visible" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="advanced"][nectar_icon icon_family="iconsmind" icon_style="default" icon_color_type="color_scheme" icon_color="black" icon_padding="0px" pointer_events="all" icon_iconsmind="iconsmind-Flowerpot"][nectar_responsive_text font_style="h4" content_alignment="default" mobile_content_alignment="inherit" font_size="5vw" font_line_height="1" font_size_desktop="2vw" font_size_tablet="3vw" font_size_phone="16px"]Platinum[/nectar_responsive_text][nectar_price_typography before_text_scale="0.4" after_text_scale="0.4" font_style="h3" price_text="59" before_text="$" after_text="/ month" font_size_desktop="4vw" font_size_tablet="7vw" font_line_height="1.5"][divider line_type="No Line" custom_height="15"][fancy-ul icon_type="standard_dot" alignment="left" spacing="10px" font_size_min="16px" font_size_desktop="1.1vw"]</p>
<ul>
<li>Everything in premium</li>
<li>A/B testing sanbox</li>
<li>Custom permissions</li>
<li>Social media automation</li>
<li>Sales automation tools</li>
</ul>
<p>[/fancy-ul][divider line_type="No Line" custom_height="90"][nectar_cta btn_style="text-reveal-wave" heading_tag="span" button_color="accent-color" text_color="#ffffff" button_border_thickness="0px" link_type="regular" alignment="center" alignment_tablet="default" alignment_phone="default" constrain_group_3="yes" constrain_group_4="yes" display="block" display_tablet="inherit" display_phone="inherit" icon_family="none" position_desktop="absolute" bottom_position_desktop="40" left_position_desktop="40" right_position_desktop="40" padding_top="0.8em" padding_bottom="0.8em" padding_left="40" padding_right="40" link_text="Get Started"][/vc_column_inner][/vc_row_inner][/tab][tab icon_family="none" title="Pay Yearly" id="1659385701727-9" tab_id="1659385701727-7"][vc_row_inner equal_height="yes" column_margin="40px" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner top_padding_desktop="40" constrain_group_100="yes" bottom_padding_desktop="40" left_padding_desktop="40" constrain_group_101="yes" right_padding_desktop="40" column_element_direction_desktop="default" column_element_spacing="10px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color="#ff6b3d" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" font_color="#ffffff" column_shadow="custom" column_border_radius="15px" column_link_target="_self" zindex="100" overflow="hidden" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" padding_type="advanced" column_padding_type="advanced" column_shadow_custom="" custom_box_shadow="horizontal:40,vertical:60,blur:60,spread:-20,opacity:0.175"][nectar_lottie trigger_type="play" mobile_func="default" loop="true" trigger_offset="0.00,100.00" frame_constraint="0.00,100.00" speed="0.2" width_desktop="150%" height_desktop="150%" alignment="center" preserve_aspect_ratio="xMidYMid meet" position_desktop="absolute" top_position_desktop="0" left_position_desktop="0" translate_y_desktop="-50%" translate_x_desktop="25%" preserveaspectratio="none" json_url="https://assets1.lottiefiles.com/packages/lf20_w4NUp4.json" zindex="-1"][nectar_icon icon_family="iconsmind" icon_style="default" icon_color_type="color_scheme" icon_color="white" icon_padding="0px" pointer_events="all" icon_iconsmind="iconsmind-Plant"][nectar_responsive_text font_style="h4" content_alignment="default" mobile_content_alignment="inherit" font_size="5vw" font_line_height="1" font_size_desktop="2vw" font_size_tablet="3vw" font_size_phone="16"]Basic[/nectar_responsive_text][nectar_responsive_text font_style="h3" content_alignment="default" mobile_content_alignment="inherit" font_size="5vw" font_line_height="1" font_size_desktop="4vw" font_size_tablet="7vw"]Free[/nectar_responsive_text][divider line_type="No Line" custom_height="15"][fancy-ul icon_type="standard_dot" alignment="left" spacing="10px" font_size_min="16px" font_size_desktop="1.1vw"]</p>
<ul>
<li>Live chat widget</li>
<li>Email marketing</li>
<li>Custom Forms</li>
<li>Traffic analytics</li>
</ul>
<p>[/fancy-ul][divider line_type="No Line" custom_height="90"][nectar_cta btn_style="text-reveal-wave" heading_tag="span" button_color="white" text_color="#000000" button_border_thickness="0px" link_type="regular" alignment="center" alignment_tablet="default" alignment_phone="default" constrain_group_3="yes" constrain_group_4="yes" display="block" display_tablet="inherit" display_phone="inherit" icon_family="none" position_desktop="absolute" bottom_position_desktop="40" left_position_desktop="40" right_position_desktop="40" padding_top="0.8em" padding_bottom="0.8em" padding_left="40" padding_right="40" link_text="Get Started"][/vc_column_inner][vc_column_inner top_padding_desktop="40" constrain_group_100="yes" bottom_padding_desktop="40" left_padding_desktop="40" constrain_group_101="yes" right_padding_desktop="40" column_element_direction_desktop="default" column_element_spacing="10px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color="#ffffff" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" font_color="#000000" column_shadow="none" column_border_radius="15px" column_link_target="_self" overflow="visible" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" gradient_type="default"][nectar_icon icon_family="iconsmind" icon_style="default" icon_color_type="color_scheme" icon_color="black" icon_padding="0px" pointer_events="all" icon_iconsmind="iconsmind-Leafs"][nectar_responsive_text font_style="h4" content_alignment="default" mobile_content_alignment="inherit" font_size="5vw" font_line_height="1" font_size_desktop="2vw" font_size_tablet="3vw" font_size_phone="16px"]Premium[/nectar_responsive_text][nectar_price_typography before_text_scale="0.4" after_text_scale="0.4" font_style="h3" price_text="250" before_text="$" after_text="/ year" font_size_desktop="4vw" font_size_tablet="7vw" font_line_height="1.5"][divider line_type="No Line" custom_height="15"][fancy-ul icon_type="standard_dot" alignment="left" spacing="10px" font_size_min="16px" font_size_desktop="1.1vw"]</p>
<ul>
<li>Everything in basic</li>
<li>Marketing automation</li>
<li>Advanced chatbot</li>
<li>Campaign management</li>
<li>Collaboration tools</li>
</ul>
<p>[/fancy-ul][divider line_type="No Line" custom_height="90"][nectar_cta btn_style="text-reveal-wave" heading_tag="span" button_color="accent-color" text_color="#ffffff" button_border_thickness="0px" link_type="regular" alignment="center" alignment_tablet="default" alignment_phone="default" constrain_group_3="yes" constrain_group_4="yes" display="block" display_tablet="inherit" display_phone="inherit" icon_family="none" position_desktop="absolute" bottom_position_desktop="40" left_position_desktop="40" right_position_desktop="40" padding_top="0.8em" padding_bottom="0.8em" padding_left="40" padding_right="40" link_text="Get Started"][/vc_column_inner][vc_column_inner top_padding_desktop="40" constrain_group_100="yes" bottom_padding_desktop="40" left_padding_desktop="40" constrain_group_101="yes" right_padding_desktop="40" column_element_direction_desktop="default" column_element_spacing="10px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color="#ffffff" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="15px" column_link_target="_self" overflow="visible" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="advanced"][nectar_icon icon_family="iconsmind" icon_style="default" icon_color_type="color_scheme" icon_color="black" icon_padding="0px" pointer_events="all" icon_iconsmind="iconsmind-Flowerpot"][nectar_responsive_text font_style="h4" content_alignment="default" mobile_content_alignment="inherit" font_size="5vw" font_line_height="1" font_size_desktop="2vw" font_size_tablet="3vw" font_size_phone="16px"]Platinum[/nectar_responsive_text][nectar_price_typography before_text_scale="0.4" after_text_scale="0.4" font_style="h3" price_text="500" before_text="$" after_text="/ year" font_size_desktop="4vw" font_size_tablet="7vw" font_line_height="1.5"][divider line_type="No Line" custom_height="15"][fancy-ul icon_type="standard_dot" alignment="left" spacing="10px" font_size_min="16px" font_size_desktop="1.1vw"]</p>
<ul>
<li>Everything in premium</li>
<li>A/B testing sanbox</li>
<li>Custom permissions</li>
<li>Social media automation</li>
<li>Sales automation tools</li>
</ul>
<p>[/fancy-ul][divider line_type="No Line" custom_height="90"][nectar_cta btn_style="text-reveal-wave" heading_tag="span" button_color="accent-color" text_color="#ffffff" button_border_thickness="0px" link_type="regular" alignment="center" alignment_tablet="default" alignment_phone="default" constrain_group_3="yes" constrain_group_4="yes" display="block" display_tablet="inherit" display_phone="inherit" icon_family="none" position_desktop="absolute" bottom_position_desktop="40" left_position_desktop="40" right_position_desktop="40" padding_top="0.8em" padding_bottom="0.8em" padding_left="40" padding_right="40" link_text="Get Started"][/vc_column_inner][/vc_row_inner][/tab][/tabbed_section][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Tilted Scrolling Text', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-8-July-2022';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/saas-strips.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#318fff" scene_position="center" top_padding="2%" constrain_group_1="yes" bottom_padding="2%" top_margin="5%" scale_desktop="1.02" rotate_desktop="2" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="hidden" advanced_gradient_angle="0" shape_divider_position="bottom" bg_image_animation="none" gradient_type="advanced" shape_type="" advanced_gradient_display_type="linear"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="0px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="parallax" animation_movement_type="transform_x" column_parallax_intensity="-2.5" persist_movement_on_mobile="true" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="default"][nectar_scrolling_text scroll_direction="rtl" scroll_speed="slowest" text_color="#0a0a0a" style="default" text_repeat_number="5" text_repeat_divider="space" text_space_amount="medium" overflow="visible" background_image_animation="None" custom_font_size="5vw" custom_font_size_mobile="9vw"]
<h2>Grow your business</h2>
[/nectar_scrolling_text][/vc_column][/vc_row][vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#ffce59" scene_position="center" top_padding="2%" constrain_group_1="yes" bottom_padding="2%" bottom_margin="5%" scale_desktop="1.02" rotate_desktop="358" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" zindex="20" overflow="hidden" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="0px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="parallax" animation_movement_type="transform_x" column_parallax_intensity="2.5" persist_movement_on_mobile="true" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="default"][nectar_scrolling_text scroll_direction="ltr" scroll_speed="slowest" text_color="#0a0a0a" style="default" text_repeat_number="5" text_repeat_divider="space" text_space_amount="medium" overflow="visible" background_image_animation="None" custom_font_size="5vw" custom_font_size_mobile="9vw"]
<h2>Grow your business</h2>
[/nectar_scrolling_text][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Clip Path Connected Sections', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-7-July-2022';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/saas-faq-footer.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="8%" left_padding_desktop="10%" constrain_group_2="yes" right_padding_desktop="10%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding="4%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" centered_text="true" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][nectar_highlighted_text style="none" custom_font_size="3vw" font_size_tablet="6vw" font_line_height="1.2"]
<h1>Frequently asked questions</h1>
[/nectar_highlighted_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row type="full_width_content" full_screen_row_position="middle" column_margin="custom" column_margin_custom="7vw" equal_height="yes" content_placement="middle" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#f8f8f8" scene_position="center" top_padding="3%" bottom_padding="12%" left_padding_desktop="7vw" constrain_group_2="yes" right_padding_desktop="7vw" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.8" gradient_direction="left_to_right" enable_shape_divider="true" shape_divider_color="#000000" shape_divider_position="bottom" shape_divider_height="99%" bg_image_animation="clip-path" clip_path_animation_type="scroll" clip_path_animation_applies="default" clip_path_start_bottom_desktop="0" clip_path_start_left_desktop="0" clip_path_start_right_desktop="0" clip_path_end_bottom_desktop="4%" clip_path_end_left_desktop="4%" clip_path_end_right_desktop="4%" clip_path_start_roundness="0" clip_path_end_roundness="20" animation_trigger_offset="32.00,50.00" animation_trigger_origin="bottom" shape_type="straight_section" gradient_type="default"][vc_column left_padding_desktop="2vw" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" gradient_type="default"][toggles style="minimal_shadow" accordion="true" accordion_starting_functionality="default" border_radius="none"][toggle color="Accent-Color" heading_tag="h3" heading_tag_functionality="default" title="What does CRM mean?"][vc_column_text]CRM stands for Content Relationship Management. Using a CRM platform gives everyone involved in your business a way to manage customer interactions to increase growth.[/vc_column_text][/toggle][toggle color="Accent-Color" heading_tag="h3" heading_tag_functionality="default" title="Is it really free to start?"][vc_column_text]Yes! You can opt to stay within the free tier for as long as you want to. It's a great way to get a feel for the platform before deciding to upgrade to take advantage of the more advanced features.[/vc_column_text][/toggle][toggle color="Accent-Color" heading_tag="h3" heading_tag_functionality="default" title="Can I import data?"][vc_column_text]Yes! Getting your existing data in is easy. Simply export your existing customers to a .csv file and import them within a couple of clicks.[/vc_column_text][/toggle][/toggles][/vc_column][vc_column right_padding_desktop="2vw" top_margin_tablet="10%" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" gradient_type="default"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color="#ff6b3d" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="15px" column_link_target="_self" overflow="hidden" advanced_gradient_radial_position="top right" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="advanced" advanced_gradient_display_type="radial"][nectar_animated_shape shape_color="#ffce59" width_desktop="65vw" animation="none" animation_easing="easeInOutCubic" animation_movement_type="transform_y" position_desktop="absolute" top_position_desktop="0" bottom_position_desktop="0" left_position_desktop="0" translate_y_desktop="10%" translate_x_desktop="-50%" zindex="-1" animation_offset="160%"][image_with_animation image_url="https://themenectar.com/img/demo-media/saas/saas-girl.webp" image_size="full" animation_type="entrance" animation="None" animation_movement_type="transform_y" animation_movement_intensity="-0.8" hover_animation="none" alignment="" border_radius="none" box_shadow="custom" box_shadow_method="filter" image_loading="default" max_width="100%" max_width_mobile="default" custom_box_shadow="horizontal:-25,vertical:5,blur:25,spread:0,opacity:0" margin_bottom="-10%" margin_top="5%"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#000000" scene_position="center" top_padding="10%" bottom_padding="10%" left_padding_desktop="6vw" constrain_group_2="yes" right_padding_desktop="6vw" top_padding_tablet="20%" bottom_padding_tablet="10%" text_color="light" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type="" gradient_type="default"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="0px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][vc_row_inner equal_height="yes" content_placement="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding="5%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner right_padding_desktop="25%" bottom_margin_phone="30" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="2/3" tablet_width_inherit="small_desktop" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" gradient_type="default" offset="vc_col-lg-8 vc_col-md-6"][split_line_heading animation_type="line-reveal-by-space" font_style="h2" line_reveal_by_space_text_effect="default" stagger_animation="true" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="Scale your brand and earn more revenue" font_size="4vw"][/split_line_heading][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" bottom_margin_tablet="0" column_element_direction_desktop="default" column_element_spacing="10px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/6" tablet_width_inherit="small_desktop" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default" delay="150" offset="vc_col-lg-2 vc_col-md-3"][vc_column_text]
<h5>Connect</h5>
[/vc_column_text][nectar_cta btn_style="underline" heading_tag="h4" button_color="default" button_border_thickness="0px" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" display="block" display_tablet="inherit" display_phone="inherit" icon_family="none" link_text="Testimonials" url="#features" margin_top="10" font_size_desktop="1.3vw" font_size_tablet="16px"][nectar_cta btn_style="underline" heading_tag="h4" button_color="default" button_border_thickness="0px" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" display="block" display_tablet="inherit" display_phone="inherit" icon_family="none" link_text="Features" url="#features" font_size_desktop="1.3vw" font_size_tablet="16px"][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="10px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/6" tablet_width_inherit="small_desktop" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default" delay="300" offset="vc_col-lg-2 vc_col-md-3"][vc_column_text]
<h5>Contact Us</h5>
[/vc_column_text][nectar_cta btn_style="underline" heading_tag="h4" button_color="default" button_border_thickness="0px" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" display="block" display_tablet="inherit" display_phone="inherit" icon_family="none" link_text="+216 (0)40 3629 4753" margin_top="10" font_size_desktop="1.3vw" font_size_tablet="16px"][nectar_cta btn_style="underline" heading_tag="h4" button_color="default" button_border_thickness="0px" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" display="block" display_tablet="inherit" display_phone="inherit" icon_family="none" link_text="hello@domain.com" font_size_desktop="1.3vw" font_size_tablet="16px"][/vc_column_inner][/vc_row_inner][vc_row_inner equal_height="yes" content_placement="top" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" bottom_margin_phone="30" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="2/3" tablet_width_inherit="small_desktop" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][nectar_cta btn_style="text-reveal-wave" heading_tag="h6" button_color="accent-color" text_color="#ffffff" button_border_thickness="0px" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" constrain_group_3="yes" constrain_group_4="yes" display="block" display_tablet="inherit" display_phone="inherit" icon_family="none" font_size_desktop="1.1vw" link_text="Start your trial" url="#" padding_top="1em" padding_bottom="1em" padding_left="2.5em" padding_right="2.5em" font_size_tablet="16"][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="small_desktop" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" mobile_disable_entrance_animation="true" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default" delay="150" animation_offset="110%"][nectar_responsive_text]©  [nectar_current_year]. Website built with <a href="https://themenectar.com/salient">Salient</a>.[/nectar_responsive_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Happy FAQ Section', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['about'];
$data['custom_class'] = 'about date-7-July-2022';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/saas-faq.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="8%" left_padding_desktop="10%" constrain_group_2="yes" right_padding_desktop="10%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding="4%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" centered_text="true" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][nectar_highlighted_text style="none" custom_font_size="3vw" font_size_tablet="6vw" font_line_height="1.2"]
<h1>Frequently asked questions</h1>
[/nectar_highlighted_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row type="full_width_content" full_screen_row_position="middle" column_margin="custom" column_margin_custom="7vw" equal_height="yes" content_placement="middle" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#f8f8f8" scene_position="center" top_padding="3%" bottom_padding="12%" left_padding_desktop="7vw" constrain_group_2="yes" right_padding_desktop="7vw" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.8" gradient_direction="left_to_right" shape_divider_color="#000000" shape_divider_position="bottom" shape_divider_height="99%" bg_image_animation="none" shape_type="straight_section" gradient_type="default"][vc_column left_padding_desktop="2vw" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" gradient_type="default"][toggles style="minimal_shadow" accordion="true" accordion_starting_functionality="default" border_radius="none"][toggle color="Accent-Color" heading_tag="h3" heading_tag_functionality="default" title="What does CRM mean?"][vc_column_text]CRM stands for Content Relationship Management. Using a CRM platform gives everyone involved in your business a way to manage customer interactions to increase growth.[/vc_column_text][/toggle][toggle color="Accent-Color" heading_tag="h3" heading_tag_functionality="default" title="Is it really free to start?"][vc_column_text]Yes! You can opt to stay within the free tier for as long as you want to. It's a great way to get a feel for the platform before deciding to upgrade to take advantage of the more advanced features.[/vc_column_text][/toggle][toggle color="Accent-Color" heading_tag="h3" heading_tag_functionality="default" title="Can I import data?"][vc_column_text]Yes! Getting your existing data in is easy. Simply export your existing customers to a .csv file and import them within a couple of clicks.[/vc_column_text][/toggle][/toggles][/vc_column][vc_column right_padding_desktop="2vw" top_margin_tablet="10%" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" gradient_type="default"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color="#ff6b3d" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="15px" column_link_target="_self" overflow="hidden" advanced_gradient_radial_position="top right" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="advanced" advanced_gradient_display_type="radial"][nectar_animated_shape shape_color="#ffce59" width_desktop="65vw" animation="none" animation_easing="easeInOutCubic" animation_movement_type="transform_y" position_desktop="absolute" top_position_desktop="0" bottom_position_desktop="0" left_position_desktop="0" translate_y_desktop="10%" translate_x_desktop="-50%" zindex="-1" animation_offset="160%"][image_with_animation image_url="https://themenectar.com/img/demo-media/saas/saas-girl.webp" image_size="full" animation_type="entrance" animation="None" animation_movement_type="transform_y" animation_movement_intensity="-0.8" hover_animation="none" alignment="" border_radius="none" box_shadow="custom" box_shadow_method="filter" image_loading="default" max_width="100%" max_width_mobile="default" custom_box_shadow="horizontal:-25,vertical:5,blur:25,spread:0,opacity:0" margin_bottom="-10%" margin_top="5%"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Dark SAAS Footer', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-7-July-2022';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/saas-footer.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#000000" scene_position="center" top_padding="10%" bottom_padding="10%" left_padding_desktop="6vw" constrain_group_2="yes" right_padding_desktop="6vw" top_padding_tablet="20%" bottom_padding_tablet="10%" text_color="light" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type="" gradient_type="default"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="0px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][vc_row_inner equal_height="yes" content_placement="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding="5%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner right_padding_desktop="25%" bottom_margin_phone="30" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="2/3" tablet_width_inherit="small_desktop" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" gradient_type="default" offset="vc_col-lg-8 vc_col-md-6"][split_line_heading animation_type="line-reveal-by-space" font_style="h2" line_reveal_by_space_text_effect="default" stagger_animation="true" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="Scale your brand and earn more revenue" font_size="4vw"][/split_line_heading][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" bottom_margin_tablet="0" column_element_direction_desktop="default" column_element_spacing="10px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/6" tablet_width_inherit="small_desktop" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default" delay="150" offset="vc_col-lg-2 vc_col-md-3"][vc_column_text]
<h5>Connect</h5>
[/vc_column_text][nectar_cta btn_style="underline" heading_tag="h4" button_color="default" button_border_thickness="0px" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" display="block" display_tablet="inherit" display_phone="inherit" icon_family="none" link_text="Testimonials" url="#features" margin_top="10" font_size_desktop="1.3vw" font_size_tablet="16px"][nectar_cta btn_style="underline" heading_tag="h4" button_color="default" button_border_thickness="0px" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" display="block" display_tablet="inherit" display_phone="inherit" icon_family="none" link_text="Features" url="#features" font_size_desktop="1.3vw" font_size_tablet="16px"][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="10px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/6" tablet_width_inherit="small_desktop" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default" delay="300" offset="vc_col-lg-2 vc_col-md-3"][vc_column_text]
<h5>Contact Us</h5>
[/vc_column_text][nectar_cta btn_style="underline" heading_tag="h4" button_color="default" button_border_thickness="0px" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" display="block" display_tablet="inherit" display_phone="inherit" icon_family="none" link_text="+216 (0)40 3629 4753" margin_top="10" font_size_desktop="1.3vw" font_size_tablet="16px"][nectar_cta btn_style="underline" heading_tag="h4" button_color="default" button_border_thickness="0px" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" display="block" display_tablet="inherit" display_phone="inherit" icon_family="none" link_text="hello@domain.com" font_size_desktop="1.3vw" font_size_tablet="16px"][/vc_column_inner][/vc_row_inner][vc_row_inner equal_height="yes" content_placement="top" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" bottom_margin_phone="30" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="2/3" tablet_width_inherit="small_desktop" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][nectar_cta btn_style="text-reveal-wave" heading_tag="h6" button_color="accent-color" text_color="#ffffff" button_border_thickness="0px" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" constrain_group_3="yes" constrain_group_4="yes" display="block" display_tablet="inherit" display_phone="inherit" icon_family="none" font_size_desktop="1.1vw" link_text="Start your trial" url="#" padding_top="1em" padding_bottom="1em" padding_left="2.5em" padding_right="2.5em" font_size_tablet="16"][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="small_desktop" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" mobile_disable_entrance_animation="true" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default" delay="150" animation_offset="110%"][nectar_responsive_text]©  [nectar_current_year]. Website built with <a href="https://themenectar.com/salient">Salient</a>.[/nectar_responsive_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Animated Gradient Hero', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['hero_section'] . ', ' . $cat_display_names['lottie'];
$data['custom_class'] = 'hero_section lottie date-7-July-2022';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/2022-promo-heading.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" equal_height="yes" content_placement="middle" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#edeef1" full_height="yes" columns_placement="stretch" animated_gradient_bg="true" animated_gradient_bg_color_1="#ffb71e" animated_gradient_bg_speed="850" animated_gradient_bg_blending_mode="linear" scene_position="center" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="hidden" advanced_gradient_angle="15" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="clip-path" clip_path_animation_type="default" clip_path_animation_applies="row" clip_path_start_top_desktop="0px" clip_path_start_bottom_desktop="0px" clip_path_start_left_desktop="0px" clip_path_start_right_desktop="0px" clip_path_end_top_desktop="30px" clip_path_end_bottom_desktop="30px" clip_path_end_left_desktop="30px" clip_path_end_right_desktop="30px" clip_path_end_top_phone="50px" clip_path_end_bottom_phone="24px" clip_path_end_left_phone="24px" clip_path_end_right_phone="24px" clip_path_start_roundness="0" clip_path_end_roundness="20px" clip_path_animation_addon="none" video_mute="true" shape_type="straight_section" gradient_type="default" bg_image_animation_delay="1000"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="0px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="static" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="parallax" animation_movement_type="default" column_parallax_intensity="-4" bg_image_animation="none" parallax_bg="true" parallax_bg_speed="medium_fast" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="default"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding="4%" bottom_padding="30" left_padding_desktop="22%" constrain_group_2="yes" right_padding_desktop="22%" left_padding_phone="14%" constrain_group_6="yes" right_padding_phone="14%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_element_direction_desktop="default" column_element_spacing="default" centered_text="true" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="1" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="slight-twist" animation_easing="easeInOutCubic" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_color="rgba(255,255,255,0.22)" column_border_style="solid" gradient_type="default" column_padding_type="advanced" delay="200"][nectar_highlighted_text scribble_color="#000000" style="scribble" scribble_shape="basic-underline" scribble_thickness="thin" scribble_speed="1.6s" scribble_easing="ease_out" custom_font_size="6vw" delay="1000" font_size_tablet="6vw" font_line_height="1.1" font_size_phone="10vw"]
<h1><strong><em>Beautiful</em></strong> websites with less work</h1>
[/nectar_highlighted_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner left_padding_desktop="38%" constrain_group_101="yes" right_padding_desktop="38%" left_padding_tablet="30%" constrain_group_103="yes" right_padding_tablet="30%" left_padding_phone="20%" constrain_group_105="yes" right_padding_phone="20%" column_element_direction_desktop="default" column_element_spacing="default" centered_text="true" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="1" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="slight-twist" animation_easing="easeInOutCubic" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_color="rgba(255,255,255,0.22)" column_border_style="solid" gradient_type="default" column_padding_type="advanced"][split_line_heading animation_type="line-reveal-by-space" font_style="p" line_reveal_by_space_text_effect="default" stagger_animation="true" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="A next-generation WordPress theme that brings professional design results to anyone, without any coding required." font_size="1.2vw" font_line_height="1.6" animation_delay="1200" font_size_tablet="16"][/split_line_heading][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="absolute" row_position_tablet="inherit" row_position_phone="inherit" bottom_position_desktop="60" left_position_desktop="60" zindex="10" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="10px" centered_text="true" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" delay="1300" animation_offset="100%" column_padding_type="default" offset="vc_hidden-sm vc_hidden-xs"][nectar_circle_images images="https://themenectar.com/img/demo-media/unsplash/webp/ff1dfc85f81f.webp,https://themenectar.com/img/demo-media/unsplash/webp/fc2fcf082f87.webp,https://themenectar.com/img/demo-media/unsplash/webp/c5799533a786.webp,https://themenectar.com/img/demo-media/unsplash/webp/adf270f4f417.webp" sizing="40px" positioning="overlapping" stacking_order="ltr" alignment="left" animation="none" image_size="nectar_small_square" image_loading="default"][nectar_responsive_text]<strong>6k+ reviews</strong> (4.8 <em>of</em> 5)[/nectar_responsive_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" translate_x="-50%" text_align="left" row_position="absolute" row_position_tablet="inherit" row_position_phone="inherit" bottom_position_desktop="60" left_position_desktop="50%" zindex="10" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" delay="1500" animation_offset="100%" column_padding_type="default" offset="vc_hidden-lg vc_hidden-md"][nectar_cta btn_style="text-reveal-wave" heading_tag="span" button_color="default" button_border_thickness="0px" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" display="block" display_tablet="inherit" display_phone="inherit" icon_family="none" link_text="Scroll Down" url="#intro"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="absolute" row_position_tablet="inherit" row_position_phone="inherit" bottom_position_desktop="60" right_position_desktop="60" zindex="10" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="0px" centered_text="true" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" delay="1300" animation_offset="100%" column_padding_type="default" offset="vc_hidden-sm vc_hidden-xs"][nectar_lottie trigger_type="play" mobile_func="default" loop="true" trigger_offset="0.00,100.00" frame_constraint="0.00,100.00" speed="0.8" width_desktop="55px" alignment="center" preserve_aspect_ratio="xMidYMid meet" json_url="https://assets1.lottiefiles.com/packages/lf20_9r65d17y.json"][nectar_responsive_text font_line_height="1.3"]<strong>Salient</strong>[/nectar_responsive_text][nectar_responsive_text font_line_height="1.3" font_size_desktop="0.9em"]<em>by</em> ThemeNectar[/nectar_responsive_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Sticky Media Sections', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-7-July-2022';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/2022-promo-sticky-media.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#ffffff" scene_position="center" top_padding="7%" bottom_padding="10%" left_padding_desktop="6%" constrain_group_2="yes" right_padding_desktop="6%" left_padding_tablet="8%" constrain_group_4="yes" right_padding_tablet="8%" top_padding_phone="25%" left_padding_phone="24px" constrain_group_6="yes" right_padding_phone="24px" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" zindex="10" overflow="visible" id="features" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_color="#0a0a0a" shape_divider_position="top" shape_divider_height="1" bg_image_animation="none" gradient_type="default" shape_type="straight_section"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][nectar_sticky_media_sections type="default" content_position="right" content_spacing="45vh" media_width="60%" media_height="75vh" mobile_aspect_ratio="4-3" border_radius="15px"][nectar_sticky_media_section section_type="image" image="https://themenectar.com/img/demo-media/promo/sticky-media-1.jpg" link_target="_self"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding="15vh" top_padding_tablet="0" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][split_line_heading animation_type="line-reveal-by-space" font_style="h2" line_reveal_by_space_text_effect="none" stagger_animation="true" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="Template library" font_size="3vw"][/split_line_heading][nectar_responsive_text inherited_font_style="default" font_size_min="16px" font_size_max="21px" font_size_desktop="1.2vw" font_line_height="1.7"]Not all templates are created equal. Salient offers access to a perpetually updated library of <strong>professional</strong> section templates, with currently over 400 to choose from — all created with passion and held to a high standard for aesthetic quality.[/nectar_responsive_text][/vc_column_inner][/vc_row_inner][/nectar_sticky_media_section][nectar_sticky_media_section section_type="image" image="https://themenectar.com/img/demo-media/promo/sticky-media-2.jpg" link_target="_self"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][split_line_heading animation_type="line-reveal-by-space" font_style="h2" line_reveal_by_space_text_effect="none" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="Visual page builder" font_size="3vw"][/split_line_heading][nectar_responsive_text inherited_font_style="default" font_size_min="16px" font_size_max="21px" font_size_desktop="1.2vw" font_line_height="1.7"]Build like it's [nectar_current_year]. Experience a high-performing, modern take on the WPBakery page builder — The editor you already know, but with supercharged power to handle complex designs and the flexibility to <strong>create any type of website.</strong>[/nectar_responsive_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding="30" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][fancy-ul icon_type="standard_dot" alignment="left" spacing="10px" font_size_min="16px" font_size_max="21px" link_style="default" font_size_desktop="1.2vw"]
<ul>
 	<li>Set option values unique based on screen size</li>
 	<li>Sidebar &amp; modal editing layout options</li>
 	<li>Visually intuitive graphical settings UI</li>
 	<li>Front-end &amp; back-end editors</li>
 	<li>Reusable global sections</li>
 	<li>Tree-list element view</li>
</ul>
[/fancy-ul][/vc_column_inner][/vc_row_inner][/nectar_sticky_media_section][nectar_sticky_media_section section_type="image" image="https://themenectar.com/img/demo-media/promo/sticky-media-3.jpg" link_target="_self"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding="15vh" bottom_padding_tablet="0" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][split_line_heading animation_type="line-reveal-by-space" font_style="h2" line_reveal_by_space_text_effect="none" stagger_animation="true" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="Premium elements" font_size="3vw"][/split_line_heading][nectar_responsive_text inherited_font_style="default" font_size_min="16px" font_size_max="21px" font_size_desktop="1.2vw" font_line_height="1.7"]A unique collection of over <strong>65 elements</strong> that make building a beautiful site easy. The Salient element set brings the latest web trends to your fingertips without any coding needed. We actively seek to bring fresh innovation by pushing the boundaries of what's possible on the web.[/nectar_responsive_text][/vc_column_inner][/vc_row_inner][/nectar_sticky_media_section][/nectar_sticky_media_sections][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Trust-Building Section', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-5-July-2022';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/2022-promo-trusted.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#ffffff" animated_gradient_bg="true" animated_gradient_bg_color_1="#ffb10a" animated_gradient_bg_speed="850" animated_gradient_bg_blending_mode="linear" scene_position="center" top_padding="1%" bottom_padding="10%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" zindex="2" overflow="visible" id="trusted" advanced_gradient="linear-gradient(0deg, rgb(255,255,255) 4%, rgba(255,255,255,0) 30%, rgba(255,255,255,0) 75%, rgb(255,255,255) 96%)" shape_divider_position="bottom" bg_image_animation="none" gradient_type="advanced" shape_type="" advanced_gradient_display_type="linear"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="0px" centered_text="true" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="static" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][carousel script="flickity" flickity_formatting="default" desktop_cols_flickity="6" desktop_small_cols_flickity="6" tablet_cols_flickity="5" phone_cols_flickity="4" flickity_controls="none" color="default" flickity_overflow="hidden" flickity_wrap_around="wrap" flickity_spacing="default" flickity_column_vertical_alignment="middle" column_padding="custom" column_padding_custom="4vw" flickity_element_spacing="default" border_radius="none" autorotate="true" autorotate_type="ticker" ticker_speed="slow"][item simple_slider_bg_image_position="default" simple_slider_overlay_strength="0.3" simple_slider_bg_image_loading="default" id="1659369460849-3" title="Item" tab_id="1659369460849-4"][image_with_animation image_url="https://themenectar.com/demo/dummy-data-imgs/tn-sample-logo.png" image_size="full" animation_type="entrance" animation="None" animation_movement_type="transform_y" hover_animation="none" alignment="" border_radius="none" box_shadow="none" image_loading="default" max_width="100%" max_width_mobile="default"][/item][item simple_slider_bg_image_position="default" simple_slider_overlay_strength="0.3" simple_slider_bg_image_loading="default" id="1659369460857-0" title="Item" tab_id="1659369460857-3"][image_with_animation image_url="https://themenectar.com/demo/dummy-data-imgs/tn-sample-logo.png" image_size="full" animation_type="entrance" animation="None" animation_movement_type="transform_y" hover_animation="none" alignment="" border_radius="none" box_shadow="none" image_loading="default" max_width="100%" max_width_mobile="default"][/item][item simple_slider_bg_image_position="default" simple_slider_overlay_strength="0.3" simple_slider_bg_image_loading="default" id="1659369460865-3" title="Item" tab_id="1659369460865-3"][image_with_animation image_url="https://themenectar.com/demo/dummy-data-imgs/tn-sample-logo.png" image_size="full" animation_type="entrance" animation="None" animation_movement_type="transform_y" hover_animation="none" alignment="" border_radius="none" box_shadow="none" image_loading="default" max_width="100%" max_width_mobile="default"][/item][item simple_slider_bg_image_position="default" simple_slider_overlay_strength="0.3" simple_slider_bg_image_loading="default" id="1659369460873-1" title="Item" tab_id="1659369460873-7"][image_with_animation image_url="https://themenectar.com/demo/dummy-data-imgs/tn-sample-logo.png" image_size="full" animation_type="entrance" animation="None" animation_movement_type="transform_y" hover_animation="none" alignment="" border_radius="none" box_shadow="none" image_loading="default" max_width="100%" max_width_mobile="default"][/item][item simple_slider_bg_image_position="default" simple_slider_overlay_strength="0.3" simple_slider_bg_image_loading="default" id="1659369460885-5" title="Item" tab_id="1659369460886-9"][image_with_animation image_url="https://themenectar.com/demo/dummy-data-imgs/tn-sample-logo.png" image_size="full" animation_type="entrance" animation="None" animation_movement_type="transform_y" hover_animation="none" alignment="" border_radius="none" box_shadow="none" image_loading="default" max_width="100%" max_width_mobile="default"][/item][item simple_slider_bg_image_position="default" simple_slider_overlay_strength="0.3" simple_slider_bg_image_loading="default" id="1659369460897-0" title="Item" tab_id="1659369460898-7"][image_with_animation image_url="https://themenectar.com/demo/dummy-data-imgs/tn-sample-logo.png" image_size="full" animation_type="entrance" animation="None" animation_movement_type="transform_y" hover_animation="none" alignment="" border_radius="none" box_shadow="none" image_loading="default" max_width="100%" max_width_mobile="default"][/item][item simple_slider_bg_image_position="default" simple_slider_overlay_strength="0.3" simple_slider_bg_image_loading="default" id="1659369460909-6" title="Item" tab_id="1659369460909-6"][image_with_animation image_url="https://themenectar.com/demo/dummy-data-imgs/tn-sample-logo.png" image_size="full" animation_type="entrance" animation="None" animation_movement_type="transform_y" hover_animation="none" alignment="" border_radius="none" box_shadow="none" image_loading="default" max_width="100%" max_width_mobile="default"][/item][/carousel][divider line_type="No Line" custom_height="8vh" custom_height_phone="2vh"][split_line_heading animation_type="line-reveal-by-space" font_style="h3" line_reveal_by_space_text_effect="none" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="Trusted by" font_size="6vw" font_line_height="1"][/split_line_heading][nectar_rotating_words_title heading_tag="h3" dynamic_text="130k websites, industry leaders, top designers" duration="3000" dynamic_heading_tag="default" element_animation="none" mobile_display="inline" font_size="6vw"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Features Grid #1', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'] . ', ' . $cat_display_names['lottie'];
$data['custom_class'] = 'general lottie date-6-July-2022';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/2022-promo-features-1.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="20px" equal_height="yes" content_placement="top" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#f0f2f6" scene_position="center" top_padding="4%" constrain_group_1="yes" bottom_padding="4%" left_padding_desktop="5%" constrain_group_2="yes" right_padding_desktop="5%" left_padding_phone="14px" constrain_group_6="yes" right_padding_phone="14px" bottom_margin="0" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" zindex="10" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type="" gradient_type="default"][vc_column top_padding_desktop="4vw" bottom_padding_desktop="1vw" left_padding_desktop="4vw" constrain_group_101="yes" right_padding_desktop="4vw" top_padding_tablet="8vw" left_padding_tablet="8vw" constrain_group_103="yes" right_padding_tablet="8vw" bottom_margin_tablet="20" column_element_direction_desktop="default" column_element_spacing="10px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color="#ffffff" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="20px" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="advanced"][nectar_badge display_tag="label" badge_style="default" bg_color_type="custom" bg_color_custom="#3452ff" text_color="#ffffff" padding="small" border_radius="20px" display="block" text="New" margin_bottom="20"][nectar_responsive_text font_size_desktop="1.8vw" font_size_tablet="22px" font_line_height="1.3"]
<h3>Lottie Integration</h3>
[/nectar_responsive_text][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner right_padding_tablet="33vw" right_padding_phone="0" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" gradient_type="default"][nectar_responsive_text font_size_min="14px" font_size_max="20px" font_size_desktop="1.1vw" font_line_height="1.5"]Tap into a vast library of free, beautiful animations or create your own using Adobe After Effects.[/nectar_responsive_text][/vc_column_inner][/vc_row_inner][nectar_lottie trigger_type="play" mobile_func="default" loop="true" trigger_offset="0.00,100.00" frame_constraint="0.00,100.00" speed="0.8" width_desktop="90%" width_tablet="70%" width_phone="90%" alignment="center" preserve_aspect_ratio="xMidYMid meet" json_url="https://assets2.lottiefiles.com/packages/lf20_f8xnmcvu.json"][/vc_column][vc_column top_padding_desktop="4vw" constrain_group_100="yes" bottom_padding_desktop="4vw" left_padding_desktop="4vw" constrain_group_101="yes" right_padding_desktop="4vw" top_padding_tablet="8vw" constrain_group_102="yes" bottom_padding_tablet="8vw" left_padding_tablet="8vw" constrain_group_103="yes" right_padding_tablet="8vw" bottom_margin_tablet="20" column_element_direction_desktop="default" column_element_spacing="10px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color="#3452ff" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" font_color="#ffffff" column_shadow="none" column_border_radius="20px" column_link_target="_self" column_position="default" advanced_gradient_angle="135" width="1/3" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="advanced" advanced_gradient_display_type="linear" column_padding_type="advanced"][nectar_responsive_text font_size_desktop="1.8vw" font_size_tablet="22px" font_line_height="1.3"]
<h3>Mega Menu Builder</h3>
[/nectar_responsive_text][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner right_padding_tablet="33vw" right_padding_phone="0" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" gradient_type="default"][nectar_responsive_text font_size_min="14px" font_size_max="20px" font_size_desktop="1.1vw" font_line_height="1.5"]Build gorgeous megamenus with columns, images, icons, and buttons all through an easy interface.[/nectar_responsive_text][/vc_column_inner][/vc_row_inner][image_with_animation image_url="https://themenectar.com/img/demo-media/promo/megamenu.webp" image_size="full" animation_type="entrance" animation="None" animation_movement_type="transform_y" hover_animation="none" alignment="center" border_radius="none" box_shadow="none" image_loading="default" max_width="110%" max_width_mobile="default" margin_top="13%"][/vc_column][vc_column top_padding_desktop="4vw" constrain_group_100="yes" bottom_padding_desktop="4vw" left_padding_desktop="4vw" constrain_group_101="yes" right_padding_desktop="4vw" top_padding_tablet="8vw" constrain_group_102="yes" bottom_padding_tablet="8vw" left_padding_tablet="8vw" constrain_group_103="yes" right_padding_tablet="8vw" column_element_direction_desktop="default" column_element_spacing="10px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color="#ffc444" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" font_color="#000000" column_shadow="none" column_border_radius="20px" column_link_target="_self" column_position="default" overflow="hidden" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" gradient_type="default"][nectar_responsive_text font_size_desktop="1.8vw" font_size_tablet="22px" font_line_height="1.3"]
<h3>Search With Substance</h3>
[/nectar_responsive_text][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner right_padding_tablet="33vw" right_padding_phone="0" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" gradient_type="default"][nectar_responsive_text font_size_min="14px" font_size_max="20px" font_size_desktop="1.1vw" font_line_height="1.5"]Advanced AJAX search functionality with multiple layout options that are capable of bringing up results in real-time.[/nectar_responsive_text][/vc_column_inner][/vc_row_inner][divider line_type="No Line" custom_height_tablet="60vw"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" min_width_desktop="152%" row_position="absolute" row_position_tablet="inherit" row_position_phone="inherit" bottom_position_desktop="-8%" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="custom" top_left_border_radius="20px" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][image_with_animation image_url="https://themenectar.com/img/demo-media/promo/promo-search.jpg" image_size="full" animation_type="entrance" animation="None" animation_movement_type="transform_y" hover_animation="none" alignment="" border_radius="none" box_shadow="none" image_loading="default" max_width="100%" max_width_mobile="default"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Features Grid #2', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'] . ', ' . $cat_display_names['lottie'];
$data['custom_class'] = 'general lottie date-5-July-2022';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/2022-promo-features-2.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="20px" equal_height="yes" content_placement="top" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#f0f2f6" scene_position="center" top_padding="4%" constrain_group_1="yes" bottom_padding="4%" left_padding_desktop="5%" constrain_group_2="yes" right_padding_desktop="5%" left_padding_phone="14px" constrain_group_6="yes" right_padding_phone="14px" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" zindex="10" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type="" gradient_type="default"][vc_column top_padding_desktop="4vw" constrain_group_100="yes" bottom_padding_desktop="4vw" left_padding_desktop="4vw" constrain_group_101="yes" right_padding_desktop="4vw" top_padding_tablet="8vw" constrain_group_102="yes" bottom_padding_tablet="8vw" left_padding_tablet="8vw" constrain_group_103="yes" right_padding_tablet="8vw" bottom_margin_tablet="20" column_element_direction_desktop="default" column_element_spacing="0px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color="#ffffff" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="15px" column_link_target="_self" column_position="default" overflow="hidden" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="7/12" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_color="rgba(10,10,10,0.1)" column_border_style="solid" gradient_type="default" column_padding_type="advanced"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner right_padding_desktop="25%" right_padding_tablet="33vw" right_padding_phone="0" column_element_direction_desktop="default" column_element_spacing="10px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" font_color="#0a0000" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="advanced"][nectar_responsive_text font_size_desktop="1.8vw" font_size_tablet="22px" font_line_height="1.3"]
<h3>Responsive Editing</h3>
[/nectar_responsive_text][nectar_responsive_text font_size_min="14px" font_size_max="20px" font_size_desktop="1.1vw" font_line_height="1.5"]Maximize your control and create intricate responsive layouts with the ability to control settings uniquely per each device viewport.[/nectar_responsive_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="relative" row_position_tablet="inherit" row_position_phone="inherit" top_position_desktop="10%" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][image_with_animation image_url="https://themenectar.com/img/demo-media/promo/promo-responsive.jpg" image_size="full" animation_type="entrance" animation="None" animation_movement_type="transform_y" hover_animation="none" alignment="" border_radius="none" box_shadow="none" image_loading="default" max_width="100%" max_width_mobile="default"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column top_padding_desktop="4vw" constrain_group_100="yes" bottom_padding_desktop="4vw" left_padding_desktop="4vw" constrain_group_101="yes" right_padding_desktop="4vw" top_padding_tablet="8vw" constrain_group_102="yes" bottom_padding_tablet="8vw" left_padding_tablet="8vw" constrain_group_103="yes" right_padding_tablet="8vw" column_element_direction_desktop="default" column_element_spacing="20px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color="#ffffff" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" font_color="#000000" column_shadow="none" column_border_radius="15px" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="5/12" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_color="rgba(0,0,0,0.15)" column_border_style="solid" gradient_type="default" column_padding_type="advanced"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner right_padding_tablet="33vw" right_padding_phone="0" column_element_direction_desktop="default" column_element_spacing="10px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" font_color="#000000" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="advanced"][nectar_badge display_tag="label" badge_style="default" bg_color_type="global" color="accent-color" text_color="#ffffff" padding="small" border_radius="20px" display="block" text="New" margin_bottom="20"][nectar_responsive_text font_size_desktop="1.8vw" font_size_tablet="22px" font_line_height="1.3"]
<h3>Global Sections</h3>
[/nectar_responsive_text][nectar_responsive_text font_size_min="14px" font_size_max="20px" font_size_desktop="1.1vw" font_line_height="1.5"]The easy way to manage a section that you place on multiple pages of your site. Edits made in one location will instantly reflect in all instances where the section is used.[/nectar_responsive_text][divider line_type="No Line" custom_height="1vh"][/vc_column_inner][/vc_row_inner][nectar_lottie trigger_type="play" mobile_func="default" trigger_offset="10.00,100.00" frame_constraint="0.00,100.00" width_desktop="80%" alignment="center" preserve_aspect_ratio="xMidYMid meet" enable_shadow="true" json_url="https://assets4.lottiefiles.com/packages/lf20_zxmqc93z.json" custom_box_shadow="horizontal:0,vertical:25,blur:14,spread:0,opacity:0.075"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Features Grid #4', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-3-July-2022';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/2022-promo-features-4.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="20px" equal_height="yes" content_placement="top" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#f0f2f6" scene_position="center" top_padding="4%" constrain_group_1="yes" bottom_padding="4%" left_padding_desktop="5%" constrain_group_2="yes" right_padding_desktop="5%" left_padding_phone="14px" constrain_group_6="yes" right_padding_phone="14px" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" zindex="10" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type="" gradient_type="default"][vc_column top_padding_desktop="4vw" left_padding_desktop="4vw" constrain_group_101="yes" right_padding_desktop="4vw" top_padding_tablet="8vw" left_padding_tablet="8vw" constrain_group_103="yes" right_padding_tablet="8vw" bottom_margin_tablet="20" column_element_direction_desktop="default" column_element_spacing="20px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color="#ffc444" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" font_color="#000000" column_shadow="none" column_border_radius="15px" column_link_target="_self" column_position="default" overflow="hidden" advanced_gradient_angle="150" width="5/12" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_color="rgba(0,0,0,0.15)" column_border_style="solid" gradient_type="advanced" advanced_gradient_display_type="linear" column_padding_type="advanced"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner right_padding_tablet="33vw" right_padding_phone="0" column_element_direction_desktop="default" column_element_spacing="10px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="advanced"][nectar_responsive_text font_size_desktop="1.8vw" font_size_tablet="22px" font_line_height="1.3"]
<div class="wpb_text_column wpb_content_element vc_custom_1490624298920">
<div class="wpb_wrapper">
<h3>Free Updates for Life</h3>
</div>
</div>
[/nectar_responsive_text][nectar_responsive_text font_size_min="14px" font_size_max="20px" font_size_desktop="1.1vw" font_line_height="1.5"]Over the past 10 years, we've consistently released updates with new features and fixes. You'll get free access to all future updates with a single purchase.[/nectar_responsive_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" min_width_desktop="100%" row_position="relative" row_position_tablet="inherit" row_position_phone="inherit" zindex="100" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][image_with_animation image_url="https://themenectar.com/img/demo-media/promo/promo-updates.png" image_size="full" animation_type="entrance" animation="None" animation_movement_type="transform_y" hover_animation="none" alignment="center" border_radius="none" box_shadow="none" image_loading="default" max_width="custom" max_width_custom="90%"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="0px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="15px" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="7/12" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="default"][vc_row_inner equal_height="yes" content_placement="top" column_margin="20px" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding="20px" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all" css=".vc_custom_1659929996435{margin-bottom: 0px !important;}"][vc_column_inner top_padding_desktop="4vw" constrain_group_100="yes" bottom_padding_desktop="4vw" left_padding_desktop="4vw" right_padding_desktop="60%" top_padding_tablet="8vw" constrain_group_102="yes" bottom_padding_tablet="8vw" left_padding_tablet="8vw" right_padding_tablet="50%" right_padding_phone="40%" bottom_margin_tablet="0" column_element_direction_desktop="default" column_element_spacing="10px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color="#3452ff" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" font_color="#ffffff" column_shadow="none" column_border_radius="15px" column_link_target="_self" overflow="hidden" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="advanced"][nectar_responsive_text font_size_desktop="1.8vw" font_size_tablet="22px" font_line_height="1.3"]
<h3>Google Fonts</h3>
[/nectar_responsive_text][nectar_responsive_text font_size_min="14px" font_size_max="20px" font_size_desktop="1.1vw" font_line_height="1.5"]Choose from over 1,400 Google fonts with powerful responsive typography settings.[/nectar_responsive_text][image_with_animation image_url="https://themenectar.com/img/demo-media/promo/promo-google-fonts-logo.webp" image_size="full" animation_type="entrance" animation="None" animation_movement_type="transform_y" hover_animation="none" alignment="right" border_radius="none" box_shadow="none" image_loading="default" max_width="custom" position_desktop="absolute" top_position_desktop="20%" right_position_desktop="5%" top_position_phone="50%" right_position_phone="10%" translate_y_phone="-50%" max_width_custom="23vw" max_width_custom_tablet="35vw" max_width_custom_phone="18vw"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner top_padding_desktop="4vw" constrain_group_100="yes" bottom_padding_desktop="4vw" left_padding_desktop="4vw" constrain_group_101="yes" right_padding_desktop="4vw" top_padding_tablet="8vw" constrain_group_102="yes" bottom_padding_tablet="8vw" left_padding_tablet="8vw" constrain_group_103="yes" right_padding_tablet="8vw" bottom_margin="0" column_element_direction_desktop="default" column_element_spacing="10px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color="#ffffff" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" font_color="#0a0000" column_shadow="none" column_border_radius="20px" column_link_target="_self" overflow="visible" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_color="rgba(0,0,0,0.15)" column_border_style="solid" gradient_type="default" column_padding_type="advanced"][nectar_responsive_text font_size_desktop="1.8vw" font_size_tablet="22px" font_line_height="1.3"]
<h3>Blazing Performance</h3>
[/nectar_responsive_text][nectar_responsive_text font_size_min="14px" font_size_max="20px" font_size_desktop="1.1vw" font_line_height="1.5"]Salient is Built with modern tooling and includes a suite of simple to use, yet powerful performance options created to target page speed scoring. View the report from <a href="#" target="_blank" rel="noopener"><strong>GTMetrix</strong></a> or <a href="#" target="_blank" rel="noopener"><strong>Google Lighthouse</strong></a>.[/nectar_responsive_text][divider line_type="No Line" custom_height="1vh"][nectar_lottie trigger_type="play" mobile_func="default" loop="true" trigger_offset="0.00,100.00" frame_constraint="0.00,100.00" speed="0.7" width_desktop="50%" width_phone="100%" alignment="left" preserve_aspect_ratio="xMidYMid meet" json_url="https://assets7.lottiefiles.com/packages/lf20_xui5jtgp.json"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Features Grid #5', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'] . ', ' . $cat_display_names['lottie'];
$data['custom_class'] = 'general lottie date-2-July-2022';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/2022-promo-features-5.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="20px" equal_height="yes" content_placement="top" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#f0f2f6" scene_position="center" top_padding="4%" constrain_group_1="yes" bottom_padding="4%" left_padding_desktop="5%" constrain_group_2="yes" right_padding_desktop="5%" left_padding_phone="14px" constrain_group_6="yes" right_padding_phone="14px" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" zindex="10" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type="" gradient_type="default"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" bottom_margin_tablet="20px" column_element_direction_desktop="default" column_element_spacing="0px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color="#ffffff" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" font_color="#000000" column_shadow="none" column_border_radius="20px" column_link_target="_self" column_position="default" overflow="hidden" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_color="rgba(0,0,0,0.15)" column_border_style="solid" gradient_type="default" column_padding_type="default"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" right_padding_desktop="24%" right_padding_phone="0" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner top_padding_desktop="4vw" constrain_group_100="yes" bottom_padding_desktop="4vw" left_padding_desktop="4vw" constrain_group_101="yes" right_padding_desktop="4vw" top_padding_tablet="8vw" constrain_group_102="yes" bottom_padding_tablet="8vw" left_padding_tablet="8vw" constrain_group_103="yes" right_padding_tablet="8vw" bottom_margin="-5%" column_element_direction_desktop="default" column_element_spacing="10px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="advanced"][nectar_responsive_text font_size_desktop="1.8vw" font_size_tablet="22px" font_line_height="1.3"]
<h3>Salient Help Center</h3>
[/nectar_responsive_text][nectar_responsive_text font_size_min="14px" font_size_max="20px" font_size_desktop="1.1vw" font_line_height="1.5"]We offer hands-on support with a professional team of agents to ensure that your questions get answered in a timely manner.[/nectar_responsive_text][/vc_column_inner][/vc_row_inner][image_with_animation image_url="https://themenectar.com/img/demo-media/promo/helpcenter.webp" image_size="full" animation_type="entrance" animation="None" animation_movement_type="transform_y" hover_animation="none" alignment="" border_radius="none" box_shadow="none" image_loading="default" max_width="custom"][/vc_column][vc_column top_padding_desktop="4vw" constrain_group_100="yes" bottom_padding_desktop="4vw" left_padding_desktop="4vw" right_padding_desktop="22vw" top_padding_tablet="8vw" constrain_group_102="yes" bottom_padding_tablet="8vw" left_padding_tablet="8vw" right_padding_tablet="50vw" right_padding_phone="33vw" column_element_direction_desktop="default" column_element_spacing="20px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://themenectar.com/img/demo-media/promo/promo-docs.jpeg" background_image_position="center top" background_image_stacking="default" enable_bg_scale="true" background_image_loading="default" column_backdrop_filter="none" font_color="#ffffff" column_shadow="none" column_border_radius="20px" column_link_target="_self" column_position="default" overflow="hidden" advanced_gradient_angle="0" width="1/2" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" parallax_bg="true" parallax_bg_speed="minimum" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="advanced" advanced_gradient_display_type="linear" column_padding_type="advanced"][nectar_responsive_text font_size_desktop="1.8vw" font_size_tablet="22px" font_line_height="1.3"]
<h3>Demo Importer</h3>
[/nectar_responsive_text][nectar_responsive_text font_size_min="14px" font_size_max="20px" font_size_desktop="1.1vw" font_line_height="1.5"]Easily import any of the demos with one click via our simple demo importer plugin.[/nectar_responsive_text][divider line_type="No Line" custom_height="30vh"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Minimal FAQ', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-2-July-2022';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/2022-promo-faq.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" equal_height="yes" content_placement="middle" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#ffffff" scene_position="center" top_padding="12%" bottom_padding="12%" left_padding_desktop="25%" constrain_group_2="yes" right_padding_desktop="25%" left_padding_tablet="20%" constrain_group_4="yes" right_padding_tablet="20%" left_padding_phone="24px" constrain_group_6="yes" right_padding_phone="24px" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" zindex="10" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.8" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" parallax_bg="true" parallax_bg_speed="fast" shape_type="" gradient_type="default"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="right" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding="3%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" centered_text="true" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][nectar_responsive_text font_size_desktop="3vw" font_size_tablet="5vw" font_size_phone="8vw" font_line_height="1.1"]
<h3>Frequently asked questions</h3>
[/nectar_responsive_text][/vc_column_inner][/vc_row_inner][toggles style="minimal_shadow" accordion="true" accordion_starting_functionality="default" border_radius="20px"][toggle color="Default" heading_tag="h3" heading_tag_functionality="default" title="Was this site built with Salient?"][nectar_responsive_text font_size_min="14px" font_size_max="20px" font_size_desktop="1.1vw" font_line_height="1.6"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Duis ultricies metus sed turpis pulvinar eleifend. Pellentesque a tempor turpis, quis congue odio.[/nectar_responsive_text][/toggle][toggle color="Default" heading_tag="h3" heading_tag_functionality="default" title="Where can I purchase Salient?"][nectar_responsive_text font_size_min="14px" font_size_max="20px" font_size_desktop="1.1vw" font_line_height="1.6"]Proin accumsan mauris ut sem gravida, vel aliquam orci ornare. Cras sed urna neque. Vivamus mauris odio, pretium ac nunc a, ornare faucibus augue. Praesent quis lorem magna.[/nectar_responsive_text][/toggle][toggle color="Default" heading_tag="h3" heading_tag_functionality="default" title="What is included with my purchase?"][fancy-ul icon_type="standard_dot" alignment="left" spacing="5px" font_size_min="14px" font_size_max="20px" font_size_desktop="1.1vw" font_line_height="1.6"]
<ul>
 	<li>Lorem ipsum dolor sit amet, consectetur.</li>
 	<li> adipiscing elit. Duis ultricies metus .</li>
 	<li>sed turpis pulvinar eleifend. Pellentesque.</li>
 	<li>a tempor turpis, quis congue odio.</li>
 	<li><strong>Aliquam tristique, quam sed vulputate lobortis.</strong></li>
</ul>
[/fancy-ul][/toggle][toggle color="Default" heading_tag="h3" heading_tag_functionality="default" title="How can I get support after purchasing?"][nectar_responsive_text font_size_min="14px" font_size_max="20px" font_size_desktop="1.1vw" font_line_height="1.6"]Donec orci est, viverra a volutpat vel, tempus non ipsum. Donec pellentesque aliquam pharetra. Maecenas tincidunt molestie enim, quis fringilla nisi laoreet in. Etiam ac nibh eget odio porta laoreet a at dui.[/nectar_responsive_text][/toggle][toggle color="Default" heading_tag="h3" heading_tag_functionality="default" title="Why should I trust ThemeNectar?"][nectar_responsive_text font_size_min="14px" font_size_max="20px" font_size_desktop="1.1vw" font_line_height="1.6"]Aenean facilisis facilisis nulla, non accumsan mauris gravida faucibus. <strong>Sed commodo laoreet erat</strong>, id elementum ipsum. Aliquam erat volutpat. Nulla ac dignissim elit, sit amet sollicitudin eros. Cras facilisis neque nec dui dignissim congue. Vestibulum ac fringilla lorem. Nulla dignissim mollis consequat.[/nectar_responsive_text][/toggle][/toggles][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );






$data = array();
$data['name'] = esc_html__( 'Project Testimonial', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['portfolio'];
$data['custom_class'] = 'portfolio date-12-Nov-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/architect-quote-image.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" equal_height="yes" content_placement="middle" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="10%" bottom_padding="5%" left_padding_desktop="5%" constrain_group_2="yes" right_padding_desktop="5%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="padding-3-percent" column_padding_tablet="no-extra-padding" column_padding_phone="no-extra-padding" column_padding_position="right" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="7/12" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding_tablet="40" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://themenectar.com/img/demo-media/unsplash/webp/photo-1548248823-ce16a73b6d49.webp" background_image_position="center center" enable_bg_scale="true" background_image_loading="default" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" parallax_bg="true" parallax_bg_speed="very_subtle" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][divider line_type="No Line" custom_height="70vh" custom_height_tablet="50vh"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="padding-3-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="left" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="5/12" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][split_line_heading animation_type="line-reveal-by-space" font_style="h2" line_reveal_by_space_text_effect="none" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="The Outcome" font_size="3vw"][/split_line_heading][split_line_heading animation_type="line-reveal-by-space" font_style="p" line_reveal_by_space_text_effect="none" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="Lorem ipsum dolor sit amet, consectetur adipiscing elit. Pellentesque ante quam, ultrices nec vulputate et, egestas et quam. Lorem ipsum dolor sit amet, consectetur adipiscing elit." font_size="1.1vw" font_line_height="1.7" font_size_tablet="18" font_size_phone="16"][/split_line_heading][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" left_padding_desktop="8%" constrain_group_2="yes" right_padding_desktop="8%" left_padding_phone="0" constrain_group_6="yes" right_padding_phone="0" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][divider line_type="Vertical Line" divider_color="black" custom_height="35"][nectar_single_testimonial testimonial_style="basic" image="https://themenectar.com/img/demo-media/unsplash/webp/photo-1472099645785-5658abf4ff4e.webp" quote="Alex was there every step of the way and brought my vision further than I could have imagined!" name="Josh Margolis" subtitle="Founder of DAF"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Project Header', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['portfolio'];
$data['custom_class'] = 'portfolio date-12-Nov-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/architect-project-header.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#566678" bg_image="https://themenectar.com/img/demo-media/unsplash/webp/photo-1535056074155-0004ae6c6283.webp" bg_position="center center" background_image_loading="default" bg_repeat="no-repeat" scene_position="center" top_padding="12%" constrain_group_1="yes" bottom_padding="12%" left_padding_desktop="10%" constrain_group_2="yes" right_padding_desktop="10%" top_padding_tablet="25%" text_color="light" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" enable_gradient="true" color_overlay="rgba(10,10,10,0.4)" color_overlay_2="#0a0a0a" advanced_gradient_angle="0" overlay_strength="0.95" gradient_direction="top_to_bottom" shape_divider_position="bottom" bg_image_animation="zoom-out-slow" parallax_bg="true" parallax_bg_speed="fast" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="0px" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" zindex="100" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][split_line_heading animation_type="line-reveal-by-space" font_style="h1" line_reveal_by_space_text_effect="letter-reveal-bottom" stagger_animation="true" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="Penn Center" font_size="8vw"][/split_line_heading][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding="1%" constrain_group_1="yes" bottom_padding="1%" left_padding_desktop="25%" constrain_group_2="yes" right_padding_desktop="25%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" delay="300"][divider line_type="Vertical Line" divider_color="white" custom_height="50" custom_height_tablet="25"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" left_padding_desktop="30%" constrain_group_2="yes" right_padding_desktop="30%" left_padding_tablet="15%" constrain_group_4="yes" right_padding_tablet="15%" left_padding_phone="8%" constrain_group_6="yes" right_padding_phone="8%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][split_line_heading animation_type="line-reveal-by-space" font_style="p" line_reveal_by_space_text_effect="default" stagger_animation="true" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="Lorem ipsum dolor sit amet, consectetur adipiscing elit. Pellentesque ante quam, ultrices nec vulputate et, egestas et quam. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Quisque vestibulum, nunc in finibus condimentum." font_size="1.1vw" font_line_height="1.6" animation_delay="500" animation_offset="100%" font_size_tablet="18" font_size_phone="16"][/split_line_heading][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Company Culture List', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'] . ', ' . $cat_display_names['about'];
$data['custom_class'] = 'general about date-12-Nov-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/architect-culture.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="5%" bottom_padding="5%" left_padding_desktop="6%" constrain_group_2="yes" right_padding_desktop="6%" top_padding_tablet="10%" bottom_padding_tablet="20%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" id="values" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type="" gradient_type="default"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][split_line_heading animation_type="line-reveal-by-space" font_style="h1" line_reveal_by_space_text_effect="letter-reveal-bottom" stagger_animation="true" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="Culture" font_size="9vw" font_size_tablet="8vw" font_size_phone="10vw"][/split_line_heading][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][divider line_type="Full Width Line" line_thickness="1" divider_color="black" animate="yes" custom_height="45"][/vc_column_inner][/vc_row_inner][vc_row_inner equal_height="yes" content_placement="middle" column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="padding-5-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="right" column_element_spacing="10px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="2/3" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" offset="vc_col-xs-10"][nectar_highlighted_text color_type="gradient" highlight_color="#9ebee7" secondary_color="#dcf0ff" style="full_text" highlight_expansion="default" custom_font_size="2vw"]
<h2>Innovate each project with <strong><em>no exceptions</em></strong>.</h2>
[/nectar_highlighted_text][vc_column_text]Lorem ipsum dolor sit amet, consectetur adipiscing elit.[/vc_column_text][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" offset="vc_col-xs-2"][split_line_heading animation_type="line-reveal-by-space" font_style="h2" line_reveal_by_space_text_effect="letter-reveal-bottom" content_alignment="right" mobile_content_alignment="inherit" link_target="_self" text_content="01" font_size="7vw" font_line_height="1" font_size_phone="46" font_size_tablet="70"][/split_line_heading][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][divider line_type="Full Width Line" line_thickness="1" divider_color="black" animate="yes" custom_height="45"][/vc_column_inner][/vc_row_inner][vc_row_inner equal_height="yes" content_placement="middle" column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="padding-5-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="right" column_element_spacing="10px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="2/3" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" offset="vc_col-xs-10"][nectar_highlighted_text color_type="gradient" highlight_color="#9ebee7" secondary_color="#dcf0ff" style="full_text" highlight_expansion="default" custom_font_size="2vw"]
<h2>Always <strong><em>overdeliver</em></strong> to our clients.</h2>
[/nectar_highlighted_text][vc_column_text]Vivamus risus quam, dapibus non libero eu, bibendum.[/vc_column_text][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" offset="vc_col-xs-2"][split_line_heading animation_type="line-reveal-by-space" font_style="h2" line_reveal_by_space_text_effect="letter-reveal-bottom" content_alignment="right" mobile_content_alignment="inherit" link_target="_self" text_content="02" font_size="7vw" font_line_height="1" font_size_phone="46" font_size_tablet="70"][/split_line_heading][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][divider line_type="Full Width Line" line_thickness="1" divider_color="black" animate="yes" custom_height="45"][/vc_column_inner][/vc_row_inner][vc_row_inner equal_height="yes" content_placement="middle" column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="padding-5-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="right" column_element_spacing="10px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="2/3" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" offset="vc_col-xs-10"][nectar_highlighted_text color_type="gradient" highlight_color="#9ebee7" secondary_color="#dcf0ff" style="full_text" highlight_expansion="default" custom_font_size="2vw"]
<h2>Build things that <strong><em>inspire</em></strong> people.</h2>
[/nectar_highlighted_text][vc_column_text]Nam magna dui, venenatis dignissim pharetra.[/vc_column_text][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" offset="vc_col-xs-2"][split_line_heading animation_type="line-reveal-by-space" font_style="h2" line_reveal_by_space_text_effect="letter-reveal-bottom" content_alignment="right" mobile_content_alignment="inherit" link_target="_self" text_content="03" font_size="7vw" font_line_height="1" font_size_phone="46" font_size_tablet="70"][/split_line_heading][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Parallax Text and Image', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-12-Nov-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/architect-text-image-3jpg.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="5%" constrain_group_1="yes" bottom_padding="5%" left_padding_desktop="6%" constrain_group_2="yes" right_padding_desktop="6%" top_padding_tablet="10%" constrain_group_3="yes" bottom_padding_tablet="10%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" id="about" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][vc_row_inner equal_height="yes" content_placement="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" bottom_margin_tablet="40" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://themenectar.com/img/demo-media/unsplash/webp/photo-1610733374054-59454fe657cd.webp" background_image_position="center center" enable_bg_scale="true" background_image_loading="default" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="2/3" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" parallax_bg="true" parallax_bg_speed="very_subtle" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][divider line_type="No Line" custom_height_tablet="75vh"][/vc_column_inner][vc_column_inner column_padding="padding-6-percent" column_padding_tablet="no-extra-padding" column_padding_phone="no-extra-padding" column_padding_position="left" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" animation_type="parallax" animation_movement_type="default" column_parallax_intensity="1" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][divider line_type="No Line" custom_height="30vh" custom_height_tablet="0"][split_line_heading animation_type="line-reveal-by-space" font_style="h2" line_reveal_by_space_text_effect="default" stagger_animation="true" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="Modern Architecture" font_size="3vw"][/split_line_heading][split_line_heading animation_type="line-reveal-by-space" font_style="p" line_reveal_by_space_text_effect="none" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo. Lorem ipsum dolor sit amet, consectetur adipiscing elit." font_size="1.1vw" font_line_height="1.7" font_size_tablet="18" font_size_phone="16"][/split_line_heading][split_line_heading animation_type="line-reveal-by-space" font_style="p" line_reveal_by_space_text_effect="none" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo. Lorem ipsum dolor sit amet, consectetur adipiscing elit." font_size="1.1vw" font_line_height="1.7" font_size_tablet="18" font_size_phone="16"][/split_line_heading][nectar_cta btn_style="arrow-animation" heading_tag="h6" text_color="#000000" button_color="default" button_border_color="#cccccc" button_border_color_hover="#0a0a0a" button_border_thickness="1px" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" constrain_group_3="yes" constrain_group_4="yes" display="block" display_tablet="inherit" display_phone="inherit" link_text="Contact Us" margin_top="50" padding_top="15" padding_bottom="15" padding_left="40" padding_right="40"][divider line_type="No Line" custom_height="30vh" custom_height_tablet="0" custom_height_phone="0"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Parallax Team Section', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general']  . ', ' . $cat_display_names['about'];
$data['custom_class'] = 'general about date-13-Nov-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/architect-team.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="5%" bottom_padding="5%" left_padding_desktop="6%" constrain_group_2="yes" right_padding_desktop="6%" top_padding_tablet="10%" constrain_group_3="yes" bottom_padding_tablet="10%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" id="team" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" sticky_content="true" sticky_content_functionality="css" sticky_content_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][split_line_heading animation_type="line-reveal-by-space" font_style="h2" line_reveal_by_space_text_effect="none" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="Meet The Team" font_size="3vw"][/split_line_heading][split_line_heading animation_type="line-reveal-by-space" font_style="p" line_reveal_by_space_text_effect="none" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="We're an award-winning multidisciplinary team based in Philadelphia with a passion for creating innovative architecture. We work with businesses and people to create a more beautiful world." font_size="1.1vw" font_line_height="1.7" font_size_tablet="18" font_size_phone="16"][/split_line_heading][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" left_padding_desktop="8%" constrain_group_2="yes" right_padding_desktop="8%" left_padding_phone="0" constrain_group_6="yes" right_padding_phone="0" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][divider line_type="Vertical Line" divider_color="black" custom_height="35"][nectar_single_testimonial testimonial_style="basic" image="https://themenectar.com/img/demo-media/unsplash/webp/photo-1545803928-04e3f4cdd4ed.webp" quote="Alex was there every step of the way and brought my vision further than I could have imagined!" name="Josh Margolis" subtitle="Founder of DAF"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="padding-6-percent" column_padding_tablet="no-extra-padding" column_padding_phone="no-extra-padding" column_padding_position="left" column_element_spacing="0px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="2/3" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][vc_row_inner column_margin="30px" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding="20" top_padding_tablet="40" bottom_padding_tablet="0" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="small_desktop" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][team_member image_url="https://themenectar.com/img/demo-media/unsplash/webp/photo-1633332755192-727a05c4013d.webp" bio_alt_image_url="https://themenectar.com/img/demo-media/unsplash/webp/photo-1633332755192-727a05c4013d.webp" team_memeber_style="bio_fullscreen_alt" bio_fullscreen_alt_parallax="true" bio_fullscreen_alt_hide_link_arrow="true" image_loading="default" team_member_bio_full_html="html" hide_link_arrow="true" name="Phil Martinez" job_position="CEO, Founder" image_size="regular" social_icon_1="fa fa-instagram" social_link_1="#" social_icon_2="fa fa-twitter" social_link_2="#"]Consectetur adipiscing elit. Etiam id mi faucibus, malesuada quam eget, facilisis turpis. Quisque ac purus erat.

Donec id pharetra tellus, vitae vehicula dolor. Aenean leo lorem, tempor vel mauris in, interdum fringilla erat. Nam auctor sodales dapibus. Ut et nibh sed neque lobortis mollis. Cras mauris tellus, ornare sed vestibulum eu, sagittis vitae justo. Vivamus pellentesque augue in orci commodo dignissim. Fusce id mi lacus.

Nullam ultricies mollis lorem, ac gravida diam pretium eget. Ut porttitor scelerisque lacus, a fringilla felis blandit sed.[/team_member][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="small_desktop" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][team_member image_url="https://themenectar.com/img/demo-media/unsplash/webp/photo-1580489944761-15a19d654956.webp" bio_alt_image_url="https://themenectar.com/img/demo-media/unsplash/webp/photo-1580489944761-15a19d654956.webp" team_memeber_style="bio_fullscreen_alt" bio_fullscreen_alt_parallax="true" bio_fullscreen_alt_hide_link_arrow="true" image_loading="default" team_member_bio_full_html="html" hide_link_arrow="true" name="Alex Smith" job_position="CFO, Partner" image_size="regular" social_icon_1="fa fa-facebook" social_link_1="#" social_icon_2="fa fa-envelope" social_link_2="#"]Consectetur adipiscing elit. Etiam id mi faucibus, malesuada quam eget, facilisis turpis. Quisque ac purus erat.Donec id pharetra tellus, vitae vehicula dolor. Aenean leo lorem, tempor vel mauris in, interdum fringilla erat.

Nam auctor sodales dapibus. Ut et nibh sed neque lobortis mollis. Cras mauris tellus, ornare sed vestibulum eu, sagittis vitae justo. Vivamus pellentesque augue in orci commodo dignissim. Fusce id mi lacus.

Nullam ultricies mollis lorem, ac gravida diam pretium eget. Ut porttitor scelerisque lacus, a fringilla felis blandit sed.[/team_member][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="30px" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all" css=".vc_custom_1634415872169{margin-bottom: 0px !important;}"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="small_desktop" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][team_member image_url="https://themenectar.com/img/demo-media/unsplash/webp/photo-1472099645785-5658abf4ff4e-2.webp" bio_alt_image_url="https://themenectar.com/img/demo-media/unsplash/webp/photo-1472099645785-5658abf4ff4e.webp" team_memeber_style="bio_fullscreen_alt" bio_fullscreen_alt_parallax="true" bio_fullscreen_alt_hide_link_arrow="true" image_loading="default" team_member_bio_full_html="html" hide_link_arrow="true" name="Kara Cohen" job_position="Associate" image_size="regular" social_icon_1="fa fa-facebook" social_link_1="#" social_icon_2="fa fa-instagram" social_link_2="#" social_icon_3="fa fa-github" social_link_3="#"]Quisque elit nisl, varius nec ullamcorper eget, egestas vitae mi. Nam hendrerit eros a sagittis tempus. Mauris hendrerit hendrerit consequat. Nunc eget dui pulvinar, auctor neque sed, convallis ipsum. Fusce sagittis, dui a malesuada ullamcorper, nulla dolor interdum ipsum.

Ac condimentum eros lacus vestibulum nunc. Nunc maximus, massa et dictum dictum, risus massa dignissim nisl, at vestibulum ligula ante id metus. Morbi fringilla rhoncus porta.[/team_member][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="small_desktop" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][team_member image_url="https://themenectar.com/img/demo-media/unsplash/webp/photo-1562124638-724e13052daf.webp" bio_alt_image_url="https://themenectar.com/img/demo-media/unsplash/webp/photo-1562124638-724e13052daf.webp" team_memeber_style="bio_fullscreen_alt" bio_fullscreen_alt_parallax="true" bio_fullscreen_alt_hide_link_arrow="true" image_loading="default" team_member_bio_full_html="html" hide_link_arrow="true" name="Justin Klein" job_position="Office Manager" image_size="regular" social_icon_1="fa fa-instagram" social_link_1="#"]Etiam nulla velit, pharetra vel leo a, pretium rhoncus eros. Fusce eu hendrerit ipsum, vitae volutpat dui. Nunc eget mi tincidunt, luctus turpis at, pharetra diam. Nam sit amet purus cursus, rhoncus nibh nec, volutpat purus. Orci varius natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Vestibulum id iaculis velit, vitae faucibus augue. In quis lectus nisi.[/team_member][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="small_desktop" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][team_member image_url="https://themenectar.com/img/demo-media/unsplash/webp/photo-1542327897-acbfd35f0163.webp" bio_alt_image_url="https://themenectar.com/img/demo-media/unsplash/webp/photo-1542327897-acbfd35f0163.webp" team_memeber_style="bio_fullscreen_alt" bio_fullscreen_alt_parallax="true" bio_fullscreen_alt_hide_link_arrow="true" image_loading="default" team_member_bio_full_html="html" hide_link_arrow="true" name="Andy Morris" job_position="Designer" image_size="regular" social_icon_1="fa fa-twitter" social_link_1="#" social_icon_2="fa fa-instagram" social_link_2="#"]Etiam nulla velit, pharetra vel leo a, pretium rhoncus eros. Fusce eu hendrerit ipsum, vitae volutpat dui. Nunc eget mi tincidunt, luctus turpis at, pharetra diam. Nam sit amet purus cursus, rhoncus nibh nec, volutpat purus. Orci varius natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Vestibulum id iaculis velit, vitae faucibus augue. In quis lectus nisi.

Quisque elit nisl, varius nec ullamcorper eget, egestas vitae mi. Nam hendrerit eros a sagittis tempus. Mauris hendrerit hendrerit consequat. Nunc eget dui pulvinar, auctor neque sed, convallis ipsum. Fusce sagittis, dui a malesuada ullamcorper, nulla dolor interdum ipsum, ac condimentum eros lacus vestibulum nunc. Nunc maximus, massa et dictum dictum, risus massa dignissim nisl, at vestibulum ligula ante id metus. Morbi fringilla rhoncus porta.[/team_member][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Clean text block', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-12-Nov-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/architect-text-heading.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="10%" bottom_padding="5%" left_padding_desktop="27%" constrain_group_2="yes" right_padding_desktop="27%" top_padding_tablet="20%" bottom_padding_tablet="10%" left_padding_tablet="20%" constrain_group_4="yes" right_padding_tablet="20%" left_padding_phone="6%" constrain_group_6="yes" right_padding_phone="6%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="0px" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][vc_row_inner column_margin="20px" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" bottom_margin="20" column_element_spacing="0px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" animation_offset="80%"][vc_column_text]
<h5>COMPANY</h5>
[/vc_column_text][/vc_column_inner][/vc_row_inner][split_line_heading animation_type="line-reveal-by-space" font_style="h1" line_reveal_by_space_text_effect="default" stagger_animation="true" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="We are a professional architecture firm based in Philadelphia" font_size="4vw" font_size_phone="10vw"][/split_line_heading][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Page Header With Anchor Links', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'] . ', ' . $cat_display_names['about'];
$data['custom_class'] = 'general about date-12-Nov-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/architect-about-header.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" equal_height="yes" content_placement="middle" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="8%" bottom_padding="10%" left_padding_desktop="6%" constrain_group_2="yes" right_padding_desktop="6%" top_padding_tablet="20%" top_padding_phone="25%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" zindex="100" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="fade-in" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][vc_row_inner equal_height="yes" content_placement="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" bottom_margin_tablet="20" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="4/5" tablet_width_inherit="small_desktop" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" offset="vc_col-md-9"][split_line_heading animation_type="line-reveal-by-space" font_style="h1" line_reveal_by_space_text_effect="letter-reveal-bottom" stagger_animation="true" mobile_disable_animation="true" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="About Salient" font_size="9vw" font_size_tablet="9vw" font_size_phone="10vw"][/split_line_heading][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="10px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/5" tablet_width_inherit="small_desktop" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" mobile_disable_entrance_animation="true" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" delay="500" offset="vc_col-md-3"][nectar_cta btn_style="underline" heading_tag="h6" text_color="#0a0a0a" button_color="default" button_border_thickness="0px" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" display="block" display_tablet="inherit" display_phone="inline-block" link_text="Team" url="#team" margin_right="25"][nectar_cta btn_style="underline" heading_tag="h6" text_color="#0a0a0a" button_color="default" button_border_thickness="0px" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" display="block" display_tablet="inherit" display_phone="inline-block" link_text="Values" url="#about" margin_right="25"][nectar_cta btn_style="underline" heading_tag="h6" text_color="#0a0a0a" button_color="default" button_border_thickness="0px" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" display="block" display_tablet="inherit" display_phone="inline-block" link_text="Culture" url="#values"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" left_padding_desktop="6%" constrain_group_2="yes" right_padding_desktop="6%" top_margin="-5%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://themenectar.com/img/demo-media/unsplash/webp/photo-1556761175-4b46a572b786.webp" background_image_position="center bottom" enable_bg_scale="true" background_image_loading="default" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" mobile_disable_entrance_animation="true" bg_image_animation="none" parallax_bg="true" parallax_bg_speed="very_subtle" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" delay="600"][divider line_type="No Line" custom_height="100vh" custom_height_tablet="70vh" custom_height_phone="50vh"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );





$data = array();
$data['name'] = esc_html__( 'Parallax Typography Scene', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-12-Nov-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/architect-typography-scene.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="15%" text_color="light" text_align="left" row_border_radius="none" row_border_radius_applies="bg" zindex="10" overflow="hidden" advanced_gradient="linear-gradient(183deg, rgb(158, 190, 231) 5%, rgb(220,240,255) 90%)" advanced_gradient_angle="183" shape_divider_position="bottom" bg_image_animation="slight-zoom-out-reveal" shape_type="" gradient_type="advanced" advanced_gradient_display_type="linear"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="0px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" zindex="10" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" translate_x="-13%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" zindex="100" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="parallax" animation_movement_type="transform_x" column_parallax_intensity="2.5" persist_movement_on_mobile="true" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][nectar_scrolling_text scroll_direction="ltr" scroll_speed="slower" text_color="#ffffff" style="default" text_repeat_number="3" text_repeat_divider="none" overflow="visible" background_image_animation="None" custom_font_size="10vw" custom_font_size_mobile="11vw"]
<h1>salient architecture</h1>
[/nectar_scrolling_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="parallax" animation_movement_type="transform_x" column_parallax_intensity="-2.5" persist_movement_on_mobile="true" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][nectar_scrolling_text scroll_direction="rtl" scroll_speed="slower" text_color="#ffffff" style="default" text_repeat_number="3" text_repeat_divider="none" overflow="visible" background_image_animation="None" custom_font_size="10vw" custom_font_size_mobile="11vw"]
<h1>salient architecture</h1>
[/nectar_scrolling_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" top_margin="-20vw" top_margin_tablet="-23vw" column_element_spacing="default" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][image_with_animation image_url="https://themenectar.com/img/demo-media/architect/red-building-gPvqQOAOXCw.png" image_size="full" animation_type="entrance" animation="None" hover_animation="none" alignment="center" border_radius="none" box_shadow="none" image_loading="skip-lazy-load" max_width="100%" max_width_mobile="default"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Sticky Text Vertical Post Grid', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'] . ', ' . $cat_display_names['portfolio'];
$data['custom_class'] = 'general portfolio date-12-Nov-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/architect-portfolio-sticky.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="10%" constrain_group_1="yes" bottom_padding="10%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type="" gradient_type="default"][vc_column column_padding="padding-6-percent" column_padding_tablet="padding-5-percent" column_padding_phone="inherit" column_padding_position="left-right" column_element_spacing="default" sticky_content="true" sticky_content_functionality="css" sticky_content_alignment="middle" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding="15" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][vc_column_text]
<h5>PORTFOLIO</h5>
[/vc_column_text][/vc_column_inner][/vc_row_inner][split_line_heading animation_type="line-reveal-by-space" font_style="h2" line_reveal_by_space_text_effect="default" stagger_animation="true" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="Making the world a more beautiful place." font_size="3vw" max_width="80%"][/split_line_heading][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding_tablet="5%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][nectar_cta btn_style="arrow-animation" heading_tag="h6" text_color="#000000" button_color="default" button_border_color="#cccccc" button_border_color_hover="#0a0a0a" button_border_thickness="1px" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" constrain_group_3="yes" constrain_group_4="yes" display="block" display_tablet="inherit" display_phone="inherit" link_text="View All Projects" margin_top="30" padding_top="15" padding_bottom="15" padding_left="40" padding_right="40" url="https://themenectar.com/salient/architect/salient-architect-projects/"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="no-extra-padding" column_padding_tablet="padding-5-percent" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="30px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][nectar_post_grid post_type="post" blog_category="all" order="DESC" orderby="date" pagination="none" columns="1" grid_item_spacing="35px" grid_item_height="60vh" image_size="large" image_loading="default" animation="none" heading_tag="h3" enable_indicator="yes" mouse_indicator_style="default" mouse_indicator_text="view" mouse_indicator_color="#ff5149" display_categories="yes" category_functionality="static" category_position="default" display_excerpt="yes" grid_style="content_under_image" content_under_image_text_align="left" text_color="dark" hover_effect="animated_underline_zoom" border_radius="none" posts_per_page="3" custom_font_size="2vw"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Text with Inline Images', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-13-Nov-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/architect-inline-images.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="6%" bottom_padding="12%" left_padding_desktop="27%" constrain_group_2="yes" right_padding_desktop="27%" bottom_padding_tablet="15%" left_padding_tablet="18%" constrain_group_4="yes" right_padding_tablet="18%" left_padding_phone="8%" constrain_group_6="yes" right_padding_phone="8%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][nectar_text_inline_images images="" image_size="nectar_small_square" image_effect="circle_fade_in" image_loading="default" line_reveal_by_space_text_effect="" content_alignment="" font_style="h1" font_size="3vw" font_line_height="1.4" font_size_desktop="3vw" font_size_tablet="4vw" max_width="" font_size_phone="5vw"]
<h2>We're * changing the way <a href="#"><strong>architecture</strong></a> is * built for clients by utilizing Virtual Reality * to provide * immersive previews during our <a href="#"><strong>build process</strong></a>.</h2>
[/nectar_text_inline_images][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Scrolling Text Heading', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-12-Nov-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/architect-scrolling-text.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="5%" constrain_group_1="yes" bottom_padding="5%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="hidden" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="0px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" zindex="100" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="parallax" animation_movement_type="transform_x" column_parallax_intensity="3.5" persist_movement_on_mobile="true" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][nectar_scrolling_text scroll_direction="ltr" scroll_speed="slowest" text_color="#0a0a0a" style="text_outline" outline_thickness="ultra-thin" text_repeat_number="5" text_repeat_divider="none" overflow="visible" background_image_animation="None" custom_font_size="11vw" custom_font_size_mobile="15vw"]
<h1><em>innovation </em></h1>
[/nectar_scrolling_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Parallax Images and Text Alt', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'] . ', ' . $cat_display_names['about'];
$data['custom_class'] = 'general about date-12-Nov-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/architect-images-and-text-2.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" equal_height="yes" content_placement="middle" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="6%" constrain_group_1="yes" bottom_padding="6%" left_padding_tablet="8%" constrain_group_4="yes" right_padding_tablet="8%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="0px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" right_padding_desktop="20%" right_padding_tablet="10%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://themenectar.com/img/demo-media/unsplash/webp/photo-1556761175-4b46a572b786.webp" background_image_position="center center" enable_bg_scale="true" background_image_loading="default" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" parallax_bg="true" parallax_bg_speed="very_subtle" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][divider line_type="No Line" custom_height="90vh" custom_height_tablet="70vh" custom_height_phone="60vh"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" translate_y="-50%" text_align="left" min_width_desktop="40%" row_position="absolute" row_position_tablet="inherit" row_position_phone="inherit" top_position_desktop="50%" right_position_desktop="0" zindex="50" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://themenectar.com/img/demo-media/unsplash/webp/photo-1636366312163-456bd30acd11.webp" background_image_position="center center" enable_bg_scale="true" background_image_loading="default" column_shadow="x_large_depth" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="parallax" animation_movement_type="default" column_parallax_intensity="2.25" persist_movement_on_mobile="true" bg_image_animation="none" parallax_bg="true" parallax_bg_speed="very_subtle" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][divider line_type="No Line" custom_height="50vh" custom_height_tablet="40vh" custom_height_phone="35vh"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="padding-8-percent" column_padding_tablet="no-extra-padding" column_padding_phone="no-extra-padding" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding="10" top_padding_tablet="7%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][vc_column_text]
<h5>COMMERICAL</h5>
[/vc_column_text][/vc_column_inner][/vc_row_inner][split_line_heading animation_type="line-reveal-by-space" font_style="h2" text_color="#000000" line_reveal_by_space_text_effect="default" stagger_animation="true" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="We create structural beauty by innovating" font_size="3vw"][/split_line_heading][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][split_line_heading animation_type="line-reveal-by-space" font_style="p" line_reveal_by_space_text_effect="none" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="Aliquam non lectus id purus cursus porta. Nullam vel felis elementum, ornare magna non, feugiat ex. Phasellus erat ligula, laoreet sit amet magna vel, aliquet facilisis libero." font_size="1.1vw" font_line_height="1.7" font_size_tablet="18px" font_size_phone="16px"][/split_line_heading][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding="30" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][nectar_badge display_tag="label" bg_color_type="custom" bg_color_custom="#efefef" text_color="#1e1c1c" padding="medium" border_radius="20px" display="inline" text="Award Winning" margin_bottom="15" margin_right="15"][nectar_badge display_tag="label" bg_color_type="custom" bg_color_custom="#efefef" text_color="#1e1c1c" padding="medium" border_radius="20px" display="inline" text="Established Team" margin_bottom="15" margin_right="15"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Architect Carousel', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'] . ', ' . $cat_display_names['services'];
$data['custom_class'] = 'general services date-12-Nov-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/architect-carousel-1.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="6%" bottom_padding="6%" left_padding_desktop="8%" right_padding_desktop="8%" top_padding_tablet="10%" bottom_padding_tablet="15%" left_padding_tablet="8%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="hidden" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_color="#000000" shape_divider_position="top" bg_image_animation="none" shape_type="straight_section" gradient_type="default"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="0px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][carousel script="flickity" flickity_formatting="default" desktop_cols_flickity="4" desktop_small_cols_flickity="3" tablet_cols_flickity="2" flickity_controls="touch_total" flickity_touch_total_style="solid_bg" flickity_touch_total_indicator_bg_color="#ff5149" flickity_touch_total_indicator_icon_color="#ffffff" flickity_touch_total_hide_indicator="true" color="default" flickity_overflow="visible" flickity_wrap_around="no-wrap" flickity_spacing="15px" flickity_column_vertical_alignment="default" column_padding="0" flickity_element_spacing="0" flickity_image_scale_on_drag="true" border_radius="none"][item simple_slider_bg_image_position="default" simple_slider_overlay_strength="0.3" simple_slider_bg_image_loading="default" id="1636930600818-5" title="Item" tab_id="1636930600818-9"][fancy_box box_style="image_above_text_underline" image_url="https://themenectar.com/img/demo-media/unsplash/webp/photo-1610733374054-59454fe657cd.webp" image_aspect_ratio="4-5" content_color="#000000" border_radius="default" image_loading="default" enable_animation="true" animation="fade-in-from-right" image_size="large" link_url="" link_screen_reader="Daily anti-aging cream"]
<h4>Perfect Exterior Lines</h4>
Lorem ipsum dolor sit amet, consectetur adipiscing elit.[/fancy_box][/item][item simple_slider_bg_image_position="default" simple_slider_overlay_strength="0.3" simple_slider_bg_image_loading="default" id="1636930600875-9" title="Item" tab_id="1636930600876-10"][fancy_box box_style="image_above_text_underline" image_url="https://themenectar.com/img/demo-media/unsplash/webp/photo-1622372738946-62e02505feb3.webp" image_aspect_ratio="4-5" content_color="#000000" border_radius="default" image_loading="default" enable_animation="true" animation="fade-in-from-right" image_size="large" delay="100"]
<h4>Square footage optimzation</h4>
Praesent porttitor pharetra sodales. Sed quam elit, congue eget est.[/fancy_box][/item][item simple_slider_bg_image_position="default" simple_slider_overlay_strength="0.3" simple_slider_bg_image_loading="default" id="1636930600904-0" title="Item" tab_id="1636930600906-2"][fancy_box box_style="image_above_text_underline" image_url="https://themenectar.com/img/demo-media/unsplash/webp/photo-1604014237744-2f4ab6bfbcc2.webp" image_aspect_ratio="4-5" content_color="#000000" border_radius="default" image_loading="default" enable_animation="true" animation="fade-in-from-right" image_size="large" delay="200"]
<h4>Aesthetic layouts</h4>
Vivamus tempor a mauris a consectetur. Duis lorem mauris, feugiat.[/fancy_box][/item][item simple_slider_bg_image_url="https://themenectar.com/img/demo-media/unsplash/webp/photo-1604014237256-11d475e2a2d8.webp" simple_slider_bg_image_position="default" simple_slider_overlay_strength="0.3" simple_slider_bg_image_loading="default" id="1636930600937-2" title="Item" tab_id="1636930600938-7"][fancy_box box_style="image_above_text_underline" image_url="https://themenectar.com/img/demo-media/unsplash/webp/photo-1525440584458-b53d13a848de.webp" image_aspect_ratio="4-5" content_color="#000000" border_radius="default" image_loading="default" enable_animation="true" animation="fade-in-from-right" image_size="large" delay="300"]
<h4>Natural light utilization</h4>
interdum accumsan libero. Etiam pretium laoreet tincidunt. Morbi semper quam orci.[/fancy_box][/item][item simple_slider_bg_image_position="default" simple_slider_overlay_strength="0.3" simple_slider_bg_image_loading="default" id="1636930600970-8" title="Item" tab_id="1636930600971-9"][fancy_box box_style="image_above_text_underline" image_url="https://themenectar.com/img/demo-media/unsplash/webp/photo-1549407704-aeb7ffce9a76.webp" image_aspect_ratio="4-5" content_color="#000000" border_radius="default" image_loading="default" enable_animation="true" animation="fade-in-from-right" image_size="large" delay="400"]
<h4>Precise details in every room</h4>
Praesent a urna non quam commodo scelerisque. Donec iaculis nunc.[/fancy_box][/item][item simple_slider_bg_image_position="default" simple_slider_overlay_strength="0.3" simple_slider_bg_image_loading="default" id="1636930600999-6" title="Item" tab_id="1636930601000-1"][fancy_box box_style="image_above_text_underline" image_url="https://themenectar.com/img/demo-media/unsplash/webp/photo-1556761175-4b46a572b786.webp" image_aspect_ratio="4-5" content_color="#000000" border_radius="default" image_loading="default" enable_animation="true" animation="fade-in-from-right" image_size="large" delay="500"]
<h4>Ultra modern designs</h4>
Donec venenatis faucibus nibh ut tristique. Mauris odio augue, pulvinar quis lacus at.[/fancy_box][/item][/carousel][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Parallax Images and Text', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'] . ', ' . $cat_display_names['about'];
$data['custom_class'] = 'general about date-12-Nov-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/architect-images-and-text-1.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" equal_height="yes" content_placement="middle" column_direction="default" column_direction_tablet="column_reverse" column_direction_phone="column_reverse" scene_position="center" top_padding="12%" bottom_padding="6%" left_padding_tablet="8%" constrain_group_4="yes" right_padding_tablet="8%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="padding-8-percent" column_padding_tablet="no-extra-padding" column_padding_phone="no-extra-padding" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding="10" top_padding_tablet="8%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][vc_column_text]
<h5>RESIDENTIAL</h5>
[/vc_column_text][/vc_column_inner][/vc_row_inner][split_line_heading animation_type="line-reveal-by-space" font_style="h2" text_color="#000000" line_reveal_by_space_text_effect="default" stagger_animation="true" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="Iconic architecture expertly developed" font_size="3vw"][/split_line_heading][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" right_padding_tablet="25%" right_padding_phone="0" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="0px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][split_line_heading animation_type="line-reveal-by-space" font_style="p" line_reveal_by_space_text_effect="none" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam fringilla est sapien, nec semper neque auctor nec. Duis vehicula quis mi at vehicula. Vivamus at." font_size="1.1vw" font_line_height="1.7" font_size_tablet="18px" font_size_phone="16px"][/split_line_heading][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding="50" top_padding_tablet="30" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="0px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="small_desktop" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" offset="vc_col-xs-4"][split_line_heading animation_type="line-reveal-by-space" font_style="h2" line_reveal_by_space_text_effect="default" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="30+" font_size="2.5vw" font_line_height="1" animation_delay="200"][/split_line_heading][split_line_heading animation_type="line-reveal-by-space" font_style="p" line_reveal_by_space_text_effect="default" stagger_animation="true" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="Years of experience" font_size="1.1vw" font_line_height="1.5" animation_delay="300" max_width="60%" font_size_tablet="16px" font_size_phone="13px"][/split_line_heading][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="0px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="small_desktop" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" offset="vc_col-xs-4"][split_line_heading animation_type="line-reveal-by-space" font_style="h2" line_reveal_by_space_text_effect="default" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="10x" font_size="2.5vw" font_line_height="1" animation_delay="200"][/split_line_heading][split_line_heading animation_type="line-reveal-by-space" font_style="p" line_reveal_by_space_text_effect="default" stagger_animation="true" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="Builder of the year" font_size="1.1vw" font_line_height="1.5" max_width="55%" animation_delay="300" font_size_tablet="16px" font_size_phone="13px"][/split_line_heading][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" offset="vc_hidden-sm vc_hidden-xs"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="0px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" left_padding_desktop="20%" left_padding_tablet="10%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://themenectar.com/img/demo-media/unsplash/webp/photo-1549407294-0bf7c458df48.webp" background_image_position="center center" enable_bg_scale="true" background_image_loading="default" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" parallax_bg="true" parallax_bg_speed="very_subtle" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][divider line_type="No Line" custom_height="90vh" custom_height_tablet="70vh" custom_height_phone="60vh"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" translate_y="-50%" text_align="left" min_width_desktop="40%" row_position="absolute" row_position_tablet="inherit" row_position_phone="inherit" top_position_desktop="50%" left_position_desktop="0" zindex="50" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://themenectar.com/img/demo-media/unsplash/webp/photo-1600585153206-c6ff50dfb3c6.webp" background_image_position="center center" enable_bg_scale="true" background_image_loading="default" column_shadow="x_large_depth" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="parallax" animation_movement_type="default" column_parallax_intensity="2.25" persist_movement_on_mobile="true" bg_image_animation="none" parallax_bg="true" parallax_bg_speed="very_subtle" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][divider line_type="No Line" custom_height="50vh" custom_height_tablet="40vh" custom_height_phone="35vh"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Fullscreen Video Hero', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['hero_section'];
$data['custom_class'] = 'hero_section date-13-Nov-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/architect-landing-header.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#2b323a" bg_image="https://themenectar.com/img/demo-media/unsplash/webp/photo-1449247666642-264389f5f5b1.webp" bg_position="left top" background_image_loading="default" bg_repeat="no-repeat" full_height="yes" scene_position="center" left_padding_desktop="8%" constrain_group_2="yes" right_padding_desktop="8%" text_color="light" text_align="left" row_border_radius="none" row_border_radius_applies="bg" zindex="100" overflow="hidden" color_overlay="rgba(0,0,0,0.78)" advanced_gradient_angle="0" overlay_strength="0.8" gradient_direction="radial" shape_divider_position="bottom" bg_image_animation="fade-in" mobile_disable_bg_image_animation="true" shape_type="" gradient_type="default"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="top-bottom" column_element_spacing="0px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="static" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" left_padding_desktop="13vw" constrain_group_2="yes" right_padding_desktop="13vw" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" zindex="10" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][split_line_heading animation_type="line-reveal-by-space" font_style="h1" line_reveal_by_space_text_effect="letter-reveal-bottom" stagger_animation="true" mobile_disable_animation="true" content_alignment="left" mobile_content_alignment="inherit" link_target="_self" text_content="Rethink architecture." font_size="9vw" font_line_height="0.95" font_size_tablet="10vw" animation_delay="150"][/split_line_heading][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" translate_y="55%" translate_x="-50%" text_align="left" min_width_desktop="175px" row_position="absolute" row_position_tablet="inherit" row_position_phone="inherit" bottom_position_desktop="0" left_position_desktop="50%" zindex="100" overflow="visible" pointer_events="all"][vc_column_inner column_padding="padding-2-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="1" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" mobile_disable_entrance_animation="true" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" mobile_disable_animation="true" gradient_type="default" column_link="#section-two" delay="600" animation_offset="100%"][image_with_animation image_url="https://themenectar.com/img/demo-media/spinners/scroll-down-light.png" image_size="full" animation_type="looped" loop_animation="rotate" hover_animation="none" alignment="" border_radius="none" image_loading="skip-lazy-load" max_width="custom" max_width_custom="175"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Minimal Blog Grid', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['blog'];
$data['custom_class'] = 'blog date-11-Nov-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/resort-news-full.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="175" bottom_padding="3%" top_padding_tablet="25%" top_padding_phone="35%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type="straight_section" gradient_type="default"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="top-bottom" column_element_spacing="0px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" left_padding_desktop="8%" constrain_group_2="yes" right_padding_desktop="8%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="0px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][split_line_heading animation_type="line-reveal-by-space" font_style="h1" line_reveal_by_space_text_effect="letter-reveal-bottom" mobile_disable_animation="true" content_alignment="center" mobile_content_alignment="inherit" link_target="_self" text_content="THE" font_size="13vw" font_line_height="0.8" font_size_tablet="13vw"][/split_line_heading][split_line_heading animation_type="line-reveal-by-space" font_style="h1" line_reveal_by_space_text_effect="letter-reveal-bottom" mobile_disable_animation="true" content_alignment="center" mobile_content_alignment="inherit" link_target="_self" text_content="NEWS" font_size="13vw" font_line_height="0.8" animation_delay="150" font_size_tablet="13vw"][/split_line_heading][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" left_padding_desktop="5%" constrain_group_2="yes" right_padding_desktop="5%" left_padding_phone="0" constrain_group_6="yes" right_padding_phone="0" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" mobile_disable_entrance_animation="true" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" delay="500" animation_offset="99%"][nectar_post_grid post_type="post" blog_category="all" order="DESC" orderby="date" pagination="load-more" button_color="black" columns="3" grid_item_spacing="35px" grid_item_height="50vh" image_size="full" aspect_ratio_image_size="yes" custom_image_aspect_ratio="3-2" image_loading="default" animation="none" heading_tag="default" enable_indicator="yes" mouse_indicator_style="default" mouse_indicator_text="read" mouse_indicator_color="#eddecc" mouse_indicator_text_color="#000000" display_categories="yes" category_functionality="default" category_position="default" display_excerpt="yes" grid_style="content_under_image" content_under_image_text_align="left" text_color="dark" hover_effect="animated_underline_zoom" border_radius="none" shadow_on_hover="yes" custom_font_size="2.8vw" posts_per_page="12"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Parallax Image Gallery With Captions', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-11-Nov-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/resort-image-gallery.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="0px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" enable_animation="true" animation="fade-in" mobile_disable_entrance_animation="true" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" delay="800"][vc_gallery type="flickity_static_height_style" images="" flickity_spacing="10px" flickity_controls="touch_total_alt" flickity_touch_total_style="solid_bg" flickity_touch_total_indicator_bg_color="#f4ece2" flickity_touch_total_indicator_icon_color="#000000" flickity_overflow="hidden" flickity_wrap_around="wrap" flickity_image_parallax="true" flickity_box_shadow="none" image_loading="default" display_title_caption="true" onclick="link_image" flickity_img_height="70vh" flickity_img_small_desktop_height="70vh" flickity_img_tablet_height="40vh" flickity_img_mobile_height="250px"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Large Animated Header', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-11-Nov-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/resort-page-heading.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="175" top_padding_tablet="25%" top_padding_phone="35%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type="straight_section" gradient_type="default"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="top-bottom" column_element_spacing="0px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" left_padding_desktop="8%" constrain_group_2="yes" right_padding_desktop="8%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="0px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][split_line_heading animation_type="line-reveal-by-space" font_style="h1" line_reveal_by_space_text_effect="letter-reveal-bottom" mobile_disable_animation="true" content_alignment="center" mobile_content_alignment="inherit" link_target="_self" text_content="RESORT" font_size="13vw" font_line_height="0.8" font_size_tablet="13vw"][/split_line_heading][split_line_heading animation_type="line-reveal-by-space" font_style="h1" line_reveal_by_space_text_effect="letter-reveal-bottom" mobile_disable_animation="true" content_alignment="center" mobile_content_alignment="inherit" link_target="_self" text_content="GALLERY" font_size="13vw" font_line_height="0.8" animation_delay="200" font_size_tablet="13vw"][/split_line_heading][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding="3%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" mobile_disable_entrance_animation="true" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" delay="600"][vc_column_text]
<h5>Explore the resort</h5>
[/vc_column_text][divider line_type="Vertical Line" divider_color="black" custom_height="100" custom_height_tablet="60" custom_height_phone="50"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Scrolling Tabbed Rooms', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-11-Nov-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/resort-vertical-tabbed-2.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="6%" bottom_padding="8%" left_padding_desktop="8%" left_padding_tablet="8%" constrain_group_4="yes" right_padding_tablet="8%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type="" gradient_type="default"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" enable_animation="true" animation="fade-in" mobile_disable_entrance_animation="true" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" delay="400"][tabbed_section style="vertical_scrolling" tab_color="Accent-Color" vs_navigation_func="active_link_only" vs_navigation_width="regular" vs_tab_spacing="35%" vs_tab_tag="h2" vs_cta_style="text-reveal-wave" vs_cta_text_color="#0a0a0a" vs_cta_bg_color="accent-color" vs_cta_heading_tag="h5" vs_sticky_aspect="default" vs_font_size="3vw" vs_sub_desc_font_size="1.05vw"][tab icon_family="none" title="Standard selection" id="1636819609648-4" tab_id="1636819609649-0" sub_desc="Get a good night's sleep in our luxurious standard room. Featuring king size beds, walk-in showers and wifi internet."][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://themenectar.com/img/demo-media/unsplash/webp/photo-1616046229478-9901c5536a45.webp" background_image_position="center center" enable_bg_scale="true" background_image_loading="skip-lazy-load" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" parallax_bg="true" parallax_bg_speed="very_subtle" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][divider line_type="No Line" custom_height="80vh" custom_height_tablet="50vh"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" left_padding_desktop="12%" left_padding_tablet="10%" constrain_group_4="yes" right_padding_tablet="10%" translate_y="33%" translate_y_tablet="0" text_align="left" min_width_desktop="60%" row_position="absolute" row_position_tablet="relative" row_position_phone="inherit" bottom_position_desktop="0" left_position_desktop="0" zindex="100" overflow="visible" pointer_events="all"][vc_column_inner column_padding="padding-3-percent" column_padding_tablet="padding-4-percent" column_padding_phone="inherit" column_padding_position="all" top_margin_tablet="-20%" column_element_spacing="10px" background_color="#ffffff" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="parallax" animation_movement_type="default" column_parallax_intensity="1.5" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][split_line_heading animation_type="line-reveal-by-space" font_style="h2" line_reveal_by_space_text_effect="none" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="From $200/night" font_size="2vw" font_line_height="1" font_size_tablet="3vw" font_size_phone="5vw"][/split_line_heading][split_line_heading animation_type="line-reveal-by-space" font_style="h2" line_reveal_by_space_text_effect="none" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="Junior Studio" font_size="4vw" font_line_height="1" font_size_tablet="6vw" font_size_phone="8vw"][/split_line_heading][divider line_type="No Line" custom_height="15"][fancy-ul icon_type="standard_dot" alignment="left" spacing="5px"]
<ul>
 	<li>Capacity: 2</li>
 	<li>Number of rooms: 30</li>
 	<li>Square Footage: 200</li>
 	<li>Beds: 1 Baths: 1</li>
</ul>
[/fancy-ul][nectar_cta btn_style="text-reveal-wave" heading_tag="h5" text_color="#000000" button_color="accent-color" button_border_thickness="0px" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" constrain_group_3="yes" constrain_group_4="yes" display="block" link_text="Reserve Room" padding_top="15" padding_bottom="15" padding_left="35" padding_right="35" margin_top="40"][/vc_column_inner][/vc_row_inner][/tab][tab icon_family="none" title="Rooms with a view" id="1636819609781-9" tab_id="1636819609782-9" sub_desc="We offer highrise rooms to elevate your view of the ocean even further. The perfect romantic getaway spot for couples."][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://themenectar.com/img/demo-media/unsplash/webp/photo-1559414059-34fe0a59e57a.webp" background_image_position="center center" enable_bg_scale="true" background_image_loading="default" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" parallax_bg="true" parallax_bg_speed="very_subtle" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][divider line_type="No Line" custom_height="80vh" custom_height_tablet="50vh"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" right_padding_desktop="12%" left_padding_tablet="10%" constrain_group_4="yes" right_padding_tablet="10%" translate_y="33%" translate_y_tablet="0" text_align="left" min_width_desktop="60%" row_position="absolute" row_position_tablet="relative" row_position_phone="inherit" bottom_position_desktop="0" right_position_desktop="0" zindex="100" overflow="visible" pointer_events="all"][vc_column_inner column_padding="padding-3-percent" column_padding_tablet="padding-4-percent" column_padding_phone="inherit" column_padding_position="all" top_margin_tablet="-20%" column_element_spacing="10px" background_color="#ffffff" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="parallax" animation_movement_type="default" column_parallax_intensity="1.5" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][split_line_heading animation_type="line-reveal-by-space" font_style="h2" line_reveal_by_space_text_effect="none" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="From $350/night" font_size="2vw" font_line_height="1" font_size_tablet="3vw" font_size_phone="5vw"][/split_line_heading][split_line_heading animation_type="line-reveal-by-space" font_style="h2" line_reveal_by_space_text_effect="none" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="Highrise Suite" font_size="4vw" font_line_height="1" font_size_tablet="6vw" font_size_phone="8vw"][/split_line_heading][divider line_type="No Line" custom_height="15"][fancy-ul icon_type="standard_dot" alignment="left" spacing="5px"]
<ul>
 	<li>Capacity: 4</li>
 	<li>Number of rooms: 15</li>
 	<li>Square Footage: 350</li>
 	<li>Beds: 2 Baths: 2</li>
</ul>
[/fancy-ul][nectar_cta btn_style="text-reveal-wave" heading_tag="h5" text_color="#000000" button_color="accent-color" button_border_thickness="0px" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" constrain_group_3="yes" constrain_group_4="yes" display="block" link_text="Reserve Room" padding_top="15" padding_bottom="15" padding_left="35" padding_right="35" margin_top="40"][/vc_column_inner][/vc_row_inner][/tab][tab icon_family="none" title="For large groups" id="1636819609866-2" tab_id="1636819609867-8" sub_desc="Leave all of your troubles behind and enjoy the ultimate escape in our deluxe cabins, perfect for the vacationing family."][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://themenectar.com/img/demo-media/unsplash/webp/photo-1572970385182-97a64c98205b.webp" background_image_position="center center" enable_bg_scale="true" background_image_loading="default" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" parallax_bg="true" parallax_bg_speed="very_subtle" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][divider line_type="No Line" custom_height="80vh" custom_height_tablet="50vh"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" left_padding_desktop="12%" left_padding_tablet="10%" constrain_group_4="yes" right_padding_tablet="10%" translate_y="33%" translate_y_tablet="0" text_align="left" min_width_desktop="60%" row_position="absolute" row_position_tablet="relative" row_position_phone="inherit" bottom_position_desktop="0" left_position_desktop="0" zindex="100" overflow="visible" pointer_events="all"][vc_column_inner column_padding="padding-3-percent" column_padding_tablet="padding-4-percent" column_padding_phone="inherit" column_padding_position="all" top_margin_tablet="-20%" column_element_spacing="10px" background_color="#ffffff" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="parallax" animation_movement_type="default" column_parallax_intensity="1.5" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][split_line_heading animation_type="line-reveal-by-space" font_style="h2" line_reveal_by_space_text_effect="none" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="From $750/night" font_size="2vw" font_line_height="1" font_size_tablet="3vw" font_size_phone="5vw"][/split_line_heading][split_line_heading animation_type="line-reveal-by-space" font_style="h2" line_reveal_by_space_text_effect="none" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="Deluxe Villa" font_size="4vw" font_line_height="1" font_size_tablet="6vw" font_size_phone="8vw"][/split_line_heading][divider line_type="No Line" custom_height="15"][fancy-ul icon_type="standard_dot" alignment="left" spacing="5px"]
<ul>
 	<li>Capacity: 8</li>
 	<li>Number of rooms: 20</li>
 	<li>Square Footage: 800</li>
 	<li>Beds: 4 Baths: 3</li>
</ul>
[/fancy-ul][nectar_cta btn_style="text-reveal-wave" heading_tag="h5" text_color="#000000" button_color="accent-color" button_border_thickness="0px" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" constrain_group_3="yes" constrain_group_4="yes" display="block" link_text="Reserve Room" padding_top="15" padding_bottom="15" padding_left="35" padding_right="35" margin_top="40"][/vc_column_inner][/vc_row_inner][/tab][tab icon_family="none" title="Exclusive experience" id="1636819609960-0" tab_id="1636819609961-0" sub_desc="A once in a lifetime experience awaits you. Stay on the water in one of our exclusive bungalows hundreds of feet out on the ocean"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://themenectar.com/img/demo-media/unsplash/webp/photo-1590523277581-658f9545acd2.webp" background_image_position="center center" enable_bg_scale="true" background_image_loading="default" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" parallax_bg="true" parallax_bg_speed="very_subtle" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][divider line_type="No Line" custom_height="80vh" custom_height_tablet="50vh"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" right_padding_desktop="12%" left_padding_tablet="10%" constrain_group_4="yes" right_padding_tablet="10%" translate_y="33%" translate_y_tablet="0" text_align="left" min_width_desktop="60%" row_position="absolute" row_position_tablet="relative" row_position_phone="inherit" bottom_position_desktop="0" right_position_desktop="0" zindex="100" overflow="visible" pointer_events="all"][vc_column_inner column_padding="padding-3-percent" column_padding_tablet="padding-4-percent" column_padding_phone="inherit" column_padding_position="all" top_margin_tablet="-20%" column_element_spacing="10px" background_color="#ffffff" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="parallax" animation_movement_type="default" column_parallax_intensity="1.5" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][split_line_heading animation_type="line-reveal-by-space" font_style="h2" line_reveal_by_space_text_effect="none" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="From $1000/night" font_size="2vw" font_line_height="1" font_size_tablet="3vw" font_size_phone="5vw"][/split_line_heading][split_line_heading animation_type="line-reveal-by-space" font_style="h2" line_reveal_by_space_text_effect="none" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="Water Bungalow" font_size="4vw" font_line_height="1" font_size_tablet="6vw" font_size_phone="8vw"][/split_line_heading][divider line_type="No Line" custom_height="15"][fancy-ul icon_type="standard_dot" alignment="left" spacing="5px"]
<ul>
 	<li>Capacity: 4</li>
 	<li>Number of rooms: 12</li>
 	<li>Square Footage: 550</li>
 	<li>Beds: 2 Baths: 2</li>
</ul>
[/fancy-ul][nectar_cta btn_style="text-reveal-wave" heading_tag="h5" text_color="#000000" button_color="accent-color" button_border_thickness="0px" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" constrain_group_3="yes" constrain_group_4="yes" display="block" link_text="Reserve Room" padding_top="15" padding_bottom="15" padding_left="35" padding_right="35" margin_top="40"][/vc_column_inner][/vc_row_inner][/tab][/tabbed_section][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Light Footer', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-11-Nov-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/resort-footer.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#f4ece2" scene_position="center" top_padding="6%" constrain_group_1="yes" bottom_padding="6%" left_padding_desktop="8%" constrain_group_2="yes" right_padding_desktop="8%" top_padding_tablet="12%" constrain_group_3="yes" bottom_padding_tablet="12%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" enable_shape_divider="true" shape_divider_color="rgba(0,0,0,0.1)" shape_divider_position="both" shape_divider_height="1" bg_image_animation="none" shape_type="straight_section" gradient_type="default"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="center" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" bg_image_animation="none" border_type="advanced" column_border_style="solid" gradient_type="default"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" right_padding_desktop="40%" bottom_padding_tablet="10%" left_padding_phone="10%" constrain_group_6="yes" right_padding_phone="10%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="10px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][vc_column_text]
<h4>Do you believe in magic?</h4>
[/vc_column_text][split_line_heading animation_type="line-reveal-by-space" font_style="p" line_reveal_by_space_text_effect="none" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" font_size="1.05vw" font_line_height="1.6" text_content="This entire website was built with Salient, a creative next-generation WordPress theme." font_size_tablet="16"][/split_line_heading][nectar_cta btn_style="text-reveal-wave" heading_tag="h5" text_color="#000000" button_color="accent-color" button_border_thickness="0px" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" constrain_group_3="yes" constrain_group_4="yes" display="block" link_text="I don't believe it" margin_top="35" padding_top="15" padding_bottom="15" padding_left="35" padding_right="35"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="center" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][vc_row_inner column_margin="50px" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="padding-5-percent" column_padding_tablet="no-extra-padding" column_padding_phone="no-extra-padding" column_padding_position="left" bottom_margin_phone="40" column_element_spacing="0px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="small_desktop" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" delay="150"][vc_column_text css=".vc_custom_1636697193664{margin-bottom: 10px !important;}"]
<h4>Address</h4>
[/vc_column_text][split_line_heading animation_type="line-reveal-by-space" font_style="p" line_reveal_by_space_text_effect="none" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" font_size="1.05vw" font_line_height="1.6" text_content="The Castle" font_size_tablet="16"][/split_line_heading][split_line_heading animation_type="line-reveal-by-space" font_style="p" line_reveal_by_space_text_effect="none" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" font_size="1.05vw" font_line_height="1.6" text_content="345 2500 Castle Dr." font_size_tablet="16"][/split_line_heading][split_line_heading animation_type="line-reveal-by-space" font_style="p" line_reveal_by_space_text_effect="none" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" font_size="1.05vw" font_line_height="1.6" text_content="Port Douglas, Queensland" font_size_tablet="16"][/split_line_heading][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" bottom_margin_tablet="0" bottom_margin_phone="0" column_element_spacing="0px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="small_desktop" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" delay="300"][vc_column_text css=".vc_custom_1636697263705{margin-bottom: 10px !important;}"]
<h4>Connect</h4>
[/vc_column_text][split_line_heading animation_type="line-reveal-by-space" font_style="p" line_reveal_by_space_text_effect="none" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" font_size="1.05vw" font_line_height="1.6" text_content="T: +216 (0)40 3629 4753" font_size_tablet="16"][/split_line_heading][split_line_heading animation_type="line-reveal-by-space" font_style="p" line_reveal_by_space_text_effect="none" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" font_size="1.05vw" font_line_height="1.6" text_content="E: hello@themenectar.com" font_size_tablet="16"][/split_line_heading][vc_column_text] [/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#f4ece2" scene_position="center" top_padding="28" constrain_group_1="yes" bottom_padding="28" left_padding_desktop="8%" constrain_group_2="yes" right_padding_desktop="8%" top_padding_tablet="6%" constrain_group_3="yes" bottom_padding_tablet="6%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" tablet_text_alignment="center" phone_text_alignment="center" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" animation_offset="101%"][vc_column_text]<b>© </b>[nectar_current_year] Salient Hotel[/vc_column_text][/vc_column][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" tablet_text_alignment="center" phone_text_alignment="center" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" animation_offset="101%"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding_tablet="10" text_align="right" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="0px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][nectar_cta btn_style="underline" heading_tag="p" button_color="default" button_border_thickness="0px" link_type="regular" alignment="right" alignment_tablet="center" alignment_phone="default" constrain_group_4="yes" display="inline" link_text="Terms &amp; Conditions" padding_left="25" padding_right="25"][nectar_cta btn_style="underline" heading_tag="p" button_color="default" button_border_thickness="0px" link_type="regular" alignment="right" alignment_tablet="center" alignment_phone="default" constrain_group_4="yes" display="inline" link_text="Privacy Policy" padding_left="25" padding_right="25"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Cropped Parallax CTA', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['cta'];
$data['custom_class'] = 'cta date-11-Nov-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/resort-cta.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="10%" top_padding_tablet="15%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient_angle="0" shape_divider_position="bottom" bg_image_animation="none" shape_type="" gradient_type="advanced" advanced_gradient_display_type="linear"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding="3%" left_padding_desktop="30%" constrain_group_2="yes" right_padding_desktop="30%" bottom_padding_tablet="6%" left_padding_tablet="13%" constrain_group_4="yes" right_padding_tablet="13%" left_padding_phone="11%" constrain_group_6="yes" right_padding_phone="11%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="0px" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][vc_column_text]
<h5>RESERVATIONS</h5>
[/vc_column_text][split_line_heading animation_type="line-reveal-by-space" font_style="h2" line_reveal_by_space_text_effect="none" content_alignment="center" mobile_content_alignment="inherit" link_target="_self" text_content="It's time for that vacation" font_line_height="1" max_width="58%" font_size="4vw"][/split_line_heading][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" bottom_padding="10%" bottom_padding_tablet="15%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient_angle="0" shape_divider_position="bottom" bg_image_animation="none" shape_type="" gradient_type="advanced" advanced_gradient_display_type="linear"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" left_padding_desktop="10%" constrain_group_2="yes" right_padding_desktop="10%" translate_y="-50%" translate_x="-50%" text_align="left" min_width_desktop="100%" row_position="absolute" row_position_tablet="inherit" row_position_phone="inherit" top_position_desktop="50%" left_position_desktop="50%" zindex="200" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="parallax" animation_movement_type="default" column_parallax_intensity="2" persist_movement_on_mobile="true" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][split_line_heading animation_type="line-reveal-by-space" font_style="h1" line_reveal_by_space_text_effect="letter-reveal-top" stagger_animation="true" content_alignment="center" mobile_content_alignment="inherit" link_target="_self" link_indicator="true" link_indicator_bg_color="#f4ece2" link_indicator_icon_color="#000000" text_content="BOOK NOW" font_size="13vw" link_href="https://google.com" font_line_height="0.9" font_size_tablet="14vw"][/split_line_heading][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" left_padding_desktop="34%" constrain_group_2="yes" right_padding_desktop="34%" left_padding_tablet="30%" constrain_group_4="yes" right_padding_tablet="30%" left_padding_phone="27%" constrain_group_6="yes" right_padding_phone="27%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://themenectar.com/img/demo-media/unsplash/webp/photo-1504941214544-9c1c44559ab4.webp" background_image_position="center center" enable_bg_scale="true" background_image_loading="default" video_mp4="" background_video_loading="lazy-load" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="radial" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][divider line_type="No Line" custom_height="75vh" custom_height_tablet="45vh"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Full Width Layered Parallax Blocks', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['services'];
$data['custom_class'] = 'services date-11-Nov-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/resort-split-parallax.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#7a95a8" scene_position="center" text_color="light" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type="" gradient_type="default"][vc_column column_padding="padding-5-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="5px" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://themenectar.com/img/demo-media/unsplash/webp/photo-1583939003579-730e3918a45a.webp" background_image_position="center center" enable_bg_scale="true" background_image_loading="default" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" enable_gradient="true" color_overlay="rgba(0,0,0,0.62)" advanced_gradient_angle="0" gradient_direction="radial" overlay_strength="0.5" width="1/2" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" bg_image_animation="none" parallax_bg="true" parallax_bg_speed="very_subtle" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][divider line_type="No Line" custom_height="35vh" custom_height_phone="150"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="0px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][split_line_heading animation_type="line-reveal-by-space" font_style="h2" line_reveal_by_space_text_effect="none" content_alignment="center" mobile_content_alignment="inherit" link_target="_self" text_content="Weddings" font_size="3vw"][/split_line_heading][nectar_cta btn_style="underline" heading_tag="span" text_color="#ffffff" button_color="default" button_border_thickness="0px" link_type="regular" alignment="center" alignment_tablet="default" alignment_phone="default" display="block" link_text="Learn More" url="#"][/vc_column_inner][/vc_row_inner][divider line_type="No Line" custom_height="35vh" custom_height_phone="150"][/vc_column][vc_column column_padding="padding-5-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="5px" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://themenectar.com/img/demo-media/unsplash/webp/photo-1515168985652-8454bcc8fcaf.webp" background_image_position="center center" enable_bg_scale="true" background_image_loading="default" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" enable_gradient="true" color_overlay="rgba(0,0,0,0.72)" color_overlay_2="rgba(0,0,0,0.24)" advanced_gradient_angle="0" gradient_direction="radial" overlay_strength="0.5" width="1/2" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" bg_image_animation="none" parallax_bg="true" parallax_bg_speed="fast" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][divider line_type="No Line" custom_height="35vh" custom_height_phone="150"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="0px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" delay="200"][split_line_heading animation_type="line-reveal-by-space" font_style="h2" line_reveal_by_space_text_effect="none" content_alignment="center" mobile_content_alignment="inherit" link_target="_self" text_content="Conferences" font_size="3vw"][/split_line_heading][nectar_cta btn_style="underline" heading_tag="span" text_color="#ffffff" button_color="default" button_border_thickness="0px" link_type="regular" alignment="center" alignment_tablet="default" alignment_phone="default" display="block" link_text="Learn More" url="#"][/vc_column_inner][/vc_row_inner][divider line_type="No Line" custom_height="35vh" custom_height_phone="150"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Featured Recent Posts List', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['blog'];
$data['custom_class'] = 'blog date-11-Nov-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/resort-news.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="6%" bottom_padding="5%" left_padding_desktop="8%" constrain_group_2="yes" right_padding_desktop="8%" top_padding_tablet="15%" constrain_group_9="yes" constrain_group_10="yes" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type="" gradient_type="default"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="0px" sticky_content="true" sticky_content_functionality="css" sticky_content_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" tablet_text_alignment="center" phone_text_alignment="center" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" left_padding_tablet="10%" constrain_group_4="yes" right_padding_tablet="10%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][split_line_heading animation_type="line-reveal-by-space" font_style="h3" line_reveal_by_space_text_effect="default" stagger_animation="true" content_alignment="left" mobile_content_alignment="center" link_target="_self" text_content="Read the latest news" font_size="4vw" font_line_height="0.9" max_width="75%"][/split_line_heading][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding="20" right_padding_desktop="15%" top_padding_tablet="0" left_padding_tablet="10%" constrain_group_4="yes" right_padding_tablet="10%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" offset="vc_hidden-sm vc_hidden-xs"][split_line_heading animation_type="line-reveal-by-space" font_style="p" line_reveal_by_space_text_effect="none" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="Track events, lean about activities and get vacation tips for your stay with us." font_size="1.05vw" font_line_height="1.6" font_size_tablet="16"][/split_line_heading][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="padding-6-percent" column_padding_tablet="no-extra-padding" column_padding_phone="no-extra-padding" column_padding_position="left" column_element_spacing="0px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="2/3" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][nectar_post_grid post_type="post" blog_category="all" order="DESC" orderby="date" pagination="none" ignore_sticky_posts="yes" grid_item_spacing="40px" image_size="portfolio-thumb_large" image_loading="default" animation="fade-in-from-bottom" heading_tag="h4" grid_style="vertical_list" vertical_list_hover_effect="slight_move" vertical_list_border_color="rgba(0,0,0,0.35)" vertical_list_read_more="yes" vertical_list_counter="yes" text_color="dark" posts_per_page="4"][/vc_column][/vc_row][vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="hidden" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][vc_row_inner content_placement="middle" column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="parallax" animation_movement_type="transform_x" column_parallax_intensity="3.5" persist_movement_on_mobile="true" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][nectar_scrolling_text scroll_direction="ltr" scroll_speed="slowest" text_color="#000000" style="text_outline" outline_thickness="ultra-thin" text_repeat_number="4" text_repeat_divider="space" overflow="visible" background_image_animation="None" custom_font_size="13vw" custom_font_size_mobile="20vw"]
<h1><em>PRIVATE EVENTS</em></h1>
[/nectar_scrolling_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Fancy Box Parallax Carousel', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['services'];
$data['custom_class'] = 'services date-11-Nov-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/resort-parallax-carousel.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="6%" constrain_group_1="yes" bottom_padding="6%" left_padding_desktop="8%" right_padding_desktop="8%" top_padding_tablet="15%" constrain_group_3="yes" bottom_padding_tablet="15%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="hidden" id="impact" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="top" shape_divider_height="50%" bg_image_animation="none" shape_type="straight_section" gradient_type="default"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding="15" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][vc_column_text]
<h5>ACTIVITIES</h5>
[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding="3%" right_padding_desktop="70%" bottom_padding_tablet="6%" right_padding_tablet="40%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][split_line_heading animation_type="line-reveal-by-space" font_style="h3" line_reveal_by_space_text_effect="default" stagger_animation="true" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="The adventure starts now" font_size="4vw" font_line_height="0.9"][/split_line_heading][/vc_column_inner][/vc_row_inner][carousel script="flickity" flickity_formatting="default" desktop_cols_flickity="3" desktop_small_cols_flickity="2" tablet_cols_flickity="2" flickity_controls="touch_total" flickity_touch_total_style="solid_bg" flickity_touch_total_indicator_bg_color="#f4ece2" flickity_touch_total_indicator_icon_color="#000000" flickity_touch_total_hide_indicator="true" color="default" flickity_overflow="visible" flickity_wrap_around="no-wrap" flickity_spacing="10px" flickity_centered_cells="true" flickity_column_vertical_alignment="bottom" column_padding="0" flickity_element_spacing="0" border_radius="none"][item simple_slider_bg_image_position="default" simple_slider_overlay_strength="0.3" simple_slider_bg_image_loading="default" id="1636816204207-0" title="Item" tab_id="1636816204207-0"][fancy_box box_style="hover_desc" icon_family="iconsmind" image_url="https://themenectar.com/img/demo-media/unsplash/webp/photo-1605144156683-5ebde77feed5.webp" hover_color="accent-color" hover_color_custom="#000000" hover_desc_color_opacity="0.9" hover_desc_hover_overlay_opacity="0.4" disable_hover_movement="true" bg_parallax="true" icon_position="top" box_alignment="left" hover_desc_bg_animation="none" border_radius="default" image_loading="lazy-load" color_scheme="dark" secondary_content="here's some awesome text that would only be shown on hover" min_height="75vh" icon_iconsmind="iconsmind-Golf" min_height_tablet="550"]
<h4>Premier Golf Course</h4>
A true test of the champion; Test your skills at our full 18-hole immaculate course overlooking the ocean.[/fancy_box][/item][item simple_slider_bg_image_position="default" simple_slider_overlay_strength="0.3" simple_slider_bg_image_loading="default" id="1636816204244-9" title="Item" tab_id="1636816204245-9"][fancy_box box_style="hover_desc" icon_family="iconsmind" image_url="https://themenectar.com/img/demo-media/unsplash/webp/photo-1567227278154-0b83bcf237e1.webp" hover_color="accent-color" hover_color_custom="#0a0202" hover_desc_color_opacity="0.9" hover_desc_hover_overlay_opacity="0.4" disable_hover_movement="true" bg_parallax="true" icon_position="top" box_alignment="left" hover_desc_bg_animation="none" border_radius="default" image_loading="lazy-load" color_scheme="dark" secondary_content="here's some awesome text that would only be shown on hover" min_height="75vh" icon_iconsmind="iconsmind-Leafs" min_height_tablet="550"]
<h4>Relaxing Wellness Spa</h4>
Another layer of relaxation awaits you on your vacation. Featuring massages, a hair salon, and nail studio.[/fancy_box][/item][item simple_slider_bg_image_position="default" simple_slider_overlay_strength="0.3" simple_slider_bg_image_loading="default" id="1636816204265-8" title="Item" tab_id="1636816204266-1"][fancy_box box_style="hover_desc" icon_family="iconsmind" image_url="https://themenectar.com/img/demo-media/unsplash/webp/photo-1602199926649-2e5e447bab97.webp" hover_color="accent-color" hover_color_custom="#000000" hover_desc_color_opacity="0.9" hover_desc_hover_overlay_opacity="0.4" disable_hover_movement="true" bg_parallax="true" icon_position="top" box_alignment="left" hover_desc_bg_animation="none" border_radius="default" image_loading="lazy-load" color_scheme="dark" secondary_content="here's some awesome text that would only be shown on hover" min_height="75vh" icon_iconsmind="iconsmind-Snorkel" min_height_tablet="550"]
<h4>Scuba Diving &amp; Snorkeling</h4>
Explore the crystal clear waters from down under with our scuba excursion.[/fancy_box][/item][item simple_slider_bg_image_position="default" simple_slider_overlay_strength="0.3" simple_slider_bg_image_loading="default" id="1636816204294-1" title="Item" tab_id="1636816204295-5"][fancy_box box_style="hover_desc" icon_family="iconsmind" image_url="https://themenectar.com/img/demo-media/unsplash/webp/photo-1600521605615-a8d3a23d8262.webp" hover_color="extra-color-1" hover_color_custom="#000000" hover_desc_color_opacity="0.9" hover_desc_hover_overlay_opacity="0.4" disable_hover_movement="true" bg_parallax="true" icon_position="top" box_alignment="left" hover_desc_bg_animation="none" border_radius="default" image_loading="lazy-load" color_scheme="dark" secondary_content="here's some awesome text that would only be shown on hover" min_height="75vh" icon_iconsmind="iconsmind-Jeep" min_height_tablet="550"]
<h4>Premium Wildlife Tours</h4>
Expertly guided scenic and tours of the land available in group UTV sessions.[/fancy_box][/item][item simple_slider_bg_image_position="default" simple_slider_overlay_strength="0.3" simple_slider_bg_image_loading="default" id="1636816204322-6" title="Item" tab_id="1636816204323-10"][fancy_box box_style="hover_desc" icon_family="iconsmind" image_url="https://themenectar.com/img/demo-media/unsplash/webp/photo-1551524358-f34c0214781d.webp" hover_color="extra-color-1" hover_color_custom="#000000" hover_desc_color_opacity="0.9" hover_desc_hover_overlay_opacity="0.4" disable_hover_movement="true" bg_parallax="true" icon_position="top" box_alignment="left" hover_desc_bg_animation="none" border_radius="default" image_loading="lazy-load" color_scheme="dark" secondary_content="here's some awesome text that would only be shown on hover" min_height="75vh" icon_iconsmind="iconsmind-Wave" min_height_tablet="550"]
<h4>Professional Surf Lessons</h4>
Get another item off your bucket list and immerse yourself in the swell with our instructors.[/fancy_box][/item][item simple_slider_bg_image_position="default" simple_slider_overlay_strength="0.3" simple_slider_bg_image_loading="default" id="1636816204348-2" title="Item" tab_id="1636816204349-3"][fancy_box box_style="hover_desc" icon_family="iconsmind" image_url="https://themenectar.com/img/demo-media/unsplash/webp/photo-1499510318569-1a3d67dc3976.webp" hover_color="accent-color" hover_color_custom="#0a0202" hover_desc_color_opacity="0.9" hover_desc_hover_overlay_opacity="0.4" disable_hover_movement="true" bg_parallax="true" icon_position="top" box_alignment="left" hover_desc_bg_animation="none" border_radius="default" image_loading="lazy-load" color_scheme="dark" secondary_content="here's some awesome text that would only be shown on hover" min_height="75vh" icon_iconsmind="iconsmind-Tennis" min_height_tablet="550"]
<h4>Clay Tennis Courts</h4>
Professional-quality tennis courts that are available to you all year round. Classes and lessons are also available.[/fancy_box][/item][/carousel][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Images and Parallax Text Column', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'] . ', ' . $cat_display_names['about'];
$data['custom_class'] = 'general about date-11-Nov-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/resort-parallax-text.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="14%" left_padding_desktop="8%" right_padding_desktop="8%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient="radial-gradient(circle at top right, rgb(255,200,129) 0%, rgba(243,243,243,0) 41%)" advanced_gradient_radial_position="top right" shape_divider_position="bottom" bg_image_animation="none" parallax_bg="true" parallax_bg_speed="fast" gradient_type="advanced" shape_type="" advanced_gradient_display_type="radial"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="0px" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="radial" overlay_strength="0.5" width="1/2" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" translate_y="-50%" translate_x="50%" text_align="left" min_width_desktop="175" row_position="absolute" row_position_tablet="inherit" row_position_phone="inherit" top_position_desktop="0" right_position_desktop="0" zindex="100" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" offset="vc_hidden-sm vc_hidden-xs"][image_with_animation image_url="https://themenectar.com/img/demo-media/spinners/ocean-views.png" image_size="full" animation_type="looped" loop_animation="rotate" hover_animation="none" alignment="" border_radius="none" image_loading="skip-lazy-load" max_width="custom" el_class="dark-filter" max_width_custom="175"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding_tablet="8%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://themenectar.com/img/demo-media/unsplash/webp/photo-1516752093629-7d10b9d79a18.webp" background_image_position="center center" enable_bg_scale="true" background_image_loading="default" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="radial" overlay_strength="0.5" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][divider line_type="No Line" custom_height="90vh" custom_height_tablet="450"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="padding-14-percent" column_padding_tablet="no-extra-padding" column_padding_phone="no-extra-padding" column_padding_position="left" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="parallax" animation_movement_type="default" column_parallax_intensity="1.75" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding="10vh" bottom_padding="15" top_padding_tablet="0" top_padding_phone="0" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][vc_column_text]
<h5>Excellence</h5>
[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="0px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][split_line_heading animation_type="line-reveal-by-space" font_style="h3" line_reveal_by_space_text_effect="default" stagger_animation="true" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="Where forest meets ocean" font_size="4vw" font_line_height="0.9" max_width="85%"][/split_line_heading][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding="4%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" zindex="100" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][split_line_heading animation_type="line-reveal-by-space" font_style="p" line_reveal_by_space_text_effect="none" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="Nestled right in the middle of a natural juxtaposition. Salient is more than a resort; it's an unforgettable experience for you and your whole family." font_size="1.05vw" font_line_height="1.6" font_size_tablet="16"][/split_line_heading][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding="4%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" zindex="100" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="0px" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][divider line_type="Vertical Line" divider_color="black" custom_height="34"][split_line_heading animation_type="line-reveal-by-space" font_style="i" line_reveal_by_space_text_effect="none" content_alignment="center" mobile_content_alignment="inherit" link_target="_self" text_content="The best of both worlds; Refreshing greenery with scenic ocean views." font_line_height="1.3" max_width="70%" font_size="1.45vw" font_size_tablet="22px"][/split_line_heading][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding="8%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://themenectar.com/img/demo-media/unsplash/webp/photo-1615228100591-976c4e87b179.webp" background_image_position="center center" enable_bg_scale="true" background_image_loading="default" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][divider line_type="No Line" custom_height="65vh" custom_height_tablet="350"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Image Slider with Static Text Overlaid', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'] . ', ' . $cat_display_names['about'];
$data['custom_class'] = 'general about date-11-Nov-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/resort-slider-carousel.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" constrain_group_9="yes" constrain_group_10="yes" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient="linear-gradient(125deg, rgb(122, 149, 168) 15%, rgb(122, 149, 168) 15%)" advanced_gradient_angle="125" shape_divider_color="#f0ece5" shape_divider_position="bottom" shape_divider_height="33%" bg_image_animation="none" shape_type="straight_section" gradient_type="advanced" advanced_gradient_display_type="linear"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="top" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][vc_row_inner equal_height="yes" content_placement="middle" column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" left_padding_desktop="35%" constrain_group_2="yes" right_padding_desktop="35%" left_padding_tablet="25%" constrain_group_4="yes" right_padding_tablet="25%" left_padding_phone="12%" constrain_group_6="yes" right_padding_phone="12%" translate_y="-50%" translate_x="-50%" text_align="left" min_width_desktop="100%" row_position="absolute" row_position_tablet="inherit" row_position_phone="inherit" top_position_desktop="50%" left_position_desktop="50%" zindex="100" overflow="visible" pointer_events="none"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="0px" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][nectar_icon icon_family="linea" enable_animation="true" animation_speed="medium" icon_style="default" icon_color_type="custom" icon_color_custom="#f4ece2" icon_padding="15px" icon_linea="icon-basic-compass"][split_line_heading animation_type="line-reveal-by-space" font_style="h2" text_color="#f4ece2" line_reveal_by_space_text_effect="default" stagger_animation="true" content_alignment="center" mobile_content_alignment="inherit" link_target="_self" text_content="Stunning views, outstanding service, and michelin star dining." font_size="3vw" font_size_tablet="5vw" font_line_height="1.3" font_size_phone="38px"][/split_line_heading][/vc_column_inner][/vc_row_inner][carousel script="simple_slider" simple_slider_sizing="aspect_ratio" simple_slider_aspect_ratio="2-1" simple_slider_pagination_controls="true" simple_slider_pagination_coloring="light" simple_slider_pagination_alignment="default" simple_slider_touch_indicator="true" simple_slider_touch_indicator_bg_color="#f4ece2" simple_slider_touch_indicator_icon_color="#000000" simple_slider_transition_type="slide" simple_slider_parallax="true" simple_slider_wrap="true" simple_slider_min_height="450"][item simple_slider_bg_image_url="https://themenectar.com/img/demo-media/unsplash/webp/photo-1634304233286-8c7956a85b29.webp" simple_slider_bg_image_position="center-top" simple_slider_font_color="#ffffff" simple_slider_color_overlay="rgba(0,0,0,0.74)" simple_slider_overlay_strength="0.3" simple_slider_bg_image_loading="default" simple_slider_gradient_direction="left_to_right" bg_image_url="" bg_image_position="default" image_url="" id="1636774480591-9" title="Item" tab_id="1636774480592-0"][vc_column_text][/vc_column_text][/item][item simple_slider_bg_image_url="https://themenectar.com/img/demo-media/unsplash/webp/photo-1446038236174-69712e24d137.webp" simple_slider_bg_image_position="center-bottom" simple_slider_font_color="#ffffff" simple_slider_color_overlay="rgba(10,10,10,0.5)" simple_slider_overlay_strength="0.3" simple_slider_bg_image_loading="default" simple_slider_gradient_direction="left_to_right" bg_image_url="" bg_image_position="default" image_url="" id="1636774480618-8" title="Item" tab_id="1636774480619-4"][vc_column_text][/vc_column_text][/item][item simple_slider_bg_image_url="https://themenectar.com/img/demo-media/unsplash/webp/photo-1508238100279-3b16198926a4.webp" simple_slider_bg_image_position="center-bottom" simple_slider_font_color="#ffffff" simple_slider_color_overlay="rgba(0,0,0,0.78)" simple_slider_overlay_strength="0.3" simple_slider_bg_image_loading="default" simple_slider_gradient_direction="left_to_right" bg_image_url="" bg_image_position="default" image_url="" id="1636774480643-1" title="Item" tab_id="1636774480643-2"][vc_column_text][/vc_column_text][/item][/carousel][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Scrolling Tabbed Images', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-11-Nov-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/resort-vertical-tabbed.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="6%" bottom_padding="12%" left_padding_desktop="8%" right_padding_tablet="8%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type="" gradient_type="default"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][tabbed_section style="vertical_scrolling" tab_color="Accent-Color" vs_navigation_func="active_link_only" vs_navigation_width="wide" vs_tab_spacing="20px" vs_tab_tag="h2" vs_enable_cta="true" vs_cta_style="text-reveal-wave" vs_cta_text_color="#0a0a0a" vs_cta_bg_color="accent-color" vs_cta_heading_tag="h5" constrain_group_1="yes" constrain_group_2="yes" vs_sticky_aspect="default" vs_cta_text="View All Accommodations" vs_cta_padding_top="15" vs_cta_padding_bottom="15" vs_cta_padding_left="25" vs_cta_padding_right="25" vs_font_size="4vw" vs_sub_desc_font_size="1.05vw"][tab icon_family="none" title="Single Suites" id="1636774480206-0" tab_id="1636774480207-0" sub_desc="Bohemian-inspired interiors with breathtaking views of the ocean from one side, and lushes greenery from the other. Ranges from 200 - 300 sqft."][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://themenectar.com/img/demo-media/unsplash/webp/photo-1559414059-34fe0a59e57a.webp"  background_image_position="center bottom" enable_bg_scale="true" background_image_loading="default" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" parallax_bg="true" parallax_bg_speed="fast" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][divider line_type="No Line" custom_height="90vh" custom_height_tablet="50vh"][/vc_column_inner][/vc_row_inner][/tab][tab icon_family="none" title="Private Cabins" id="1636774480315-8" tab_id="1636774480317-5" sub_desc="Leave all of your troubles behind and enjoy the ultimate escape in our deluxe cabins, perfect for the vacationing family. Ranges from 400 - 600 sqft."][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://themenectar.com/img/demo-media/unsplash/webp/photo-1572970385182-97a64c98205b.webp" background_image_position="center bottom" enable_bg_scale="true" background_image_loading="default" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" parallax_bg="true" parallax_bg_speed="fast" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][divider line_type="No Line" custom_height="90vh" custom_height_tablet="50vh"][/vc_column_inner][/vc_row_inner][/tab][tab icon_family="none" title="Ocean Villas" id="1636774480370-4" tab_id="1636774480370-3" sub_desc="A once in a lifetime experience awaits you. Stay on the water in one of our exclusive bungalows hundreds of feet out on the ocean. Ranges from 300 - 500 sqft."][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://themenectar.com/img/demo-media/unsplash/webp/photo-1590523277581-658f9545acd2.webp" background_image_position="center center" enable_bg_scale="true" background_image_loading="default" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" parallax_bg="true" parallax_bg_speed="fast" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][divider line_type="No Line" custom_height="90vh" custom_height_tablet="50vh"][/vc_column_inner][/vc_row_inner][/tab][/tabbed_section][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Text With Inline Images', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-11-Nov-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/resort-text-with-images.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="6%" constrain_group_1="yes" bottom_padding="6%" left_padding_desktop="16%" constrain_group_2="yes" right_padding_desktop="16%" left_padding_phone="8%" constrain_group_6="yes" right_padding_phone="8%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type="" gradient_type="default"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="0px" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][nectar_text_inline_images images="" image_size="medium" image_effect="circle_reveal" image_effect_rm_mobile="yes" image_loading="skip-lazy-load" line_reveal_by_space_text_effect="default" content_alignment="default" font_size="3vw" font_size_desktop="6vw" font_line_height="1.3" font_size_tablet="6vw" font_size_phone="8vw"]
<h2>An * enchanting new resort nestled on the coast of  Queensland *</h2>
[/nectar_text_inline_images][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Landing Hero Video', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['hero_section'];
$data['custom_class'] = 'hero_section date-11-Nov-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/resort-landing-video.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="80" bottom_padding="6%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="hidden" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type="straight_section" gradient_type="default"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" co